#!/bin/sh

# Source Router type
#
. /app/scripts/eipr_type

# Source Network Information
. /app/config/network_eth0.ini


if [ "$EIPR_TYPE" = "REALTEK" ]; then
	WANIF=eth0.2
else
	WANIF=eth0
fi

echo Content-type: text/html
echo ""
echo "<html><head><title>EIPR</title><link href=\"test.css\" rel=\"stylesheet\" type=\"text/css\" />
</head><body style=\"background: white;\">"

#
# DHCP or Static for WAN port
#
if [ "$BOOTPROTO_ETH0" = "dhcp" ] || [ "$BOOTPROTO_ETH0" = "none" ]; then
echo "<br />"
echo "<h2 style=\"width: 500;\">WAN Interface Statistics:</h2>"
echo "<br />"
lineNums=$(echo $(ifconfig $WANIF | wc -l))
echo "<pre>"
if [ "$lineNums" = "8" ]; then
	ifconfig $WANIF | sed -n -e '4,7 p'
else
	ifconfig $WANIF | sed -n -e '3,6 p'
fi
echo "</pre>"
fi
#
# IF PPP interface is present
#
if [ "$BOOTPROTO_ETH0" = "cellular" ]; then
echo "<br />"
echo "<h2 style=\"width: 500;\">Cellular Interface Statistics:</h2>"
echo "<br />"
if [ -e "/app/config/cell/wan.eth1" ]; then
	CELLIF=eth1
else
	CELLIF=ppp0
fi
lineNums=$(echo $(ifconfig $CELLIF | wc -l))
echo "<pre>"
if [ "$lineNums" = "8" ]; then
	ifconfig $CELLIF | sed -n -e '4,7 p'
else
	ifconfig $CELLIF | sed -n -e '3,6 p'
fi
echo "</pre>"
fi

#
#
# If VPN is enabled, show tunnel statistics
#
if [ "$EIPR_VPN" = "YES" ]; then
echo "<br />"
echo "<h2 style=\"width: 500;\">VPN Interface Statistics:</h2>"
echo "<br />"
lineNums=$(echo $(ifconfig tun0 | wc -l))
echo "<pre>"
if [ "$lineNums" = "8" ]; then
	ifconfig tun0 | sed -n -e '4,7 p'
else
	ifconfig tun0 | sed -n -e '3,6 p'
fi
echo "</pre>"
fi

echo "</body></html>"
