//
// File: check.js
// Product: Skorpion IP Router
// Author: Harpartap Parmar
// Copyright 2010-2024: Contemporary Control Systems, Inc.
//
function checkDigit(val)
{
	var i;
	var digits="0123456789";
	var len=val.length;

	for(i = 0; i < len; i++)
	{
		if (digits.indexOf(val.charAt(i))< 0)
			return 1;
	}

	return 0;
}

function checkHex(val)
{
	var i;
	var digits="0123456789abcdefABCDEF";
	var len=val.length;

	for(i = 0; i < len; i++)
	{
		if (digits.indexOf(val.charAt(i))< 0)
			return 1;
	}

	return 0;
}
//
//
function IPCheck1(val)
{
	var proceed=checkDigit(val);
	if(proceed==1)
		return 1;
	if(proceed==0)
	{
		if((val<1) || (val >223))
		return 2;
	}
	return 0;
}

//
//
function IPCheck2(val)
{
	var proceed=checkDigit(val);
	if(proceed==1)
		return 1;
	if(proceed==0)
	{
		if((val < 0) || (val > 255))
		return 2;
	}
	return 0;
}

//
//
function IPCheck3(val)
{
	var proceed=checkDigit(val);
	if(proceed==1)
		return 1;
	if(proceed==0)
	{
		if((val < 1) || (val > 254))
		return 2;
	}
	return 0;
}

//
//
function checkDNS(a)
{
	var dns=new Array(4);
	var ret;

	//Static DNS1
	dns[0]=a._3_5_1_2.value;
	dns[1]=a._3_5_2_2.value;
	dns[2]=a._3_5_3_2.value;
	dns[3]=a._3_5_4_2.value;

	//If all dns1 values are empty, set them to zeroes
	if( (dns[0].length==0) && (dns[1].length==0) && (dns[2].length==0) && (dns[3].length==0) )
	{

		for(i = 0; i < 4; i++)
		dns[i] = 0;

		a._3_5_1_2.value=0;
		a._3_5_2_2.value=0;
		a._3_5_3_2.value=0;
		a._3_5_4_2.value=0;
	}

	if( (dns[0].length==0) || (dns[1].length==0) || (dns[2].length==0) || (dns[3].length==0) )
	{
		alert('Input values for Static DNS 1 for WAN Setup');
		return 1;
	}

	for(i = 0; i < 4; i++)
	{
		ret=checkDigit(dns[i]);
		if(ret==1)
		{
			alert('Input numerical values for Static DNS 1 for WAN Setup');
			return 1;
		}
	}

	if( ((dns[0] != 0) || (dns[1] != 0) || (dns[2] != 0)) && (dns[3] == 0) )
	{
		alert('Invalid Static DNS 1 value for WAN Setup');
		return 1;
	} 

	if( (dns[0]!=0) || (dns[1]!=0) || (dns[2]!=0) || (dns[3]!=0) )
	{
		//check range
		// check valid IP address values for gateway address for WAN
		ret=IPCheck1(dns[0]);
		//NOTE: ret value of 1 is not possible as we already called checkDigit function, so don't check it.
		if(ret==2)
		{
			alert('Input a value from 1 to 223 for First Octet of Static DNS 1 for WAN Setup');
			return 1;
		}

		retVal=IPCheck2(dns[1]);
		if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of Static DNS 1 for WAN Setup');
			return 1;
		}

		retVal=IPCheck2(dns[2]);
		if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of Static DNS 1 for WAN Setup');
			return 1;
		}

		if((dns[3]<1) || (dns[3] > 255))
		{
			alert('Input a value from 1 to 255 for Fourth Octet of Static DNS 1 for WAN Setup');
			return 1;
		}	
	}

	//Static DNS2
	dns[0]=a._3_6_1_2.value;
	dns[1]=a._3_6_2_2.value;
	dns[2]=a._3_6_3_2.value;
	dns[3]=a._3_6_4_2.value;

	//If all dns1 values are empty, set them to zeroes
	if( (dns[0].length==0) && (dns[1].length==0) && (dns[2].length==0) && (dns[3].length==0))
	{
	
		for(i = 0; i < 4; i++)
			dns[i] = 0;

		a._3_6_1_2.value=0;
		a._3_6_2_2.value=0;
		a._3_6_3_2.value=0;
		a._3_6_4_2.value=0;
	}

	if( (dns[0].length==0) || (dns[1].length==0) || (dns[2].length==0) || (dns[3].length==0))
	{
		alert('Input values for Static DNS 2 for WAN Setup');
		return 1;
	}

	for(i=0;i<4; i++)
	{
		ret=checkDigit(dns[i]);
		if(ret==1)
		{
			alert('Input numerical values for Static DNS 2 for WAN Setup');
			return 1;
		}
	}

	if( ( (dns[0]!=0) || (dns[1]!=0) || (dns[2]!=0) ) && (dns[3]==0) )
	{
		alert('Invalid Static DNS 2 value for WAN Setup');
		return 1;
	} 

	if( (dns[0]!=0) || (dns[1]!=0) || (dns[2]!=0) || (dns[3]!=0) )
	{
		//check range
		// check valid IP address values for gateway address for WAN
		ret=IPCheck1(dns[0]);
		//NOTE: ret value of 1 is not possible as we already called checkDigit function, so don't check it.
		if(ret==2)
		{
			alert('Input a value from 1 to 223 for First Octet of Static DNS 2 for WAN Setup');
			return 1;
		}

		retVal=IPCheck2(dns[1]);
		if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of Static DNS 2 for WAN Setup');
			return 1;
		}

		retVal=IPCheck2(dns[2]);
		if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of Static DNS 2 for WAN Setup');
			return 1;
		}

		if((dns[3]<1) || (dns[3] > 255))
		{
			alert('Input a value from 1 to 255 for Fourth Octet of Static DNS 2 for WAN Setup');
			return 1;
		}	
	}

	//Static DNS3
	dns[0]=a._3_7_1_2.value;
	dns[1]=a._3_7_2_2.value;
	dns[2]=a._3_7_3_2.value;
	dns[3]=a._3_7_4_2.value;

	//If all dns1 values are empty, set them to zeroes
	if( (dns[0].length==0) && (dns[1].length==0) && (dns[2].length==0) && (dns[3].length==0))
	{
	
		for(i = 0; i < 4; i++)
			dns[i] = 0;

		a._3_7_1_2.value=0;
		a._3_7_2_2.value=0;
		a._3_7_3_2.value=0;
		a._3_7_4_2.value=0;
	}

	if( (dns[0].length==0) || (dns[1].length==0) || (dns[2].length==0) || (dns[3].length==0))
	{
		alert('Input values for Static DNS 3 for WAN Setup');
		return 1;
	}

	for(i=0;i < 4; i++)
	{
		ret=checkDigit(dns[i]);
		if(ret==1)
		{
			alert('Input numerical values for Static DNS 3 for WAN Setup');
			return 1;
		}
	}

	if( ( (dns[0]!=0) || (dns[1]!=0) || (dns[2]!=0) ) && (dns[3]==0) )
	{
		alert('Invalid Static DNS 3 value for WAN Setup');
		return 1;
	} 

	if( (dns[0]!=0) || (dns[1]!=0) || (dns[2]!=0) || (dns[3]!=0) )
	{
		//check range
		// check valid IP address values for gateway address for WAN
		ret=IPCheck1(dns[0]);
		//NOTE: ret value of 1 is not possible as we already called checkDigit function, so don't check it.
		if(ret==2)
		{
			alert('Input a value from 1 to 223 for First Octet of Static DNS 3 for WAN Setup');
			return 1;
		}

		retVal=IPCheck2(dns[1]);
		if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of Static DNS 3 for WAN Setup');
			return 1;
		}

		retVal=IPCheck2(dns[2]);
		if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of Static DNS 3 for WAN Setup');
			return 1;
		}

		if((dns[3]<1) || (dns[3] > 255))
		{
			alert('Input a value from 1 to 255 for Fourth Octet of Static DNS 3 for WAN Setup');
			return 1;
		}	
	}

	return 0;
}

//
//
function CheckMTU_Val(a)
{
	val=a._3_10_2_2.value
	if(val.length=0)
	{
		alert('Input a value for MTU');
		return 1;
	}
	var proceed=checkDigit(val);
	if(proceed==1)
	{
		alert('Input numerical value for MTU');
		return 1;
	}
	if(proceed==0)
	{	
		var wanType=a._3_1_0_2.value;
		if((wanType==0) || (wanType==1)) //dhcp or static ip
		{
			if((val<576) || (val >1500))
			{
				alert('MTU size should be between 576 and 1500')
				return 1;
			}
		}
		else if(wanType==2) //pppoe
		{
			if((val<576) || (val >1492))
			{
				alert('MTU size for PPPoE should be between 576 and 1492')
				return 1;
			}
		}
		else if(wanType==3) //pptp
		{
			if((val<576) || (val >1460))
			{
				alert('MTU size for PPTP should be between 576 and 1460')
				return 1;
			}
		}
	}
	return 0;
}


//
//
function SelectMTU(a,b)
{
	if(a==0)
		b._3_10_2_2.disabled = true;
	else if(a==1)
		b._3_10_2_2.disabled = false;
}


//
//
function SetMTU(a)
{
	var wanType=a._3_1_0_2.value;
	if((wanType==0) || (wanType==1) || (wanType==4))
		a._3_10_2_2.value=1500;
	else if(wanType==2)
		a._3_10_2_2.value=1492;
	else if(wanType==3)
		a._3_10_2_2.value=1460;

	return true;
}


//
//
function wanSelect(a)
{
	val = a._3_1_0_2.value;
	
	if((val==0) || (val==4)) //dhcp or cellular
	{
		document.getElementById("wanhide1").style.display = "none";
		document.getElementById("wanhide2").style.display = "none";
		document.getElementById("wanhide3").style.display = "none";
		document.getElementById("wanhide4").style.display = "none";
		document.getElementById("wanhide5").style.display = "none";
		document.getElementById("wanhide6").style.display = "none";

		document.getElementById("wanhide7").style.display = "none";
		document.getElementById("wanhide8").style.display = "none";
		document.getElementById("wanhide9").style.display = "none";
		document.getElementById("wanhide10").style.display = "none";
		document.getElementById("wanhide11").style.display = "none";
		document.getElementById("wanhide12").style.display = "none";
	}
	else if(val==1) //static ip
	{
		document.getElementById("wanhide1").style.display = "block";
		document.getElementById("wanhide2").style.display = "block";
		document.getElementById("wanhide3").style.display = "block";
		document.getElementById("wanhide4").style.display = "block";
		document.getElementById("wanhide5").style.display = "block";
		document.getElementById("wanhide6").style.display = "block";
		
		document.getElementById("wanhide7").style.display = "none";
		document.getElementById("wanhide8").style.display = "none";
		document.getElementById("wanhide9").style.display = "none";
		document.getElementById("wanhide10").style.display = "none";
		document.getElementById("wanhide11").style.display = "none";
		document.getElementById("wanhide12").style.display = "none";
	}
	else if(val==2) //pppoe
	{
		document.getElementById("wanhide1").style.display = "none";
		document.getElementById("wanhide2").style.display = "none";
		document.getElementById("wanhide3").style.display = "none";
		document.getElementById("wanhide4").style.display = "none";
		document.getElementById("wanhide5").style.display = "none";
		document.getElementById("wanhide6").style.display = "none";

		document.getElementById("wanhide7").style.display = "block";
		document.getElementById("wanhide8").style.display = "block";
		document.getElementById("wanhide9").style.display = "block";
		document.getElementById("wanhide10").style.display = "block";
		document.getElementById("wanhide11").style.display = "block";
		document.getElementById("wanhide12").style.display = "none";
	}
	else if(val==3) //pptp
	{
		document.getElementById("wanhide1").style.display = "block";
		document.getElementById("wanhide2").style.display = "block";
		document.getElementById("wanhide3").style.display = "block";
		document.getElementById("wanhide4").style.display = "none";
		document.getElementById("wanhide5").style.display = "none";
		document.getElementById("wanhide6").style.display = "none";

		document.getElementById("wanhide7").style.display = "block";
		document.getElementById("wanhide8").style.display = "block";
		document.getElementById("wanhide9").style.display = "none";
		document.getElementById("wanhide10").style.display = "block";
		document.getElementById("wanhide11").style.display = "block";
		document.getElementById("wanhide12").style.display = "block";
	}


	return true;
}


//
//
function PortCheck(value)
{
	var proceed=checkDigit(value);
	if(proceed==1)
	{
		alert('Input numerical value for Port Number');
		return false;
	}
	if(proceed==0)
	{
		if((value<1) || (value >65535))
		{
			alert('Port Number should be between 1 and 65535')
			return false; 
		}
	}
	return true;
}


//
//
function isSameSubnet(type,a,b,c,d,e)
{
	var nm_array1 = new Array(4);
	var nm_array2 = new Array(4);

	if(type==1) //WAN Settings
	{
		ip=a._5_3_2_1.value;
		subnet=a._5_3_3_1.value;
	}
	else if(type==2) //LAN Settings
	{
		ip=a._5_4_1_1.value;
		subnet=a._5_4_2_1.value;
	}

	ip_array=ip.split(".");
	subnet_array=subnet.split(".");

		
	for (i = 0; i < 4; i++)
		nm_array1[i] = ip_array[i] & subnet_array[i];

	nm_array2[0] = b & subnet_array[0];
	nm_array2[1] = c & subnet_array[1];
	nm_array2[2] = d & subnet_array[2];
	nm_array2[3] = e & subnet_array[3];

	//if network addresses don't match, not in same subnet
	if((nm_array1[0]!=nm_array2[0]) || (nm_array1[1]!=nm_array2[1]) || (nm_array1[2]!=nm_array2[2]) || (nm_array1[3]!=nm_array2[3]) )
		return 1;	

	//if ip address matches network address
	if((b==nm_array2[0]) && (c==nm_array2[1]) && (d==nm_array2[2]) && (e==nm_array2[3]) )
		return 2;

	//calculate inverse netmask
	var invSubnet=new Array(4);
	for (i = 0; i < 4; i++)
		invSubnet[i] = subnet_array[i] ^ 255;

	//calculate broadcast address
	var bc=new Array(4);
	for (i = 0; i < 4; i++)
		bc[i] = ip_array[i] | invSubnet[i];	

	//if ip address matches broadcast address
	if((b==bc[0]) && (c==bc[1]) && (d==bc[2]) && (e==bc[3]) )
		return 3;

	return 0;
}

//
//
function pfcheck1(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._6_5_0_2;

	if(b.checked)
	{
		p1=a._6_1_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		ip[0]=a._6_3_1_2.value;
		ip[1]=a._6_3_2_2.value;
		ip[2]=a._6_3_3_2.value;
		ip[3]=a._6_3_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}	
	
		p2=a._6_4_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		if(parseInt(p2,10) < parseInt(p1,10))
		{
			alert('End Port should be equal or greater than Start Port');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function pfcheck2(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._6_10_0_2;

	if(b.checked)
	{
		p1=a._6_6_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		ip[0]=a._6_8_1_2.value;
		ip[1]=a._6_8_2_2.value;
		ip[2]=a._6_8_3_2.value;
		ip[3]=a._6_8_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}	
	
		p2=a._6_9_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		if(parseInt(p2,10) < parseInt(p1,10))
		{
			alert('End Port should be equal or greater than Start Port');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function pfcheck3(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._6_15_0_2;

	if(b.checked)
	{
		p1=a._6_11_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		ip[0]=a._6_13_1_2.value;
		ip[1]=a._6_13_2_2.value;
		ip[2]=a._6_13_3_2.value;
		ip[3]=a._6_13_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}	
	
		p2=a._6_14_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		if(parseInt(p2,10) < parseInt(p1,10))
		{
			alert('End Port should be equal or greater than Start Port');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function pfcheck4(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._6_20_0_2;

	if(b.checked)
	{
		p1=a._6_16_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._6_18_1_2.value;
		ip[1]=a._6_18_2_2.value;
		ip[2]=a._6_18_3_2.value;
		ip[3]=a._6_18_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		p2=a._6_19_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		if(parseInt(p2,10) < parseInt(p1,10))
		{
			alert('End Port should be equal or greater than Start Port');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function pfcheck5(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._6_25_0_2;

	if(b.checked)
	{
		p1=a._6_21_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		ip[0]=a._6_23_1_2.value;
		ip[1]=a._6_23_2_2.value;
		ip[2]=a._6_23_3_2.value;
		ip[3]=a._6_23_4_2.value;
	
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		p2=a._6_24_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		if(parseInt(p2,10) < parseInt(p1,10))
		{
			alert('End Port should be equal or greater than Start Port');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function pfcheck6(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._6_30_0_2;

	if(b.checked)
	{
		p1=a._6_26_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		ip[0]=a._6_28_1_2.value;
		ip[1]=a._6_28_2_2.value;
		ip[2]=a._6_28_3_2.value;
		ip[3]=a._6_28_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}	
	
		p2=a._6_29_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		if(parseInt(p2,10) < parseInt(p1,10))
		{
			alert('End Port should be equal or greater than Start Port');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function pfcheck7(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._6_35_0_2;

	if(b.checked)
	{
		p1=a._6_31_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._6_33_1_2.value;
		ip[1]=a._6_33_2_2.value;
		ip[2]=a._6_33_3_2.value;
		ip[3]=a._6_33_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}	
		
		p2=a._6_34_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		if(parseInt(p2,10) < parseInt(p1,10))
		{
			alert('End Port should be equal or greater than Start Port');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function pfcheck8(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._6_40_0_2;

	if(b.checked)
	{
		p1=a._6_36_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._6_38_1_2.value;
		ip[1]=a._6_38_2_2.value;
		ip[2]=a._6_38_3_2.value;
		ip[3]=a._6_38_4_2.value;
	
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}	
		
		p2=a._6_39_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		if(parseInt(p2,10) < parseInt(p1,10))
		{
			alert('End Port should be equal or greater than Start Port');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}	
	}
}


//
//
function pfcheck9(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._6_45_0_2;

	if(b.checked)
	{
		p1=a._6_41_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._6_43_1_2.value;
		ip[1]=a._6_43_2_2.value;
		ip[2]=a._6_43_3_2.value;
		ip[3]=a._6_43_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}	
		
		p2=a._6_44_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		if(parseInt(p2,10) < parseInt(p1,10))
		{
			alert('End Port should be equal or greater than Start Port');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function pfcheck10(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._6_50_0_2;

	if(b.checked)
	{
		p1=a._6_46_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._6_48_1_2.value;
		ip[1]=a._6_48_2_2.value;
		ip[2]=a._6_48_3_2.value;
		ip[3]=a._6_48_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		p2=a._6_49_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		if(parseInt(p2,10) < parseInt(p1,10))
		{
			alert('End Port should be equal or greater than Start Port');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function pfcheck11(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._6_55_0_2;

	if(b.checked)
	{
		p1=a._6_51_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._6_53_1_2.value;
		ip[1]=a._6_53_2_2.value;
		ip[2]=a._6_53_3_2.value;
		ip[3]=a._6_53_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		p2=a._6_54_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		if(parseInt(p2,10) < parseInt(p1,10))
		{
			alert('End Port should be equal or greater than Start Port');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function pfcheck12(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._6_60_0_2;

	if(b.checked)
	{
		p1=a._6_56_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._6_58_1_2.value;
		ip[1]=a._6_58_2_2.value;
		ip[2]=a._6_58_3_2.value;
		ip[3]=a._6_58_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		p2=a._6_59_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		if(parseInt(p2,10) < parseInt(p1,10))
		{
			alert('End Port should be equal or greater than Start Port');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function pfcheck13(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._6_65_0_2;

	if(b.checked)
	{
		p1=a._6_61_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._6_63_1_2.value;
		ip[1]=a._6_63_2_2.value;
		ip[2]=a._6_63_3_2.value;
		ip[3]=a._6_63_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		p2=a._6_64_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		if(parseInt(p2,10) < parseInt(p1,10))
		{
			alert('End Port should be equal or greater than Start Port');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}

//
//
function pfcheck14(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._6_70_0_2;

	if(b.checked)
	{
		p1=a._6_66_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._6_68_1_2.value;
		ip[1]=a._6_68_2_2.value;
		ip[2]=a._6_68_3_2.value;
		ip[3]=a._6_68_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		p2=a._6_69_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		if(parseInt(p2,10) < parseInt(p1,10))
		{
			alert('End Port should be equal or greater than Start Port');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}

//
//
function pfcheck15(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._6_75_0_2;

	if(b.checked)
	{
		p1=a._6_71_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._6_73_1_2.value;
		ip[1]=a._6_73_2_2.value;
		ip[2]=a._6_73_3_2.value;
		ip[3]=a._6_73_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		p2=a._6_74_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		if(parseInt(p2,10) < parseInt(p1,10))
		{
			alert('End Port should be equal or greater than Start Port');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}

//
//
function pfcheck16(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._6_80_0_2;

	if(b.checked)
	{
		p1=a._6_76_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._6_78_1_2.value;
		ip[1]=a._6_78_2_2.value;
		ip[2]=a._6_78_3_2.value;
		ip[3]=a._6_78_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		p2=a._6_79_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		if(parseInt(p2,10) < parseInt(p1,10))
		{
			alert('End Port should be equal or greater than Start Port');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}

//
//
function pfcheck17(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._6_85_0_2;

	if(b.checked)
	{
		p1=a._6_81_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._6_83_1_2.value;
		ip[1]=a._6_83_2_2.value;
		ip[2]=a._6_83_3_2.value;
		ip[3]=a._6_83_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		p2=a._6_84_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		if(parseInt(p2,10) < parseInt(p1,10))
		{
			alert('End Port should be equal or greater than Start Port');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}

//
//
function pfcheck18(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._6_90_0_2;

	if(b.checked)
	{
		p1=a._6_86_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._6_88_1_2.value;
		ip[1]=a._6_88_2_2.value;
		ip[2]=a._6_88_3_2.value;
		ip[3]=a._6_88_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		p2=a._6_89_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		if(parseInt(p2,10) < parseInt(p1,10))
		{
			alert('End Port should be equal or greater than Start Port');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}

//
//
function pfcheck19(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._6_95_0_2;

	if(b.checked)
	{
		p1=a._6_91_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._6_93_1_2.value;
		ip[1]=a._6_93_2_2.value;
		ip[2]=a._6_93_3_2.value;
		ip[3]=a._6_93_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		p2=a._6_94_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		if(parseInt(p2,10) < parseInt(p1,10))
		{
			alert('End Port should be equal or greater than Start Port');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}

//
//
function pfcheck20(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._6_100_0_2;

	if(b.checked)
	{
		p1=a._6_96_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._6_98_1_2.value;
		ip[1]=a._6_98_2_2.value;
		ip[2]=a._6_98_3_2.value;
		ip[3]=a._6_98_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		p2=a._6_99_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		if(parseInt(p2,10) < parseInt(p1,10))
		{
			alert('End Port should be equal or greater than Start Port');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Range Forwarding');
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}



//
//
function patcheck1(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._1_5_0_2;

	if(b.checked)
	{
		p1=a._1_1_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		ip[0]=a._1_3_1_2.value;
		ip[1]=a._1_3_2_2.value;
		ip[2]=a._1_3_3_2.value;
		ip[3]=a._1_3_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}	
	
		p2=a._1_4_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function patcheck2(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._1_10_0_2;

	if(b.checked)
	{
		p1=a._1_6_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		ip[0]=a._1_8_1_2.value;
		ip[1]=a._1_8_2_2.value;
		ip[2]=a._1_8_3_2.value;
		ip[3]=a._1_8_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}	
	
		p2=a._1_9_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function patcheck3(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._1_15_0_2;

	if(b.checked)
	{
		p1=a._1_11_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		ip[0]=a._1_13_1_2.value;
		ip[1]=a._1_13_2_2.value;
		ip[2]=a._1_13_3_2.value;
		ip[3]=a._1_13_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}	
	
		p2=a._1_14_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function patcheck4(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._1_20_0_2;

	if(b.checked)
	{
		p1=a._1_16_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._1_18_1_2.value;
		ip[1]=a._1_18_2_2.value;
		ip[2]=a._1_18_3_2.value;
		ip[3]=a._1_18_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		p2=a._1_19_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function patcheck5(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._1_25_0_2;

	if(b.checked)
	{
		p1=a._1_21_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		ip[0]=a._1_23_1_2.value;
		ip[1]=a._1_23_2_2.value;
		ip[2]=a._1_23_3_2.value;
		ip[3]=a._1_23_4_2.value;
	
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		p2=a._1_24_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function patcheck6(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._1_30_0_2;

	if(b.checked)
	{
		p1=a._1_26_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		ip[0]=a._1_28_1_2.value;
		ip[1]=a._1_28_2_2.value;
		ip[2]=a._1_28_3_2.value;
		ip[3]=a._1_28_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}	
	
		p2=a._1_29_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function patcheck7(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._1_35_0_2;

	if(b.checked)
	{
		p1=a._1_31_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._1_33_1_2.value;
		ip[1]=a._1_33_2_2.value;
		ip[2]=a._1_33_3_2.value;
		ip[3]=a._1_33_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}	
		
		p2=a._1_34_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function patcheck8(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._1_40_0_2;

	if(b.checked)
	{
		p1=a._1_36_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._1_38_1_2.value;
		ip[1]=a._1_38_2_2.value;
		ip[2]=a._1_38_3_2.value;
		ip[3]=a._1_38_4_2.value;
	
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}	
		
		p2=a._1_39_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}	
	}
}


//
//
function patcheck9(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._1_45_0_2;

	if(b.checked)
	{
		p1=a._1_41_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._1_43_1_2.value;
		ip[1]=a._1_43_2_2.value;
		ip[2]=a._1_43_3_2.value;
		ip[3]=a._1_43_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}	
		
		p2=a._1_44_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function patcheck10(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._1_50_0_2;

	if(b.checked)
	{
		p1=a._1_46_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._1_48_1_2.value;
		ip[1]=a._1_48_2_2.value;
		ip[2]=a._1_48_3_2.value;
		ip[3]=a._1_48_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		p2=a._1_49_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function patcheck11(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._1_55_0_2;

	if(b.checked)
	{
		p1=a._1_51_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._1_53_1_2.value;
		ip[1]=a._1_53_2_2.value;
		ip[2]=a._1_53_3_2.value;
		ip[3]=a._1_53_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}	
		
		p2=a._1_54_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function patcheck12(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._1_60_0_2;

	if(b.checked)
	{
		p1=a._1_56_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._1_58_1_2.value;
		ip[1]=a._1_58_2_2.value;
		ip[2]=a._1_58_3_2.value;
		ip[3]=a._1_58_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		p2=a._1_59_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}

//
//
function patcheck13(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._1_65_0_2;

	if(b.checked)
	{
		p1=a._1_61_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._1_63_1_2.value;
		ip[1]=a._1_63_2_2.value;
		ip[2]=a._1_63_3_2.value;
		ip[3]=a._1_63_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}	
		
		p2=a._1_64_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function patcheck14(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._1_70_0_2;

	if(b.checked)
	{
		p1=a._1_66_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._1_68_1_2.value;
		ip[1]=a._1_68_2_2.value;
		ip[2]=a._1_68_3_2.value;
		ip[3]=a._1_68_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		p2=a._1_69_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}

//
//
function patcheck15(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._1_75_0_2;

	if(b.checked)
	{
		p1=a._1_71_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._1_73_1_2.value;
		ip[1]=a._1_73_2_2.value;
		ip[2]=a._1_73_3_2.value;
		ip[3]=a._1_73_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}	
		
		p2=a._1_74_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function patcheck16(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._1_80_0_2;

	if(b.checked)
	{
		p1=a._1_76_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._1_78_1_2.value;
		ip[1]=a._1_78_2_2.value;
		ip[2]=a._1_78_3_2.value;
		ip[3]=a._1_78_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		p2=a._1_79_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}

//
//
function patcheck17(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._1_85_0_2;

	if(b.checked)
	{
		p1=a._1_81_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._1_83_1_2.value;
		ip[1]=a._1_83_2_2.value;
		ip[2]=a._1_83_3_2.value;
		ip[3]=a._1_83_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}	
		
		p2=a._1_84_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function patcheck18(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._1_90_0_2;

	if(b.checked)
	{
		p1=a._1_86_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._1_88_1_2.value;
		ip[1]=a._1_88_2_2.value;
		ip[2]=a._1_88_3_2.value;
		ip[3]=a._1_88_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		p2=a._1_89_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}

//
//
function patcheck19(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._1_95_0_2;

	if(b.checked)
	{
		p1=a._1_91_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._1_93_1_2.value;
		ip[1]=a._1_93_2_2.value;
		ip[2]=a._1_93_3_2.value;
		ip[3]=a._1_93_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}	
		
		p2=a._1_94_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function patcheck20(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._1_100_0_2;

	if(b.checked)
	{
		p1=a._1_96_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		ip[0]=a._1_98_1_2.value;
		ip[1]=a._1_98_2_2.value;
		ip[2]=a._1_98_3_2.value;
		ip[3]=a._1_98_4_2.value;
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		p2=a._1_99_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
	
		retVal=PortCheck(p1)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}
	
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck1(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_3_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_1_1_2.value;
		ip1[1]=a._2_1_2_2.value;
		ip1[2]=a._2_1_3_2.value;
		ip1[3]=a._2_1_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}		

		ip[0]=a._2_2_1_2.value;
		ip[1]=a._2_2_2_2.value;
		ip[2]=a._2_2_3_2.value;
		ip[3]=a._2_2_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck2(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_6_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_4_1_2.value;
		ip1[1]=a._2_4_2_2.value;
		ip1[2]=a._2_4_3_2.value;
		ip1[3]=a._2_4_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_5_1_2.value;
		ip[1]=a._2_5_2_2.value;
		ip[2]=a._2_5_3_2.value;
		ip[3]=a._2_5_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck3(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_9_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_7_1_2.value;
		ip1[1]=a._2_7_2_2.value;
		ip1[2]=a._2_7_3_2.value;
		ip1[3]=a._2_7_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}
		
		ip[0]=a._2_8_1_2.value;
		ip[1]=a._2_8_2_2.value;
		ip[2]=a._2_8_3_2.value;
		ip[3]=a._2_8_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
		
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck4(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_12_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_10_1_2.value;
		ip1[1]=a._2_10_2_2.value;
		ip1[2]=a._2_10_3_2.value;
		ip1[3]=a._2_10_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}
		
		ip[0]=a._2_11_1_2.value;
		ip[1]=a._2_11_2_2.value;
		ip[2]=a._2_11_3_2.value;
		ip[3]=a._2_11_4_2.value;
	
		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck5(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_15_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_13_1_2.value;
		ip1[1]=a._2_13_2_2.value;
		ip1[2]=a._2_13_3_2.value;
		ip1[3]=a._2_13_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_14_1_2.value;
		ip[1]=a._2_14_2_2.value;
		ip[2]=a._2_14_3_2.value;
		ip[3]=a._2_14_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck6(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_18_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_16_1_2.value;
		ip1[1]=a._2_16_2_2.value;
		ip1[2]=a._2_16_3_2.value;
		ip1[3]=a._2_16_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_17_1_2.value;
		ip[1]=a._2_17_2_2.value;
		ip[2]=a._2_17_3_2.value;
		ip[3]=a._2_17_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck7(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_21_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_19_1_2.value;
		ip1[1]=a._2_19_2_2.value;
		ip1[2]=a._2_19_3_2.value;
		ip1[3]=a._2_19_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_20_1_2.value;
		ip[1]=a._2_20_2_2.value;
		ip[2]=a._2_20_3_2.value;
		ip[3]=a._2_20_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck8(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_24_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_22_1_2.value;
		ip1[1]=a._2_22_2_2.value;
		ip1[2]=a._2_22_3_2.value;
		ip1[3]=a._2_22_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_23_1_2.value;
		ip[1]=a._2_23_2_2.value;
		ip[2]=a._2_23_3_2.value;
		ip[3]=a._2_23_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck9(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_27_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_25_1_2.value;
		ip1[1]=a._2_25_2_2.value;
		ip1[2]=a._2_25_3_2.value;
		ip1[3]=a._2_25_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_26_1_2.value;
		ip[1]=a._2_26_2_2.value;
		ip[2]=a._2_26_3_2.value;
		ip[3]=a._2_26_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck10(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_30_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_28_1_2.value;
		ip1[1]=a._2_28_2_2.value;
		ip1[2]=a._2_28_3_2.value;
		ip1[3]=a._2_28_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_29_1_2.value;
		ip[1]=a._2_29_2_2.value;
		ip[2]=a._2_29_3_2.value;
		ip[3]=a._2_29_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck11(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_33_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_31_1_2.value;
		ip1[1]=a._2_31_2_2.value;
		ip1[2]=a._2_31_3_2.value;
		ip1[3]=a._2_31_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_32_1_2.value;
		ip[1]=a._2_32_2_2.value;
		ip[2]=a._2_32_3_2.value;
		ip[3]=a._2_32_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck12(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_36_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_34_1_2.value;
		ip1[1]=a._2_34_2_2.value;
		ip1[2]=a._2_34_3_2.value;
		ip1[3]=a._2_34_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_35_1_2.value;
		ip[1]=a._2_35_2_2.value;
		ip[2]=a._2_35_3_2.value;
		ip[3]=a._2_35_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck13(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_39_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_37_1_2.value;
		ip1[1]=a._2_37_2_2.value;
		ip1[2]=a._2_37_3_2.value;
		ip1[3]=a._2_37_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_38_1_2.value;
		ip[1]=a._2_38_2_2.value;
		ip[2]=a._2_38_3_2.value;
		ip[3]=a._2_38_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck14(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_42_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_40_1_2.value;
		ip1[1]=a._2_40_2_2.value;
		ip1[2]=a._2_40_3_2.value;
		ip1[3]=a._2_40_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_41_1_2.value;
		ip[1]=a._2_41_2_2.value;
		ip[2]=a._2_41_3_2.value;
		ip[3]=a._2_41_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck15(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_45_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_43_1_2.value;
		ip1[1]=a._2_43_2_2.value;
		ip1[2]=a._2_43_3_2.value;
		ip1[3]=a._2_43_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_44_1_2.value;
		ip[1]=a._2_44_2_2.value;
		ip[2]=a._2_44_3_2.value;
		ip[3]=a._2_44_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck16(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_48_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_46_1_2.value;
		ip1[1]=a._2_46_2_2.value;
		ip1[2]=a._2_46_3_2.value;
		ip1[3]=a._2_46_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_47_1_2.value;
		ip[1]=a._2_47_2_2.value;
		ip[2]=a._2_47_3_2.value;
		ip[3]=a._2_47_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck17(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_51_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_49_1_2.value;
		ip1[1]=a._2_49_2_2.value;
		ip1[2]=a._2_49_3_2.value;
		ip1[3]=a._2_49_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_50_1_2.value;
		ip[1]=a._2_50_2_2.value;
		ip[2]=a._2_50_3_2.value;
		ip[3]=a._2_50_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck18(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_54_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_52_1_2.value;
		ip1[1]=a._2_52_2_2.value;
		ip1[2]=a._2_52_3_2.value;
		ip1[3]=a._2_52_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_53_1_2.value;
		ip[1]=a._2_53_2_2.value;
		ip[2]=a._2_53_3_2.value;
		ip[3]=a._2_53_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck19(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_57_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_55_1_2.value;
		ip1[1]=a._2_55_2_2.value;
		ip1[2]=a._2_55_3_2.value;
		ip1[3]=a._2_55_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_56_1_2.value;
		ip[1]=a._2_56_2_2.value;
		ip[2]=a._2_56_3_2.value;
		ip[3]=a._2_56_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck20(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_60_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_58_1_2.value;
		ip1[1]=a._2_58_2_2.value;
		ip1[2]=a._2_58_3_2.value;
		ip1[3]=a._2_58_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_59_1_2.value;
		ip[1]=a._2_59_2_2.value;
		ip[2]=a._2_59_3_2.value;
		ip[3]=a._2_59_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck21(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_63_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_61_1_2.value;
		ip1[1]=a._2_61_2_2.value;
		ip1[2]=a._2_61_3_2.value;
		ip1[3]=a._2_61_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_62_1_2.value;
		ip[1]=a._2_62_2_2.value;
		ip[2]=a._2_62_3_2.value;
		ip[3]=a._2_62_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck22(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_66_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_64_1_2.value;
		ip1[1]=a._2_64_2_2.value;
		ip1[2]=a._2_64_3_2.value;
		ip1[3]=a._2_64_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_65_1_2.value;
		ip[1]=a._2_65_2_2.value;
		ip[2]=a._2_65_3_2.value;
		ip[3]=a._2_65_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck23(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_69_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_67_1_2.value;
		ip1[1]=a._2_67_2_2.value;
		ip1[2]=a._2_67_3_2.value;
		ip1[3]=a._2_67_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_68_1_2.value;
		ip[1]=a._2_68_2_2.value;
		ip[2]=a._2_68_3_2.value;
		ip[3]=a._2_68_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck24(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_72_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_70_1_2.value;
		ip1[1]=a._2_70_2_2.value;
		ip1[2]=a._2_70_3_2.value;
		ip1[3]=a._2_70_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_71_1_2.value;
		ip[1]=a._2_71_2_2.value;
		ip[2]=a._2_71_3_2.value;
		ip[3]=a._2_71_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck25(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_75_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_73_1_2.value;
		ip1[1]=a._2_73_2_2.value;
		ip1[2]=a._2_73_3_2.value;
		ip1[3]=a._2_73_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_74_1_2.value;
		ip[1]=a._2_74_2_2.value;
		ip[2]=a._2_74_3_2.value;
		ip[3]=a._2_74_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck26(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_78_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_76_1_2.value;
		ip1[1]=a._2_76_2_2.value;
		ip1[2]=a._2_76_3_2.value;
		ip1[3]=a._2_76_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_77_1_2.value;
		ip[1]=a._2_77_2_2.value;
		ip[2]=a._2_77_3_2.value;
		ip[3]=a._2_77_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck27(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_81_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_79_1_2.value;
		ip1[1]=a._2_79_2_2.value;
		ip1[2]=a._2_79_3_2.value;
		ip1[3]=a._2_79_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_80_1_2.value;
		ip[1]=a._2_80_2_2.value;
		ip[2]=a._2_80_3_2.value;
		ip[3]=a._2_80_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck28(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_84_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_82_1_2.value;
		ip1[1]=a._2_82_2_2.value;
		ip1[2]=a._2_82_3_2.value;
		ip1[3]=a._2_82_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_83_1_2.value;
		ip[1]=a._2_83_2_2.value;
		ip[2]=a._2_83_3_2.value;
		ip[3]=a._2_83_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck29(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_87_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_85_1_2.value;
		ip1[1]=a._2_85_2_2.value;
		ip1[2]=a._2_85_3_2.value;
		ip1[3]=a._2_85_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_86_1_2.value;
		ip[1]=a._2_86_2_2.value;
		ip[2]=a._2_86_3_2.value;
		ip[3]=a._2_86_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function natcheck30(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._2_90_0_2;

	if(b.checked)
	{
		ip1[0]=a._2_88_1_2.value;
		ip1[1]=a._2_88_2_2.value;
		ip1[2]=a._2_88_3_2.value;
		ip1[3]=a._2_88_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for WAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of WAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('WAN IP address entered for NAT is not in WAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('WAN IP address entered for NAT matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('WAN IP address entered for NAT matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}

		ip[0]=a._2_89_1_2.value;
		ip[1]=a._2_89_2_2.value;
		ip[2]=a._2_89_3_2.value;
		ip[3]=a._2_89_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}
			
		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for LAN IP address for NAT');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of LAN IP address for NAT');
			b.checked=false;
			return false;
		}
			
		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('LAN IP address entered for NAT is not in LAN subnet!!')
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('LAN IP address entered for NAT matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('LAN IP address entered for NAT matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
	}
}

//
//
function checkPortRangePage(a)
{
	var retVal;
	retVal=pfcheck1(a);if(retVal==false) return false;
	retVal=pfcheck2(a);if(retVal==false) return false;
	retVal=pfcheck3(a);if(retVal==false) return false;
	retVal=pfcheck4(a);if(retVal==false) return false;
	retVal=pfcheck5(a);if(retVal==false) return false;
	retVal=pfcheck6(a);if(retVal==false) return false;
	retVal=pfcheck7(a);if(retVal==false) return false;
	retVal=pfcheck8(a);if(retVal==false) return false;
	retVal=pfcheck9(a);if(retVal==false) return false;
	retVal=pfcheck10(a);if(retVal==false) return false;
	retVal=pfcheck11(a);if(retVal==false) return false;
	retVal=pfcheck12(a);if(retVal==false) return false;
	retVal=pfcheck13(a);if(retVal==false) return false;
	retVal=pfcheck14(a);if(retVal==false) return false;
	retVal=pfcheck15(a);if(retVal==false) return false;
	retVal=pfcheck16(a);if(retVal==false) return false;
	retVal=pfcheck17(a);if(retVal==false) return false;
	retVal=pfcheck18(a);if(retVal==false) return false;
	retVal=pfcheck19(a);if(retVal==false) return false;
	retVal=pfcheck20(a);if(retVal==false) return false;


	return true;
}



//
//
function checkPatPage(a)
{
	var retVal;
	var wan_port=new Array(20);
	var enabledVal=new Array(20);
	var run=1; 

	retVal=patcheck1(a);if(retVal==false) return false;
	retVal=patcheck2(a);if(retVal==false) return false;
	retVal=patcheck3(a);if(retVal==false) return false;
	retVal=patcheck4(a);if(retVal==false) return false;
	retVal=patcheck5(a);if(retVal==false) return false;
	retVal=patcheck6(a);if(retVal==false) return false;
	retVal=patcheck7(a);if(retVal==false) return false;
	retVal=patcheck8(a);if(retVal==false) return false;
	retVal=patcheck9(a);if(retVal==false) return false;
	retVal=patcheck10(a);if(retVal==false) return false;
	retVal=patcheck11(a);if(retVal==false) return false;
	retVal=patcheck12(a);if(retVal==false) return false;
	retVal=patcheck13(a);if(retVal==false) return false;
	retVal=patcheck14(a);if(retVal==false) return false;
	retVal=patcheck15(a);if(retVal==false) return false;
	retVal=patcheck16(a);if(retVal==false) return false;
	retVal=patcheck17(a);if(retVal==false) return false;
	retVal=patcheck18(a);if(retVal==false) return false;
	retVal=patcheck19(a);if(retVal==false) return false;
	retVal=patcheck20(a);if(retVal==false) return false;

	enabledVal[0]=a._1_5_0_2.checked;
	enabledVal[1]=a._1_10_0_2.checked;
	enabledVal[2]=a._1_15_0_2.checked;
	enabledVal[3]=a._1_20_0_2.checked;
	enabledVal[4]=a._1_25_0_2.checked;
	enabledVal[5]=a._1_30_0_2.checked;
	enabledVal[6]=a._1_35_0_2.checked;
	enabledVal[7]=a._1_40_0_2.checked;
	enabledVal[8]=a._1_45_0_2.checked;
	enabledVal[9]=a._1_50_0_2.checked;
	enabledVal[10]=a._1_55_0_2.checked;
	enabledVal[11]=a._1_60_0_2.checked;
	enabledVal[12]=a._1_65_0_2.checked;
	enabledVal[13]=a._1_70_0_2.checked;
	enabledVal[14]=a._1_75_0_2.checked;
	enabledVal[15]=a._1_80_0_2.checked;
	enabledVal[16]=a._1_85_0_2.checked;
	enabledVal[17]=a._1_90_0_2.checked;
	enabledVal[18]=a._1_95_0_2.checked;
	enabledVal[19]=a._1_100_0_2.checked;

	wan_port[0]=a._1_1_0_2.value;
	wan_port[1]=a._1_6_0_2.value;
	wan_port[2]=a._1_11_0_2.value;
	wan_port[3]=a._1_16_0_2.value;
	wan_port[4]=a._1_21_0_2.value;
	wan_port[5]=a._1_26_0_2.value;
	wan_port[6]=a._1_31_0_2.value;
	wan_port[7]=a._1_36_0_2.value;
	wan_port[8]=a._1_41_0_2.value;
	wan_port[9]=a._1_46_0_2.value;
	wan_port[10]=a._1_51_0_2.value;
	wan_port[11]=a._1_56_0_2.value;
	wan_port[12]=a._1_61_0_2.value;
	wan_port[13]=a._1_66_0_2.value;
	wan_port[14]=a._1_71_0_2.value;
	wan_port[15]=a._1_76_0_2.value;
	wan_port[16]=a._1_81_0_2.value;
	wan_port[17]=a._1_86_0_2.value;
	wan_port[18]=a._1_91_0_2.value;
	wan_port[19]=a._1_96_0_2.value;

	for(i=0; i<19 && run;i++)
	{
		if(enabledVal[i])
		{		
			for(j=(i+1);j<20 && run; j++)
			{
				if((enabledVal[j]) && (wan_port[i]==wan_port[j]))
					run=0;
			}
		}
	}

	
	if(run==0)
	{
	alert('Duplicate WAN IP Ports!!');
	return false;	
	}

	return true;
}

//
//
function patcheck_1(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._12_5_0_2;

	
		p1=a._12_1_0_2.value;
		if(p1.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		ip[0]=a._12_3_1_2.value;
		ip[1]=a._12_3_2_2.value;
		ip[2]=a._12_3_3_2.value;
		ip[3]=a._12_3_4_2.value;

		if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}	
	
		p2=a._12_4_0_2.value;
		if(p2.length==0)
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p1)
		if(retVal==false)
		{	
			b.checked=false;		
			return false;
		}

		retVal=IPCheck1(ip[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Port Forwarding');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
			b.checked=false;
			return false;
		}

		retVal=PortCheck(p2)
		if(retVal==false)
		{
			b.checked=false;
			return false;
		}

		ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
		if(ret==1)
		{
			alert('IP address entered is not in LAN subnet!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}

	return true;
	
}

//
//
function checkPat100Page(a)
{
	var retVal;
	retVal = a._12_6_0_2.value;
	if(retVal > 99)
	{
		alert('Maximum 100 entries allowed. No more entries can be added.');
		return false;
	}
	retVal=patcheck_1(a);if(retVal==false) return false;
	
	return true;	
} 

//
//
function checkPFDelete(a)
{
	var b = a._12_7_0_2;
	var numEntries = a._12_6_0_2.value;
	
	val=b.value;
	if(val.length==0)
	{
		alert('Input a value to Delete Entry');
		b.focus();
		return false;
	}
	ret=NumberCheck(val, 1, 100);
	if(ret==1)
	{
		alert('Input numerical value to Delete Entry');
		b.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Delete Entry value should be between 1 and 100');
		b.focus();
		return false; 
	}
	
	if(parseInt(val,10) > parseInt(numEntries,10))
	{
		alert(' Delete Entry value greater than number of current entries');
		b.focus();
		return false;
	}
	
	return true;
	
}

//
//
function checkPFEdit1(a)
{
	var edit_text=new Array(5);
	var edit_val=new Array(5);
	var edit_used=new Array(5);

	edit_text[0]=a._12_9_0_2;
	edit_text[1]=a._12_9_1_2;
	edit_text[2]=a._12_9_2_2;
	edit_text[3]=a._12_9_3_2;
	edit_text[4]=a._12_9_4_2;

	var numEntries = a._12_6_0_2.value;
	
	for(var i=0; i<5; i++)
		edit_val[i]=edit_text[i].value;


	if(edit_val[0].length==0)
	{
		alert('Input a value to Edit Entry');
		edit_text[0].focus();
		return false;
	}
	ret=NumberCheck(edit_val[0], 1, 100);
	if(ret==1)
	{
		alert('Input numerical value to Delete Entry');
		edit_text[0].focus();
		return false;
	}
	if(ret==2)
	{
		alert('Edit Entry value should be between 1 and 100');
		edit_text[0].focus();
		return false; 
	}
	
	if(parseInt(edit_val[0],10) > parseInt(numEntries,10))
	{
		alert(' Edit Entry value greater than number of current entries');
		edit_text[0].focus();
		return false;
	}

	edit_used[0]=1;
	
	for (var i = 1; i < 5; i++)
	{
		if(edit_val[i].length!=0)
		{
			ret=NumberCheck(edit_val[i], 1, 100);
			if(ret==1)
			{
				alert('Input numerical value to Delete Entry');
				edit_text[i].focus();
				return false;
			}
			if(ret==2)
			{
				alert('Edit Entry value should be between 1 and 100');
				edit_text[i].focus();
				return false; 
			}
		
			if(parseInt(edit_val[i],10) > parseInt(numEntries,10))
			{
				alert(' Edit Entry value greater than number of current entries');
				edit_text[i].focus();
				return false;
			}
			
			edit_used[i]=1;
		}
		else
			edit_used[i]=0;
	}

	for(i = 0; i < 4; i++)
	{
		for(j=i+1; j<5; j++)
		{
			if ( (edit_used[i] && edit_used[j]) && (edit_val[i]==edit_val[j]) )
			{
				alert(' Duplicate Edit Entry values!!');
				edit_text[j].focus();
				return false;
			}
		}
	}
	
	return true;	
}

//
//
function pateditcheck_1(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._12_15_0_2;
	
	p1=a._12_11_0_2.value;
	if(p1.length==0)
	{
		alert('Enter Values before enabling');
		return false;
	}

	ip[0]=a._12_13_1_2.value;
	ip[1]=a._12_13_2_2.value;
	ip[2]=a._12_13_3_2.value;
	ip[3]=a._12_13_4_2.value;

	if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
	{
		alert('Enter Values before enabling');
		return false;
	}	

	p2=a._12_14_0_2.value;
	if(p2.length==0)
	{
		alert('Enter Values before enabling');
		return false;
	}
	retVal=PortCheck(p1)
	if(retVal==false)
	{			
		return false;
	}
	retVal=IPCheck1(ip[0]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for Port Forwarding');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
		return false;
	}

	retVal=IPCheck2(ip[1]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for Port Forwarding');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
		return false;
	}
	
	retVal=IPCheck2(ip[2]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for Port Forwarding');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
		return false;
	}

	retVal=IPCheck2(ip[3]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for Port Forwarding');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
		return false;
	}

	retVal=PortCheck(p2)
	if(retVal==false)
	{
		return false;
	}

	ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
	if(ret==1)
	{
		alert('IP address entered is not in LAN subnet!!');
		return false;
	}
	else if(ret==2)
	{
		alert('IP address entered matches network address for LAN!!');
		return false;
	}
	else if(ret==3)
	{
		alert('IP address entered matches broadcast address for LAN!!');
		return false;
	}	
}


//
//
function pateditcheck_2(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._12_20_0_2;
	
	p1=a._12_16_0_2.value;
	if(p1.length==0)
	{
		alert('Enter Values before enabling');
		return false;
	}

	ip[0]=a._12_18_1_2.value;
	ip[1]=a._12_18_2_2.value;
	ip[2]=a._12_18_3_2.value;
	ip[3]=a._12_18_4_2.value;

	if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
	{
		alert('Enter Values before enabling');
		return false;
	}	

	p2=a._12_19_0_2.value;
	if(p2.length==0)
	{
		alert('Enter Values before enabling');
		return false;
	}
	retVal=PortCheck(p1)
	if(retVal==false)
	{			
		return false;
	}
	retVal=IPCheck1(ip[0]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for Port Forwarding');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
		return false;
	}

	retVal=IPCheck2(ip[1]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for Port Forwarding');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
		return false;
	}
	
	retVal=IPCheck2(ip[2]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for Port Forwarding');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
		return false;
	}

	retVal=IPCheck2(ip[3]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for Port Forwarding');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
		return false;
	}

	retVal=PortCheck(p2)
	if(retVal==false)
	{
		return false;
	}

	ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
	if(ret==1)
	{
		alert('IP address entered is not in LAN subnet!!');
		return false;
	}
	else if(ret==2)
	{
		alert('IP address entered matches network address for LAN!!');
		return false;
	}
	else if(ret==3)
	{
		alert('IP address entered matches broadcast address for LAN!!');
		return false;
	}	
}


//
//
function pateditcheck_3(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._12_25_0_2;
	
	p1=a._12_21_0_2.value;
	if(p1.length==0)
	{
		alert('Enter Values before enabling');
		return false;
	}

	ip[0]=a._12_23_1_2.value;
	ip[1]=a._12_23_2_2.value;
	ip[2]=a._12_23_3_2.value;
	ip[3]=a._12_23_4_2.value;

	if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
	{
		alert('Enter Values before enabling');
		return false;
	}	

	p2=a._12_24_0_2.value;
	if(p2.length==0)
	{
		alert('Enter Values before enabling');
		return false;
	}
	retVal=PortCheck(p1)
	if(retVal==false)
	{			
		return false;
	}
	retVal=IPCheck1(ip[0]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for Port Forwarding');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
		return false;
	}

	retVal=IPCheck2(ip[1]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for Port Forwarding');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
		return false;
	}
	
	retVal=IPCheck2(ip[2]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for Port Forwarding');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
		return false;
	}

	retVal=IPCheck2(ip[3]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for Port Forwarding');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
		return false;
	}

	retVal=PortCheck(p2)
	if(retVal==false)
	{
		return false;
	}

	ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
	if(ret==1)
	{
		alert('IP address entered is not in LAN subnet!!');
		return false;
	}
	else if(ret==2)
	{
		alert('IP address entered matches network address for LAN!!');
		return false;
	}
	else if(ret==3)
	{
		alert('IP address entered matches broadcast address for LAN!!');
		return false;
	}
	
}

//
//
function pateditcheck_4(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._12_30_0_2;
	
	p1=a._12_26_0_2.value;
	if(p1.length==0)
	{
		alert('Enter Values before enabling');
		return false;
	}

	ip[0]=a._12_28_1_2.value;
	ip[1]=a._12_28_2_2.value;
	ip[2]=a._12_28_3_2.value;
	ip[3]=a._12_28_4_2.value;

	if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
	{
		alert('Enter Values before enabling');
		return false;
	}	

	p2=a._12_29_0_2.value;
	if(p2.length==0)
	{
		alert('Enter Values before enabling');
		return false;
	}
	retVal=PortCheck(p1)
	if(retVal==false)
	{			
		return false;
	}
	retVal=IPCheck1(ip[0]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for Port Forwarding');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
		return false;
	}

	retVal=IPCheck2(ip[1]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for Port Forwarding');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
		return false;
	}
	
	retVal=IPCheck2(ip[2]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for Port Forwarding');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
		return false;
	}

	retVal=IPCheck2(ip[3]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for Port Forwarding');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
		return false;
	}

	retVal=PortCheck(p2)
	if(retVal==false)
	{
		return false;
	}

	ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
	if(ret==1)
	{
		alert('IP address entered is not in LAN subnet!!');
		return false;
	}
	else if(ret==2)
	{
		alert('IP address entered matches network address for LAN!!');
		return false;
	}
	else if(ret==3)
	{
		alert('IP address entered matches broadcast address for LAN!!');
		return false;
	}	
}

//
//
function pateditcheck_5(a)
{
	var ip=new Array(4);
	var p1, p2;
	var retVal;
	b=a._12_35_0_2;
	
	p1=a._12_31_0_2.value;
	if(p1.length==0)
	{
		alert('Enter Values before enabling');
		return false;
	}

	ip[0]=a._12_33_1_2.value;
	ip[1]=a._12_33_2_2.value;
	ip[2]=a._12_33_3_2.value;
	ip[3]=a._12_33_4_2.value;

	if( (ip[0].length==0) || (ip[1].length==0) || (ip[2].length==0) || (ip[3].length==0))
	{
		alert('Enter Values before enabling');
		return false;
	}	

	p2=a._12_34_0_2.value;
	if(p2.length==0)
	{
		alert('Enter Values before enabling');
		return false;
	}
	retVal=PortCheck(p1)
	if(retVal==false)
	{			
		return false;
	}
	retVal=IPCheck1(ip[0]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for Port Forwarding');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 1 to 223 for First Octet of IP address for Port Forwarding');
		return false;
	}

	retVal=IPCheck2(ip[1]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for Port Forwarding');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 0 to 255 for Second Octet of IP address for Port Forwarding');
		return false;
	}
	
	retVal=IPCheck2(ip[2]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for Port Forwarding');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 0 to 255 for Third Octet of IP address for Port Forwarding');
		return false;
	}

	retVal=IPCheck2(ip[3]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for Port Forwarding');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 0 to 255 for Fourth Octet of IP address for Port Forwarding');
		return false;
	}

	retVal=PortCheck(p2)
	if(retVal==false)
	{
		return false;
	}

	ret=isSameSubnet(2,a,ip[0],ip[1],ip[2],ip[3]);
	if(ret==1)
	{
		alert('IP address entered is not in LAN subnet!!');
		return false;
	}
	else if(ret==2)
	{
		alert('IP address entered matches network address for LAN!!');
		return false;
	}
	else if(ret==3)
	{
		alert('IP address entered matches broadcast address for LAN!!');
		return false;
	}
	
}


//
//
function checkPatEditPage(a)
{
	var retVal;
	var wan_port=new Array(5);
	//var enabledVal=new Array(5);
	var entryVal=new Array(5);

	var run=1;

	entryVal[0]=a._12_10_0_2.value.length;
	entryVal[1]=a._12_10_1_2.value.length;
	entryVal[2]=a._12_10_2_2.value.length;
	entryVal[3]=a._12_10_3_2.value.length;
	entryVal[4]=a._12_10_4_2.value.length;

	if(entryVal[0])
	{
		retVal=pateditcheck_1(a);if(retVal==false) return false;
	}

	if(entryVal[1])
	{
		retVal=pateditcheck_2(a);if(retVal==false) return false;
	}

	if(entryVal[2])
	{
		retVal=pateditcheck_3(a);if(retVal==false) return false;
	}

	if(entryVal[3])
	{
		retVal=pateditcheck_4(a);if(retVal==false) return false;
	}
	if(entryVal[4])
	{
		retVal=pateditcheck_5(a);if(retVal==false) return false;
	}

	//enabledVal[0]=a._12_15_0_2.checked;
	//enabledVal[1]=a._12_20_0_2.checked;
	//enabledVal[2]=a._12_25_0_2.checked;
	//enabledVal[3]=a._12_30_0_2.checked;
	//enabledVal[4]=a._12_35_0_2.checked;

	wan_port[0]=a._12_11_0_2.value;
	wan_port[1]=a._12_16_0_2.value;
	wan_port[2]=a._12_21_0_2.value;
	wan_port[3]=a._12_26_0_2.value;
	wan_port[4]=a._12_31_0_2.value;
	

	for(i = 0; i < 4; i++)
	{
		for(j=i+1; j<5; j++)
		{
			if ( (entryVal[i] && entryVal[j]) && (wan_port[i]==wan_port[j]) )
			{
				alert(' Duplicate WAN IP Ports!!');
				return false;
			}
		}
	}

	return true;
}


//
//
function checkNatPage(a)
{
	var retVal;
	var wan_ip=new Array(30);
	var enabledVal=new Array(30);
	var run=1;


	for (var i = 0; i < 30; i++) 
  		wan_ip[i] = new Array(4);


	retVal=natcheck1(a);if(retVal==false) return false;
	retVal=natcheck2(a);if(retVal==false) return false;
	retVal=natcheck3(a);if(retVal==false) return false;
	retVal=natcheck4(a);if(retVal==false) return false;
	retVal=natcheck5(a);if(retVal==false) return false;
	retVal=natcheck6(a);if(retVal==false) return false;
	retVal=natcheck7(a);if(retVal==false) return false;
	retVal=natcheck8(a);if(retVal==false) return false;
	retVal=natcheck9(a);if(retVal==false) return false;
	retVal=natcheck10(a);if(retVal==false) return false;
	retVal=natcheck11(a);if(retVal==false) return false;
	retVal=natcheck12(a);if(retVal==false) return false;
	retVal=natcheck13(a);if(retVal==false) return false;
	retVal=natcheck14(a);if(retVal==false) return false;
	retVal=natcheck15(a);if(retVal==false) return false;
	retVal=natcheck16(a);if(retVal==false) return false;
	retVal=natcheck17(a);if(retVal==false) return false;
	retVal=natcheck18(a);if(retVal==false) return false;
	retVal=natcheck19(a);if(retVal==false) return false;
	retVal=natcheck20(a);if(retVal==false) return false;
	retVal=natcheck21(a);if(retVal==false) return false;
	retVal=natcheck22(a);if(retVal==false) return false;
	retVal=natcheck23(a);if(retVal==false) return false;
	retVal=natcheck24(a);if(retVal==false) return false;
	retVal=natcheck25(a);if(retVal==false) return false;
	retVal=natcheck26(a);if(retVal==false) return false;
	retVal=natcheck27(a);if(retVal==false) return false;
	retVal=natcheck28(a);if(retVal==false) return false;
	retVal=natcheck29(a);if(retVal==false) return false;
	retVal=natcheck30(a);if(retVal==false) return false;


	enabledVal[0]=a._2_3_0_2.checked;
	enabledVal[1]=a._2_6_0_2.checked;
	enabledVal[2]=a._2_9_0_2.checked;
	enabledVal[3]=a._2_12_0_2.checked;
	enabledVal[4]=a._2_15_0_2.checked;
	enabledVal[5]=a._2_18_0_2.checked;
	enabledVal[6]=a._2_21_0_2.checked;
	enabledVal[7]=a._2_24_0_2.checked;
	enabledVal[8]=a._2_27_0_2.checked;
	enabledVal[9]=a._2_30_0_2.checked;
	enabledVal[10]=a._2_33_0_2.checked;
	enabledVal[11]=a._2_36_0_2.checked;
	enabledVal[12]=a._2_39_0_2.checked;
	enabledVal[13]=a._2_42_0_2.checked;
	enabledVal[14]=a._2_45_0_2.checked;
	enabledVal[15]=a._2_48_0_2.checked;
	enabledVal[16]=a._2_51_0_2.checked;
	enabledVal[17]=a._2_54_0_2.checked;
	enabledVal[18]=a._2_57_0_2.checked;
	enabledVal[19]=a._2_60_0_2.checked;
	enabledVal[20]=a._2_63_0_2.checked;
	enabledVal[21]=a._2_66_0_2.checked;
	enabledVal[22]=a._2_69_0_2.checked;
	enabledVal[23]=a._2_72_0_2.checked;
	enabledVal[24]=a._2_75_0_2.checked;
	enabledVal[25]=a._2_78_0_2.checked;
	enabledVal[26]=a._2_81_0_2.checked;
	enabledVal[27]=a._2_84_0_2.checked;
	enabledVal[28]=a._2_87_0_2.checked;
	enabledVal[29]=a._2_90_0_2.checked;

	wan_ip[0][0]= a._2_1_1_2.value;
	wan_ip[0][1]= a._2_1_2_2.value;
	wan_ip[0][2]= a._2_1_3_2.value;
	wan_ip[0][3]= a._2_1_4_2.value;

	wan_ip[1][0]= a._2_4_1_2.value;
	wan_ip[1][1]= a._2_4_2_2.value;
	wan_ip[1][2]= a._2_4_3_2.value;
	wan_ip[1][3]= a._2_4_4_2.value;

	wan_ip[2][0]= a._2_7_1_2.value;
	wan_ip[2][1]= a._2_7_2_2.value;
	wan_ip[2][2]= a._2_7_3_2.value;
	wan_ip[2][3]= a._2_7_4_2.value;
	
	wan_ip[3][0]= a._2_10_1_2.value;
	wan_ip[3][1]= a._2_10_2_2.value;
	wan_ip[3][2]= a._2_10_3_2.value;
	wan_ip[3][3]= a._2_10_4_2.value;

	wan_ip[4][0]= a._2_13_1_2.value;
	wan_ip[4][1]= a._2_13_2_2.value;
	wan_ip[4][2]= a._2_13_3_2.value;
	wan_ip[4][3]= a._2_13_4_2.value;

	wan_ip[5][0]= a._2_16_1_2.value;
	wan_ip[5][1]= a._2_16_2_2.value;
	wan_ip[5][2]= a._2_16_3_2.value;
	wan_ip[5][3]= a._2_16_4_2.value;

	wan_ip[6][0]= a._2_19_1_2.value;
	wan_ip[6][1]= a._2_19_2_2.value;
	wan_ip[6][2]= a._2_19_3_2.value;
	wan_ip[6][3]= a._2_19_4_2.value;

	wan_ip[7][0]= a._2_22_1_2.value;
	wan_ip[7][1]= a._2_22_2_2.value;
	wan_ip[7][2]= a._2_22_3_2.value;
	wan_ip[7][3]= a._2_22_4_2.value;
	
	wan_ip[8][0]= a._2_25_1_2.value;
	wan_ip[8][1]= a._2_25_2_2.value;
	wan_ip[8][2]= a._2_25_3_2.value;
	wan_ip[8][3]= a._2_25_4_2.value;

	wan_ip[9][0]= a._2_28_1_2.value;
	wan_ip[9][1]= a._2_28_2_2.value;
	wan_ip[9][2]= a._2_28_3_2.value;
	wan_ip[9][3]= a._2_28_4_2.value;

	wan_ip[10][0]= a._2_31_1_2.value;
	wan_ip[10][1]= a._2_31_2_2.value;
	wan_ip[10][2]= a._2_31_3_2.value;
	wan_ip[10][3]= a._2_31_4_2.value;

	wan_ip[11][0]= a._2_34_1_2.value;
	wan_ip[11][1]= a._2_34_2_2.value;
	wan_ip[11][2]= a._2_34_3_2.value;
	wan_ip[11][3]= a._2_34_4_2.value;
	
	wan_ip[12][0]= a._2_37_1_2.value;
	wan_ip[12][1]= a._2_37_2_2.value;
	wan_ip[12][2]= a._2_37_3_2.value;
	wan_ip[12][3]= a._2_37_4_2.value;

	wan_ip[13][0]= a._2_40_1_2.value;
	wan_ip[13][1]= a._2_40_2_2.value;
	wan_ip[13][2]= a._2_40_3_2.value;
	wan_ip[13][3]= a._2_40_4_2.value;

	wan_ip[14][0]= a._2_43_1_2.value;
	wan_ip[14][1]= a._2_43_2_2.value;
	wan_ip[14][2]= a._2_43_3_2.value;
	wan_ip[14][3]= a._2_43_4_2.value;

	wan_ip[15][0]= a._2_46_1_2.value;
	wan_ip[15][1]= a._2_46_2_2.value;
	wan_ip[15][2]= a._2_46_3_2.value;
	wan_ip[15][3]= a._2_46_4_2.value;

	wan_ip[16][0]= a._2_49_1_2.value;
	wan_ip[16][1]= a._2_49_2_2.value;
	wan_ip[16][2]= a._2_49_3_2.value;
	wan_ip[16][3]= a._2_49_4_2.value;

	wan_ip[17][0]= a._2_52_1_2.value;
	wan_ip[17][1]= a._2_52_2_2.value;
	wan_ip[17][2]= a._2_52_3_2.value;
	wan_ip[17][3]= a._2_52_4_2.value;
	
	wan_ip[18][0]= a._2_55_1_2.value;
	wan_ip[18][1]= a._2_55_2_2.value;
	wan_ip[18][2]= a._2_55_3_2.value;
	wan_ip[18][3]= a._2_55_4_2.value;

	wan_ip[19][0]= a._2_58_1_2.value;
	wan_ip[19][1]= a._2_58_2_2.value;
	wan_ip[19][2]= a._2_58_3_2.value;
	wan_ip[19][3]= a._2_58_4_2.value;

	wan_ip[20][0]= a._2_61_1_2.value;
	wan_ip[20][1]= a._2_61_2_2.value;
	wan_ip[20][2]= a._2_61_3_2.value;
	wan_ip[20][3]= a._2_61_4_2.value;

	wan_ip[21][0]= a._2_64_1_2.value;
	wan_ip[21][1]= a._2_64_2_2.value;
	wan_ip[21][2]= a._2_64_3_2.value;
	wan_ip[21][3]= a._2_64_4_2.value;

	wan_ip[22][0]= a._2_67_1_2.value;
	wan_ip[22][1]= a._2_67_2_2.value;
	wan_ip[22][2]= a._2_67_3_2.value;
	wan_ip[22][3]= a._2_67_4_2.value;

	wan_ip[23][0]= a._2_70_1_2.value;
	wan_ip[23][1]= a._2_70_2_2.value;
	wan_ip[23][2]= a._2_70_3_2.value;
	wan_ip[23][3]= a._2_70_4_2.value;

	wan_ip[24][0]= a._2_73_1_2.value;
	wan_ip[24][1]= a._2_73_2_2.value;
	wan_ip[24][2]= a._2_73_3_2.value;
	wan_ip[24][3]= a._2_73_4_2.value;

	wan_ip[25][0]= a._2_76_1_2.value;
	wan_ip[25][1]= a._2_76_2_2.value;
	wan_ip[25][2]= a._2_76_3_2.value;
	wan_ip[25][3]= a._2_76_4_2.value;

	wan_ip[26][0]= a._2_79_1_2.value;
	wan_ip[26][1]= a._2_79_2_2.value;
	wan_ip[26][2]= a._2_79_3_2.value;
	wan_ip[26][3]= a._2_79_4_2.value;

	wan_ip[27][0]= a._2_82_1_2.value;
	wan_ip[27][1]= a._2_82_2_2.value;
	wan_ip[27][2]= a._2_82_3_2.value;
	wan_ip[27][3]= a._2_82_4_2.value;

	wan_ip[28][0]= a._2_85_1_2.value;
	wan_ip[28][1]= a._2_85_2_2.value;
	wan_ip[28][2]= a._2_85_3_2.value;
	wan_ip[28][3]= a._2_85_4_2.value;

	wan_ip[29][0]= a._2_88_1_2.value;
	wan_ip[29][1]= a._2_88_2_2.value;
	wan_ip[29][2]= a._2_88_3_2.value;
	wan_ip[29][3]= a._2_88_4_2.value;


	for(i=0; i<29 && run;i++)
	{
		if(enabledVal[i])
		{		
			for(j=(i+1);j<30 && run; j++)
			{
				if((enabledVal[j]) && (wan_ip[i][0]==wan_ip[j][0]) && (wan_ip[i][1]==wan_ip[j][1]) && (wan_ip[i][2]==wan_ip[j][2]) && (wan_ip[i][3]==wan_ip[j][3]))
					run=0;
			}
		}
	}

	
	if(run==0)
	{
	alert('Duplicate WAN IPs !!');
	return false;	
	}


	return true;
}


//
//
function LeaseCheck(a)
{
	var value = a._4_7_0_2.value;
	var proceed=checkDigit(value);
	if(proceed==1)
	{
		alert('Enter numerical value for Client Lease Time');
		return false;
	}
	if(proceed==0)
	{
		if((value < 0) || (value > 65535))
		{
			alert('Client Lease Time should be between 0 and 65535')
			return false; 
		}
	}
}


//
//
function checkdhcpstart(form)
{
	var subnet=form._4_2_0_2.value;
	
	if(subnet==30)
		form._4_5_0_2.value=1;
	else if(subnet==29)
		form._4_5_0_2.value=5;
	else if(subnet==28)
		form._4_5_0_2.value=13;
	else if(subnet==27)
		form._4_5_0_2.value=29;
	else if(subnet==26)
		form._4_5_0_2.value=61;
	else if(subnet==25)
		form._4_5_0_2.value=125;
	else if(subnet==24)
		form._4_5_0_2.value=253;
	else
		form._4_5_0_2.value=254;
}


//
//
function SelDHCPServer(a, form)
{
	if(a==1)//enable
	{
		form._4_4_1_2.disabled=false; //Start IP address
		form._4_4_2_2.disabled=false;
		form._4_4_3_2.disabled=false;
		form._4_4_4_2.disabled=false;

		form._4_5_0_2.disabled=false; //Number of addresses
		form._4_7_0_2.disabled=false; //Client lease time
	}
	else if(a==0)//disable
	{
		form._4_4_1_2.disabled=true; //Start IP address
		form._4_4_2_2.disabled=true;
		form._4_4_3_2.disabled=true;
		form._4_4_4_2.disabled=true;

		form._4_5_0_2.disabled=true; //Number of addresses
		form._4_7_0_2.disabled=true; //Client lease time
	}
}


//
//
function numDHCP(form)
{
	var val=form._4_5_0_2.value;
	var subnet=form._4_2_0_2.value;

	var ret=checkDigit(val);
	if(ret==1)
	{
		alert('Enter numerical value between 1 to 254 for number of addresses');
		return false;
	}
	
	if((val<1) || (val>254))
	{
		alert('Number of addresses should be between 1 and 254');
		return false;
	}

	if(subnet==30)
	{
		if(val >1)
		{
			alert('Only 1 DHCP address is possible with the selected subnet mask');
			return false;
		}
	}
	else if(subnet==29)
	{
		if(val>5)
		{
			alert('Only 5 DHCP addresses are possible with the selected subnet mask');
			return false;
		}
	}
	else if(subnet==28)
	{
		if(val>13)
		{
			alert('Only 13 DHCP addresses are possible with the selected subnet mask');
			return false;
		}
	}
	else if(subnet==27)
	{
		if(val>29)
		{
			alert('Only 29 DHCP addresses are possible with the selected subnet mask');
			return false;
		}
	}
	else if(subnet==26)
	{
		if(val>61)
		{
			alert('Only 61 DHCP addresses are possible with the selected subnet mask');
			return false;
		}
	}
	else if(subnet==25)
	{
		if(val>125)
		{
			alert('Only 125 DHCP addresses are possible with the selected subnet mask');
			return false;
		}
	}
	else if(subnet==24)
	{
		if(val>253)
		{
			alert('Only 253 DHCP addresses are possible with the selected subnet mask');
			return false;
		}
	}
}


//
//
function SelectPPPoE_Demand(a, b)
{
	if(a==1) //on demand
	{
		b._3_11_5_2.disabled = false;
		b._3_11_6_2.disabled = true;
	}
	else if(a==0) // keep alive
	{
		b._3_11_5_2.disabled = true;
		b._3_11_6_2.disabled = false;
	}
}


//
//
function checkSetupPage(a)
{
	var dotted_subnet = new Array("255.0.0.0", "255.128.0.0", "255.192.0.0", "255.224.0.0",
			      	"255.240.0.0", "255.248.0.0", "255.252.0.0", "255.254.0.0",
			      	"255.255.0.0", "255.255.128.0", "255.255.192.0", "255.255.224.0",
			      	"255.255.240.0", "255.255.248.0", "255.255.252.0", "255.255.254.0",
			 	"255.255.255.0", "255.255.255.128", "255.255.255.192", "255.255.255.224",
				"255.255.255.240", "255.255.255.248", "255.255.255.252" );

	var subnet;
	var invSubnet=new Array(4);

	//////////////////////////////////////////////////////////////////////////
	// 				WAN Setup
	//////////////////////////////////////////////////////////////////////////
	var wanType=a._3_1_0_2.value;
	var valWiFi=a._9_0_3_2.value;

	if((wanType==4) && (valWiFi==1))
	{
		alert('Wi-Fi is enabled. USB port is being used by USB Wi-Fi Adapter. Cannot set WAN Connection Type to Cellular.');
		return false;
	}
	
	if((wanType==1) || (wanType==3) ) //static IP or PPTP
	{
		//get wan ip
		var wanip=new Array(4);
		
		wanip[0]=a._3_2_1_2.value;
		wanip[1]=a._3_2_2_2.value;
		wanip[2]=a._3_2_3_2.value;
		wanip[3]=a._3_2_4_2.value;



		//check no value is empty
		if( (wanip[0].length==0) || (wanip[1].length==0) || (wanip[2].length==0) || (wanip[3].length==0))
		{
			alert('Enter IP Address Values for WAN Setup');
			return false;
		}
		
		// check valid IP address values for WAN IP
		retVal=IPCheck1(wanip[0]);
		if(retVal==1)
		{
			alert('Input Numerical Value for IP Address for WAN Setup');
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP Address for WAN Setup');
			return false;
		}

		retVal=IPCheck2(wanip[1]);
		if(retVal==1)
		{
			alert('Input Numerical Value for IP Address for WAN Setup');
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP Address for WAN Setup');
			return false;
		}
	
		retVal=IPCheck2(wanip[2]);
		if(retVal==1)
		{
			alert('Input Numerical Value for IP Address for WAN Setup');
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP Address for WAN Setup');
			return false;
		}

		retVal=IPCheck2(wanip[3]);
		if(retVal==1)
		{
			alert('Input Numerical Value for IP Address for WAN Setup');
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP Address for WAN Setup');
			return false;
		}
	

		//get wan subnet
		var wansubnet=new Array(4);
		subnet=a._3_3_0_2.value;
		var wan_subnet_val=dotted_subnet[subnet-8];
		wansubnet=wan_subnet_val.split(".");

		//calculate network address for wan
		var wan_nm_array=new Array(4);
		for (i = 0; i < 4; i++)
			wan_nm_array[i] = wanip[i] & wansubnet[i];

		//calculate inverse netmask for wan
		for (i = 0; i < 4; i++)
			invSubnet[i] = wansubnet[i] ^ 255;
	
		//calculate broadcast address for wan
		var bc_wan=new Array(4);
		for (i = 0; i < 4; i++)
			bc_wan[i] = wanip[i] | invSubnet[i];

		//
		// Display error if wan ip address matches network or broadcast IP address
		//
		if((wanip[0]==wan_nm_array[0]) && (wanip[1]==wan_nm_array[1]) && (wanip[2]==wan_nm_array[2]) && (wanip[3]==wan_nm_array[3]) )
		{
			alert('IP address is equal to network IP address for WAN setup');
			return false;
		}

		if((wanip[0]==bc_wan[0]) && (wanip[1]==bc_wan[1]) && (wanip[2]==bc_wan[2]) && (wanip[3]==bc_wan[3]) )
		{
			alert('IP address is equal to broadcast IP address for WAN setup');
			return false;
		}

		//get gateway address
		var gw=new Array(4);
	
		gw[0]=a._3_4_1_2.value;
		gw[1]=a._3_4_2_2.value;
		gw[2]=a._3_4_3_2.value;
		gw[3]=a._3_4_4_2.value;

		//if all boxes for gateway address are empty, fill them with zereos.
		if( (gw[0].length==0) && (gw[1].length==0) && (gw[2].length==0) && (gw[3].length==0))
		{
			for (i=0; i<4; i++)
				gw[i]=0;

			a._3_4_1_2.value=0;
			a._3_4_2_2.value=0;
			a._3_4_3_2.value=0;
			a._3_4_4_2.value=0;
		}

		//check no value is empty
		if( (gw[0].length==0) || (gw[1].length==0) || (gw[2].length==0) || (gw[3].length==0))
		{
			alert('Enter Default Gateway Address Values for WAN Setup');
			return false;
		}

		if( (gw[0]!=0) || (gw[1]!=0) || (gw[2]!=0) || (gw[3]!=0) )
		{
			// check valid IP address values for gateway address for WAN
			retVal=IPCheck1(gw[0]);
			if(retVal==1)
			{
				alert('Input Numerical Value for Default Gateway for WAN Setup');
				return false;
			}
			else if(retVal==2)
			{
				alert('Input a value from 1 to 223 for First Octet of Default Gateway for WAN Setup');
				return false;
			}
	
			retVal=IPCheck2(gw[1]);
			if(retVal==1)
			{
				alert('Input Numerical Value for Default Gateway for WAN Setup');
				return false;
			}
			else if(retVal==2)
			{
				alert('Input a value from 0 to 255 for Second Octet of Default Gateway for WAN Setup');
				return false;
			}
	
			retVal=IPCheck2(gw[2]);
			if(retVal==1)
			{
				alert('Input Numerical Value for Default Gateway for WAN Setup');
				return false;
			}
			else if(retVal==2)
			{
				alert('Input a value from 0 to 255 for Third Octet of Default Gateway for WAN Setup');
				return false;
			}
	
			retVal=IPCheck2(gw[3]);
			if(retVal==1)
			{
				alert('Input Numerical Value for Default Gateway for WAN Setup');
				return false;
			}
			else if(retVal==2)
			{
				alert('Input a value from 0 to 255 for Fourth Octet of Default Gateway for WAN Setup');
				return false;
			}
	
			//
			// calculate network address for wan_gw
			var gw_nm_array=new Array(4);
		
			for (i = 0; i < 4; i++)
				gw_nm_array[i] = gw[i] & wansubnet[i];

	
			//
			// validate gateway ip address to be in same subnet as WAN ip address
			if( (gw_nm_array[0]!=wan_nm_array[0]) || (gw_nm_array[1]!=wan_nm_array[1]) || (gw_nm_array[2]!=wan_nm_array[2]) 
				|| (gw_nm_array[3]!=wan_nm_array[3]) )
			{
				alert('Default Gateway address not in WAN IP subnet');
				return false;
			}

			//
			// Display error if gw ip address matches network or broadcast IP address
			//
			if( (gw[0]==wan_nm_array[0]) && (gw[1]==wan_nm_array[1]) && (gw[2]==wan_nm_array[2]) && (gw[3]==wan_nm_array[3]) )
			{
				alert('Default Gateway address is equal to network IP address for WAN setup');
				return false;
			}

			if( (gw[0]==bc_wan[0]) && (gw[1]==bc_wan[1]) && (gw[2]==bc_wan[2]) && (gw[3]==bc_wan[3]) )
			{
				alert('Default Gateway address is equal to broadcast IP address for WAN setup');
				return false;
			}
		}


		if(wanType==1) //static IP
		{
			//
			//Check DNS values
			//
			retVal=checkDNS(a);
			if(retVal==1)
				return false;
		}
		
		if(wanType==3) //PPTP
		{
			//get server ip address
			var sip=new Array(4);
	
			sip[0]=a._3_14_1_2.value;
			sip[1]=a._3_14_2_2.value;
			sip[2]=a._3_14_3_2.value;
			sip[3]=a._3_14_4_2.value;

			//check no value is empty
			if( (sip[0].length==0) || (sip[1].length==0) || (sip[2].length==0) || (sip[3].length==0))
			{
				alert('Enter Server IP Address Values for WAN Setup');
				return false;
			}

			// check valid Server IP address values for WAN IP
			retVal=IPCheck1(sip[0]);
			if(retVal==1)
			{
				alert('Input Numerical Value for Server IP Address for WAN Setup');
				return false;
			}
			else if(retVal==2)
			{
				alert('Input a value from 1 to 223 for First Octet of Server IP Address for WAN Setup');
				return false;
			}
	
			retVal=IPCheck2(sip[1]);
			if(retVal==1)
			{
				alert('Input Numerical Value for Server IP Address for WAN Setup');
				return false;
			}
			else if(retVal==2)
			{
				alert('Input a value from 0 to 255 for Second Octet of Server IP Address for WAN Setup');
				return false;
			}
		
			retVal=IPCheck2(sip[2]);
			if(retVal==1)
			{
				alert('Input Numerical Value for Server IP Address for WAN Setup');
				return false;
			}
			else if(retVal==2)
			{
				alert('Input a value from 0 to 255 for Third Octet of Server IP Address for WAN Setup');
				return false;
			}
	
			retVal=IPCheck2(sip[3]);
			if(retVal==1)
			{
				alert('Input Numerical Value for Server IP Address for WAN Setup');
				return false;
			}
			else if(retVal==2)
			{
				alert('Input a value from 0 to 255 for Fourth Octet of Server IP Address for WAN Setup');
				return false;
			}
		}

	} //end of if((wanType==1) || (wanType==3)) //static IP or PPTP

	if((wanType==2) || (wanType==3)) //PPPoE or PPTP
	{
		//check for username and password
		var uname=a._3_11_1_1.value;
		var pword=a._3_11_2_1.value
		
		//check if value is empty
		if((uname.length==0) || (uname.pword==0))
		{
			alert('Enter Username/Password values for WAN Setup');
			return false;
		}

		if(a._3_11_4_2[0].checked) // If connect on demand
		{
			if(a._3_11_5_2.value.length==0) //Max idle time should not be empty
			{
				alert('Enter Max Idle Time value for WAN Setup');
				return false;
			}
		}
		else if(a._3_11_4_2[1].checked) // If keep alive
		{
			if(a._3_11_6_2.value.length==0) // redial period should not be empty
			{
				alert('Enter Redial Period value for WAN Setup');
				return false;
			}
		}
	}

	//
	//Check MTU value if MTU is enabled
	if(a._3_10_0_2[0].checked)
	{
		retVal=CheckMTU_Val(a);
		if(retVal==1)
			return false;
	}
	else //set default value
	{
		SetMTU(a);
	}


	/////////////////////////////////////////////////////////////////////////////////
	// 				LAN Setup 
	/////////////////////////////////////////////////////////////////////////////////

	//get lan ip
	var lanip=new Array(4);
	
	lanip[0]=a._4_1_1_2.value;
	lanip[1]=a._4_1_2_2.value;
	lanip[2]=a._4_1_3_2.value;
	lanip[3]=a._4_1_4_2.value;

	if( (lanip[0].length==0) || (lanip[1].length==0) || (lanip[2].length==0) || (lanip[3].length==0))
	{
		alert('Enter Router IP Address Values for LAN Setup');
		return false;
	}

	// check valid IP address values for LAN IP
	retVal=IPCheck1(lanip[0]);
	if(retVal==1)
	{
		alert('Input Numerical Value for Router IP Address for LAN Setup');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 1 to 223 for First Octet of Router IP Address for LAN Setup');
		return false;
	}
	
	retVal=IPCheck2(lanip[1]);
	if(retVal==1)
	{
		alert('Input Numerical Value for Router IP Address for LAN Setup');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 0 to 255 for Second Octet of Router IP Address for LAN Setup');
		return false;
	}
	
	retVal=IPCheck2(lanip[2]);
	if(retVal==1)
	{
		alert('Input Numerical Value for Router IP Address for LAN Setup');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 0 to 255 for Third Octet of Router IP Address for LAN Setup');
		return false;
	}
	
	retVal=IPCheck2(lanip[3]);
	if(retVal==1)
	{
		alert('Input Numerical Value for Router IP Address for LAN Setup');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 0 to 255 for Fourth Octet of Router IP Address for LAN Setup');
		return false;
	}

	//get lan subnet
	var lansubnet=new Array(4);
	subnet=a._4_2_0_2.value;
	
	var lan_subnet_val=dotted_subnet[subnet-8];
	lansubnet=lan_subnet_val.split(".");
	
	//alert('subnet::: ' + lansubnet[0] + '   ' + lansubnet[1] + '   ' + lansubnet[2] + '   ' + lansubnet[3] + '   ');

	//calculate network address for lan
	var nm_array1=new Array(4);

	for (i = 0; i < 4; i++)
		nm_array1[i] = lanip[i] & lansubnet[i];

	//calculate inverse netmask for lan
	for (i = 0; i < 4; i++)
		invSubnet[i] = lansubnet[i] ^ 255;

	//calculate broadcast address for lan
	var bc_lan=new Array(4);
	
	for (i = 0; i < 4; i++)
		bc_lan[i] = lanip[i] | invSubnet[i];

	//
	// Display error if lan ip address matches network or broadcast IP address
	//
	if((lanip[0]==nm_array1[0]) && (lanip[1]==nm_array1[1]) && (lanip[2]==nm_array1[2]) && (lanip[3]==nm_array1[3]) )
	{
		alert('Router IP address is equal to network IP address for LAN setup');
		return false;
	}

	if((lanip[0]==bc_lan[0]) && (lanip[1]==bc_lan[1]) && (lanip[2]==bc_lan[2]) && (lanip[3]==bc_lan[3]) )
	{
		alert('Router IP address is equal to broadcast IP address for LAN setup');
		return false;
	}

	//check if dhcp server is enabled
	if(a._4_3_0_2[0].checked)
	{
		//get dhcp start ip
		var dhcpip=new Array(4);

		dhcpip[0]=a._4_4_1_2.value;
		dhcpip[1]=a._4_4_2_2.value;
		dhcpip[2]=a._4_4_3_2.value;
		dhcpip[3]=a._4_4_4_2.value;

		if( (dhcpip[0].length==0) || (dhcpip[1].length==0) || (dhcpip[2].length==0) || (dhcpip[3].length==0))
		{
			alert('Enter DHCP Start IP Address Values for LAN Setup');
			return false;
		}

		// check valid IP address values for DHCP Start Address
		retVal=IPCheck1(dhcpip[0]);
		if(retVal==1)
		{
			alert('Input Numerical Value for DHCP Start address for LAN Setup');
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of DHCP Start address for LAN Setup');
			return false;
		}
		
		retVal=IPCheck2(dhcpip[1]);
		if(retVal==1)
		{
			alert('Input Numerical Value for DHCP Start address for LAN Setup');
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of DHCP Start address for LAN Setup');
			return false;
		}
		
		retVal=IPCheck2(dhcpip[2]);
		if(retVal==1)
		{
			alert('Input Numerical Value for DHCP Start Address for LAN Setup');
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of DHCP Start address for LAN Setup');
			return false;
		}
		
		retVal=IPCheck3(dhcpip[3]);
		if(retVal==1)
		{
			alert('Input Numerical Value for DHCP Start address for LAN Setup');
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 254 for Fourth Octet of DHCP Start address for LAN Setup');
			return false;
		}

		//calculate network address for dhcp address entered
		var nm_array2 = new Array(4);

		for (i = 0; i < 4; i++)
			nm_array2[i] = dhcpip[i] & lansubnet[i];

		// If network addresses for lan and dhcp do not match, display alert
		if((nm_array1[0]!=nm_array2[0]) || (nm_array1[1]!=nm_array2[1]) || (nm_array1[2]!=nm_array2[2]) || (nm_array1[3]!=nm_array2[3]) )
		{
			alert('DHCP Start address not in LAN IP subnet');
			return false;
		}

		// Display error if dhcp ip address matches network or broadcast address or lan ip
		if((dhcpip[0]==nm_array2[0]) && (dhcpip[1]==nm_array1[1]) && (dhcpip[2]==nm_array1[2]) && (dhcpip[3]==nm_array1[3]) )
		{
			alert('DHCP Start address is equal to network IP address for LAN setup');
			return false;
		}
	
		if((dhcpip[0]==bc_lan[0]) && (dhcpip[1]==bc_lan[1]) && (dhcpip[2]==bc_lan[2]) && (dhcpip[3]==bc_lan[3]) )
		{
			alert('DHCP Start address is equal to broadcast IP address for LAN setup');
			return false;
		}
	
		//Display error if dhcp start address matches router LAN ip address
		if((lanip[0]==dhcpip[0]) && (lanip[1]==dhcpip[1]) && (lanip[2]==dhcpip[2]) && (lanip[3]==dhcpip[3]) )
		{
			alert('DHCP Start address is equal to Router IP address for LAN setup');
			return false;
		}
	
		//get number of clients
		var numClients=a._4_5_0_2.value;
		if(numClients.length==0)
		{
			alert('Input Number of addresses for LAN Setup');
			return false;
		}

		retVal=numDHCP(a);
		if(retVal==false)
			return false;
	
		//calculate ending dhcp ip address, skipping 0 and 255 in last octet
		var dhcp_end_ip=new Array(4);
	
		for(i=0; i < 4; i++)
			dhcp_end_ip[i] = parseInt(dhcpip[i]);
		//alert('start dhcp is '+dhcp_end_ip[0]+'  '+dhcp_end_ip[1]+'  '+dhcp_end_ip[2]+'  '+dhcp_end_ip[3]+'  ');	
		dhcp_end_ip[3] += (parseInt(numClients) -1);

		//alert('end dhcp after adding is '+dhcp_end_ip[0]+'  '+dhcp_end_ip[1]+'  '+dhcp_end_ip[2]+'  '+dhcp_end_ip[3]+'  ');
		
	
		if(dhcp_end_ip[3] > 254)
		{
			var temp = dhcp_end_ip[3]-254;
			dhcp_end_ip[3] = temp;
			dhcp_end_ip[2]++;
			if(dhcp_end_ip[2] > 255)
			{
				dhcp_end_ip[2] = 0;
				dhcp_end_ip[1]++;
				if(dhcp_end_ip[1] > 255)
				{
					dhcp_end_ip[1] = 0;
					dhcp_end_ip[0]++;
				}
			}
		}

		// calculate int values of lan ip address, starting dhcp and ending dhcp address
		var int_lanip, int_startdhcp, int_enddhcp;
		
		int_lanip=(256*256*256*parseInt(lanip[0])) + (256*256*parseInt(lanip[1])) + (256*parseInt(lanip[2])) + parseInt(lanip[3]);
		int_startdhcp=(256*256*256*parseInt(dhcpip[0])) + (256*256*parseInt(dhcpip[1])) + (256*parseInt(dhcpip[2])) + parseInt(dhcpip[3]);
		int_enddhcp=(256*256*256*dhcp_end_ip[0]) + (256*256*dhcp_end_ip[1]) + (256*dhcp_end_ip[2]) + dhcp_end_ip[3];

		//alert('lan ip is '+int_lanip+'\ndhcp start is '+int_startdhcp+'\nend dhcp is '+int_enddhcp);  
	
		//make sure that ending dhcp address is smaller than or equal to (broadcast address -1)
		//calculate int value of broadcast address
		var int_bc;
		int_bc=(256*256*256*parseInt(bc_lan[0])) + (256*256*parseInt(bc_lan[1])) + (256*parseInt(bc_lan[2])) + parseInt(bc_lan[3]);
		
		if(int_enddhcp > (int_bc-1))
		{
			alert('Ending DHCP address not in LAN Subnet.\n Change the DHCP Start Address or decrease number of addresses');
			return false;
		}


		//check that router ip is not in dhcp address range	
		if((int_lanip > int_startdhcp) && (int_lanip < (int_enddhcp+1)) )
		{
			alert('Router IP cannot be in the dhcp address range.\n\nRouter ip: '+lanip[0]+'.'+lanip[1]+'.'+lanip[2]+'.'
				+lanip[3]+'\n\nDHCP Range: '+dhcpip[0]+'.'+dhcpip[1]+'.'+dhcpip[2]+'.'+dhcpip[3]+' to '
				+dhcp_end_ip[0]+'.'+dhcp_end_ip[1]+'.'+dhcp_end_ip[2]+'.'+dhcp_end_ip[3]);
			return false;
		}

		//Check Client Lease Time
		retVal=LeaseCheck(a);

		if(retVal==false)
			return false;
	} //end if dhcp enabled

	return true;
}

function checkAdminPage(a)
{
	var u=a._4_8_1_1.value;
	var p1=a._4_8_2_1.value;
	var p2=a._4_8_3_1.value;
	var paswd=  /^(?=.*[0-9])(?=.*[a-zA-Z])/;

        if ( ( /[^A-Za-z0-9]/.test(u) ) || ( /[^A-Za-z0-9!%@#\+\^\[\]_{}~]+$/.test(p1) ) )
	{ 
		alert('Only alpha-numeric characters can be used for Username.\nAlpha-numeric and special characters ~ ! @ # % ^ + [ ] { } and _ can be used for Password.');
		return false;
	}

	//check for minimum length of 8 characters
	if( (u.length < 8) || (p1.length < 8) || (p2.length < 8) )
	{
		alert('Username and Password must be atleast 8 characters long.');
		return false;
	}

	//check to see if passwords p1 and p2 match	
	if(p1 != p2)
	{
		alert('Passwords entered do not match. Re-enter passwords and try again');
		return false;	
	}
	
	if(p1.match(paswd)) 
	{ 
		
		return true;
	}
	else
	{
		alert('Password must contain atleast one alphabet and one number.');
		return false;
	}

	return true;
}

function checkAdmin1Page(a)
{
	var p=a._3_13_1_2.value;
	var retVal;
	retVal=PortCheck(p);
	if(retVal==false)
		return false;
	
	return true;
}

//
//
function SelectWhitelist(a)
{
	if(a==0)
		document.getElementById("wlhide").style.display = "none";
	else if(a==1)
		document.getElementById("wlhide").style.display = "block";
}


//
//
function CheckWlSubnet(type,a,b,c,d,e)
{
	var nm_array1 = new Array(4); //LAN or WAN netmask
	var nm_array2 = new Array(4); // User input ip address netmask

	if(type==1) //WAN Settings
	{
		ip=a._5_3_2_1.value;
		subnet=a._5_3_3_1.value;
	}
	else if(type==2) //LAN Settings
	{
		ip=a._5_4_1_1.value;
		subnet=a._5_4_2_1.value;
	}

	ip_array=ip.split(".");
	subnet_array=subnet.split(".");

		
	for (i = 0; i < 4; i++)
		nm_array1[i] = ip_array[i] & subnet_array[i]; //LAN or WAN netmask

	nm_array2[0] = b & subnet_array[0]; //user ip value netmask
	nm_array2[1] = c & subnet_array[1];
	nm_array2[2] = d & subnet_array[2];
	nm_array2[3] = e & subnet_array[3];

	//if ip addresses match
	if((ip_array[0]==b) && (ip_array[1]==c) && (ip_array[2]==d) && (ip_array[3]==e) )
		return 1;

	if(type==2)//LAN settings
	{
		//netmask matches, meaning same subnet
		if((nm_array1[0]==nm_array2[0]) && (nm_array1[1]==nm_array2[1]) && (nm_array1[2]==nm_array2[2]) && (nm_array1[3]==nm_array2[3]) )
			return 4;	
	}

	//if ip address matches network address
	if((b==nm_array2[0]) && (c==nm_array2[1]) && (d==nm_array2[2]) && (e==nm_array2[3]) )
		return 2;

	//calculate inverse netmask
	var invSubnet=new Array(4);
	for (i = 0; i < 4; i++)
		invSubnet[i] = subnet_array[i] ^ 255;

	//calculate broadcast address
	var bc=new Array(4);
	for (i = 0; i < 4; i++)
		bc[i] = ip_array[i] | invSubnet[i];	

	//if ip address matches broadcast address
	if((b==bc[0]) && (c==bc[1]) && (d==bc[2]) && (e==bc[3]) )
		return 3;

	return 0;
}


//
//
function wlcheck1(a)
{
	var ip1=new Array(4);
	b=a._7_2_0_2;

	if(b.checked)
	{
		ip1[0]=a._7_1_1_2.value;
		ip1[1]=a._7_1_2_2.value;
		ip1[2]=a._7_1_3_2.value;
		ip1[3]=a._7_1_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}
		
		//Check Whitelist IP against WAN Settings	
		ret=CheckWlSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('IP address entered matches WAN IP address!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}		

		//Check Whitelist IP against LAN Settings		
		ret=CheckWlSubnet(2,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('IP address entered matches LAN IP address!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==4)
		{
			alert('IP address entered belongs to LAN subnet!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function wlcheck2(a)
{
	var ip1=new Array(4);
	b=a._7_4_0_2;

	if(b.checked)
	{
		ip1[0]=a._7_3_1_2.value;
		ip1[1]=a._7_3_2_2.value;
		ip1[2]=a._7_3_3_2.value;
		ip1[3]=a._7_3_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}
		
		//Check Whitelist IP against WAN Settings	
		ret=CheckWlSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('IP address entered matches WAN IP address!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}		

		//Check Whitelist IP against LAN Settings		
		ret=CheckWlSubnet(2,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('IP address entered matches LAN IP address!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==4)
		{
			alert('IP address entered belongs to LAN subnet!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function wlcheck3(a)
{
	var ip1=new Array(4);
	b=a._7_6_0_2;

	if(b.checked)
	{
		ip1[0]=a._7_5_1_2.value;
		ip1[1]=a._7_5_2_2.value;
		ip1[2]=a._7_5_3_2.value;
		ip1[3]=a._7_5_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}
		
		//Check Whitelist IP against WAN Settings	
		ret=CheckWlSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('IP address entered matches WAN IP address!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}		

		//Check Whitelist IP against LAN Settings		
		ret=CheckWlSubnet(2,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('IP address entered matches LAN IP address!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==4)
		{
			alert('IP address entered belongs to LAN subnet!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function wlcheck4(a)
{
	var ip1=new Array(4);
	b=a._7_8_0_2;

	if(b.checked)
	{
		ip1[0]=a._7_7_1_2.value;
		ip1[1]=a._7_7_2_2.value;
		ip1[2]=a._7_7_3_2.value;
		ip1[3]=a._7_7_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}
		
		//Check Whitelist IP against WAN Settings	
		ret=CheckWlSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('IP address entered matches WAN IP address!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}		

		//Check Whitelist IP against LAN Settings		
		ret=CheckWlSubnet(2,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('IP address entered matches LAN IP address!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==4)
		{
			alert('IP address entered belongs to LAN subnet!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function wlcheck5(a)
{
	var ip1=new Array(4);
	b=a._7_10_0_2;

	if(b.checked)
	{
		ip1[0]=a._7_9_1_2.value;
		ip1[1]=a._7_9_2_2.value;
		ip1[2]=a._7_9_3_2.value;
		ip1[3]=a._7_9_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}
		
		//Check Whitelist IP against WAN Settings	
		ret=CheckWlSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('IP address entered matches WAN IP address!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}		

		//Check Whitelist IP against LAN Settings		
		ret=CheckWlSubnet(2,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('IP address entered matches LAN IP address!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==4)
		{
			alert('IP address entered belongs to LAN subnet!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function wlcheck6(a)
{
	var ip1=new Array(4);
	b=a._7_12_0_2;

	if(b.checked)
	{
		ip1[0]=a._7_11_1_2.value;
		ip1[1]=a._7_11_2_2.value;
		ip1[2]=a._7_11_3_2.value;
		ip1[3]=a._7_11_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}
		
		//Check Whitelist IP against WAN Settings	
		ret=CheckWlSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('IP address entered matches WAN IP address!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}		

		//Check Whitelist IP against LAN Settings		
		ret=CheckWlSubnet(2,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('IP address entered matches LAN IP address!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==4)
		{
			alert('IP address entered belongs to LAN subnet!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function wlcheck7(a)
{
	var ip1=new Array(4);
	b=a._7_14_0_2;

	if(b.checked)
	{
		ip1[0]=a._7_13_1_2.value;
		ip1[1]=a._7_13_2_2.value;
		ip1[2]=a._7_13_3_2.value;
		ip1[3]=a._7_13_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}
		
		//Check Whitelist IP against WAN Settings	
		ret=CheckWlSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('IP address entered matches WAN IP address!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}		

		//Check Whitelist IP against LAN Settings		
		ret=CheckWlSubnet(2,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('IP address entered matches LAN IP address!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==4)
		{
			alert('IP address entered belongs to LAN subnet!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function wlcheck8(a)
{
	var ip1=new Array(4);
	b=a._7_16_0_2;

	if(b.checked)
	{
		ip1[0]=a._7_15_1_2.value;
		ip1[1]=a._7_15_2_2.value;
		ip1[2]=a._7_15_3_2.value;
		ip1[3]=a._7_15_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}
		
		//Check Whitelist IP against WAN Settings	
		ret=CheckWlSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('IP address entered matches WAN IP address!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}		

		//Check Whitelist IP against LAN Settings		
		ret=CheckWlSubnet(2,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('IP address entered matches LAN IP address!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==4)
		{
			alert('IP address entered belongs to LAN subnet!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function wlcheck9(a)
{
	var ip1=new Array(4);
	b=a._7_18_0_2;

	if(b.checked)
	{
		ip1[0]=a._7_17_1_2.value;
		ip1[1]=a._7_17_2_2.value;
		ip1[2]=a._7_17_3_2.value;
		ip1[3]=a._7_17_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}
		
		//Check Whitelist IP against WAN Settings	
		ret=CheckWlSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('IP address entered matches WAN IP address!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}		

		//Check Whitelist IP against LAN Settings		
		ret=CheckWlSubnet(2,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('IP address entered matches LAN IP address!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==4)
		{
			alert('IP address entered belongs to LAN subnet!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function wlcheck10(a)
{
	var ip=new Array(4);
	var ip1=new Array(4);
	b=a._7_20_0_2;

	if(b.checked)
	{
		ip1[0]=a._7_19_1_2.value;
		ip1[1]=a._7_19_2_2.value;
		ip1[2]=a._7_19_3_2.value;
		ip1[3]=a._7_19_4_2.value;

		if( (ip1[0].length==0) || (ip1[1].length==0) || (ip1[2].length==0) || (ip1[3].length==0))
		{
			alert('Enter Values before enabling');
			b.checked=false;
			return false;
		}

		retVal=IPCheck1(ip1[0]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 1 to 223 for First Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[1]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Second Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}
	
		retVal=IPCheck2(ip1[2]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Third Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}

		retVal=IPCheck2(ip1[3]);
		if(retVal==1)
		{
			alert('Input numerical value for IP address for Allowlist');
			b.checked=false;
			return false;
		}
		else if(retVal==2)
		{
			alert('Input a value from 0 to 255 for Fourth Octet of IP address for Allowlist');
			b.checked=false;
			return false;
		}
		
		//Check Whitelist IP against WAN Settings	
		ret=CheckWlSubnet(1,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('IP address entered matches WAN IP address!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for WAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for WAN!!');
			b.checked=false;
			return false;
		}		

		//Check Whitelist IP against LAN Settings		
		ret=CheckWlSubnet(2,a,ip1[0],ip1[1],ip1[2],ip1[3]);
		if(ret==1)
		{
			alert('IP address entered matches LAN IP address!!');
			b.checked=false;
			return false;
		}
		else if(ret==2)
		{
			alert('IP address entered matches network address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==3)
		{
			alert('IP address entered matches broadcast address for LAN!!');
			b.checked=false;
			return false;
		}
		else if(ret==4)
		{
			alert('IP address entered belongs to LAN subnet!!');
			b.checked=false;
			return false;
		}
	}
}


//
//
function checkWhitelistPage(a)
{
	var retVal, validEntry, i;
	var b=new Array(10);
	var wl_globalState=a._7_0_0_2[0].checked;

	b[0]=a._7_2_0_2.checked;
	b[1]=a._7_4_0_2.checked;
	b[2]=a._7_6_0_2.checked;
	b[3]=a._7_8_0_2.checked;
	b[4]=a._7_10_0_2.checked;
	b[5]=a._7_12_0_2.checked;
	b[6]=a._7_14_0_2.checked;
	b[7]=a._7_16_0_2.checked;
	b[8]=a._7_18_0_2.checked;
	b[9]=a._7_20_0_2.checked;

	if(wl_globalState) // if whitelist enabled, check values
	{
		//check atleast one entry is enabled
		validEntry=0;
		
		for(i=0;i<10;i++)
		{
			if(b[i])
			{
				validEntry=1;break;
			}
		}
		if(validEntry==0)
		{
			alert('Enable at least one Allowlist IP Address entry');
			return false;
		}		
		
		//check ip values
		retVal=wlcheck1(a);if(retVal==false) return false;
		retVal=wlcheck2(a);if(retVal==false) return false;
		retVal=wlcheck3(a);if(retVal==false) return false;
		retVal=wlcheck4(a);if(retVal==false) return false;
		retVal=wlcheck5(a);if(retVal==false) return false;
		retVal=wlcheck6(a);if(retVal==false) return false;
		retVal=wlcheck7(a);if(retVal==false) return false;
		retVal=wlcheck8(a);if(retVal==false) return false;
		retVal=wlcheck9(a);if(retVal==false) return false;
		retVal=wlcheck10(a);if(retVal==false) return false;
	}
	return true;
}

function extractFilename(path)
{
  var x;
  x = path.lastIndexOf('\\');
  if (x >= 0) // Windows-based path
    return path.substr(x+1);

  x = path.lastIndexOf('/');
  if (x >= 0) // Unix-based path
    return path.substr(x+1);

  return path; // just the filename
}

function updateFilename(path)
{
   var name;	
   name = extractFilename(path);
   document.getElementById('upfile').value = name;
}

function checkAdmin2Page(a)
{
	var p=a.upfile.value;
	if(p.length == 0)
	{
		alert('Select File to be uploaded');
		return false;
	}
	return true;
}


function Wifi_SecurityMode(a)
{
	val = a._8_5_0_2.value;

	if(val==0) //WEP
	{
		document.getElementById("wepKeyLength").style.display = "table-row";
		document.getElementById("wepKeyFormat").style.display = "table-row";
		document.getElementById("wpaCipher").style.display = "none";
		document.getElementById("wpaRekeyInterval").style.display = "none";
	}
	else //WPA or WPA2
	{
		document.getElementById("wepKeyLength").style.display = "none";
		document.getElementById("wepKeyFormat").style.display = "none";
		document.getElementById("wpaCipher").style.display = "table-row";
		document.getElementById("wpaRekeyInterval").style.display = "table-row";

		if(val==1) //WPA
		{
			a._8_8_0_2.selectedIndex=1;
		}
		else //WPA2
		{
			a._8_8_0_2.selectedIndex=0;
		}
	}

	return true;
}

function checkWiFiPage(a)
{
	val = a._8_5_0_2.value; // security mode
	val1 = a._8_10_0_1.value; // preshared key
	val2 = a._8_9_0_2.value; // Group Key Update Interval
	vpnVal = a._9_0_2_2.value
	var proceed, val3;
	
	if(a._8_1_0_2.checked) // if wifi enabled
	{
		if(vpnVal==4)
		{
			a._8_1_0_2.checked=false;
			alert('WAN Connection Type set for Cellular. USB port is being used by USB Cellular Modem.\nWi-Fi cannot be enabled.');
			return false;
		}
		if(val==0) //wep
		{
			if(a._8_6_0_2[0].checked) // 64 bit wep key length
			{
				if(a._8_7_0_2[0].checked) // hex, should be 10 digits
				{
					proceed=checkHex(val1);
					if((proceed==1) || (val1.length != 10) )
					{
						alert('Input 10 digit Hexadecimal value for Shared Key');
						return false;
					}				
				}
				else if(a._8_7_0_2[1].checked) // ASCII, should be 5 digits
				{
					if(val1.length != 5)
					{
						alert('Input 5 digits value for Shared Key');
						return false;
					}
				}
			}
			else if(a._8_6_0_2[1].checked)// 128 bit wep key length
			{
				if(a._8_7_0_2[0].checked) // hex, should be 26 digits
				{
					proceed=checkHex(val1);
					if((proceed==1) || (val1.length != 26) )
					{
						alert('Input 26 digit Hexadecimal value Shared Key');
						return false;
					}
				}
				else if(a._8_7_0_2[1].checked)// ASCII, should be 13 digits
				{
					if(val1.length != 13)
					{
						alert('Input 13 digits value for Shared Key');
						return false;
					}
				}
			}
		}
		else //WPA or WPA2
		{
			if((val1.length < 8) || (val1.length > 63))
			{
				alert('Shared Key should be between 8 and 63 characters');
				return false;
			}
		}

		val3=a._8_2_0_1.value;
		if(val3.length==0)
		{
			alert('Input value for SSID');
			return false;
		}
	}
	
	
	proceed=checkDigit(val2);
	{
		if(proceed==1)
		{
			alert('Input numerical value for Group Key Update Interval');
			return false;
		}
	}

	return true;
}

//
//
//
function NumberCheck(value, a, b)
{
	var proceed=checkDigit(value);
	if(proceed==1)
	{
		return 1;
	}
	if(proceed==0)
	{
		if((parseInt(value,10) < parseInt(a, 10)) || (parseInt(value,10) > parseInt(b,10)))
		{
			return 2; 
		}
	}
	return 0;
}

//
//
function checkBBMDPage(a)
{
	if(a._16_0_0_2[0].checked) //if BBMD enabled
	{
		// device instance (0, 4194302)
		b=a._16_2_0_2;
		val=b.value;
		if(val.length==0)
		{
			alert('Input a value for Device Instance');
			b.focus();
			return false;
		}
		ret=NumberCheck(val, 0, 4194302);
		if(ret==1)
		{
			alert('Input numerical value for Device Instance');
			b.focus();
			return false;
		}
		if(ret==2)
		{
			alert('Device Instance should be between 0 and 4194302');
			b.focus();
			return false; 
		}
		
		// Ethernet Network
		//b=a._16_5_0_2;
		//val=b.value;
		//if(val.length==0)
		//{
		//	alert('Input a value for Ethernet Network');
		//	b.focus();
		//	return false;
		//}
		//ret=NumberCheck(val, 0, 65534);
		//if(ret==1)
		//{
		//	alert('Input numerical value for Ethernet Network');
		//	b.focus();
		//	return false;
		//}
		//if(ret==2)
		//{
		//	alert('Ethernet Network should be between 0 and 65534');
		//	b.focus();
		//	return false; 
		//}
	
		// WAN BACnet/IP UDP Port (0 - ffff)
		b=a._16_6_0_1;
		val=b.value;
		if(val.length==0)
		{
			alert('Input a value for WAN BACnet/IP UDP Port');
			b.focus();
			return false;
		}
		ret=checkHex(val);
		if(ret==1)
		{
			alert('Input hexadecimal value between 1 to FFFF for WAN BACnet/IP UDP Port');
			b.focus();
			return false;
		}
	
		p1=val;
		//Check that port is not zero
		val=parseInt(p1,16);//convert to decimal
		if(val==0)
		{
			alert('Input hexadecimal value between 1 to FFFF for WAN BACnet/IP UDP Port');
			b.focus();
			return false;
		}
	
		// WAN BACnet/IP Network  (1-65534)
		b=a._16_7_0_2
		val=b.value;
		if(val.length==0)
		{
			alert('Input a value for WAN BACnet/IP Network');
			b.focus();
			return false;
		}
		ret=NumberCheck(val, 1, 65534);
		if(ret==1)
		{
			alert('Input numerical value for WAN BACnet/IP Network');
			b.focus();
			return false;
		}
		if(ret==2)
		{
			alert('WAN BACnet/IP Network value should be between 1 and 65534');
			b.focus();
			return false; 
		}
		
		n1=val;
		
		//check LAN side settings if firewall is enabled, then these 2 fields are not grayed out
	
		// LAN BACnet/IP UDP Port (1 - ffff)
		b=a._16_8_0_1;
		if(b.disabled == false)
		{
			val=b.value;
			if(val.length==0)
			{
				alert('Input a value for LAN BACnet/IP UDP Port');
				b.focus();
				return false;
			}
			ret=checkHex(val);
			if(ret==1)
			{
				alert('Input hexadecimal value between 1 to FFFF for LAN BACnet/IP UDP Port');
				b.focus();
				return false;
			}
			
			p2=val;
			//Check that port is not zero
			val=parseInt(p2,16);//convert to decimal
			if(val==0)
			{
				alert('Input hexadecimal value between 1 to FFFF for LAN BACnet/IP UDP Port');
				b.focus();
				return false;
			}
		
			// LAN BACnet/IP Network  (1-65534)
			b=a._16_9_0_2
			val=b.value;
			if(val.length==0)
			{
				alert('Input a value for LAN BACnet/IP Network');
				b.focus();
				return false;
			}
			ret=NumberCheck(val, 1, 65534);
			if(ret==1)
			{
				alert('Input numerical value for LAN BACnet/IP Network');
				b.focus();
				return false;
			}
			if(ret==2)
			{
				alert('LAN BACnet/IP Network value should be between 1 and 65534');
				b.focus();
				return false; 
			}
	
			n2=val;
			
			// No duplicate values
			if(p1==p2)
			{
				alert('WAN BACnet/IP UDP Port and LAN BACnet/IP UDP Port should not be same');
				a._16_8_0_1.focus();
				return false;
			}	
			if(n1==n2)
			{
				alert('WAN BACnet/IP Network and LAN BACnet/IP Network should not be same');
				a._16_9_0_2.focus();
				return false;
			}
		}
	}

	return true;
}


function checkBdtPage1(a)
{
	var i;
	var digits="0123456789.";

	//BBMD IP Address
	var b=a._18_1_0_1;
	ipVal=b.value;
	var len=ipVal.length;
	if(len==0)
	{
		alert('Input BBMD IP Address');
		b.focus();
		return false;	
	}
	
	//only digits and . allowed
	for(i = 0; i < len; i++)
	{
		if (digits.indexOf(ipVal.charAt(i))< 0)
		{
			alert('Input Valid BBMD IP Address. Only numbers and . allowed');
			return false;
		}
	}

	ipArray=ipVal.split(".");
	if(ipArray.length != 4)
	{
		alert('Input Valid BBMD IP Address');
		b.focus();
		return false;
	}

	if((ipArray[0].length ==0) ||(ipArray[1].length==0) || (ipArray[2].length == 0) || (ipArray[3].length==0))
	{
		alert('Input Valid BBMD IP Address');
		b.focus();
		return false;
	}

	if( ((ipArray[0]<1) || (ipArray[0] >223)) || ((ipArray[1]<0) || (ipArray[1] >255)) ||
	((ipArray[2]<0) || (ipArray[2] >255)) || ((ipArray[3]<0) || (ipArray[3] >255)) )
	{
		alert('Input Valid BBMD IP Address');
		b.focus();
		return false;
	}
	
	return true;
}

function checkBdtPage2(a)
{
	//Delete Entry for Broadcast Distribution Table
	var b=a._18_4_0_2;
	val=b.value;
	if(val.length==0)
	{
		alert('Input a value to Delete Entry');
		b.focus();
		return false;
	}
	ret=NumberCheck(val, 1, 50);
	if(ret==1)
	{
		alert('Input numerical value to Delete Entry');
		b.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Delete Entry value should be between 1 and 50');
		b.focus();
		return false; 
	}
	
	return true;
}

function agreeDH_Message()
{
	var r = confirm("The server certificate/keys generation includes DH which takes upto 15 minutes.\nPlease do not reboot or cycle power to the router while this step completes in the background.");
	if (r == true)
    		return true;
	else 
		return false;
 	
	return false;
}

function agreeVPN_Reset()
{
	var r = confirm("All the current certificate and keys including CA will be deleted!!.\nThe VPN clients will be disconnected and new configuration files must be generated and uploaded to setup VPN again.\nDo you really want to continue?");
	if (r == true)
    		return true;
	else 
		return false;
 	
	return false;
}

function isLeapYear(year)
{
	return year%400 ==0 || (year%100 != 0 && year%4 == 0);
}

function checkTimePage(a)
{
	var numDays=["31","28","31","30","31","30","31","31","30","31","30","31"];
	// Year
	var val=a._11_1_0_2.value;
	
	if(val.length==0)
	{
		alert('Input a value for Year');
		a._11_1_0_2.focus();
		return false;
	}
	ret=NumberCheck(val, 1000, 9999);
	if(ret==1)
	{
		alert('Input valid numerical value for Year');
		a._11_1_0_2.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Enter numerical value for Year in YYYY format');
		a._11_1_0_2.focus();
		return false; 
	}

	var isLeap=isLeapYear(val);	

	// Month
	val=a._11_2_0_2.value;
	if(val.length==0)
	{
		alert('Input a value for Month');
		a._11_2_0_2.focus();
		return false;
	}
	ret=NumberCheck(val, 1, 12);
	if(ret==1)
	{
		alert('Input numerical value for Month');
		a._11_2_0_2.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Month value should be between 1 and 12');
		a._11_2_0_2.focus();
		return false; 
	}

	mnthVal=parseInt(val,10)-1;
	if ((isLeap) && (mnthVal == 1))//feb and leap year
		numDays[mnthVal]=29;	

	// Day
	val=a._11_3_0_2.value;
	if(val.length==0)
	{
		alert('Input a value for Day');
		a._11_3_0_2.focus();
		return false;
	}
	ret=NumberCheck(val, 1, numDays[mnthVal]);
	if(ret==1)
	{
		alert('Input numerical value for Day');
		a._11_3_0_2.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Day value should be between 1 and ' + numDays[mnthVal] + '');
		a._11_3_0_2.focus();
		return false; 
	}
	
	// Hours
	val=a._11_4_0_2.value;
	if(val.length==0)
	{
		alert('Input a value for Hours');
		a._11_4_0_2.focus();
		return false;
	}
	ret=NumberCheck(val, 0, 24);
	if(ret==1)
	{
		alert('Input numerical value for Hours');
		a._11_4_0_2.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Hours value should be between 0 and 24');
		a._11_4_0_2.focus();
		return false; 
	}
	
	// Minutes
	val=a._11_5_0_2.value;
	if(val.length==0)
	{
		alert('Input a value for Minutes');
		a._11_5_0_2.focus();
		return false;
	}
	ret=NumberCheck(val, 0, 60);
	if(ret==1)
	{
		alert('Input numerical value for Minutes');
		a._11_5_0_2.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Minutes value should be between 0 and 60');
		a._11_5_0_2.focus();
		return false; 
	}

	// Secs
	val=a._11_6_0_2.value;
	if(val.length==0)
	{
		alert('Input a value for Seconds');
		a._11_6_0_2.focus();
		return false;
	}
	ret=NumberCheck(val, 0, 60);
	if(ret==1)
	{
		alert('Input numerical value for Seconds');
		a._11_6_0_2.focus();
		return false;
	}
	if(ret==2)
	{
		alert('Seconds value should be between 0 and 60');
		a._11_6_0_2.focus();
		return false; 
	}

	return true;
}

//
//

function checkVPN22Page(a)
{
	var bridge_ip = new Array(4);
	var nm_array1 = new Array(4);
	var nm_array2 = new Array(4);
	var lanip = new Array(4);
	var dhcpip = new Array(4);

	
	bridge_ip[0]=a._22_4_1_2.value;
	bridge_ip[1]=a._22_4_2_2.value;
	bridge_ip[2]=a._22_4_3_2.value;
	bridge_ip[3]=a._22_4_4_2.value;

	ip=a._5_4_1_1.value;
	lanip=ip.split(".");

	subnet=a._5_4_2_1.value;
	subnet_array=subnet.split(".");

	dhcp=a._5_4_3_1.value;
	dhcpip=dhcp.split(".");


	var numClients=a._5_4_4_1.value;

	retVal=IPCheck1(bridge_ip[0]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for VPN Client IP Address');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 1 to 223 for First Octet of IP address for VPN Client IP Address');
		return false;
	}
	retVal=IPCheck2(bridge_ip[1]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for VPN Client IP Address');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 0 to 255 for Second Octet of IP address for VPN Client IP Address');
		return false;
	}
	retVal=IPCheck2(bridge_ip[2]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for VPN Client IP Address');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 0 to 255 for Third Octet of IP address for VPN Client IP Address');
		return false;
	}
	retVal=IPCheck2(bridge_ip[3]);
	if(retVal==1)
	{
		alert('Input numerical value for IP address for VPN Client IP Address');
		return false;
	}
	else if(retVal==2)
	{
		alert('Input a value from 0 to 255 for Fourth Octet of IP address for VPN Client IP Address');
		return false;
	}


	//Display error if VPN start address matches router LAN ip address
	if((lanip[0]==bridge_ip[0]) && (lanip[1]==bridge_ip[1]) && (lanip[2]==bridge_ip[2]) && (lanip[3]==bridge_ip[3]) )
	{
		alert('VPN Client Start address is equal to Router IP address for LAN setup');
		return false;
	}

	//LAN network address
	for (i = 0; i < 4; i++)
		nm_array1[i] = lanip[i] & subnet_array[i];

	//VPN IP network address
	for (i = 0; i < 4; i++)
		nm_array2[i] = bridge_ip[i] & subnet_array[i];

	//if network addresses don't match, not in same subnet
	if((nm_array1[0]!=nm_array2[0]) || (nm_array1[1]!=nm_array2[1]) || (nm_array1[2]!=nm_array2[2]) || (nm_array1[3]!=nm_array2[3]) )
	{
		alert('VPN Client IP address entered is not in LAN subnet!!');
		return false;
	}

	//if VPN address matches network address
	if((bridge_ip[0]==nm_array2[0]) && (bridge_ip[1]==nm_array2[1]) && (bridge_ip[2]==nm_array2[2]) && (bridge_ip[3]==nm_array2[3]) )
	{
		alert('VPN Client IP address entered matches network address for LAN!!');
		return false;
	}

	//calculate inverse netmask
	var invSubnet=new Array(4);
	for (i = 0; i < 4; i++)
		invSubnet[i] = subnet_array[i] ^ 255;

	//calculate LAN broadcast address
	var bc_lan=new Array(4);
	for (i = 0; i < 4; i++)
		bc_lan[i] = lanip[i] | invSubnet[i];	

	//if VPN ip address matches broadcast address
	if((bridge_ip[0]==bc_lan[0]) && (bridge_ip[1]==bc_lan[1]) && (bridge_ip[2]==bc_lan[2]) && (bridge_ip[3]==bc_lan[3]) )
	{
		alert('VPN Client IP address is equal to broadcast IP address for LAN setup');
		return false;
	}
	

	var dhcp_end_ip=new Array(4);	
	for(i=0; i < 4; i++)
		dhcp_end_ip[i] = parseInt(dhcpip[i]);	
		
	dhcp_end_ip[3] += (parseInt(numClients) -1);	
	if(dhcp_end_ip[3] > parseInt(254))
	{
		var temp = dhcp_end_ip[3]-parseInt(254);
		dhcp_end_ip[3] = temp;
		dhcp_end_ip[2]++;
		if(dhcp_end_ip[2] > 255)
		{
			dhcp_end_ip[2] = parseInt(0);
			dhcp_end_ip[1]++;
			if(dhcp_end_ip[1] > parseInt(255))
			{
				dhcp_end_ip[1] = parseInt(0);
				dhcp_end_ip[0]++;
			}
		}
	}

/*alert('dhcp ip');
alert('start '+dhcpip[0]+''+dhcpip[1]+''+dhcpip[2]+''+dhcpip[3]+'');
alert('end '+dhcp_end_ip[0]+''+dhcp_end_ip[1]+''+dhcp_end_ip[2]+''+dhcp_end_ip[3]+'');*/

	var bridge_end_ip=new Array(4);	
	for(i=0; i < 4; i++)
		bridge_end_ip[i] = parseInt(bridge_ip[i]);	
		
	bridge_end_ip[3] += 9;	
	if(bridge_end_ip[3] > parseInt(254))
	{
		var temp = bridge_end_ip[3]-parseInt(254);
		bridge_end_ip[3] = temp;
		bridge_end_ip[2]++;
		if(bridge_end_ip[2] > parseInt(255))
		{
			bridge_end_ip[2] = parseInt(0);
			bridge_end_ip[1]++;
			if(bridge_end_ip[1] > parseInt(255))
			{
				bridge_end_ip[1] = parseInt(0);
				bridge_end_ip[0]++;
			}
		}
	}

	/*alert('bridge ip');
	alert('start :'+bridge_ip[0]+'.'+bridge_ip[1]+'.'+bridge_ip[2]+'.'+bridge_ip[3]+'');
	alert('end :'+bridge_end_ip[0]+'.'+bridge_end_ip[1]+'.'+bridge_end_ip[2]+'.'+bridge_end_ip[3]+'');*/
	
	// calculate int values of VPN ip address, starting dhcp and ending dhcp address
	var int_bridgeip, int_startdhcp, int_enddhcp, int_endbridgeip;
		
	int_bridgeip=(256*256*256*parseInt(bridge_ip[0])) + (256*256*parseInt(bridge_ip[1])) + (256*parseInt(bridge_ip[2])) + parseInt(bridge_ip[3]);
	int_endbridgeip = (256*256*256*parseInt(bridge_end_ip[0])) + (256*256*parseInt(bridge_end_ip[1])) + (256*parseInt(bridge_end_ip[2])) + parseInt(bridge_end_ip[3]);

	int_startdhcp=(256*256*256*parseInt(dhcpip[0])) + (256*256*parseInt(dhcpip[1])) + (256*parseInt(dhcpip[2])) + parseInt(dhcpip[3]);
	int_enddhcp=(256*256*256*parseInt(dhcp_end_ip[0])) + (256*256*parseInt(dhcp_end_ip[1])) + (256*parseInt(dhcp_end_ip[2])) + parseInt(dhcp_end_ip[3]);
 
	
	//make sure that ending bridge address is smaller than or equal to (broadcast address -1)
	//calculate int value of broadcast address
	var int_bc;
	int_bc=(256*256*256*parseInt(bc_lan[0])) + (256*256*parseInt(bc_lan[1])) + (256*parseInt(bc_lan[2])) + parseInt(bc_lan[3]);
		
	if(int_endbridgeip > (int_bc-1))
	{
		alert('Ending VPN Client IP address not in LAN Subnet.\n Change the VPN Client IP Start Address. (10 VPN clients)');
		return false;
	}

	//alert('bridge: '+int_bridgeip+' end:'+int_endbridgeip+'\ndhcp:   '+int_startdhcp+' end:'+int_enddhcp+'   ');

	//check that VPN Bridge ip is not in dhcp address range	
	for(i=0; i < 10; i++)
	{
		/*if((parseInt(int_bridgeip) + parseInt(i)) > (parseInt(int_startdhcp)-parseInt(1)))
			alert('overlap1');
		if ((parseInt(int_bridgeip) +parseInt(i)) < (parseInt(int_enddhcp) + parseInt(1)))
			alert('overlap2');*/
		if(  
		((parseInt(int_bridgeip) + parseInt(i)) > (parseInt(int_startdhcp)-parseInt(1)) ) && 
			((parseInt(int_bridgeip) +parseInt(i)) < (parseInt(int_enddhcp) + parseInt(1)))
			)
		{
			i=99;
			alert('VPN Client IP cannot be in the DHCP address range.\n\nVPN Client IP Range: '+bridge_ip[0]+'.'+bridge_ip[1]+'.'+bridge_ip[2]+'.'
				+bridge_ip[3]+' to '+bridge_end_ip[0]+'.'+bridge_end_ip[1]+'.'+bridge_end_ip[2]+'.'+bridge_end_ip[3]+
				'\n\nDHCP Range: '+dhcpip[0]+'.'+dhcpip[1]+'.'+dhcpip[2]+'.'+dhcpip[3]+' to '
				+dhcp_end_ip[0]+'.'+dhcp_end_ip[1]+'.'+dhcp_end_ip[2]+'.'+dhcp_end_ip[3]);
			return false;
		}
	}

	return true;
}

