#!/bin/sh

. /app/config/network_wan.ini

file_basvpn=/etc/openvpn/client/cfg_ip


if [ -e $file_basvpn ] && [ "$VPN_MODE" = "CLIENT" ]; then
	/app/scripts/update_cfg_ip.sh
fi

#check if openvpn is running, else start it

if [ -z "$(pgrep openvpn)" ]
then
	# openvpn is not running, check mode
	if [ "$VPN_MODE" = "CLIENT" ]; then
		client_cfg_name=$(echo $(ls /etc/openvpn/client/*.ovpn))
		openvpn $client_cfg_name &
	elif [ "$VPN_MODE" = "SERVER" ]; then
		openvpn /etc/openvpn/server/server-udp.conf &
	fi
fi
