#!/bin/sh

# Source Router type
#
. /app/scripts/eipr_type

# Source Network Information
. /app/config/network_wan.ini


if [ "$EIPR_TYPE" = "REALTEK" ]; then
	WANIF=eth0.2
else
	WANIF=eth1
fi

if [ "$VPN_MODE" = "SERVER" ]; then
	VPNIF=tap0
else
	VPNIF=tun0
fi

echo Content-type: text/html
echo ""
echo "<html><head><title>EIGR-C</title><link href=\"test.css\" rel=\"stylesheet\" type=\"text/css\" />
</head><body style=\"background: white;\">"

#
# DHCP or Static for WAN port
#
if [ "$BOOTPROTO_WAN" = "dhcp" ] || [ "$BOOTPROTO_WAN" = "none" ]; then
echo "<br />"
echo "<h2 style=\"width: 500;\">WAN Interface Statistics:</h2>"
echo "<br />"
lineNums=$(echo $(ifconfig $WANIF | wc -l))
echo "<pre>"
if [ "$lineNums" = "8" ]; then
	ifconfig $WANIF | sed -n -e '4,7 p'
else
	ifconfig $WANIF | sed -n -e '3,6 p'
fi
echo "</pre>"
fi
#
# IF PPP interface is present
#
if [ "$BOOTPROTO_WAN" = "cellular" ]; then
echo "<br />"
echo "<h2 style=\"width: 500;\">Cellular Interface Statistics:</h2>"
echo "<br />"
lineNums=$(echo $(ifconfig ppp0 | wc -l))
echo "<pre>"
if [ "$lineNums" = "8" ]; then
	ifconfig ppp0 | sed -n -e '4,7 p'
else
	ifconfig ppp0 | sed -n -e '3,6 p'
fi
echo "</pre>"
fi

#
#
# If VPN is enabled, show tunnel statistics
#
if [ "$EIPR_VPN" = "YES" ]; then
echo "<br />"
echo "<h2 style=\"width: 500;\">VPN Interface Statistics:</h2>"
echo "<br />"
lineNums=$(echo $(ifconfig $VPNIF | wc -l))
echo "<pre>"
if [ "$lineNums" = "8" ]; then
	ifconfig $VPNIF | sed -n -e '4,7 p'
else
	ifconfig $VPNIF | sed -n -e '3,6 p'
fi
echo "</pre>"
fi

echo "</body></html>"

