/*
 * Converter.java
 *
 * Created on January 12, 2007, 4:28 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package	    Misc;

/**
 *
 * @author rcw
 */
public class Converter
{
	//
	public final static int	SCL_NONE	=  0;
	public final static int	SCL_UP_10	=  1;
	public final static int	SCL_UP_100	=  2;
	public final static int	SCL_UP_1000	=  3;
	public final static int	SCL_DN_10	=  4;
	public final static int	SCL_DN_100	=  5;
	public final static int	SCL_DN_1000	=  6;
	public final static int	SCL_FTOC	=  7;
	public final static int	SCL_CTOF	=  8;

	// Here to convert an integer value retrieved from a Modbus
	// transaction to a string used by the display.
	//
	public String RawToString( int val , int scale )
	{
		//
		float	    tmpFloat;
		String	    tmpString;

		// Convert to floating point.
		tmpFloat = val;
		// Which scale factor.
		switch ( scale )
		{
			case SCL_UP_10:
				tmpFloat *= 10;
				break;
			case SCL_UP_100:
				tmpFloat *= 100;
				break;
			case SCL_UP_1000:
				tmpFloat *= 1000;
				break;
			case SCL_DN_10:
				tmpFloat /= 10;
				break;
			case SCL_DN_100:
				tmpFloat /= 100;
				break;
			case SCL_DN_1000:
				tmpFloat /= 1000;
				break;
			case SCL_FTOC:
				tmpFloat /= 10;
				tmpFloat -= 32.0;
				tmpFloat *= .5556;
				break;
			case SCL_CTOF:
				tmpFloat /= 10;
				tmpFloat *= 1.8;
				tmpFloat += 32.0;
				break;
			default:
				break;
		}
		// Make string out of float.
		tmpString = Float.toString( tmpFloat );
		//
		// Strip to 2 decimal places?
		//
		// Return with string.
		return tmpString;
	}

	// Here to convert an string value in an edit box to a Modbus
	// value we can send to the controller.
	//
	public int StringToRaw( String val , int scale )
	{
		//
		float	    tmpFloat;

		// Convert to floating point.
		tmpFloat = Float.parseFloat(val);
		// Which scale factor.
		switch ( scale )
		{
			case SCL_UP_10:
				tmpFloat *= 10;
				break;
			case SCL_UP_100:
				tmpFloat *= 100;
				break;
			case SCL_UP_1000:
				tmpFloat *= 1000;
				break;
			case SCL_DN_10:
				tmpFloat /= 10;
				break;
			case SCL_DN_100:
				tmpFloat /= 100;
				break;
			case SCL_DN_1000:
				tmpFloat /= 1000;
				break;
			case SCL_FTOC:
				tmpFloat *= 10;
				tmpFloat -= 32.0;
				tmpFloat *= .5556;
				break;
			case SCL_CTOF:
				tmpFloat *= 10;
				tmpFloat *= 1.8;
				tmpFloat += 32.0;
				break;
			default:
				break;
		}
		// Return with integer value of float.
		return (int)tmpFloat;
	}

	/**
	 * Creates a new instance of Converter
	 */
	public Converter()
	{
	}

}
