package MappingCfg;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

import modbus.mod;

public class devicePanel extends JPanel
{
	private JTextField EbxDeviceName;
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private JTextField EbxModIP;
	private JLabel 		errorLabel;
	private JPanel 		checkPanel;
	private JTextField 	EbxDevInst;
	private JTextField 	EbxModbusAddr;
	private JCheckBox	objCheckbox;
    private JScrollPane scrollPane;
	private JPanel 		regPanel;
	/**
	 * 
	 */
    mod.device        	comBas         	= new mod.device();
    int					obj_qty			= 0;
    int					unit_index 		= 1;
    String				filename		= null;
    int					objStatus[];
    String				password		= "ccsi2431";
 	
	public devicePanel()
	{
        super();
		initComponents();	
		readUserFile();
	}

    public void ProcessError( String text )
    {
        mod.err e = mod.err.getObj(text);

        switch (e)
        {
            // We ignore ILLEGAL errors here.
            case ILLEGAL_DATA_ADDRESS:
            case ILLEGAL_FUNCTION:
            case ILLEGAL_DATA_VALUE:
            case ILLEGAL_OBJECT_INSTANCE:
                break;
            default:
                comBas.Disconnect();
                break;
        }
        errorLabel.setText(text);
        errorLabel.setVisible(true);
    }


    private void readUserFile()
    {
    	String 		objID = null;
        int			i, obj_qty;
        
		// Get object data.
		EbxDeviceName.setText(fileFunction.unit_name);
		EbxModbusAddr.setText(fileFunction.mod_address);
		EbxDevInst.setText(fileFunction.unit_instance);
		EbxModIP.setText(fileFunction.mod_ip);
	    obj_qty = fileFunction.reg_qty;
	    if(obj_qty > 1000)
	    	obj_qty = 1000;
	    objStatus = new int[obj_qty];
        
		// Loop to get all object instances.
        for (i = 0; i < obj_qty; ++i)
        {
        	// Get object instance.
			objID = fileFunction.registers[i];
			objCheckbox = new JCheckBox(objID + "   " + fileFunction.description[i]);
			// Set combo box selection.
			if(fileFunction.reg_status[i] == 0)
				objCheckbox.setSelected(false);    
			else
				objCheckbox.setSelected(true);
			objCheckbox.setEnabled(false);
			regPanel.add(objCheckbox, i);
		}
        this.validate();
		this.repaint();
    }

    private void initComponents()
    {
		setLayout(null);
		setBounds(10, 10, 418, 475);

		final JLabel nameLabel = new JLabel();
		nameLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		nameLabel.setText("Device Name:");
		nameLabel.setBounds(28, 69, 103, 18);
		add(nameLabel);

		final JLabel modbusAddressLabel = new JLabel();
		modbusAddressLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		modbusAddressLabel.setText("Modbus Address:");
		modbusAddressLabel.setBounds(28, 96, 130, 21);
		add(modbusAddressLabel);

		EbxModbusAddr = new JTextField();
		EbxModbusAddr.setBorder(new BevelBorder(BevelBorder.LOWERED));
		EbxModbusAddr.setText("EbxModbusAddr");
		EbxModbusAddr.setBounds(164, 96, 40, 21);
		EbxModbusAddr.setEditable(false);
		add(EbxModbusAddr);

		final JLabel deviceInstanceLabel = new JLabel();
		deviceInstanceLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		deviceInstanceLabel.setText("Device Instance:");
		deviceInstanceLabel.setBounds(28, 145, 120, 21);
		add(deviceInstanceLabel);

		EbxDevInst = new JTextField();
		EbxDevInst.setBorder(new BevelBorder(BevelBorder.LOWERED));
		EbxDevInst.setText("EbxDevInstance");
		EbxDevInst.setBounds(153, 145, 144, 21);
		EbxDevInst.setEditable(false);
		add(EbxDevInst);

		final JLabel modbusRegistersLabel = new JLabel();
		modbusRegistersLabel.setText("All Modbus Registers (Max 1000):");
		modbusRegistersLabel.setBounds(28, 182, 248, 14);
		add(modbusRegistersLabel);

		checkPanel = new JPanel();
		checkPanel.setLayout(null);
		checkPanel.setBorder(new BevelBorder(BevelBorder.LOWERED));
		checkPanel.setBounds(28, 202, 332, 216);
		add(checkPanel);

		scrollPane = new JScrollPane();
		scrollPane.setBounds(0, 0, 332, 216);
		checkPanel.add(scrollPane);

		regPanel = new JPanel();
		regPanel.setBorder(new BevelBorder(BevelBorder.LOWERED));
		regPanel.setLayout(new BoxLayout(regPanel, BoxLayout.Y_AXIS));
		regPanel.setBounds(27, 244, 363, 163);
        scrollPane.setViewportView(regPanel);

        errorLabel = new JLabel();
		errorLabel.setForeground(Color.RED);
		errorLabel.setBounds(28, 417, 298, 18);
		add(errorLabel);

		final JButton cancelButton = new JButton();
		cancelButton.addActionListener(new ActionListener() 
		{
			public void actionPerformed(final ActionEvent arg0) 
			{
				int		i;
    			java.awt.Component[] components = regPanel.getComponents();
            	
    			for (i = 0; i < components.length; ++i)
    			{
					regPanel.remove(components[i]);
				}
				cmuFlag.set_exit_device_panel();
			}
		});
		cancelButton.setText("Back");
		cancelButton.setBounds(153, 441, 90, 24);
		add(cancelButton);   	

		final JLabel modifyDeviceLabel = new JLabel();
		modifyDeviceLabel.setForeground(Color.RED);
		modifyDeviceLabel.setFont(new Font("Sans", Font.BOLD, 20));
		modifyDeviceLabel.setText("Device Information");
		modifyDeviceLabel.setBounds(28, 10, 239, 23);
		add(modifyDeviceLabel);

		final JLabel modbusIpAddressLabel = new JLabel();
		modbusIpAddressLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		modbusIpAddressLabel.setText("Modbus IP Address:");
		modbusIpAddressLabel.setBounds(28, 125, 144, 14);
		add(modbusIpAddressLabel);

		EbxModIP = new JTextField();
		EbxModIP.setText("EbxModIP");
		EbxModIP.setBorder(new BevelBorder(BevelBorder.LOWERED));
		EbxModIP.setBounds(178, 123, 148, 18);
		EbxModIP.setEditable(false);
		add(EbxModIP);

		EbxDeviceName = new JTextField();
		EbxDeviceName.setBorder(new BevelBorder(BevelBorder.LOWERED));
		EbxDeviceName.setEditable(false);
		EbxDeviceName.setText("EbxDeviceName");
		EbxDeviceName.setBounds(122, 66, 254, 21);
		add(EbxDeviceName);
    }
}
