package MappingCfg;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import modbus.mod;
import bas_remote.bas_def;

public class copyPanel extends JPanel
{

	private JTextField EbxRegNumber;
	private JTextField EbxModIP;
	private JLabel 		errorLabel;
	private JPanel 		checkPanel;
	private JTextField 	EbxDevInst;
	private JTextField 	EbxModAddr;
	private JTextArea 	EbxDeviceName;
	private JCheckBox	objCheckbox;
    private JScrollPane scrollPane;
	private JPanel 		regPanel;
	private JCheckBox 	CbxAutoInst;
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
    mod.device        	comBas         	= new mod.device();
    int					obj_qty			= 0;
    int					unit_index 		= 1;
    String				filename		= null;
    int					objStatus[];
    String				password		= "ccsi2431";
 	
	public copyPanel()
	{
        super();
		initComponents();	
		readUserFile();
	}

    int validateIPAddress( String ip )
    {
        int k;
        String[] temp = null;

        // Do the split.
        temp = ip.split("\\.");

        // should have 4 values
        if (temp.length < 4)
            return -1;

        // no whitespace allowed
        for (k = 0; k < 4; k++)
        {
            if (temp[k].length() != temp[k].trim().length())
                return -1;
        }

        if ((temp[0].length() == 0) || (temp[1].length() == 0) || (temp[2].length() == 0) || (temp[3].length() == 0))
            return -1;

        // valid range is 0 to 255
        for (k = 0; k < 4; k++)
        {
            if ((Integer.valueOf(temp[k]).intValue() < 0) || (Integer.valueOf(temp[k]).intValue() > 255))
                return -1;
        }

        return 0;
    }

    public void ProcessError( String text )
    {
        mod.err e = mod.err.getObj(text);

        switch (e)
        {
            // We ignore ILLEGAL errors here.
            case ILLEGAL_DATA_ADDRESS:
            case ILLEGAL_FUNCTION:
            case ILLEGAL_DATA_VALUE:
            case ILLEGAL_OBJECT_INSTANCE:
                break;
            default:
                comBas.Disconnect();
                break;
        }
        errorLabel.setText(text);
        errorLabel.setVisible(true);
    }

    private void writeUserFile() throws Exception
    {
    	String				ip, newFilename;
        int 				instance = 0, i;
        int					regionNumber = 0;
        String				dirName = "/data/map/";
        int					checked_reg = 0;
		StringTokenizer 	st = null;
		String				deviceType = null;
		boolean 			foundFile = false, error = false;
		int					reg_cnt = 0;
		String				errorMsg = null;
		int					result = 0;
        String				modAddr = null;
        int					iModAddr = 0;
        String				comModAddr = null;
		String				modIP = null, reg;
		
        // Return if not connected.
        if (!comBas.IsConnected())
            return;
        
		if(filename != null)
		{
			fileFunction.unit_name = EbxDeviceName.getText();
	        if(fileFunction.unit_name.equals("") || (fileFunction.unit_name == null))
	        {
	            errorMsg = "Error: No Unit Name";   
		        JOptionPane.showMessageDialog(null, errorMsg);
		        return;
	        }
			
			modAddr = EbxModAddr.getText();
			try
			{
				Integer.parseInt(modAddr);
				iModAddr = Integer.decode(modAddr);
				if((iModAddr > 246) || (iModAddr < 1))
				{
					errorMsg = "Error: wrong modbus address"; 
			        JOptionPane.showMessageDialog(null, errorMsg);
			        return;
				}
				else
				{
					modIP = EbxModIP.getText();
					if(validateIPAddress(modIP) != 0)
					{
						errorMsg = "Error: wrong modbus IP address"; 
				        JOptionPane.showMessageDialog(null, errorMsg);
				        return;
					}
					else
					{
						if(modIP.equals("0.0.0.0"))
							comModAddr = modAddr;
						else
							comModAddr = modIP.concat(":" + modAddr);
						// check duplicate modAddr/modIP
						for(i = 0; i < fileFunction.unit_qty; i++)
						{
							if(comModAddr.equals(fileFunction.modbusAddr[i]))
							{
								errorMsg = "Error: Modbus Address already exists";
								error = true;        						
								break;
							}
						}
						if(error == true)
						{
							JOptionPane.showMessageDialog(null, errorMsg);
							return;
						}
						else
						{
							fileFunction.mod_address = modAddr;            					
							fileFunction.mod_ip = modIP;
						}
    				
						if(CbxAutoInst.isSelected() == true)
						{
							// To do: generate device instance automatically
							instance = 2450000 + iModAddr;
							reg = EbxRegNumber.getText();
							try
							{
								Integer.parseInt(reg);
								regionNumber = Integer.decode(reg);
								if((regionNumber < 0) || (regionNumber > 10))
								{
									errorMsg = "Error: Invalid Region Number"; 
							    	JOptionPane.showMessageDialog(null, errorMsg);
									return;
								}
								else
								{
									instance = instance + regionNumber * 1000;
									fileFunction.unit_instance = String.valueOf(instance);
								}
							}
							catch(Exception e)
							{
								errorMsg = "Error: Invalid Region Number"; 
						    	JOptionPane.showMessageDialog(null, errorMsg);
								return;								
							}
						}
						else
						{
							fileFunction.unit_instance = EbxDevInst.getText();
							try
							{
								Integer.parseInt(fileFunction.unit_instance);
								instance = Integer.decode(fileFunction.unit_instance);								
							}
							catch(Exception e)
							{
								errorMsg = "Error: Invalid Device Instance"; 
						    	JOptionPane.showMessageDialog(null, errorMsg);
								return;																
							}
						}
						if((instance < 0) || (instance >= 0x3FFFFF))
						{
							errorMsg = "Error: wrong device instance";   
					    	JOptionPane.showMessageDialog(null, errorMsg);
							return;																
						}
						else
						{
							// check duplicate device instance
							for(i = 0; i < fileFunction.unit_qty; i++)
							{
								if(instance == fileFunction.devInstance[i])
								{
									errorMsg = "Error: Device Instance already exists";
									error = true;      
									break;
								}
							}
							if(error == true)
							{
								// Show status dialog box.
								JOptionPane.showMessageDialog(null, errorMsg);
								return;
							}
							java.awt.Component[] components = regPanel.getComponents();
							if(components.length > 1000)
							{
	         					errorMsg = "Error: Number of registers exceeds 1000";      
	            		        JOptionPane.showMessageDialog(null, errorMsg);
	            		        return;
							}
							else
								reg_cnt = components.length;
    					
							for (i = 0; i < reg_cnt; ++i)
							{
								JCheckBox cb = (JCheckBox)components[i];
								if(cb.isSelected())
								{
									fileFunction.reg_status[i] = 1;
									checked_reg++;
								}
								else
									fileFunction.reg_status[i] = 0;                		
							}
            			
							if(checked_reg <= 0)
							{
								errorMsg = "Error: No Register Checked";
						    	JOptionPane.showMessageDialog(null, errorMsg);
								return;	
							}
							
							if((fileFunction.total_reg_qty + checked_reg) > 1000)
							{
								errorMsg = "Error: Mapped Registers exceed max limit 1000";
						    	JOptionPane.showMessageDialog(null, errorMsg);
								return;									
							}
							
							ip = comBas.ReadCfgStr(bas_def.REG_SYS_IPADDR);
							st = new StringTokenizer(fileFunction.devType, ",");
							if(st.hasMoreTokens())
								deviceType = st.nextToken();
            			
							if((validateIPAddress(ip) == 0) && (deviceType != null))
							{
								for(i = 0; i < fileFunction.template_qty; i++ )
								{
									if(fileFunction.template_type[i].equals(deviceType))
									{
										foundFile = true;
										break;
									}
								}
								if((foundFile == true) && (fileFunction.unit_qty < 30))
								{
									newFilename = fileFunction.template_filename[i].replace(".csv", fileFunction.unit_instance);
									newFilename = newFilename.concat(".csv");
									newFilename = dirName.concat(newFilename);
									result = fileFunction.modifyUserCSVFile(ip, "root", password, filename, newFilename);
									if(result == 0) // success
									{
										fileFunction.modbusAddr[fileFunction.unit_qty] = comModAddr;
										fileFunction.devInstance[fileFunction.unit_qty] = instance;
										errorMsg = "Copy Device: SUCCESS";
										fileFunction.unit_qty++;
										fileFunction.total_reg_qty += checked_reg;
									}
									else // failure
										errorMsg = "Error: Copy Device failed";
								}
								else
								{
									if(foundFile == false)
										errorMsg = "Error: Can't find file";
									else
										errorMsg = "Error: Max number of device is 30";
								}
							}
							else
								errorMsg = "Error: Can't Modify Settings";
						}
            		} 		
				}
			}
			catch(Exception e)
			{
				errorMsg = "Error: Invalid Modbus Address";							
			}
		}
		else
			errorMsg = "Error: No file selected";			
        // Show status dialog box.
    	JOptionPane.showMessageDialog(null, errorMsg);
    }

    private void readUserFile()
    {
    	String 		objID = null;
        int			i;
        
		// Get object data.
		EbxDeviceName.setText(fileFunction.unit_name);
		EbxModAddr.setText(fileFunction.mod_address);
		EbxDevInst.setText(fileFunction.unit_instance);
		EbxModIP.setText(fileFunction.mod_ip);
	    obj_qty = fileFunction.reg_qty;
	    if(obj_qty > 1000)
	    	obj_qty = 1000;
	    if(obj_qty > 0)
	    	objStatus = new int[obj_qty];
        
		// Loop to get all object instances.
        for (i = 0; i < obj_qty; ++i)
        {
        	// Get object instance.
			objID = fileFunction.registers[i];
			objCheckbox = new JCheckBox(objID + "   " + fileFunction.description[i]);
			// Set combo box selection.
			if(fileFunction.reg_status[i] == 0)
				objCheckbox.setSelected(false);    
			else
				objCheckbox.setSelected(true);
			regPanel.add(objCheckbox, i);
		}
        this.validate();
		this.repaint();
    }

	public void reCalculate()
	{
		if(CbxAutoInst.isSelected() == true)
		{
			int		region = 0;
			int 	instance = 0;
			String	mod;
			String	reg;
			
			EbxDevInst.setEnabled(false);
			EbxRegNumber.setEnabled(true);
			mod = EbxModAddr.getText();
			try
			{
				Integer.parseInt(mod);
				instance = 2450000 + Integer.decode(mod);
			}
			catch(Exception e)
			{
				instance = 2450000;						
	        	//JOptionPane.showMessageDialog(null, "Error: Invalid Device Instance");
			}
			reg = EbxRegNumber.getText();
			try
			{
				Integer.parseInt(reg);
				region = Integer.decode(reg);
			}
			catch(Exception e)
			{
				region = 0;
	        	//JOptionPane.showMessageDialog(null, "Error: Invalid Region Number");
			}
			instance = instance + region * 1000;
			EbxDevInst.setText(Integer.toString(instance));
		}
	}

	private void initComponents()
    {
		setLayout(null);
		setBounds(10, 10, 418, 475);

		final JLabel nameLabel = new JLabel();
		nameLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		nameLabel.setText("Device Name:");
		nameLabel.setBounds(28, 50, 103, 18);
		add(nameLabel);

		EbxDeviceName = new JTextArea();
		EbxDeviceName.setBorder(new BevelBorder(BevelBorder.LOWERED));
		EbxDeviceName.setText("EbxDeviceName");
		EbxDeviceName.setBounds(136, 50, 190, 21);
		add(EbxDeviceName);

		final JLabel modbusAddressLabel = new JLabel();
		modbusAddressLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		modbusAddressLabel.setText("Modbus Address:");
		modbusAddressLabel.setBounds(28, 77, 130, 21);
		add(modbusAddressLabel);

		EbxModAddr = new JTextField();
		EbxModAddr.setBorder(new BevelBorder(BevelBorder.LOWERED));
		EbxModAddr.setText("EbxModbusAddr");
		EbxModAddr.setBounds(164, 77, 40, 21);
		EbxModAddr.getDocument().addDocumentListener(new DocumentListener()
		{

			@Override
			public void changedUpdate(DocumentEvent arg0) 
			{
				// TODO Auto-generated method stub
				// re-calculate 
				reCalculate();
			}

			@Override
			public void insertUpdate(DocumentEvent arg0) 
			{
				// TODO Auto-generated method stub
				reCalculate();
			}

			@Override
			public void removeUpdate(DocumentEvent arg0) 
			{
				// TODO Auto-generated method stub
				reCalculate();
			}
		});
		add(EbxModAddr);

		final JLabel deviceInstanceLabel = new JLabel();
		deviceInstanceLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		deviceInstanceLabel.setText("Device Instance:");
		deviceInstanceLabel.setBounds(28, 155, 120, 21);
		add(deviceInstanceLabel);

		EbxDevInst = new JTextField();
		EbxDevInst.setBorder(new BevelBorder(BevelBorder.LOWERED));
		EbxDevInst.setText("EbxDevInstance");
		EbxDevInst.setBounds(153, 155, 144, 21);
		add(EbxDevInst);

		final JLabel modbusRegistersLabel = new JLabel();
		modbusRegistersLabel.setText("Modbus Registers (Max 1000):");
		modbusRegistersLabel.setBounds(28, 182, 228, 14);
		add(modbusRegistersLabel);

		checkPanel = new JPanel();
		checkPanel.setLayout(null);
		checkPanel.setBorder(new BevelBorder(BevelBorder.LOWERED));
		checkPanel.setBounds(28, 202, 332, 216);
		add(checkPanel);

		scrollPane = new JScrollPane();
		scrollPane.setBounds(0, 0, 332, 216);
		checkPanel.add(scrollPane);

		regPanel = new JPanel();
		regPanel.setBorder(new BevelBorder(BevelBorder.LOWERED));
		regPanel.setLayout(new BoxLayout(regPanel, BoxLayout.Y_AXIS));
		regPanel.setBounds(27, 244, 363, 163);
        scrollPane.setViewportView(regPanel);

        errorLabel = new JLabel();
		errorLabel.setForeground(Color.RED);
		errorLabel.setBounds(28, 417, 298, 18);
		add(errorLabel);

		final JButton submitButton = new JButton();
		submitButton.addActionListener(new ActionListener() 
		{
			public void actionPerformed(final ActionEvent arg0) 
			{
				try 
				{
					writeUserFile();
				} 
				catch (Exception e) 
				{
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		});
		submitButton.setText("Submit");
		submitButton.setBounds(78, 441, 90, 24);
		add(submitButton);

		final JButton cancelButton = new JButton();
		cancelButton.addActionListener(new ActionListener() 
		{
			public void actionPerformed(final ActionEvent arg0)
			{
				int		i;
    			java.awt.Component[] components = regPanel.getComponents();
            	
    			for (i = 0; i < components.length; ++i)
    			{
					regPanel.remove(components[i]);
				}
				cmuFlag.set_exit_copy_panel();
			}
		});
		cancelButton.setText("Back");
		cancelButton.setBounds(234, 441, 90, 24);
		add(cancelButton);   	

		final JLabel modifyDeviceLabel = new JLabel();
		modifyDeviceLabel.setForeground(Color.RED);
		modifyDeviceLabel.setFont(new Font("Sans", Font.BOLD, 20));
		modifyDeviceLabel.setText("Copy Device");
		modifyDeviceLabel.setBounds(28, 10, 168, 23);
		add(modifyDeviceLabel);

		final JLabel modbusIpAddressLabel = new JLabel();
		modbusIpAddressLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		modbusIpAddressLabel.setText("Modbus IP Address:");
		modbusIpAddressLabel.setBounds(28, 106, 144, 14);
		add(modbusIpAddressLabel);

		EbxModIP = new JTextField();
		EbxModIP.setText("EbxModIP");
		EbxModIP.setBorder(new BevelBorder(BevelBorder.LOWERED));
		EbxModIP.setBounds(178, 104, 148, 18);
		add(EbxModIP);

		CbxAutoInst = new JCheckBox();
		CbxAutoInst.setFont(new Font("Sans", Font.PLAIN, 12));
		CbxAutoInst.addActionListener(new ActionListener() 
		{
			public void actionPerformed(final ActionEvent event) 
			{
				if(CbxAutoInst.isSelected() == true)
				{
					int		region = 0;
					int 	instance = 0;
					String	mod;
					String	reg;
					
					EbxDevInst.setEnabled(false);
					EbxRegNumber.setEnabled(true);
					mod = EbxModAddr.getText();
					try
					{
						Integer.parseInt(mod);
						instance = 2450000 + Integer.decode(mod);
					}
					catch(Exception e)
					{
						instance = 2450000;						
			        	//JOptionPane.showMessageDialog(null, "Error: Invalid Device Instance");
					}
					reg = EbxRegNumber.getText();
					try
					{
						Integer.parseInt(reg);
						region = Integer.decode(reg);
					}
					catch(Exception e)
					{
						region = 0;
			        	//JOptionPane.showMessageDialog(null, "Error: Invalid Region Number");
					}
					instance = instance + region * 1000;
					EbxDevInst.setText(Integer.toString(instance));
				}
				else
				{
					EbxDevInst.setEnabled(true);
					EbxRegNumber.setEnabled(false);
				}
			}
		});
		CbxAutoInst.setText("Device Instance Auto");
		CbxAutoInst.setBounds(26, 126, 178, 22);
		add(CbxAutoInst);

		final JLabel regionNumberLabel = new JLabel();
		regionNumberLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		regionNumberLabel.setText("Region Number:");
		regionNumberLabel.setBounds(228, 128, 120, 21);
		add(regionNumberLabel);

		EbxRegNumber = new JTextField();
		EbxRegNumber.setText("0");
		EbxRegNumber.setBorder(new BevelBorder(BevelBorder.LOWERED));
		EbxRegNumber.setBounds(333, 128, 24, 18);
		EbxRegNumber.getDocument().addDocumentListener(new DocumentListener()
		{

			@Override
			public void changedUpdate(DocumentEvent arg0) 
			{
				// TODO Auto-generated method stub
				// re-calculate 
				reCalculate();
			}

			@Override
			public void insertUpdate(DocumentEvent arg0) 
			{
				// TODO Auto-generated method stub
				reCalculate();
			}

			@Override
			public void removeUpdate(DocumentEvent arg0) 
			{
				// TODO Auto-generated method stub
			}
		});
		add(EbxRegNumber);

		final JLabel label = new JLabel();
		label.setFont(new Font("Sans", Font.PLAIN, 12));
		label.setText("(1 to 246)");
		label.setBounds(210, 80, 77, 14);
		add(label);

    }
}

