package MappingCfg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.DefaultListModel;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import modbus.mod;
import modbus.mod_def;
import modbus.mod_dev_t;
import bas_remote.bas_def;

/**
 * Unit data used in listModel for displaying
 * online/offline unit status.
 */
class dev_data
{
	String	modAddr;
    String	instance;
    String	type;
    String	name;
    public String toString()
    {
    	String		local = null;
    	String		tmp = "";
    	int			i;
    	
    	
    	local = modAddr;
    	if(modAddr.length() < 3)
    	{
    		for(i = 0; i < (3 - modAddr.length()); i++)
    			tmp += " ";
    		local = local.concat(tmp);
    		local = local.concat("      ");
    	}
    	else if(modAddr.length() > 4)
    		local = local.concat("  ");   
    	else
    		local = local.concat("      ");       		
    	
    	tmp = "";   	
    	if(instance.length() > 7)
    		local = local.concat(instance.substring(0, 7));
    	else
    	{
    		local = local.concat(instance);
    		for(i = 0; i < (7 - instance.length()); i++)
    			tmp += " ";
    		tmp += " ";
    		local = local.concat(tmp);
    	}
		local = local.concat("   ");
    	
    	tmp = "";    	
    	if(name.length() > 32)
    		local = local.concat(name.substring(0, 32));
    	else
    	{
    		local = local.concat(name);
    		for(i = 0; i < (32 - name.length()); i++)
    			tmp += " ";
    		local = local.concat(tmp);
    	}
		local = local.concat("   ");
    	
    	tmp = "";
    	if(type.length() > 20)
    		local = local.concat(type.substring(0, 20));
    	else
    	{
    		local = local.concat(type);
    		for(i = 0; i < (20 - type.length()); i++)
    			tmp += " ";
    		tmp += " ";
    		local = local.concat(tmp);
    	}
    	return local;
    }
}

public class MappingCfgApplet extends JApplet
{

    private JTextField ebxObjNumber;
    private JTextField ebxDevNumber;
    private String            	hostAddress;
    static boolean           	dbug_on        	= false;
    static String             	dbug_ip        	= "192.168.92.68";
    static int                	dbug_unit      	= 1;
    private mod.device        	comBas         	= new mod.device();
    int							devNumber    	= 0;
    String[]					files;
    private ConnectTask        	connect_task    = new ConnectTask();
    private boolean            	applet_running  = true;
    
    private JPanel 				contentPanel;
    private JPanel 				panel;
    private addPanel			addPanel1;
    private modifyPanel			modifyPanel1;
    private copyPanel			copyPanel1;
    private JPanel 				cfgPanel;
    private devicePanel			devicePanel1;
    private JScrollPane 		scrollPane;
	private JLabel 				errorLabel;
    private DefaultListModel  	listModel;
    private JList				list;
    private JButton 			updateButton 	= new JButton();;
    private JButton 			copyButton 		= new JButton();
    private JButton 			addButton 		= new JButton();
    private JButton 			modifyButton 	= new JButton();
    private JButton 			deleteButton 	= new JButton();

    //
    private boolean            	update_in_process   = false;
    String						password		= "ccsi2431";
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	public MappingCfgApplet() 
	{
		super();
		setSize(547, 490);
        initComponents();
	}

    public void init()
    {
        // Get code base string.
        hostAddress = this.getCodeBase().toString().toLowerCase();
        // If forcing the address.
        if (dbug_on == true)
            hostAddress = dbug_ip;
        // Else if executing from local machine.
        else if (hostAddress.startsWith("file"))
            hostAddress = "localhost";
        // Else for real.
        else
        {
            hostAddress = hostAddress.replace("http://", " ");
            hostAddress = hostAddress.replace("/", " ").trim();
        }
        // Connect with host.
        comBas.Connect(hostAddress, mod_dev_t.PORT_TCP, mod_def.PROT_TCP);
        if (!comBas.IsConnected())
        {
            errorLabel.setText("Cannot connect to target");
            errorLabel.setVisible(true);
        }

        cmuFlag.init();
        fileFunction.init();
        
        // If we're connected.
        if (comBas.IsConnected())
        {
        	GetDeviceData();
            GetTemplateInfo();
        	updateButton.setEnabled(true);        	
            copyButton.setEnabled(true);
            addButton.setEnabled(true);
            modifyButton.setEnabled(true);
            deleteButton.setEnabled(true);
        }
        else
        {
            // Disable update button.
        	updateButton.setEnabled(false);        	
            copyButton.setEnabled(false);
            addButton.setEnabled(false);
            modifyButton.setEnabled(false);
            deleteButton.setEnabled(false);
        }
        
        // Start connect task.
        connect_task.execute();
    }

    public void destroy()
    {
        comBas.Disconnect();
        applet_running = false;
    }
    
    private void GetTemplateInfo()
    {
        int			tmp_qty = 0;
        int			i;
        // Return if not connected.
        if (!comBas.IsConnected())
            return;
        // Use try/catch.
        try
        {
            // Get the number of units.
            tmp_qty = comBas.ReadCfgInt(bas_def.TEMPLATE_QTY);
        	fileFunction.template_qty = tmp_qty;
            fileFunction.template_filename = new String[tmp_qty];
            fileFunction.template_type = new String[tmp_qty];
            for(i = 0; i < tmp_qty; i++)
            {
                // Write unit index.
                comBas.WriteCfg(bas_def.TEMPLATE_INDEX, i);
                fileFunction.template_filename[i] = comBas.ReadCfgStr(bas_def.TEMPLATE_FILE_NAME);
                fileFunction.template_type[i] = comBas.ReadCfgStr(bas_def.TEMPLATE_FILE_TYPE);
            }
        } 
        catch (IOException e)
        {
            ProcessError(e.getMessage());
        }
    }
    /**
     * This thread operates in the background to try and re-establish the link
     * with the host should it be broken.
     * 
     * @author rcw
     * 
     */
    public class ConnectTask extends SwingWorker<Void, Void>
    {
        public Void doInBackground()
        {
            while (applet_running)
            {
            	if(cmuFlag.is_exit_add_panel_select() == true)
            	{
            		cmuFlag.clear_exit_add_panel();
                    panel.removeAll();
                    //panel.remove(addPanel1);
                    panel.add(scrollPane , BorderLayout.CENTER);
                    panel.validate();
                    panel.repaint();
            	}
            	else if(cmuFlag.is_exit_modify_panel_select() == true)
            	{
            		cmuFlag.clear_exit_modify_panel();
                    panel.removeAll();
                    //panel.remove(modifyPanel1);
                    panel.add(scrollPane , BorderLayout.CENTER);
                    panel.validate();
                    panel.repaint();
            	}
            	else if(cmuFlag.is_exit_copy_panel_select() == true)
            	{
            		cmuFlag.clear_exit_copy_panel();
                    panel.removeAll();
                    //panel.remove(copyPanel1);
                    panel.add(scrollPane , BorderLayout.CENTER);
                    panel.validate();
                    panel.repaint();
            	}
            	else if(cmuFlag.is_exit_device_panel_select() == true)
            	{
            		cmuFlag.clear_exit_device_panel();
                    panel.removeAll();
                    //panel.remove(devicePanel1);
                    panel.add(scrollPane , BorderLayout.CENTER);
                    panel.validate();
                    panel.repaint();
            	}
            	
                try
                {
                    Thread.sleep(300);
                } catch (InterruptedException e)
                {
                }
            }
            return null;
        }
    }

    private void GetDeviceData()
    {
        int			dev_qty = 0;
        int			i;
        dev_data 	dd;
        String		tmp;
        
        // Return if not connected.
        if (!comBas.IsConnected())
            return;
        // Use try/catch.
        try
        {
            // Get the number of units.
            dev_qty = comBas.ReadCfgInt(bas_def.REG_UNIT_QTY);
            
            if(dev_qty < 0)
            	return;
            
            if(dev_qty > 30)
            	dev_qty = 30;
            
            fileFunction.unit_qty = dev_qty;    
            ebxDevNumber.setText(Integer.toString(dev_qty));
            tmp = comBas.ReadCfgStr(bas_def.REG_OBJ_QTY);
            ebxObjNumber.setText(tmp);
            fileFunction.total_reg_qty = Integer.valueOf(tmp);
            	
            if(dev_qty > 0)
            {
                // clear listbox
                listModel.clear();
                files = new String[dev_qty];            	
            }
            for(i = 0; i < dev_qty; i++)
            {
            	dd = new dev_data();
                // Write unit index.
                comBas.WriteCfg(bas_def.REG_UNIT_IDX, i);
				files[i] = comBas.ReadCfgStr(bas_def.REG_UNIT_FILENAME);
				dd.modAddr = comBas.ReadCfgStr(bas_def.REG_UNIT_ADDR);
				dd.modAddr = dd.modAddr.replace(':', '/');
				fileFunction.modbusAddr[i] = dd.modAddr;
                dd.instance = comBas.ReadCfgStr(bas_def.REG_UNIT_INSTANCE);
                fileFunction.devInstance[i] = Integer.valueOf(dd.instance);
                dd.type = comBas.ReadCfgStr(bas_def.REG_UNIT_MOD_TYPE);
            	dd.name = comBas.ReadCfgStr(bas_def.REG_UNIT_NAME);
                // Add element to list model.
                listModel.addElement(dd);    	
            }
        } 
        catch (IOException e)
        {
            ProcessError(e.getMessage());
        }
    }
    
    public void ProcessError( String text )
    {
        mod.err e = mod.err.getObj(text);

        switch (e)
        {
            // We ignore ILLEGAL errors here.
            case ILLEGAL_DATA_ADDRESS:
            case ILLEGAL_FUNCTION:
            case ILLEGAL_DATA_VALUE:
            case ILLEGAL_OBJECT_INSTANCE:
                break;
            default:
                comBas.Disconnect();
                break;
        }
        errorLabel.setText(text);
        errorLabel.setVisible(true);
    }

    private void updateCfg()
    {
        // Ignore this if already updating.
        if ( update_in_process )
            return;
        
        // Set flag. We'll reset this flag at the end of the update,
        // or whenever an error condition is cleared.
        update_in_process = true;
        errorLabel.setText("");

        // Use try/catch.
        try
        {
            // Take unit offline; error if we can't.
            comBas.WriteCfg(bas_def.REG_SYS_OFFLINE, "1");

            // Extend timeout for this operation, then reset to default value.
            comBas.SetTimeout(15000);
            comBas.WriteCfg(bas_def.REG_SYS_FCN, bas_def.FCN_COMMIT);
            comBas.SetTimeout(-1);
            // Clear flag.
            update_in_process = false;
            listModel.clear();
            GetDeviceData();
        } catch (IOException e)
        {
            ProcessError(e.getMessage());
        }
    }
    
    // initialize components
    private void initComponents()
    {
        contentPanel = new JPanel();
        contentPanel.setLayout(null);
        setContentPane(contentPanel);
		
        panel = new JPanel(); // 
		panel.setLayout(null);
		panel.setBounds(10, 10, 527, 480);
		contentPanel.add(panel);  
		
		scrollPane = new JScrollPane();
		scrollPane.setBounds(0, 0, 527, 480);
        panel.add(scrollPane);

		cfgPanel = new JPanel();
		cfgPanel.setLayout(null);
		cfgPanel.setBounds(10, 10, 409, 441);
        scrollPane.setViewportView(cfgPanel);

		final JLabel configuredDevicesLabel = new JLabel();
		configuredDevicesLabel.setForeground(Color.RED);
		configuredDevicesLabel.setFont(new Font("Sans", Font.BOLD, 20));
		configuredDevicesLabel.setText("Configured Devices (Max 30):");
		configuredDevicesLabel.setBounds(10, 0, 341, 23);
		cfgPanel.add(configuredDevicesLabel);

		final JLabel instanceLabel = new JLabel();
		instanceLabel.setFont(new Font("Sans", Font.BOLD, 12));
		instanceLabel.setText("Instance");
		instanceLabel.setBounds(80, 53, 70, 14);
		cfgPanel.add(instanceLabel);

		final JLabel nameLabel = new JLabel();
		nameLabel.setFont(new Font("Sans", Font.BOLD, 12));
		nameLabel.setText("Name");
		nameLabel.setBounds(210, 53, 51, 14);
		cfgPanel.add(nameLabel);

		final JLabel typeLabel = new JLabel();
		typeLabel.setFont(new Font("Sans", Font.BOLD, 12));
		typeLabel.setText("Type");
		typeLabel.setBounds(433, 53, 42, 14);
		cfgPanel.add(typeLabel);

		errorLabel = new JLabel();
		errorLabel.setForeground(Color.RED);
		errorLabel.setBounds(10, 385, 341, 14);
		cfgPanel.add(errorLabel);

		listModel = new DefaultListModel();
        list = new JList(listModel);
        list.setFont(new Font("Courier", Font.BOLD, 12));
        list.addMouseListener(new MouseAdapter()
        {
        	public void mouseClicked(MouseEvent evt)
        	{
				String		filename = null, ip = null;
        		JList 		list1 = (JList)evt.getSource();
        		int			index = 0;
        		int			m_cnt;
        		
        		m_cnt = evt.getClickCount();
        		if(m_cnt >= 2)
        		{
        			index = list1.locationToIndex(evt.getPoint());
					filename = files[index];
					if(filename != null)
					{
				        // Return if not connected.
				        if (!comBas.IsConnected())
				        {
				            errorLabel.setText("Error: Can't connect to target");
				            return;
				        }
				    	
				    	try {
							ip = comBas.ReadCfgStr(bas_def.REG_SYS_IPADDR);
						} catch (IOException e) {
							// TODO Auto-generated catch block
							ip = null;
							e.printStackTrace();
				            errorLabel.setText("Error: Can't connect to target");
							return;
						}
				    	fileFunction.getUserCSVFile(ip , "root" , password , filename );
				       	devicePanel1 = new devicePanel();
				        devicePanel1.comBas = comBas;
				        devicePanel1.filename = filename;
		                panel.remove(scrollPane);
		                panel.add(devicePanel1 , BorderLayout.CENTER);
		                panel.validate();
		                panel.repaint();
					}
        		}
        	}
        });
		
		final JScrollPane scrollPane_1 = new JScrollPane(list);
		scrollPane_1.setBounds(10, 73, 507, 306);
		cfgPanel.add(scrollPane_1);
		
		addButton.addActionListener(new ActionListener() 
		{
			public void actionPerformed(final ActionEvent arg0) 
			{
				addPanel1 = new addPanel();
                panel.remove(scrollPane);
                addPanel1.comBas = comBas;
                panel.add(addPanel1 , BorderLayout.CENTER);
                panel.validate();
                panel.repaint();
			}
		});
		addButton.setText("Add");
		addButton.setBounds(26, 412, 70, 24);
		cfgPanel.add(addButton);

		deleteButton.addActionListener(new ActionListener() 
		{
			public void actionPerformed(final ActionEvent arg0) 
			{
				String	filename;
				int		i;
				
				int	index = list.getSelectedIndex();
				String	ip = null;
				
				errorLabel.setText("");
				if(index < 0)
				{
					errorLabel.setText("Error: must select a device to delete");
					return;
				}
		    	try 
		    	{
					ip = comBas.ReadCfgStr(bas_def.REG_SYS_IPADDR);
				} 
		    	catch (IOException e) 
		    	{
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
		    	if(ip == null)
		    		return;
		    	
				filename = files[index];
				if(filename == null)
					return;
				if(fileFunction.delFile(ip, "root", password, filename) == true)
				{
					if(fileFunction.unit_qty > 0)
					{
						for(i = index; i < (fileFunction.unit_qty - 1); i++)
						{
							fileFunction.modbusAddr[i] = fileFunction.modbusAddr[i + 1];
							fileFunction.devInstance[i] = fileFunction.devInstance[i + 1];
							files[i] = files[i + 1];
						}
						fileFunction.unit_qty--;
					}
					listModel.remove(index);
				}
			    else
			    	errorLabel.setText("Error: can't delete selected device");
			}
		});
		deleteButton.setText("Delete");
		deleteButton.setBounds(363, 412, 82, 24);
		cfgPanel.add(deleteButton);

		modifyButton.addActionListener(new ActionListener() 
		{
			public void actionPerformed(final ActionEvent arg0) 
			{
				String	filename = null, ip = null;
				int		index = list.getSelectedIndex();

				if(index < 0)
				{
					errorLabel.setText("Error: must select a device to modify");
					return;
				}
				
				filename = files[index];
				if(filename != null)
				{
					// Return if not connected.
					if (!comBas.IsConnected())
					{
						errorLabel.setText("Error: Can't connect to target");
						return;
					}
				    	
					try 
					{
						ip = comBas.ReadCfgStr(bas_def.REG_SYS_IPADDR);
					} 
					catch (IOException e) 
					{
						// TODO Auto-generated catch block
						ip = null;
						e.printStackTrace();
				        errorLabel.setText("Error: Can't connect to target");
						return;
					}
				    if(fileFunction.getUserCSVFile(ip , "root" , password , filename ) == 0)
				    {
				    	fileFunction.unit_index = index;
				    	modifyPanel1 = new modifyPanel();
				    	modifyPanel1.comBas = comBas;
				    	modifyPanel1.filename = filename;
				    	panel.remove(scrollPane);
				    	panel.add(modifyPanel1 , BorderLayout.CENTER);
				    	panel.validate();
				    	panel.repaint();
				    }
				    else
				    	errorLabel.setText("Error: can't open selected device");
				}
			}
		});
		modifyButton.setText("Modify");
		modifyButton.setBounds(230, 412, 88, 24);
		cfgPanel.add(modifyButton);

		copyButton.addActionListener(new ActionListener() 
		{
			public void actionPerformed(final ActionEvent arg0) 
			{
				String	filename = null, ip = null;
				int	index = list.getSelectedIndex();
				
				if(index < 0)
				{
					errorLabel.setText("Error: must select a device to copy");
					return;
				}
				filename = files[index];
				if(filename != null)
				{
					// Return if not connected.
					if (!comBas.IsConnected())
					{
						errorLabel.setText("Error: Can't connect to target");
				        return;
					}
				    	
					try 
					{
						ip = comBas.ReadCfgStr(bas_def.REG_SYS_IPADDR);
					} 
					catch (IOException e) 
					{
						// TODO Auto-generated catch block
						ip = null;
						e.printStackTrace();
						errorLabel.setText("Error: Can't connect to target");
						return;
					}
				    
					if(fileFunction.getUserCSVFile(ip , "root" , password , filename ) == 0)
					{
						copyPanel1 = new copyPanel();
						copyPanel1.comBas = comBas;
						copyPanel1.filename = filename;
						panel.remove(scrollPane);
						panel.add(copyPanel1 , BorderLayout.CENTER);
						panel.validate();
						panel.repaint();
					}
					else
				    	errorLabel.setText("Error: can't open selected device");
				}
			}
		});
		copyButton.setText("Copy");
		copyButton.setBounds(130, 412, 70, 24);
		cfgPanel.add(copyButton);
		
		updateButton.addActionListener(new ActionListener() 
		{
			public void actionPerformed(final ActionEvent arg0) 
			{
			    updateCfg();
			}
		});
		updateButton.setText("Refresh");
		updateButton.setBounds(26, 442, 107, 24);
		cfgPanel.add(updateButton);

		final JLabel modbusLabel = new JLabel();
		modbusLabel.setText("Modbus");
		modbusLabel.setBounds(10, 39, 64, 14);
		cfgPanel.add(modbusLabel);

		final JLabel addressLabel = new JLabel();
		addressLabel.setText("Address");
		addressLabel.setBounds(10, 53, 64, 14);
		cfgPanel.add(addressLabel);

		final JLabel afterAnyChangeLabel = new JLabel();
		afterAnyChangeLabel.setForeground(Color.BLUE);
		afterAnyChangeLabel.setText("To view changes press Refresh");
		afterAnyChangeLabel.setBounds(140, 447, 296, 14);
		cfgPanel.add(afterAnyChangeLabel);

		ebxDevNumber = new JTextField();
		ebxDevNumber.setBorder(new EmptyBorder(0, 0, 0, 0));
		ebxDevNumber.setFont(new Font("Sans", Font.PLAIN, 12));
		ebxDevNumber.setBounds(363, 5, 31, 18);
		ebxDevNumber.setEditable(false);
		cfgPanel.add(ebxDevNumber);

		final JLabel mappedObjectsLabel = new JLabel();
		mappedObjectsLabel.setText("Mapped Objects (Max 1000):");
		mappedObjectsLabel.setBounds(138, 29, 213, 14);
		cfgPanel.add(mappedObjectsLabel);

		ebxObjNumber = new JTextField();
		ebxObjNumber.setBorder(new EmptyBorder(0, 0, 0, 0));
		ebxObjNumber.setBounds(363, 29, 58, 18);
		ebxObjNumber.setEditable(false);
		cfgPanel.add(ebxObjNumber);
    }
}

