/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package modbus;

//
import java.net.*;
import java.io.*;

import bas_remote.bas_def;

/**
 * @author rcw
 *
 */
public class mod_dev_t
{
	// Connection ports.
	public final static int  PORT_DF1    = 5001;
    public final static int  PORT_TCP    = 502;
//  public final static int  PORT_TCP    = 5001;        // _DBUG: For testing on PC.
	public final static int  PORT_RCLI   = 5003;
	//
	// Timeouts.
	//
	public final static int  TIMEOUT_CONNECT   = 3000; // 3 sec.
	public final static int  TIMEOUT_RX        = 7000; // 7 sec.
	//
	// Modbus variables.
	//
	public final static byte SKT_BIT     = 0x01;
	public final static byte DIS_BIT     = 0x02;
	public final static byte DOS_BIT     = 0x04;
	//
	private Socket           skt;
	private byte             m_flags     = 0;
	//
	public InputStream       dis;
	public OutputStream      dos;
	//
	public mod_ex            mex;
	public mod_rxtx          mxt;
	//
	public boolean           m_connected = false;
	public byte              m_error     = 0;

	public boolean IsConnected()
	{
	    return m_connected;
	}
	/**
	 * Closes data input stream, data output stream, and socket.
	 */
	public void Disconnect()
	{
		// If data input stream.
		if ((m_flags & DIS_BIT) != 0)
		{
			// Clear bit.
			m_flags &= ~DIS_BIT;
			// Close input stream.
			try
			{
				dis.close();
			}
			catch (IOException e)
			{}
		}
		// If data output stream.
		if ((m_flags & DOS_BIT) != 0)
		{
			// Clear bit.
			m_flags &= ~DOS_BIT;
			// Close output stream.
			try
			{
				dos.close();
			}
			catch (IOException e)
			{}
		}
		// If socket.
		if ((m_flags & SKT_BIT) != 0)
		{
			// Clear bit.
			m_flags &= ~SKT_BIT;
			// Close socket.
			try
			{
				skt.close();
			}
			catch (IOException e)
			{}
		}
		// Clear flag.
		m_connected = false;
	}

	/**
	 * Connect to the target and setup to use the specified protocol.
	 * 
	 * @param DottedIpAddress = IP Address of target.
	 * @param port = Host port number.
	 * @param protocol = mod_def.PROT_XXX protocol.
	 * @return = 0 if success, -1 otherwise.
	 */
	public int Connect(String DottedIpAddress, int port , int protocol )
	{
		InetSocketAddress addr;

		// Create our socket and set flag.
		skt = new Socket();
		m_flags |= SKT_BIT;

		// Bind to a local ephemeral port.
		try
		{
			skt.bind(null);
		}
		catch (IOException e)
		{
			Disconnect();
			return -1;
		}

		// Get socket address.
		addr = new InetSocketAddress(DottedIpAddress, port);

		// If port is unresolved.
		if (addr.isUnresolved())
			return -1;

		// Connect with timeout.
		try
		{
			skt.connect(addr, TIMEOUT_CONNECT);
		}
		catch (IOException e)
		{
			Disconnect();
			return -1;
		}

		// Putting in a timeout because the receive loop could hang
		// waiting for a character.
		try
		{
			skt.setSoTimeout(TIMEOUT_RX);
		}
		catch (IOException e)
		{
			Disconnect();
			return -1;
		}

		// Get stream for output.
		try
		{
			dos = skt.getOutputStream();
		}
		catch (IOException e)
		{
			Disconnect();
			return -1;
		}
		// Set flag bit.
		m_flags |= DOS_BIT;

		// Get stream for input.
		try
		{
			dis = skt.getInputStream();
		}
		catch (IOException e)
		{
			Disconnect();
			return -1;
		}
		// Set flag bit.
		m_flags |= DIS_BIT;

        // Create our modbus exchange objects.
        mex = new mod_ex();
        mxt = new mod_rxtx(dis, dos);
        // Assign protocol.
        mxt.SetProtocol((byte) protocol);
        
		// Set the flag.
		m_connected = true;

		// And return.
		return 0;
	}

	//
	// -------------------------------------------------------------------------
	//
	public int SetTimeout(int msTimeout)
	{
		try
		{
			skt.setSoTimeout(msTimeout);
		}
		catch (IOException e)
		{
			Disconnect();
			return -1;
		}
		return 0;
	}

	//
	// -------------------------------------------------------------------------
	//
	public void SetProtocol(int protocol)
	{
		switch (protocol)
		{
			case mod_def.PROT_DF1:
			case mod_def.PROT_TCP:
				mxt.SetProtocol((byte) protocol);
				break;
			default:
				break;
		}
	}

	//
	// -------------------------------------------------------------------------
	//
	public int GetProtocol()
	{
		return mxt.GetProtocol();
	}

	//
	// -------------------------------------------------------------------------
	/**
	 * Returns mod_def.ErrStr[mex.b[0]].
	 */
	public String GetError()
	{
	    int        err_idx = mex.b[0] & 0x0ff;
	    
	    if ( err_idx <= mod_def.ErrStr.length )
	        return mod_def.ErrStr[ err_idx] ;
	    else
	        return "UNKOWN ERROR CODE";
	}

	//
	// -------------------------------------------------------------------------
	/**
	 * Reads an unsigned 16-bit value. Can be used with any Modbus device.
	 * Returns the 16-bit value as an integer if success, -1 otherwise. Member
	 * 'm_error' is set to 0 if success, Modbus error code if problem.
	 * 
	 * @param slave = Modbus slave address.
	 * @param reg = Register number.
	 * @return = Unsigned 16-bit value if success, -1 otherwise.
	 */
	public int ReadReg16(int slave, int reg)
	{
		mex.slv_adr = (byte) slave;
		mex.fcn = (byte) mod_def.READ_HOLDING_REGISTERS;
		mex.itm_adr = (short) reg;
		mex.itm_qty = 1;
		if (mxt.MasterTx(mex) != 0)
		{
			m_error = mex.b[0];
			return -1;
		}
		else
		{
			m_error = 0;
			return mex.w[0] & 0x0000ffff;
		}
	}

	//
	// -------------------------------------------------------------------------
	/**
	 * Writes an unsiged 16-bit value. Can be used with any Modbus device.
	 * Returns 0 if success, -1 otherwise. Member 'm_error' is set to 0 if
	 * success, Modbus error code if problem.
	 * 
	 * @param slave= Modbus slave address.
	 * @param reg = Register number.
	 * @param value = 16-bit value to write.
	 * @return
	 */
	public int WriteReg16(int slave, int reg, int value)
	{
		mex.slv_adr = (byte) slave;
		mex.fcn = (byte) mod_def.WRITE_MULTIPLE_REGISTERS;
		mex.itm_adr = (short) reg;
		mex.itm_qty = 1;
		mex.w[0] = (short) value;
		return mxt.MasterTx(mex);
	}

	//
	// -------------------------------------------------------------------------
	/**
	 * Writes an array of unsiged 16-bit values. Can be used with any Modbus device.
	 * Returns 0 if success, -1 otherwise. Member 'm_error' is set to 0 if
	 * success, Modbus error code if problem.
	 * 
	 * @param slave= Modbus slave address.
	 * @param reg = Register number.
	 * @param value = 16-bit value to write.
	 * @return
	 */
	public int WriteReg16(int slave, int reg, int value[])
	{
		int				i;
		
		mex.slv_adr = (byte) slave;
		mex.fcn = (byte) mod_def.WRITE_MULTIPLE_REGISTERS;
		mex.itm_adr = (short) reg;
		mex.itm_qty = (short)value.length;
		for ( i = 0 ; i < mex.itm_qty ; ++i )
		{
			mex.w[i] = (short)value[i];
		}
		return mxt.MasterTx(mex);
	}
	//
	// -------------------------------------------------------------------------
	/**
	 * Reads an unsigned 16-bit value. Used to read indexed channel registers in
	 * BAS Remote units only. Returns the 16-bit value as an integer if success,
	 * -1 otherwise. Member 'm_error' is set to 0 if success, Modbus error code
	 * if problem.
	 * 
	 * @param slave = Modbus slave address.
	 * @param reg = Indexed register number.
	 * @param chn = Channel number (0-based).
	 * @return = Unsigned 16-bit value if success, -1 otherwise.
	 */
	public int ReadReg16(int slave, int reg, int chn)
	{
		mex.slv_adr = (byte) slave;
		mex.fcn = (byte) mod_def.READ_HOLDING_REGISTERS;
		mex.itm_adr = (short) mex.RegIdx(chn, reg);
		mex.itm_qty = 1;
		if (mxt.MasterTx(mex) != 0)
		{
			m_error = mex.b[0];
			return -1;
		}
		else
		{
			m_error = 0;
			return mex.w[0] & 0x0000ffff;
		}
	}

	//
	// -------------------------------------------------------------------------
	/**
	 * Writes an unsigned 16-bit value. Used to write indexed channel registers
	 * in BAS Remote units only. Returns 0 if success, -1 otherwise. Member
	 * 'm_error' is set to 0 if success, Modbus error code if problem.
	 * 
	 * @param slave = Modbus slave address.
	 * @param reg = Indexed register number.
	 * @param value = 16-bit value to write.
	 * @param chn = Channel number (0-based).
	 * @return = 0 if success, -1 otherwise.
	 */
	public int WriteReg16(int slave, int reg, int value, int chn)
	{
		mex.slv_adr = (byte) slave;
		mex.fcn = (byte) mod_def.WRITE_MULTIPLE_REGISTERS;
		mex.itm_adr = (short) mex.RegIdx(chn, reg);
		mex.itm_qty = 1;
		mex.w[0] = (short) value;
		return mxt.MasterTx(mex);
	}

	//
	// -------------------------------------------------------------------------
	/**
	 * Reads or writes two consecutive registers. For reads, the return values
	 * are left in mex.w[0:1]. For writes, values must be pre-loaded into
	 * mex.w[0:1].
	 * 
	 * @param slave = Modbus slave address.
	 * @param reg = First register number (1-based).
	 * @param write = true if write operation.
	 * @return 0=success , -1=failure; return code in mex.b[0].
	 */
	public int RegPair(int slave, int reg, boolean write)
	{
		mex.slv_adr = (byte) slave;
		if (write)
			mex.fcn = (byte) mod_def.WRITE_MULTIPLE_REGISTERS;
		else
			mex.fcn = (byte) mod_def.READ_HOLDING_REGISTERS;
		mex.itm_adr = (short) reg;
		mex.itm_qty = 2;
		return mxt.MasterTx(mex);
	}

	//
	// -------------------------------------------------------------------------

	/**
	 * @param slave
	 * @param reg
	 * @param rp
	 * @return
	 */
	public int ReadRegPair(int slave, int reg, modbus.reg_pair_t rp)
	{
		int val;

		if (RegPair(slave, reg, false) != 0)
			return -1;
		if (rp.big_endian)
		{
			val = mex.w[0] & 0x0000ffff;
			val <<= 16;
			val |= mex.w[1] & 0x0000ffff;
		}
		else
		{
			val = mex.w[1] & 0x0000ffff;
			val <<= 16;
			val |= mex.w[0] & 0x0000ffff;
		}
		if ( rp.float_op )
		    rp.f = Float.intBitsToFloat(val);
		else
		    rp.i = val;
		return 0;
	}

	public int WriteRegPair(int slave, int reg, modbus.reg_pair_t rp)
	{
		int val;

		if (rp.float_op)
			val = Float.floatToRawIntBits(rp.f);
		else
			val = rp.i;
		if (rp.big_endian)
		{
			mex.w[0] = (short) (val >> 16);
			mex.w[1] = (short) val;
		}
		else
		{
			mex.w[0] = (short) val;
			mex.w[1] = (short) (val >> 16);
		}
		return RegPair(slave, reg, true);
	}

	//
	// -------------------------------------------------------------------------
	//
	public int ReadInp(int slave , int reg)
	{
        mex.slv_adr = (byte) slave;
        mex.fcn = (byte) mod_def.READ_DISCRETE_INPUTS;
        mex.itm_adr = (short) reg;
        mex.itm_qty = 1;
        if (mxt.MasterTx(mex) == 0)
        {
            if ((mex.b[0] & 1) > 0)
            {
                return 1;
            }
            else
            {
                return 0;
            }
        }
        else
        {
            return -1;
        }
	}

    //
    // -------------------------------------------------------------------------
    //
	public int ReadCoil(int slave, int reg)
	{
		mex.slv_adr = (byte) slave;
		mex.fcn = (byte) mod_def.READ_COILS;
		mex.itm_adr = (short) reg;
		mex.itm_qty = 1;
		if (mxt.MasterTx(mex) == 0)
		{
			if (mex.b[0] > 0)
			{
				return 1;
			}
			else
			{
				return 0;
			}
		}
		else
		{
			return -1;
		}
	}

	public int WriteCoil(int slave, int reg, int value)
    {
    	mex.slv_adr = (byte) slave;
    	mex.fcn = (byte) mod_def.WRITE_SINGLE_COIL;
    	mex.itm_adr = (short) reg;
    	mex.itm_qty = 1;
    	if (value != 0)
    	{
    		mex.b[0] = 1;
    	}
    	else
    	{
    		mex.b[0] = 0;
    	}
    	return mxt.MasterTx(mex);
    }

	//
	// -------------------------------------------------------------------------
	//
	public String ReadBasReg(int slave, int reg)
	{
		mex.slv_adr = (byte) slave;
		mex.fcn = (byte) mod_def.RD_REGS_STR;
		mex.itm_adr = (short) reg;
		mex.itm_qty = 1;
		if (mxt.MasterTx(mex) == 0)
		{
			return mex.s[0];
		}
		else
		{
			return "ERROR: " + GetError();
		}
	}

	//
	// -------------------------------------------------------------------------
	//
	public String WriteBasReg(int slave, int reg, String val)
	{
		mex.slv_adr = (byte) slave;
		mex.fcn = (byte) mod_def.WR_REGS_STR;
		mex.itm_adr = (short) reg;
		mex.itm_qty = 1;
		mex.s[0] = val;
		if (mxt.MasterTx(mex) == 0)
		{
			return "SUCCESS";
		}
		else
		{
			return "ERROR: " + GetError();
		}
	}
    //
    //-------------------------------------------------------------------------
    //
    // Here to read a single string value.
    // Returns string if success, "ERROR" if failure.
    //
    public String ReadCfgStr( int reg )
    {
        mex.slv_adr = (byte)bas_def.CONFIG_ADDRESS;
        mex.fcn = (byte)mod_def.RD_REGS_STR;
        mex.itm_adr = (short)reg;
        mex.itm_qty = 1;
        if ( mxt.MasterTx( mex ) == 0 )
            return mex.s[0];
        else
            return "ERROR: " + GetError();
    }
    //
    //-------------------------------------------------------------------------
    //
    // Here to read a single string value.
    // Returns string if success, "ERROR" if failure.
    //
    public int ReadCfgInt( int reg )
    {
        mex.slv_adr = (byte)bas_def.CONFIG_ADDRESS;
        mex.fcn = (byte)mod_def.RD_REGS_STR;
        mex.itm_adr = (short)reg;
        mex.itm_qty = 1;
        if ( mxt.MasterTx( mex ) == 0 )
            return Integer.decode(mex.s[0]);
        else
            return -1;
    }
    //
    //-------------------------------------------------------------------------
    //
    // Here to write a string value.
    // Returns 0 if success, -1 if failure.
    //
    public int WriteCfgStr( int reg , String val )
    {
        mex.slv_adr = (byte)bas_def.CONFIG_ADDRESS;
        mex.fcn = (byte)mod_def.WR_REGS_STR;
        mex.itm_adr = (short)reg;
        mex.itm_qty = 1;
        mex.s[0] = val;
        return mxt.MasterTx( mex );
    }
    //
    //-------------------------------------------------------------------------
    //
    // Here to write a string value.
    // Returns 0 if success, -1 if failure.
    //
    public int WriteCfgInt( int reg , int val )
    {
        mex.slv_adr = (byte)bas_def.CONFIG_ADDRESS;
        mex.fcn = (byte)mod_def.WR_REGS_STR;
        mex.itm_adr = (short)reg;
        mex.itm_qty = 1;
        mex.s[0] = Integer.toString( val );
        return mxt.MasterTx( mex );
    }
    //
    //-------------------------------------------------------------------------
    //
    /**
     * Here to write a single object parameter.
     * 
     * @param obj = index flag, instance, property, String value.
     * @return    = 0 if success, Modbus error code otherwise.
     */
    public int ReadObj( obj_param_t obj )
    {
        mex.slv_adr = (byte)255;
        mex.fcn = (byte)mod_def.RD_OBJ;
        if ( obj.index == true )
            mex.itm_adr = (short)0x8001;
        else
            mex.itm_adr = 1;
        mex.itm_qty = 1;
        mex.l[0] = obj.instance;
        mex.w[0] = (short)obj.property;
        if ( mxt.MasterTx( mex ) == 0 )
        {
            obj.value = mex.s[0];
            return 0;
        }
        else
        {
            return mex.b[0] & 0x0ff;
        }
    }
    //
    //-------------------------------------------------------------------------
    //
    /**
     * Here to write a single object parameter.
     * 
     * @param obj = index flag, instance, property, String value.
     * @return    = 0 if success, Modbus error code otherwise.
     */
    public int WriteObj( obj_param_t obj )
    {
        mex.slv_adr = (byte)255;
        mex.fcn = (byte)mod_def.WR_OBJ;
        if ( obj.index == true )
            mex.itm_adr = (short)0x8001;
        else
            mex.itm_adr = 1;
        mex.itm_qty = 1;
        mex.l[0] = obj.instance;
        mex.w[0] = (short)obj.property;
        mex.s[0] = obj.value;
        if ( mxt.MasterTx( mex ) == 0 )
            return 0;
        else
        {
            return mex.b[0] & 0x0ff;
        }
    }
}
