//
// Copyright (c) 2008 Tridium, Inc.
// Licensed under the Academic Free License version 3.0
//
// History:
//   11 Jun 08  Brian Frank  Creation
//

package sedona;

import java.io.*;
import sedona.util.*;

/**
 * Constants for the Sedona environment
 */
public interface Constants
{

////////////////////////////////////////////////////////////////
// Type Constants (defined in Type.sedona)
////////////////////////////////////////////////////////////////

  // these type ids must match those generated by the compiler
  // and used by the vm to identify primitive types

  public static final int voidId   = 0;
  public static final int boolId   = 1;
  public static final int byteId   = 2;
  public static final int shortId  = 3;
  public static final int intId    = 4;
  public static final int longId   = 5;
  public static final int floatId  = 6;
  public static final int doubleId = 7;
  public static final int bufId    = 8;    // predefined but not primitive
  public static final int strId    = 101;  // not a real prop value type (facet/Buf)
                                
////////////////////////////////////////////////////////////////
// User Security (defined in User.sedona)
////////////////////////////////////////////////////////////////
                                
  public static final int or = 0x01;        // operator read
  public static final int ow = 0x02;        // operator write
  public static final int oi = 0x04;        // operator invoke
  public static final int ar = 0x08;        // admin read
  public static final int aw = 0x10;        // admin write
  public static final int ai = 0x20;        // admin invoke
  public static final int ua = 0x40;        // user admin

  public static final int provApp  = 0x01;  // permission to provision app.sab
  public static final int provKits = 0x02;  // permission to provision kits.scode
  public static final int provSvm  = 0x04;  // permission to provision svm native image


}

