/*
 * Decompiled with CFR 0.152.
 */
package sedona.sox;

import java.util.ArrayList;
import sedona.Kit;
import sedona.Link;
import sedona.Schema;
import sedona.Slot;
import sedona.Type;
import sedona.Value;
import sedona.sox.Msg;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;
import sedona.sox.VersionInfo;

public class SoxUtil {
    private SoxClient client;
    Schema schema;
    VersionInfo version;

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public VersionInfo getVersion() {
        return this.version;
    }

    public void setVersion(VersionInfo versionInfo) {
        this.version = versionInfo;
    }

    public SoxComponent apply(Msg msg, int n, int n2, SoxComponent soxComponent) throws Exception {
        if (soxComponent == null) {
            if (n2 == 116) {
                return this.applyTreeNew(msg, n);
            }
            return null;
        }
        switch (n2) {
            case 116: {
                this.applyTreeCached(msg, soxComponent);
                break;
            }
            case 99: {
                this.applyProps(msg, soxComponent, 99, false);
                break;
            }
            case 114: {
                this.applyProps(msg, soxComponent, 114, false);
                break;
            }
            case 67: {
                this.applyProps(msg, soxComponent, 99, true);
                break;
            }
            case 82: {
                this.applyProps(msg, soxComponent, 114, true);
                break;
            }
            case 108: {
                this.applyLinks(msg, soxComponent);
                break;
            }
            default: {
                System.out.println("WARNING: apply of unknown category: " + (char)n2 + " 0x" + Integer.toHexString(n2));
            }
        }
        return soxComponent;
    }

    SoxComponent applyTreeNew(Msg msg, int n) throws Exception {
        Kit kit = this.schema.kit(msg.u1());
        Type type = kit.type(msg.u1());
        SoxComponent soxComponent = new SoxComponent(this.client, n, type);
        this.applyTree(msg, soxComponent);
        return soxComponent;
    }

    void applyTreeCached(Msg msg, SoxComponent soxComponent) throws Exception {
        Kit kit = this.schema.kit(msg.u1());
        Type type = kit.type(msg.u1());
        if (soxComponent.type != type) {
            System.out.println("ERROR: Component has changed type!");
            Thread.dumpStack();
        }
        this.applyTree(msg, soxComponent);
    }

    void applyTree(Msg msg, SoxComponent soxComponent) throws Exception {
        String string;
        soxComponent.name = string = msg.str();
        soxComponent.parent = msg.u2();
        soxComponent.permissions = msg.u1();
        int[] nArray = new int[msg.u1()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = msg.u2();
            ++n;
        }
        soxComponent.setChildren(nArray);
        soxComponent.fireChanged(1);
    }

    void applyProps(Msg msg, SoxComponent soxComponent, int n, boolean bl) throws Exception {
        Slot[] slotArray = soxComponent.type.slots;
        int n2 = 0;
        while (n2 < slotArray.length) {
            Slot slot = slotArray[n2];
            if (slot.isProp() && (!bl || slot.isOperator()) && !(n == 99 ? slot.isRuntime() : slot.isConfig())) {
                Value value = soxComponent.get(slot).decodeBinary(msg);
                soxComponent.set(slot, value);
            }
            ++n2;
        }
        soxComponent.fireChanged(n == 99 ? 2 : 4);
    }

    void applyLinks(Msg msg, SoxComponent soxComponent) throws Exception {
        ArrayList<Link> arrayList = null;
        while (true) {
            int n = msg.u2();
            boolean bl = false;
            if (n == (char)-1) {
                bl = true;
            }
            boolean bl2 = false;
            if (n < 0) {
                bl2 = true;
            }
            if (bl | bl2) break;
            Link link = new Link();
            link.fromCompId = n;
            link.fromSlotId = msg.u1();
            link.toCompId = msg.u2();
            link.toSlotId = msg.u1();
            if (arrayList == null) {
                arrayList = new ArrayList<Link>();
            }
            arrayList.add(link);
        }
        soxComponent.links = arrayList == null ? Link.none : arrayList.toArray(new Link[arrayList.size()]);
        soxComponent.fireChanged(8);
    }

    public SoxUtil(Schema schema, VersionInfo versionInfo) {
        this.schema = schema;
        this.version = versionInfo;
    }

    SoxUtil(SoxClient soxClient) {
        this.client = soxClient;
    }
}

