/*
 * Decompiled with CFR 0.152.
 */
package sedona.manifest;

import sedona.Depend;
import sedona.KitPart;
import sedona.manifest.TypeManifest;
import sedona.util.Abstime;
import sedona.util.Version;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedona.xml.XWriter;

public class KitManifest {
    public final String name;
    public int checksum;
    public Version version;
    public String vendor;
    public String description;
    public boolean hasNatives;
    public boolean doc;
    public Abstime buildTime;
    public String buildHost;
    public Depend[] depends;
    public TypeManifest[] types;

    public KitPart part() {
        return new KitPart(this.name, this.checksum);
    }

    public void encodeXml(XWriter xWriter) {
        xWriter.w("<?xml version='1.0'?>\n");
        xWriter.w("<kitManifest\n");
        xWriter.w("   ").attr("name", this.name).w("\n");
        xWriter.w("   ").attr("checksum", Integer.toHexString(this.checksum)).w("\n");
        xWriter.w("   ").attr("hasNatives", this.hasNatives).w("\n");
        xWriter.w("   ").attr("doc", this.doc).w("\n");
        if (this.version != null) {
            xWriter.w("   ").attr("version", this.version.toString()).w("\n");
        }
        if (this.vendor != null) {
            xWriter.w("   ").attr("vendor", this.vendor).w("\n");
        }
        if (this.description != null) {
            xWriter.w("   ").attr("description", this.description).w("\n");
        }
        if (this.buildHost != null) {
            xWriter.w("   ").attr("buildHost", this.buildHost).w("\n");
        }
        if (this.buildTime != null) {
            xWriter.w("   ").attr("buildTime", this.buildTime.encode()).w("\n");
        }
        xWriter.w(">\n");
        xWriter.w("\n");
        xWriter.w("<!-- Dependencies -->\n");
        xWriter.w("<depends>\n");
        int n = 0;
        while (this.depends != null && n < this.depends.length) {
            this.depends[n].encodeXml(xWriter);
            ++n;
        }
        xWriter.w("</depends>\n");
        xWriter.w("\n");
        n = 0;
        while (n < this.types.length) {
            if (this.types[n] != null) {
                this.types[n].encodeXml(xWriter);
                xWriter.w("\n");
            }
            ++n;
        }
        xWriter.w("</kitManifest>\n");
    }

    public void decodeXml(XElem xElem) {
        int n;
        XElem[] xElemArray;
        if (!xElem.name().equals("kitManifest")) {
            throw new XException("Expected root to be <kitManifest>", xElem);
        }
        if (!this.name.equals(xElem.get("name"))) {
            throw new XException("Mismatched name " + this.name + " != " + xElem.get("name"), xElem);
        }
        this.checksum = (int)Long.parseLong(xElem.get("checksum"), 16);
        this.version = xElem.getVersion("version", null);
        this.vendor = xElem.get("vendor", null);
        this.description = xElem.get("description", null);
        this.hasNatives = xElem.getb("hasNatives", false);
        this.doc = xElem.getb("doc", false);
        this.buildTime = xElem.getAbstime("buildTime", null);
        this.buildHost = xElem.get("buildHost", null);
        XElem xElem2 = xElem.elem("depends");
        if (xElem2 == null) {
            this.depends = new Depend[0];
        } else {
            xElemArray = xElem2.elems("depend");
            this.depends = new Depend[xElemArray.length];
            n = 0;
            while (n < xElemArray.length) {
                this.depends[n] = Depend.decodeXml(xElemArray[n]);
                ++n;
            }
        }
        xElemArray = xElem.elems("type");
        this.types = new TypeManifest[xElemArray.length];
        n = 0;
        while (n < xElemArray.length) {
            TypeManifest typeManifest = TypeManifest.decodeXml(this, xElemArray[n]);
            if (typeManifest.id != n) {
                throw new XException("Misaligned type id", xElemArray[n]);
            }
            this.types[n] = typeManifest;
            ++n;
        }
    }

    public static KitManifest fromXml(XElem xElem) {
        if (!xElem.name().equals("kitManifest")) {
            throw new XException("Expected root to be <kitManifest>", xElem);
        }
        String string = xElem.get("name");
        if (string == null) {
            throw new XException("Missing name attribute", xElem);
        }
        KitManifest kitManifest = new KitManifest(string);
        kitManifest.decodeXml(xElem);
        return kitManifest;
    }

    public KitManifest(String string) {
        this.name = string;
    }
}

