/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pansheet.viz;

import com.tridium.pansheet.viz.BNodeGlyph;
import com.tridium.pansheet.viz.BPanCanvas;
import com.tridium.pansheet.viz.BPanWidget;
import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BThumbnail
extends BWidget {
    public static final Type TYPE;
    static final BColor thumbBg;
    static final BColor thumbFg;
    static final BColor edge;
    protected BImage buffer;
    private Point dragCheckPoint;
    private boolean dragging;
    private RectGeom vpDrag;
    static /* synthetic */ Class class$com$tridium$pansheet$viz$BThumbnail;
    static /* synthetic */ Class class$com$tridium$pansheet$viz$BNodeGlyph;

    public Type getType() {
        return TYPE;
    }

    protected final BPanCanvas getPanCanvas() {
        return (BPanCanvas)this.getParentWidget();
    }

    public synchronized void repaintBuffer() {
        if (this.buffer != null) {
            this.buffer.dispose();
        }
        this.buffer = BImage.make((double)this.getWidth(), (double)this.getHeight());
        double d = this.getPreferredWidth();
        double d2 = this.getPreferredHeight();
        double d3 = this.getPanCanvas().getPreferredWidth();
        double d4 = this.getPanCanvas().getPreferredHeight();
        double d5 = d / d3;
        double d6 = d2 / d4;
        RectGeom rectGeom = this.getPanCanvas().getViewport();
        if (rectGeom.width >= d3 && rectGeom.height >= d4) {
            return;
        }
        Graphics graphics = this.buffer.getGraphics();
        graphics.setBrush(thumbBg);
        graphics.fillRect(1.0, 1.0, d, d2);
        graphics.setBrush(thumbFg);
        double d7 = rectGeom.x * d5;
        double d8 = rectGeom.y * d6;
        double d9 = rectGeom.width * d5;
        double d10 = rectGeom.height * d6;
        graphics.fillRect(d7, d8, d9, d10);
        this.paintBufferNodes(graphics, d5, d6);
        graphics.setBrush(edge);
        graphics.strokeRect(0.0, 0.0, d, d2);
        graphics.dispose();
    }

    private final synchronized void paintBufferNodes(Graphics graphics, double d, double d2) {
        BPanWidget bPanWidget = this.getPanCanvas().getPanWidget();
        Class clazz = class$com$tridium$pansheet$viz$BNodeGlyph;
        if (clazz == null) {
            clazz = class$com$tridium$pansheet$viz$BNodeGlyph = BThumbnail.class("[Lcom.tridium.pansheet.viz.BNodeGlyph;", false);
        }
        BNodeGlyph[] bNodeGlyphArray = (BNodeGlyph[])bPanWidget.getChildren(clazz);
        BTransform bTransform = this.getPanCanvas().getPanWidget().getTransform();
        graphics.setBrush(BColor.gray);
        int n = 0;
        while (n < bNodeGlyphArray.length) {
            double d3 = bNodeGlyphArray[n].getX() * d;
            double d4 = bNodeGlyphArray[n].getY() * d2;
            double d5 = bNodeGlyphArray[n].getWidth() * d;
            double d6 = bNodeGlyphArray[n].getHeight() * d2;
            Point point = bTransform.transform((IPoint)new Point(d3, d4), null);
            Point point2 = bTransform.transform((IPoint)new Point(d5, d6), null);
            graphics.fillRect(point.x, point.y, Math.max(1.0, point2.x), Math.max(1.0, point2.y));
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        if (this.buffer != null) {
            graphics.drawImage(this.buffer, 0.0, 0.0);
        }
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        super.mousePressed(bMouseEvent);
        this.dragging = false;
        this.dragCheckPoint = this.translateToCanvas(bMouseEvent);
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        super.mouseDragged(bMouseEvent);
        if (this.dragCheckPoint == null) {
            return;
        }
        if (!this.dragging) {
            this.dragging = true;
            this.vpDrag = this.getPanCanvas().getViewport();
        }
        Point point = this.translateToCanvas(bMouseEvent);
        this.updateViewport(point.x, point.y);
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        super.mouseReleased(bMouseEvent);
        Point point = this.translateToCanvas(bMouseEvent);
        if (this.dragging) {
            this.updateViewport(point.x, point.y);
        } else {
            this.centerViewport(point);
        }
        this.dragging = false;
        this.dragCheckPoint = null;
    }

    private final void centerViewport(Point point) {
        RectGeom rectGeom = this.getPanCanvas().getViewport();
        RectGeom rectGeom2 = new RectGeom(point.x - rectGeom.width / (double)2, point.y - rectGeom.height / (double)2, rectGeom.width, rectGeom.height);
        this.getPanCanvas().scrollToVisible(rectGeom2);
    }

    private final void updateViewport(double d, double d2) {
        double d3 = Theme.scrollBar().getFixedWidth();
        double d4 = this.getPanCanvas().getWidth() - d3;
        double d5 = this.getPanCanvas().getHeight() - d3;
        double d6 = (d -= this.getX()) - (this.dragCheckPoint.x - this.vpDrag.x);
        double d7 = (d2 -= this.getY()) - (this.dragCheckPoint.y - this.vpDrag.y);
        RectGeom rectGeom = new RectGeom(d6, d7, d4, d5);
        this.getPanCanvas().scrollToVisible(rectGeom);
    }

    private final Point translateToCanvas(BMouseEvent bMouseEvent) {
        return this.translateToCanvas(new Point(bMouseEvent.getX(), bMouseEvent.getY()));
    }

    private final Point translateToCanvas(Point point) {
        double d = this.getPanCanvas().getPreferredWidth() / this.getPreferredWidth();
        double d2 = this.getPanCanvas().getPreferredHeight() / this.getPreferredHeight();
        return new Point(point.x * d, point.y * d2);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$pansheet$viz$BThumbnail;
        if (clazz == null) {
            clazz = class$com$tridium$pansheet$viz$BThumbnail = BThumbnail.class("[Lcom.tridium.pansheet.viz.BThumbnail;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        thumbBg = BColor.make((int)230, (int)230, (int)230, (int)210);
        thumbFg = UiEnv.get().isMicroEdition() ? BColor.make((int)14072801) : BColor.make((int)142, (int)6, (int)198, (int)50);
        edge = BColor.make((int)0);
    }
}

