/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pansheet.viz;

import com.tridium.nsedona.pan.LinkPair;
import com.tridium.pansheet.viz.BNodeGlyph;
import com.tridium.pansheet.viz.BPanGlyph;
import javax.baja.gx.BColor;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLinkGlyph
extends BPanGlyph {
    public static final Property color = BLinkGlyph.newProperty((int)0, (BValue)BColor.DEFAULT, null);
    public static final Property pen = BLinkGlyph.newProperty((int)0, (BValue)BPen.DEFAULT, null);
    public static final Type TYPE;
    private static final int MouseThreshold = 5;
    protected BNodeGlyph sourceGlyph;
    protected BNodeGlyph targetGlyph;
    protected Array dummies;
    protected Point[] waypoints;
    private RectGeom bounds;
    static /* synthetic */ Class class$com$tridium$pansheet$viz$BLinkGlyph;
    static /* synthetic */ Class class$javax$baja$gx$Point;

    public BColor getColor() {
        return (BColor)this.get(color);
    }

    public void setColor(BColor bColor) {
        this.set(color, (BValue)bColor, null);
    }

    public BPen getPen() {
        return (BPen)this.get(pen);
    }

    public void setPen(BPen bPen) {
        this.set(pen, (BValue)bPen, null);
    }

    public Type getType() {
        return TYPE;
    }

    public LinkPair getLinkPair() {
        return this.panWidget.graph.getLinkPair(this.sourceGlyph.getPanNode(), this.targetGlyph.getPanNode());
    }

    public IRectGeom bounds() {
        return this.bounds;
    }

    protected void buildLink() {
        this.computeWaypoints();
        this.computePaint();
        this.computeBounds();
    }

    private final void computeWaypoints() {
        Class clazz = class$javax$baja$gx$Point;
        if (clazz == null) {
            clazz = class$javax$baja$gx$Point = BLinkGlyph.class("[Ljavax.baja.gx.Point;", false);
        }
        Array array = new Array(clazz);
        Point point = this.getOutPoint(this.sourceGlyph);
        Point point2 = this.getInPoint(this.targetGlyph);
        point2.y -= 1.0;
        array.add((Object)point);
        if (this.dummies.size() == 0) {
            array.add((Object)point2);
        } else {
            BWidget bWidget = (BWidget)this.dummies.get(0);
            BWidget bWidget2 = (BWidget)this.dummies.last();
            Point point3 = this.getInPoint(bWidget);
            Point point4 = this.getOutPoint(bWidget2);
            if (this.isVertical(this.sourceGlyph, bWidget)) {
                if (this.isVertical(bWidget2, this.targetGlyph)) {
                    array.add((Object)new Point(point.x, point2.y));
                } else {
                    array.add((Object)point4);
                    array.add((Object)point2);
                }
            } else if (this.isVertical(bWidget2, this.targetGlyph)) {
                array.add((Object)point3);
                array.add((Object)new Point(point3.x, point2.y));
            } else {
                array.add((Object)point3);
                array.add((Object)new Point(point3.x, point4.y));
                array.add((Object)point2);
            }
        }
        this.waypoints = (Point[])array.trim();
    }

    private final void computePaint() {
        LinkPair linkPair = this.panWidget.graph.getLinkPair(this.sourceGlyph.getPanNode(), this.targetGlyph.getPanNode());
        switch (this.panWidget.getPanNetwork().getSignalBars(linkPair.getSignalStrength()).getOrdinal()) {
            case 0: 
            case 1: {
                this.setColor(BColor.red);
                break;
            }
            case 2: {
                this.setColor(BColor.orange);
                break;
            }
            case 3: {
                this.setColor(BColor.make((int)200, (int)200, (int)0));
                break;
            }
            case 4: {
                this.setColor(BColor.green);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.setPen(BPen.make((double)2, (int)101, (int)202, null));
    }

    private final void computeBounds() {
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        while (n < this.waypoints.length) {
            Point point = this.waypoints[n];
            d = Math.min(d, point.x);
            d2 = Math.min(d2, point.y);
            d3 = Math.max(d3, point.x);
            d4 = Math.max(d4, point.y);
            ++n;
        }
        this.bounds = new RectGeom(d, d2, d3 - d + (double)3, d4 - d2 + 1.0);
    }

    private final boolean isVertical(BWidget bWidget, BWidget bWidget2) {
        BWidget bWidget3 = bWidget;
        if (bWidget.getWidth() < bWidget2.getWidth()) {
            bWidget = bWidget2;
            bWidget2 = bWidget3;
        }
        boolean bl = false;
        if (bWidget.getX() <= bWidget2.getX() && bWidget.getX() + bWidget.getWidth() >= bWidget2.getX() + bWidget2.getWidth()) {
            bl = true;
        }
        return bl;
    }

    private final Point getInPoint(BWidget bWidget) {
        return new Point((double)((int)(bWidget.getX() + bWidget.getWidth() / (double)2)), (double)((int)bWidget.getY()));
    }

    private final Point getOutPoint(BWidget bWidget) {
        return new Point((double)((int)(bWidget.getX() + bWidget.getWidth() / (double)2)), (double)((int)(bWidget.getY() + bWidget.getHeight())));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paint(Graphics graphics) {
        graphics.push();
        try {
            BColor bColor = this.getColor();
            if (this.panWidget.getSelection().getLinkGlyphs().length > 0) {
                if (this.isSelected()) {
                    graphics.setBrush(bColor);
                } else {
                    graphics.setBrush(BColor.make((int)bColor.getRed(), (int)bColor.getGreen(), (int)bColor.getBlue(), (int)77));
                }
            } else {
                graphics.setBrush(bColor);
            }
            graphics.setPen(this.getPen());
            Point point = this.waypoints[0];
            int n = 1;
            while (n < this.waypoints.length) {
                Point point2 = this.waypoints[n];
                graphics.strokeLine(point.x, point.y, point2.x, point2.y);
                point = point2;
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            graphics.pop();
            throw throwable;
        }
        {
            Object var3_8 = null;
        }
        graphics.pop();
    }

    public boolean contains(double d, double d2) {
        if (!this.bounds.contains(this.bounds.x, d2)) {
            return false;
        }
        if (!new RectGeom(this.bounds.x - (double)5, this.bounds.y, this.bounds.width + (double)5, this.bounds.height).contains(d, d2)) {
            return false;
        }
        Point point = this.waypoints[0];
        int n = 1;
        while (n < this.waypoints.length) {
            Point point2 = this.waypoints[n];
            if (this.lineContains(point, point2, (int)d, (int)d2)) {
                return true;
            }
            point = point2;
            ++n;
        }
        return false;
    }

    private final boolean lineContains(Point point, Point point2, int n, int n2) {
        if (Math.abs(point.x - point2.x) < (double)5) {
            boolean bl = false;
            if (Math.abs((double)n - point.x) < (double)5) {
                bl = true;
            }
            return bl;
        }
        double d = (point2.y - point.y) / (point2.x - point.x);
        double d2 = d * ((double)n - point.x) + point.y;
        boolean bl = false;
        if (Math.abs(d2 - (double)n2) < (double)5) {
            bl = true;
        }
        return bl;
    }

    public String toString(Context context) {
        return (Object)((Object)this.sourceGlyph) + " -> " + (Object)((Object)this.targetGlyph);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.waypoints = new Point[0];
        this.bounds = new RectGeom();
    }

    public BLinkGlyph() {
        this.this();
    }

    public BLinkGlyph(BNodeGlyph bNodeGlyph, BNodeGlyph bNodeGlyph2, Array array) {
        super(bNodeGlyph.panWidget);
        this.this();
        if (bNodeGlyph.panWidget != bNodeGlyph2.panWidget) {
            throw new IllegalStateException("glyphs in different widgets");
        }
        this.sourceGlyph = bNodeGlyph;
        this.targetGlyph = bNodeGlyph2;
        this.dummies = array;
        this.buildLink();
    }

    static {
        Class clazz = class$com$tridium$pansheet$viz$BLinkGlyph;
        if (clazz == null) {
            clazz = class$com$tridium$pansheet$viz$BLinkGlyph = BLinkGlyph.class("[Lcom.tridium.pansheet.viz.BLinkGlyph;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

