/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pansheet.digraph.algo;

import com.tridium.pansheet.digraph.Digraph;
import com.tridium.pansheet.digraph.Edge;
import com.tridium.pansheet.digraph.algo.CycleBreaker;
import java.util.Iterator;
import java.util.Set;

public class TwoCycleRemover
implements CycleBreaker {
    public Digraph breakCycles(Digraph digraph) {
        Digraph digraph2 = new Digraph();
        Iterator iterator = digraph.vertices().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Set set = digraph.outDegree(e) >= digraph.inDegree(e) ? digraph.getOutEdges(e) : digraph.getInEdges(e);
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Edge edge = (Edge)iterator2.next();
                if (digraph2.containsEdge(edge.reverse())) continue;
                edge.addEdge(digraph2);
            }
        }
        return digraph2;
    }

    public static void main(String[] stringArray) {
        Digraph digraph = new Digraph();
        digraph.addEdge("v0", "v1");
        digraph.addEdge("v1", "v2");
        digraph.addEdge("v2", "v1");
        digraph.addEdge("v2", "v3");
        digraph.dumpAdjacencyList("cycles");
        new TwoCycleRemover().breakCycles(digraph).dumpAdjacencyList("no cycles");
    }
}

