/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pansheet.digraph.algo;

import com.tridium.pansheet.digraph.Digraph;
import com.tridium.pansheet.digraph.Edge;
import com.tridium.pansheet.digraph.LayerSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;

public class BarycentricOrdering {
    private LayerSet layers;
    private Digraph dag;

    public static void order(LayerSet layerSet) {
        BarycentricOrdering barycentricOrdering = new BarycentricOrdering(layerSet);
        barycentricOrdering.order();
    }

    private final void order() {
        boolean bl = true;
        int n = 0;
        while (bl && n < 100) {
            ++n;
            bl = false;
            int n2 = 1;
            while (n2 < this.layers.height()) {
                bl |= this.barycenter(this.layers.getLayer(n2 - 1), this.layers.getLayer(n2), true);
                ++n2;
            }
            n2 = this.layers.height() - 2;
            while (n2 >= 0) {
                bl |= this.barycenter(this.layers.getLayer(n2 + 1), this.layers.getLayer(n2), false);
                --n2;
            }
        }
        if (bl && n >= 100) {
            System.out.println("######### Barycenter never converged");
        }
    }

    private final boolean barycenter(LayerSet.Layer layer, LayerSet.Layer layer2, boolean bl) {
        boolean bl2 = false;
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        int n = 0;
        while (n < layer.width()) {
            hashMap.put(layer.getVertex(n), new Integer(n));
            ++n;
        }
        HashMap<Object, double[]> hashMap2 = new HashMap<Object, double[]>();
        double d = -1.0;
        int n2 = 0;
        while (n2 < layer2.width()) {
            Object object = layer2.getVertex(n2);
            double[] dArray = new double[2];
            dArray[0] = n2;
            double[] dArray2 = dArray;
            int n3 = 0;
            Set set = bl ? this.dag.getInEdges(object) : this.dag.getOutEdges(object);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                Integer n4 = (Integer)(bl ? hashMap.get(edge.tail) : hashMap.get(edge.head));
                dArray2[1] = dArray2[1] + n4.doubleValue();
                ++n3;
            }
            dArray2[1] = dArray2[1] / (double)n3;
            hashMap2.put(object, dArray2);
            if (dArray2[1] < d) {
                bl2 = true;
            }
            d = dArray2[1];
            ++n2;
        }
        if (bl2) {
            layer2.vertices = layer2.vertices.sort((Comparator)new BaryCompare(hashMap2));
        }
        return bl2;
    }

    protected BarycentricOrdering(LayerSet layerSet) {
        this.layers = layerSet;
        this.dag = layerSet.dag;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class BaryCompare
    implements Comparator {
        HashMap vertToPos;
        boolean reverse;

        public int compare(Object object, Object object2) {
            double d = this.baryPos(object) - this.baryPos(object2);
            if (d == 0.0) {
                return (this.reverse ? -1 : 1) * (this.origPos(object) - this.origPos(object2));
            }
            return d < 0.0 ? -1 : 1;
        }

        private final double baryPos(Object object) {
            return ((double[])this.vertToPos.get(object))[1];
        }

        private final int origPos(Object object) {
            return (int)((double[])this.vertToPos.get(object))[0];
        }

        private final /* synthetic */ void this() {
            this.vertToPos = null;
        }

        public BaryCompare(HashMap hashMap) {
            this.this();
            this.vertToPos = hashMap;
            boolean bl = false;
            if (new Random().nextInt(10) % 2 == 0) {
                bl = true;
            }
            this.reverse = bl;
        }
    }
}

