/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jen6lp.messages;

import com.tridium.jen6lp.BMac154DeviceAddress;
import com.tridium.jen6lp.messages.JenserUnsCtrlMsg;
import com.tridium.jen6lp.util.JenserInputStream;
import javax.baja.log.Log;

public class PanNodeMsg
extends JenserUnsCtrlMsg {
    static final Log log = Log.getLog((String)"sedona.6lp");
    private BMac154DeviceAddress mac154;
    private String ipv6;

    public BMac154DeviceAddress getMac154() {
        return this.mac154;
    }

    public static JenserUnsCtrlMsg make(int n, JenserInputStream jenserInputStream) {
        return PanNodeMsg.make(n, jenserInputStream, false);
    }

    public static JenserUnsCtrlMsg make(int n, JenserInputStream jenserInputStream, boolean bl) {
        int n2;
        int n3;
        PanNodeMsg panNodeMsg = new PanNodeMsg(n);
        if (bl) {
            n3 = jenserInputStream.readUint32();
            n2 = jenserInputStream.readUint32();
        } else {
            n2 = jenserInputStream.readUint32();
            n3 = jenserInputStream.readUint32();
        }
        panNodeMsg.mac154 = BMac154DeviceAddress.make(n3, n2);
        StringBuffer stringBuffer = new StringBuffer("IPv6 ");
        stringBuffer.append(panNodeMsg.getIPv6());
        if (n == 7 || n == 12) {
            stringBuffer.append(": Node joined");
        } else if (n == 8 || n == 13) {
            stringBuffer.append(": Node left");
        } else {
            stringBuffer.append(": Unknown status");
        }
        log.message(stringBuffer.toString());
        return panNodeMsg;
    }

    public String getIPv6() {
        if (this.ipv6 == null) {
            String string = PanNodeMsg.createHexStrZ(this.mac154.getExtAddrLower());
            String string2 = PanNodeMsg.createHexStrZ(this.mac154.getExtAddrUpper() | 0x2000000);
            StringBuffer stringBuffer = new StringBuffer().append("fe80::").append(string2.substring(0, 4)).append(':').append(string2.substring(4, 8)).append(':').append(string.substring(0, 4)).append(':').append(string.substring(4, 8));
            this.ipv6 = stringBuffer.toString().toLowerCase();
        }
        return this.ipv6;
    }

    protected PanNodeMsg(int n) {
        super(n);
    }
}

