/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jen6lp.messages;

import com.tridium.jen6lp.messages.ControlReadResponse;
import com.tridium.jen6lp.messages.JennicMacNwkCheckResponse;
import com.tridium.jen6lp.messages.ScanRfResponse;
import com.tridium.jen6lp.util.JenserInputStream;
import com.tridium.jen6lp.util.JenserOutputStream;
import java.io.IOException;

public class JenserControlMsg {
    public static final int JENSER_CONTROL_READ = 1;
    public static final int JENSER_CONTROL_WRITE = 2;
    public static final int JENSER_CONTROL_ENABLE_STACK = 3;
    public static final int JENSER_CONTROL_RESTART_COORD = 4;
    public static final int JENSER_CONTROL_DISASSOCIATE = 5;
    public static final int JENSER_CONTROL_RF_SCAN = 6;
    public static final int JENSER_CONTROL_BOOTLDR_MODE = 9;
    public static final int JENSER_CONTROL_ENABLE_MSTP = 10;
    public static final int JENSER_CONTROL_MAC_NWK_CHECK = 12;
    public static final int JENSER_CONTROL_RESPONSE = 128;
    public static final int JENSER_FATAL_ERROR = 255;
    public static final int JENSER_UNS_CTRL_NODE_JOINED = 7;
    public static final int JENSER_UNS_CTRL_NODE_LEFT = 8;
    public static final int JENSER_UNS_CTRL_NBR_NODE_INFO = 10;
    public static final int JENSER_UNS_CTRL_RTG_NODE_INFO = 11;
    public static final int JENSER_UNS_CTRL_NODE_JOINED_2 = 12;
    public static final int JENSER_UNS_CTRL_NODE_LEFT_2 = 13;
    public static final int JENSER_UNS_CTRL_NWK_STATS = 14;
    public static final int JENSER_UNS_CTRL_PANID_ERROR = 15;
    public static final int JENSER_UNS_CTRL_COORD_MAC = 16;
    public static final int JENSER_UNS_CTRL_JIP_ERROR = 17;
    public static final int JS_PROP_RF_CHANNEL = 1;
    public static final int JS_PROP_PANID = 2;
    public static final int JS_PROP_DEVTABLE = 3;
    public static final int JS_PROP_DIAG_LEVEL = 4;
    public static final int JS_PROP_BEACON_PAYLOAD = 5;
    public static final int JS_PROP_VERSION = 6;
    public static final int JS_PROP_DEVTABLE_INFO = 7;
    public static final int JS_PROP_DEVTABLE_LEFT = 8;
    public static final int JS_PROP_MSTP_ADDRESS = 9;
    public static final int JS_PROP_MSTP_BAUD_RATE = 10;
    public static final int JS_PROP_MSTP_MAX_MASTER = 11;
    public static final int JS_PROP_MSTP_MAX_INFO = 12;
    public static final int JS_PROP_RADIO_POWER = 13;
    public static final int JS_PROP_COORD_MAC_ADDR = 14;
    public static final int JS_PROP_COORD_NWK_STATS = 15;
    public static final int JS_PROP_COORD_MEM_DUMP = 16;
    public static final int JS_PROP_COORD_TIMEOUT_SEC = 17;
    public static final int JS_PROP_ALLOW_SLEEPING_CHILDREN = 18;
    int type;

    public static boolean isResponseMsg(byte[] byArray) {
        boolean bl = false;
        if ((byArray[0] & 0x80) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isFatalError(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return true;
        }
        boolean bl = false;
        if ((byArray[0] & 0xFF) == 255) {
            bl = true;
        }
        return bl;
    }

    static String createHexStrZ(int n) {
        String string = Integer.toHexString(n);
        int n2 = 8 - string.length();
        int n3 = 0;
        while (n3 < n2) {
            string = "0" + string;
            ++n3;
        }
        return string;
    }

    public static JenserControlMsg decode(byte[] byArray) throws IOException {
        JenserInputStream jenserInputStream = new JenserInputStream(byArray);
        int n = jenserInputStream.read();
        switch (n) {
            case 129: {
                return ControlReadResponse.make(jenserInputStream);
            }
            case 134: {
                return ScanRfResponse.make(jenserInputStream);
            }
            case 140: {
                return JennicMacNwkCheckResponse.make(jenserInputStream);
            }
        }
        throw new IllegalStateException("Unsupported control msg type rcvd " + n);
    }

    public byte[] encode() throws IOException {
        JenserOutputStream jenserOutputStream = new JenserOutputStream();
        this.write(jenserOutputStream);
        return jenserOutputStream.toByteArray();
    }

    protected void write(JenserOutputStream jenserOutputStream) throws IOException {
        jenserOutputStream.write(this.type);
    }

    public JenserControlMsg(int n) {
        this.type = n;
    }
}

