/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jen6lp;

import com.tridium.jen6lp.util.JenserInputStream;
import com.tridium.jen6lp.util.Mac154Address;

public class JennicMacRxFrame {
    public static final byte MAC154_SHORT_ADDRESS = 2;
    public static final byte MAC154_EXT_ADDRESS = 3;
    private Mac154Address srcAddr;
    private int linkQuality;
    private boolean securityUsed;
    private int aclEntry;
    private byte[] data;

    public static JennicMacRxFrame decode(byte[] byArray) {
        JenserInputStream jenserInputStream = new JenserInputStream(byArray);
        int n = jenserInputStream.readUint16();
        int n2 = jenserInputStream.read();
        int n3 = jenserInputStream.read();
        int n4 = 0;
        if (n3 == 0) {
            n4 = 1;
        }
        boolean bl = 1 - n4;
        int n5 = jenserInputStream.read();
        int n6 = jenserInputStream.read();
        jenserInputStream.read();
        jenserInputStream.read();
        Mac154Address mac154Address = n == 2 ? JennicMacRxFrame.readShortAddr(jenserInputStream) : JennicMacRxFrame.readExtAddr(jenserInputStream);
        byte[] byArray2 = new byte[n6];
        jenserInputStream.read(byArray2, 0, n6);
        return new JennicMacRxFrame(mac154Address, n2, bl, n5, byArray2);
    }

    private static final Mac154Address readShortAddr(JenserInputStream jenserInputStream) {
        int n = jenserInputStream.readUint16();
        int n2 = jenserInputStream.readUint16();
        return Mac154Address.make(n2, n);
    }

    private static final Mac154Address readExtAddr(JenserInputStream jenserInputStream) {
        int n = jenserInputStream.readUint16();
        int n2 = jenserInputStream.readUint16();
        int n3 = jenserInputStream.readUint16();
        return Mac154Address.make(n3, n2, n);
    }

    public Mac154Address getSrcAddr() {
        return this.srcAddr;
    }

    public int getLinkQuality() {
        return this.linkQuality;
    }

    public boolean getSecurityUsed() {
        return this.securityUsed;
    }

    public int getAclEntry() {
        return this.aclEntry;
    }

    public byte[] getData() {
        return this.data;
    }

    public JennicMacRxFrame(Mac154Address mac154Address, byte[] byArray) {
        this(mac154Address, -1, false, -1, byArray);
    }

    public JennicMacRxFrame(Mac154Address mac154Address, int n, boolean bl, int n2, byte[] byArray) {
        this.srcAddr = mac154Address;
        this.linkQuality = n;
        this.securityUsed = bl;
        this.aclEntry = n2;
        this.data = byArray;
    }
}

