/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jen6lp;

import com.tridium.jen6lp.BIpv4Mac154Entry;
import com.tridium.jen6lp.BJennicMstpBaudRate;
import com.tridium.jen6lp.BSedonaJen6lpAbstractNetwork;
import com.tridium.jen6lp.BSedonaJen6lpDevice;
import com.tridium.jen6lp.messages.ControlWriteRequest;
import com.tridium.jen6lp.messages.JenserControlMsg;
import com.tridium.platJen6lp.BJen6lpAdapter;
import com.tridium.platJen6lp.BJen6lpPlatformService;
import com.tridium.sedonanet.driver.BSedonaBaseDevice;
import com.tridium.util.IPAddressUtil;
import java.io.IOException;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSedonaJen6lpNetwork
extends BSedonaJen6lpAbstractNetwork {
    public static final Property mstpEnabled = BSedonaJen6lpNetwork.newProperty((int)4, (boolean)false, null);
    public static final Property mstpBaudRate = BSedonaJen6lpNetwork.newProperty((int)4, (BValue)BJennicMstpBaudRate.baud_9600, null);
    public static final Property mstpAddress = BSedonaJen6lpNetwork.newProperty((int)5, (int)0, (BFacets)BFacets.makeInt((int)0, (int)127));
    public static final Property mstpMaxMaster = BSedonaJen6lpNetwork.newProperty((int)4, (int)127, (BFacets)BFacets.makeInt((int)0, (int)127));
    public static final Property mstpMaxInfoFrames = BSedonaJen6lpNetwork.newProperty((int)4, (int)20, (BFacets)BFacets.makeInt((int)1, (int)100));
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$jen6lp$BSedonaJen6lpNetwork;

    public boolean getMstpEnabled() {
        return this.getBoolean(mstpEnabled);
    }

    public void setMstpEnabled(boolean bl) {
        this.setBoolean(mstpEnabled, bl, null);
    }

    public BJennicMstpBaudRate getMstpBaudRate() {
        return (BJennicMstpBaudRate)this.get(mstpBaudRate);
    }

    public void setMstpBaudRate(BJennicMstpBaudRate bJennicMstpBaudRate) {
        this.set(mstpBaudRate, (BValue)bJennicMstpBaudRate, null);
    }

    public int getMstpAddress() {
        return this.getInt(mstpAddress);
    }

    public void setMstpAddress(int n) {
        this.setInt(mstpAddress, n, null);
    }

    public int getMstpMaxMaster() {
        return this.getInt(mstpMaxMaster);
    }

    public void setMstpMaxMaster(int n) {
        this.setInt(mstpMaxMaster, n, null);
    }

    public int getMstpMaxInfoFrames() {
        return this.getInt(mstpMaxInfoFrames);
    }

    public void setMstpMaxInfoFrames(int n) {
        this.setInt(mstpMaxInfoFrames, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected BJen6lpAdapter openAdapter(String string) throws Exception {
        BJen6lpPlatformService bJen6lpPlatformService = (BJen6lpPlatformService)Sys.getService((Type)BJen6lpPlatformService.TYPE);
        this.adapter = bJen6lpPlatformService.open(string);
        if (this.getEnabled()) {
            this.enableCoord();
        }
        return this.adapter;
    }

    public void enableCoord() throws IOException {
        boolean bl = this.adapter.getForceCoordRestartOnInit();
        int n = this.getPanid();
        int n2 = this.getChannel();
        int n3 = this.getDiagLevel();
        if (!bl) {
            int n4 = this.readPanid();
            int n5 = this.readChannel();
            if (n4 != n || n5 != n2) {
                bl = true;
                System.out.println("     PAN/channel mismatch, forcing coord restart");
            }
        }
        if (bl) {
            this.writeRestartCoord();
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {}
            this.writeDiagLevel(n3);
            if (this.getMstpEnabled()) {
                this.writeMstpAddress(this.getMstpAddress());
                this.writeMstpBaudRate(this.getMstpBaudRate().getOrdinal());
                this.writeMstpMaxMaster(this.getMstpMaxMaster());
                this.writeMstpMaxInfoFrames(this.getMstpMaxInfoFrames());
                this.writeEnableMstp();
            }
            this.writeRadioPowerLevel(this.getRadioPowerLevel());
            this.writeChannelPanid(n2, n);
            this.writeCoordRcvTimeout(this.getCoordRcvTimeout().getSeconds());
            this.writeAllowSleepingChildren(this.getAllowSleepingChildren());
            this.writeEnable();
        } else {
            this.writeDiagLevel(n3);
            System.out.println("     Requesting node list...");
            this.requestPanDevices();
        }
        log.trace("PAN ID  = 0x" + Integer.toHexString(n));
        log.trace("channel = 0x" + Integer.toHexString(n2));
        log.trace("diag    = 0x" + Integer.toHexString(n3));
    }

    protected int readMstpAddress() throws IOException {
        return this.readByteProperty(9);
    }

    protected void writeMstpAddress(int n) throws IOException {
        this.adapter.sendRcvControlMsg(ControlWriteRequest.makeByte(9, n).encode(), (int)this.getCtrlMsgTimeout().getMillis());
    }

    protected int readMstpBaudRate() throws IOException {
        int n = this.readByteProperty(10);
        return BSedonaJen6lpNetwork.jennicMstpBaudToBaud(n);
    }

    protected void writeMstpBaudRate(int n) throws IOException {
        int n2 = BSedonaJen6lpNetwork.baudToJennicMstpBaud(n);
        this.adapter.sendRcvControlMsg(ControlWriteRequest.makeByte(10, n2).encode(), (int)this.getCtrlMsgTimeout().getMillis());
    }

    protected int readMstpMaxMaster() throws IOException {
        return this.readByteProperty(11);
    }

    protected void writeMstpMaxMaster(int n) throws IOException {
        this.adapter.sendRcvControlMsg(ControlWriteRequest.makeByte(11, n).encode(), (int)this.getCtrlMsgTimeout().getMillis());
    }

    protected int readMstpMaxInfoFrames() throws IOException {
        return this.readByteProperty(12);
    }

    protected void writeMstpMaxInfoFrames(int n) throws IOException {
        this.adapter.sendRcvControlMsg(ControlWriteRequest.makeByte(12, n).encode(), (int)this.getCtrlMsgTimeout().getMillis());
    }

    protected void writeEnableMstp() throws IOException {
        JenserControlMsg jenserControlMsg = new JenserControlMsg(10);
        byte[] byArray = jenserControlMsg.encode();
        this.adapter.sendRcvControlMsg(byArray, (int)this.getCtrlMsgTimeout().getMillis());
    }

    private static final int baudToJennicMstpBaud(int n) {
        switch (n) {
            case 4800: {
                return 0;
            }
            case 9600: {
                return 1;
            }
            case 19200: {
                return 2;
            }
            case 38400: {
                return 3;
            }
            case 76800: {
                return 4;
            }
            case 115200: {
                return 5;
            }
        }
        return 3;
    }

    private static final int jennicMstpBaudToBaud(int n) {
        switch (n) {
            case 0: {
                return 4800;
            }
            case 1: {
                return 9600;
            }
            case 2: {
                return 19200;
            }
            case 3: {
                return 38400;
            }
            case 4: {
                return 76800;
            }
            case 5: {
                return 115200;
            }
        }
        return 38400;
    }

    public Object _fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 9900: {
                BSedonaJen6lpDevice bSedonaJen6lpDevice = (BSedonaJen6lpDevice)((Object)object2);
                return bSedonaJen6lpDevice.getMacAddress().getIpv6Address();
            }
            case 9901: {
                return this.userDefined1((String)object);
            }
        }
        return super._fw(n, object, object2, object3, object4);
    }

    private final BSedonaBaseDevice[] userDefined1(String string) {
        string = IPAddressUtil.expandIPv6NumericString((String)string, (boolean)true);
        string = TextUtil.replace((String)string, (String)":", (String)"").toLowerCase();
        BIpv4Mac154Entry[] bIpv4Mac154EntryArray = this.getAddressMap().list();
        BIpv4Mac154Entry bIpv4Mac154Entry = null;
        int n = 0;
        while (n < bIpv4Mac154EntryArray.length) {
            String string2 = TextUtil.replace((String)bIpv4Mac154EntryArray[n].getMac154().toString(), (String)":", (String)"").toLowerCase();
            if (string.endsWith(string2.substring(2))) {
                bIpv4Mac154Entry = bIpv4Mac154EntryArray[n];
                break;
            }
            ++n;
        }
        if (bIpv4Mac154Entry == null) {
            return new BSedonaBaseDevice[0];
        }
        BSedonaBaseDevice[] bSedonaBaseDeviceArray = this.getDeviceList();
        int n2 = 0;
        while (n2 < bSedonaBaseDeviceArray.length) {
            bSedonaBaseDeviceArray[n2].loadSlots();
            if (bSedonaBaseDeviceArray[n2].getAddress().getIp().equalsIgnoreCase(bIpv4Mac154Entry.getIpv4())) {
                return new BSedonaBaseDevice[]{bSedonaBaseDeviceArray[n2]};
            }
            ++n2;
        }
        return new BSedonaBaseDevice[0];
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$jen6lp$BSedonaJen6lpNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$jen6lp$BSedonaJen6lpNetwork = BSedonaJen6lpNetwork.class("[Lcom.tridium.jen6lp.BSedonaJen6lpNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

