/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet.ui.manifest;

import com.tridium.sedonanet.driver.BSedonaBaseNetwork;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.file.FileUtil;
import javax.baja.gx.BImage;
import javax.baja.sys.BString;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.util.SortUtil;
import sedona.Env;
import sedona.KitPart;
import sedona.manifest.ManifestDb;
import sedona.util.TextUtil;
import sedona.util.sedonadev.Download;

public abstract class Db {
    static final String localName = "Local Database";
    static final String webName = "Web Database";
    static final String stationName = "Station Database";
    static final BImage localIcon = BImage.make((String)"module://icons/x16/folder.png");
    static final BImage webIcon = BImage.make((String)"module://icons/x16/web.png");
    static final BImage stationIcon = BImage.make((String)"module://icons/x16/device.png");
    public String name;
    public BImage icon;
    Kit[] kits;
    private HashMap kitsByName;

    public static Db makeLocal() {
        return new LocalDb();
    }

    public Kit[] kits() {
        if (this.kits == null) {
            this.load();
            this.kitsByName = new HashMap();
            SortUtil.sort((Object[])this.kits);
            int n = 0;
            while (n < this.kits.length) {
                Kit kit = this.kits[n];
                this.kitsByName.put(kit.name, kit);
                SortUtil.sort((Object[])kit.manifests);
                ++n;
            }
        }
        return this.kits;
    }

    public boolean contains(Manifest manifest) {
        this.kits();
        Kit kit = (Kit)this.kitsByName.get(manifest.kit.name);
        if (kit == null) {
            return false;
        }
        int n = 0;
        while (n < kit.manifests.length) {
            if (kit.manifests[n].checksum == manifest.checksum) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public abstract String read(Manifest var1) throws Exception;

    public abstract void write(Manifest var1, String var2) throws Exception;

    public abstract void delete(Manifest var1) throws Exception;

    public boolean isReadonly() {
        return false;
    }

    public boolean isLocal() {
        return this.name.equals(localName);
    }

    public void reload() {
        this.kits = null;
        this.kits();
    }

    protected abstract void load();

    protected void loadFromTextFile(String string) {
        String[] stringArray = TextUtil.split((String)string, (char)'\n');
        ArrayList<Kit> arrayList = new ArrayList<Kit>();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string2.length() != 0 && !string2.startsWith("//")) {
                String[] stringArray2 = TextUtil.split((String)string2, (char)',');
                Kit kit = new Kit(this, stringArray2[0]);
                Object[] objectArray = new Manifest[stringArray2.length - 1];
                int n2 = 0;
                while (n2 < objectArray.length) {
                    objectArray[n2] = new Manifest(kit, (int)Long.parseLong(stringArray2[n2 + 1], 16));
                    ++n2;
                }
                SortUtil.sort((Object[])objectArray);
                kit.manifests = objectArray;
                arrayList.add(kit);
            }
            ++n;
        }
        this.kits = arrayList.toArray(new Kit[arrayList.size()]);
    }

    public Db(String string, BImage bImage) {
        this.name = string;
        this.icon = bImage;
    }

    public static class LocalDb
    extends Db {
        protected void load() {
            String[] stringArray = ManifestDb.listInstalledKits();
            this.kits = new Kit[stringArray.length];
            int n = 0;
            while (n < this.kits.length) {
                Kit kit = this.kits[n] = new Kit(this, stringArray[n]);
                KitPart[] kitPartArray = ManifestDb.listInstalledParts((String)stringArray[n]);
                kit.manifests = new Manifest[kitPartArray.length];
                int n2 = 0;
                while (n2 < kitPartArray.length) {
                    kit.manifests[n2] = new Manifest(kit, kitPartArray[n2].checksum);
                    ++n2;
                }
                ++n;
            }
        }

        public String read(Manifest manifest) throws Exception {
            return FileUtil.readString((File)ManifestDb.toFile((KitPart)manifest.part));
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void write(Manifest manifest, String string) throws Exception {
            File file = ManifestDb.toFile((KitPart)manifest.part);
            file.getParentFile().mkdirs();
            FileWriter fileWriter = new FileWriter(file);
            try {
                fileWriter.write(string);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                ((Writer)fileWriter).close();
                throw throwable;
            }
            {
                Object var6_7 = null;
            }
            ((Writer)fileWriter).close();
        }

        public void delete(Manifest manifest) throws Exception {
            File file = ManifestDb.toFile((KitPart)manifest.part);
            FileUtil.delete((File)file);
        }

        public LocalDb() {
            super(Db.localName, localIcon);
        }
    }

    public static class Kit
    implements Comparable {
        public final Db db;
        public final String name;
        public Manifest[] manifests;

        public int compareTo(Object object) {
            return this.name.compareTo(((Kit)object).name);
        }

        public int hashCode() {
            int n = 1;
            int n2 = 0;
            if (this.name != null) {
                n2 = this.name.hashCode();
            }
            n = 31 * n + n2;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Kit kit = (Kit)object;
            return !(this.name == null ? kit.name != null : !this.name.equals(kit.name));
        }

        public String toString() {
            return this.name;
        }

        public Kit(Db db, String string) {
            this.db = db;
            this.name = string;
        }
    }

    public static class Manifest
    implements Comparable {
        public final Kit kit;
        public final int checksum;
        public final KitPart part;

        public int compareTo(Object object) {
            return this.toString().compareTo(this.toString());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Manifest manifest = (Manifest)object;
            return this.toString().equals(manifest.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String checksumToString() {
            return TextUtil.intToHexString((int)this.checksum);
        }

        public String toString() {
            return this.kit.toString() + '-' + this.checksumToString();
        }

        public Manifest(Kit kit, int n) {
            this.kit = kit;
            this.checksum = n;
            this.part = new KitPart(kit.name, n);
        }
    }

    public static class WebDb
    extends Db {
        protected void load() {
            try {
                String string = Download.fetchString((String)"/download/api/all-manifests");
                this.loadFromTextFile(string);
            }
            catch (Exception exception) {
                throw new BajaRuntimeException("Cannot load kits from web", (Throwable)exception);
            }
        }

        public String read(Manifest manifest) throws Exception {
            return Download.fetchString((String)("/download/kit/" + manifest.part + ".xml"));
        }

        public void write(Manifest manifest, String string) throws Exception {
            throw new IOException("Web manifest database is read-only");
        }

        public void delete(Manifest manifest) throws Exception {
            throw new IOException("Web manifest database is read-only");
        }

        public boolean isReadonly() {
            return true;
        }

        public WebDb() {
            super(Db.webName, webIcon);
            Env.getProperties().setProperty("sedonadev.autodownload", "true");
        }
    }

    public static class StationDb
    extends Db {
        BSedonaBaseNetwork network;

        protected void load() {
            String string = this.network.manifestManagement(BString.make((String)"list")).toString();
            this.loadFromTextFile(string);
        }

        public String read(Manifest manifest) throws Exception {
            String string = "get " + manifest.part;
            return this.network.manifestManagement(BString.make((String)string)).toString();
        }

        public void write(Manifest manifest, String string) throws Exception {
            String string2 = "put " + manifest.part + '\n' + string;
            this.network.manifestManagement(BString.make((String)string2));
        }

        public void delete(Manifest manifest) throws Exception {
            String string = "delete " + manifest.part;
            this.network.manifestManagement(BString.make((String)string));
        }

        StationDb(BSedonaBaseNetwork bSedonaBaseNetwork) {
            super(Db.stationName, stationIcon);
            this.network = bSedonaBaseNetwork;
        }
    }
}

