/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet.driver.comm;

import com.tridium.sedonanet.driver.BSedonaBaseDevice;
import com.tridium.sedonanet.driver.comm.NoSessionException;
import com.tridium.sedonanet.driver.comm.SoxComm;
import com.tridium.sedonanet.driver.comm.SoxMsg;
import com.tridium.sedonanet.driver.comm.SoxTransaction;
import com.tridium.sedonanet.driver.comm.TimeOutException;
import com.tridium.sedonanet.soxgw.BSoxGatewaySpace;
import java.util.Hashtable;
import java.util.Properties;
import javax.baja.sys.BComponent;
import javax.baja.sys.Clock;
import sedona.dasp.DaspSession;
import sedona.sox.FileTransfer;
import sedona.sox.ISoxComm;
import sedona.sox.Msg;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;
import sedona.sox.SoxFile;

public class SoxCommSession
implements ISoxComm {
    SoxComm comm;
    BSedonaBaseDevice device;
    DaspSession session;
    long lastCommTicks;
    SoxClient soxClient;
    String closeCause;
    FileTransfer fileTransfer;
    volatile boolean closing;

    public void send(Msg msg) throws Exception {
        this.session.send(msg.bytes, 0, msg.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Msg request(Msg msg) throws Exception {
        SoxMsg soxMsg = SoxMsg.make(msg);
        SoxTransaction soxTransaction = this.comm.transactionManager.getTransaction();
        SoxMsg soxMsg2 = null;
        Object object = null;
        int n = this.comm.network.getCommConfig().getRetryTime();
        int n2 = this.comm.network.getCommConfig().getRetryCount();
        try {
            int n3 = 0;
            while (n3 <= n2) {
                DaspSession daspSession = this.session;
                this.lastCommTicks = Clock.ticks();
                SoxTransaction soxTransaction2 = soxTransaction;
                synchronized (soxTransaction2) {
                    soxTransaction.outgoingMessage = soxMsg;
                    soxMsg.setReplyNum(soxTransaction.tag);
                    soxMsg.device = this.device;
                    soxTransaction.responseMessage = null;
                    soxTransaction.exception = null;
                    soxTransaction.timeOut = true;
                    this.comm.writeLinkDebug("|send" + n3 + ':', this.device.getAddress().toDebugString(), soxMsg.bytes, soxMsg.size);
                    if (daspSession == null) {
                        throw new NoSessionException("request:session closed");
                    }
                    daspSession.send(soxMsg.bytes, 0, soxMsg.size);
                    try {
                        this.comm.xdbg("%%W" + n + " on " + soxTransaction.tag);
                        soxTransaction.wait(n);
                    }
                    catch (InterruptedException interruptedException) {}
                    soxMsg2 = soxTransaction.responseMessage;
                    Object object2 = object = soxTransaction.timeOut ? new TimeOutException() : soxTransaction.exception;
                    if (soxTransaction.responseMessage != null || soxTransaction.exception != null) {
                        break;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 5, 9] lbl36 : MonitorExitStatement: MONITOREXIT : var13_10
                    ++n3;
                }
            }
            Object var9_13 = null;
            this.comm.transactionManager.freeTransaction(soxTransaction);
            if (soxMsg2 != null || object == null) return soxMsg2;
            throw object;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.comm.transactionManager.freeTransaction(soxTransaction);
            throw throwable;
        }
    }

    public Msg[] request(Msg[] msgArray) throws Exception {
        if (msgArray == null) {
            return null;
        }
        Msg[] msgArray2 = new Msg[msgArray.length];
        int n = 0;
        while (n < msgArray.length) {
            msgArray2[n] = this.request(msgArray[n]);
            ++n;
        }
        return msgArray2;
    }

    public void connect(Hashtable hashtable) throws Exception {
        if (this.isClosed()) {
            this.comm.connectSession(this, hashtable);
        }
    }

    public SoxClient client() {
        return this.soxClient;
    }

    public DaspSession session() {
        return this.session;
    }

    public int localId() {
        DaspSession daspSession = this.session;
        return daspSession == null ? -1 : daspSession.id;
    }

    public int remoteId() {
        DaspSession daspSession = this.session;
        return daspSession == null ? -1 : daspSession.remoteId();
    }

    public boolean isClosed() {
        DaspSession daspSession = this.session;
        if (daspSession == null) {
            return true;
        }
        if (daspSession.isClosed()) {
            this.closeCause = daspSession.closeCause();
            return true;
        }
        return false;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getFile(String string, SoxFile soxFile, Properties properties, ISoxComm.TransferListener transferListener) throws Exception {
        this.fileTransfer = new FileTransfer((ISoxComm)this, string, soxFile, properties, transferListener);
        try {
            Properties properties2 = this.fileTransfer.getFile();
            Object var6_6 = null;
            this.fileTransfer = null;
            return properties2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fileTransfer = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties putFile(String string, SoxFile soxFile, Properties properties, ISoxComm.TransferListener transferListener) throws Exception {
        this.fileTransfer = new FileTransfer((ISoxComm)this, string, soxFile, properties, transferListener);
        try {
            Properties properties2 = this.fileTransfer.putFile();
            Object var6_6 = null;
            this.fileTransfer = null;
            return properties2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fileTransfer = null;
            throw throwable;
        }
    }

    public boolean isSubscribed(SoxComponent soxComponent) {
        return this.device.isSubscribed(soxComponent.id());
    }

    boolean isExpired() {
        if (this.device.isPlatformSessionOpen()) {
            return false;
        }
        if (this.device.getSedonaNetwork().getSessionLingerTime() == 0L) {
            return false;
        }
        if (this.device.isAnySubscribed()) {
            return false;
        }
        BSoxGatewaySpace bSoxGatewaySpace = (BSoxGatewaySpace)this.device.getSoxGateway().getGatewaySpace();
        BComponent[] bComponentArray = bSoxGatewaySpace.getAllComponents();
        int n = 0;
        while (n < bComponentArray.length) {
            if (bComponentArray[n].isSubscribed()) {
                return false;
            }
            ++n;
        }
        boolean bl = false;
        if (this.lastCommTicks + this.device.getSedonaNetwork().getSessionLingerTime() < Clock.ticks()) {
            bl = true;
        }
        return bl;
    }

    void closeSession() {
        if (this.closing) {
            return;
        }
        this.closing = true;
        try {
            DaspSession daspSession = this.session;
            if (daspSession != null) {
                daspSession.close();
            }
            this.session = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.soxClient != null) {
            this.soxClient.closed();
        }
        this.closing = false;
    }

    SoxCommSession(BSedonaBaseDevice bSedonaBaseDevice, DaspSession daspSession, SoxComm soxComm) {
        this.device = bSedonaBaseDevice;
        this.session = daspSession;
        this.comm = soxComm;
        this.lastCommTicks = Clock.ticks();
    }
}

