/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet.driver.comm;

import com.tridium.nsedona.util.StringUtil;
import com.tridium.sedonanet.driver.BSedonaAddress;
import com.tridium.sedonanet.driver.BSedonaBaseDevice;
import com.tridium.sedonanet.driver.BSedonaBaseNetwork;
import com.tridium.sedonanet.driver.comm.ErrorResponseException;
import com.tridium.sedonanet.driver.comm.NoSessionException;
import com.tridium.sedonanet.driver.comm.SedByteArrayUtil;
import com.tridium.sedonanet.driver.comm.SoxCommSession;
import com.tridium.sedonanet.driver.comm.SoxMsg;
import com.tridium.sedonanet.driver.comm.SoxTransaction;
import com.tridium.sedonanet.driver.comm.SoxTransactionManager;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import sedona.dasp.DaspMessage;
import sedona.dasp.DaspSession;
import sedona.dasp.DaspSocket;
import sedona.sox.ISoxComm;
import sedona.sox.Msg;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SoxComm {
    BSedonaBaseNetwork network;
    DaspSocket daspSocket;
    Hashtable dsHash;
    SoxTransactionManager transactionManager;
    boolean commStarted;
    boolean done;
    SoxReceiveDriver rcvDriver;
    Thread rcvThread;
    SoxConnect soxConnect;
    Thread soxThread;
    boolean transactionDebug;
    Log log;

    public void start() throws Exception {
        this.transactionManager.start();
        this.daspSocket = DaspSocket.open((int)-1, null, (int)13);
        this.rcvDriver = new SoxReceiveDriver(this.daspSocket);
        this.rcvThread = new Thread((Runnable)this.rcvDriver, this.network.getName() + ":SoxRcv");
        this.rcvThread.start();
        this.rcvThread.setPriority(5);
        this.soxConnect = new SoxConnect(this);
        this.soxThread = new Thread((Runnable)this.soxConnect, this.network.getName() + ":SoxConnect");
        this.soxThread.start();
        this.soxThread.setPriority(5);
        this.commStarted = true;
    }

    public void stop() throws Exception {
        this.done = true;
        if (this.rcvThread != null) {
            this.rcvDriver.stop();
            this.rcvThread.interrupt();
        }
        if (this.soxThread != null) {
            this.soxConnect.stop();
            this.soxThread.interrupt();
        }
        this.transactionManager.stop();
        this.daspSocket.close();
        this.commStarted = false;
    }

    public SoxMsg sendRequest(BSedonaBaseDevice bSedonaBaseDevice, SoxMsg soxMsg) throws Exception {
        return this.sendRequest(bSedonaBaseDevice, soxMsg, false);
    }

    public SoxMsg sendRequestSynch(BSedonaBaseDevice bSedonaBaseDevice, SoxMsg soxMsg) throws Exception {
        return this.sendRequest(bSedonaBaseDevice, soxMsg, true);
    }

    private final SoxMsg sendRequest(BSedonaBaseDevice bSedonaBaseDevice, SoxMsg soxMsg, boolean bl) throws Exception {
        if (!this.commStarted) {
            throw new BajaRuntimeException("SoxComm not started.");
        }
        SoxCommSession soxCommSession = this.getCommSession(bSedonaBaseDevice, bl);
        if (soxCommSession == null) {
            throw new NoSessionException("No Session for " + bSedonaBaseDevice.getName());
        }
        return (SoxMsg)soxCommSession.request(soxMsg);
    }

    private final void receiveSoxMessage(SoxMsg soxMsg) {
        if (soxMsg.isRequest()) {
            this.handleUnsolicited(soxMsg);
        } else {
            this.handleResponse(soxMsg);
        }
    }

    public SoxCommSession getCommSession(BSedonaBaseDevice bSedonaBaseDevice) {
        return this.getCommSession(bSedonaBaseDevice, false);
    }

    public DaspSession getDaspSession(BSedonaBaseDevice bSedonaBaseDevice) {
        SoxCommSession soxCommSession = this.getCommSession(bSedonaBaseDevice, false);
        return soxCommSession != null ? soxCommSession.session : null;
    }

    public SoxClient getSoxClient(BSedonaBaseDevice bSedonaBaseDevice) throws Exception {
        SoxCommSession soxCommSession = this.getCommSession(bSedonaBaseDevice, true);
        if (soxCommSession == null) {
            throw new NoSessionException("getSoxClient():Cannot create/find SoxCommSession");
        }
        if (soxCommSession.soxClient == null) {
            soxCommSession.soxClient = new SoxClient(this.daspSocket, bSedonaBaseDevice.getAddress().getInetAddress(), bSedonaBaseDevice.getAddress().getSoxPort(), bSedonaBaseDevice.getCredentials().getUsername(), bSedonaBaseDevice.getCredentials().getPassword().getString());
            soxCommSession.soxClient.setComm((ISoxComm)soxCommSession);
            soxCommSession.soxClient.readVersion();
        }
        return soxCommSession.soxClient;
    }

    public SoxCommSession peekCommSession(BSedonaBaseDevice bSedonaBaseDevice) {
        SoxCommSession soxCommSession = (SoxCommSession)this.dsHash.get((Object)bSedonaBaseDevice.getAddress());
        if (soxCommSession != null) {
            DaspSession daspSession = soxCommSession.session;
            if (daspSession == null) {
                this.dsHash.remove((Object)bSedonaBaseDevice.getAddress());
            } else {
                if (!daspSession.isClosed()) {
                    return soxCommSession;
                }
                this.dsHash.remove((Object)bSedonaBaseDevice.getAddress());
            }
        }
        return null;
    }

    public DaspSession peekDaspSession(BSedonaBaseDevice bSedonaBaseDevice) {
        SoxCommSession soxCommSession = (SoxCommSession)this.dsHash.get((Object)bSedonaBaseDevice.getAddress());
        if (soxCommSession == null) {
            return null;
        }
        DaspSession daspSession = soxCommSession.session;
        if (daspSession == null || daspSession.isClosed()) {
            this.dsHash.remove((Object)bSedonaBaseDevice.getAddress());
            return null;
        }
        return daspSession;
    }

    public SoxClient peekSoxClient(BSedonaBaseDevice bSedonaBaseDevice) {
        SoxCommSession soxCommSession = this.peekCommSession(bSedonaBaseDevice);
        if (soxCommSession == null) {
            return null;
        }
        return soxCommSession.soxClient;
    }

    void connectSession(SoxCommSession soxCommSession, Hashtable hashtable) throws Exception {
        BSedonaAddress bSedonaAddress = soxCommSession.device.getAddress();
        BUsernameAndPassword bUsernameAndPassword = soxCommSession.device.getCredentials();
        DaspSession daspSession = this.daspSocket.connect(bSedonaAddress.getInetAddress(), bSedonaAddress.getSoxPort(), bUsernameAndPassword.getUsername(), bUsernameAndPassword.getPassword().getString(), hashtable);
        daspSession.userData = soxCommSession.device;
        daspSession.traceSend = daspSession.traceReceive = soxCommSession.device.getTraceDasp();
        daspSession.listener = new SessionClosedListener();
        soxCommSession.session = daspSession;
        this.dsHash.put(bSedonaAddress, soxCommSession);
        soxCommSession.device.pingOk();
        soxCommSession.device.resubscribe();
    }

    public void endSession(BSedonaBaseDevice bSedonaBaseDevice) {
        this.soxConnect.disconnectDevice(bSedonaBaseDevice);
    }

    private final SoxCommSession getCommSession(BSedonaBaseDevice bSedonaBaseDevice, boolean bl) {
        Object object;
        SoxCommSession soxCommSession = (SoxCommSession)this.dsHash.get((Object)bSedonaBaseDevice.getAddress());
        if (soxCommSession != null) {
            object = soxCommSession.session;
            if (object == null) {
                this.dsHash.remove((Object)bSedonaBaseDevice.getAddress());
            } else {
                if (!object.isClosed()) {
                    return soxCommSession;
                }
                this.dsHash.remove((Object)bSedonaBaseDevice.getAddress());
            }
        }
        if (this.daspSocket.isClosed()) {
            bSedonaBaseDevice.pingFail("Socket is closed.");
            return null;
        }
        if (this.xdbg()) {
            object = bSedonaBaseDevice.getAddress();
            try {
                this.log.trace("No session match in dsHash: dev addr=" + object + "; hC=" + object.hashCode() + "; hK=" + ((BSedonaAddress)((Object)object)).hashKey());
            }
            catch (Exception exception) {
                this.log.trace("No session match in dsHash: dev addr=" + object + "; hC=" + object.hashCode() + "; hK=" + exception.toString());
            }
            this.dumpDsHash();
        }
        if (bl) {
            return this.soxConnect.connectDeviceSynch(bSedonaBaseDevice);
        }
        this.soxConnect.connectDevice(bSedonaBaseDevice);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void handleResponse(SoxMsg soxMsg) {
        int n = soxMsg.replyNum() & 0xFF;
        SoxTransaction soxTransaction = this.transactionManager.getTransactionMatch(n);
        if (soxTransaction == null) {
            this.log.warning("Received response message with no matching transaction.\n" + (Object)((Object)soxMsg));
            return;
        }
        if (this.network.getLinkDebug()) {
            this.log.trace(StringUtil.timeStampMSec() + ": xact delta " + soxTransaction.delta);
        }
        SoxTransaction soxTransaction2 = soxTransaction;
        synchronized (soxTransaction2) {
            soxTransaction.timeOut = false;
            if (soxMsg.isFailed()) {
                soxMsg.seek(2);
                String string = "replyNum:0x" + Integer.toHexString(soxMsg.replyNum());
                try {
                    string = string + " err:" + soxMsg.str();
                }
                catch (IOException iOException) {}
                soxTransaction.exception = new ErrorResponseException(string);
                this.xdbg("%%N-" + soxTransaction.tag);
            } else {
                soxTransaction.responseMessage = soxMsg;
                this.xdbg("%%N+" + soxTransaction.tag);
            }
            soxTransaction.notify();
            return;
        }
    }

    private final void handleUnsolicited(SoxMsg soxMsg) {
        int n = soxMsg.getCommand();
        BSedonaBaseDevice bSedonaBaseDevice = soxMsg.device;
        SoxCommSession soxCommSession = (SoxCommSession)this.dsHash.get((Object)bSedonaBaseDevice.getAddress());
        if (soxCommSession != null) {
            soxCommSession.lastCommTicks = Clock.ticks();
        }
        switch (n) {
            case 101: {
                boolean bl = false;
                if (soxCommSession != null) {
                    try {
                        soxMsg.seek(2);
                        int n2 = soxMsg.u2();
                        SoxComponent soxComponent = soxCommSession.soxClient.cache(n2);
                        if (soxComponent != null && soxComponent.subscription() != 0) {
                            bl = true;
                        }
                        soxMsg.seek(2);
                        soxCommSession.soxClient.applyToCache((Msg)soxMsg, false);
                    }
                    catch (Exception exception) {
                        this.log.message("Cannot apply event to SoxClient cache:", (Throwable)exception);
                    }
                }
                soxMsg.seek(0);
                bSedonaBaseDevice.receiveEvent(soxMsg, bl);
                break;
            }
            case 107: {
                if (soxCommSession == null) break;
                soxCommSession.fileTransfer.receiveChunk((Msg)soxMsg);
                break;
            }
            case 122: {
                if (soxCommSession == null) break;
                soxCommSession.fileTransfer.receiveClose((Msg)soxMsg);
                break;
            }
            default: {
                this.log.warning("Received unhandled message type.\n" + (Object)((Object)soxMsg));
            }
        }
    }

    private final synchronized void clearUnusedSessions() {
        Iterator iterator = this.dsHash.keySet().iterator();
        while (iterator.hasNext()) {
            BSedonaAddress bSedonaAddress = (BSedonaAddress)((Object)iterator.next());
            SoxCommSession soxCommSession = (SoxCommSession)this.dsHash.get((Object)bSedonaAddress);
            if (!soxCommSession.isExpired()) continue;
            if (this.log.isTraceOn()) {
                this.log.trace("Removing unused DASP session: " + this.sessionToString(soxCommSession.session) + " address " + (Object)((Object)bSedonaAddress));
            }
            soxCommSession.closeSession();
            this.dsHash.remove((Object)bSedonaAddress);
        }
    }

    public DaspSocket getDaspSocket() {
        return this.daspSocket;
    }

    public String toString() {
        if (this.daspSocket != null) {
            return "SoxComm [" + this.daspSocket.port() + ']';
        }
        return "SoxComm [closed]";
    }

    private final String sessionToString(DaspSession daspSession) {
        if (daspSession == null) {
            return "NULL SESSION";
        }
        if (daspSession.isClosed()) {
            return "CLOSED - " + daspSession.toString();
        }
        return daspSession.toString();
    }

    private final void dumpDsHash() {
        Iterator iterator = this.dsHash.keySet().iterator();
        while (iterator.hasNext()) {
            BSedonaAddress bSedonaAddress = (BSedonaAddress)((Object)iterator.next());
            SoxCommSession soxCommSession = (SoxCommSession)this.dsHash.get((Object)bSedonaAddress);
            DaspSession daspSession = soxCommSession.session;
            try {
                System.out.println("k(adr):" + (Object)((Object)bSedonaAddress) + " [,hC:" + bSedonaAddress.hashCode() + "; hK:" + bSedonaAddress.hashKey() + "] ==> v(DaspSess):" + this.sessionToString(daspSession) + " lastTix=" + soxCommSession.lastCommTicks);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void spy(SpyWriter spyWriter) throws Exception {
        DaspSocket daspSocket = this.daspSocket;
        if (daspSocket.isClosed()) {
            spyWriter.w((Object)"DaspSocket is closed");
        } else {
            spyWriter.startProps("DaspSocket");
            spyWriter.prop((Object)"isClosed", daspSocket.isClosed());
            spyWriter.prop((Object)"local port", daspSocket.port());
            spyWriter.prop((Object)"number of sessions", daspSocket.sessions().length);
            spyWriter.endProps();
        }
        spyWriter.startTable(true);
        spyWriter.trTitle((Object)"Sox Comm Sessions", 6);
        spyWriter.w((Object)"<tr>").th((Object)"Address").th((Object)"Device").th((Object)"DASP Session").th((Object)"Last Comm Ticks").th((Object)"SoxClient").th((Object)"Close Cause").w((Object)"</tr>\n");
        Hashtable hashtable = this.dsHash;
        synchronized (hashtable) {
            Iterator iterator = this.dsHash.keySet().iterator();
            while (iterator.hasNext()) {
                BSedonaAddress bSedonaAddress = (BSedonaAddress)((Object)iterator.next());
                SoxCommSession soxCommSession = (SoxCommSession)this.dsHash.get((Object)bSedonaAddress);
                spyWriter.tr((Object)bSedonaAddress, (Object)soxCommSession.device, (Object)this.sessionToString(soxCommSession.session), (Object)("" + soxCommSession.lastCommTicks), (Object)soxCommSession.soxClient, (Object)soxCommSession.closeCause);
            }
        }
        spyWriter.endTable();
        long l = Clock.ticks();
        long l2 = l - this.network.getSessionLingerTime();
        if (l2 < 0L) {
            l2 = 0L;
        }
        spyWriter.startProps();
        spyWriter.prop((Object)"expireTime", (Object)("" + l2));
        spyWriter.endProps();
        this.soxConnect.spy(spyWriter);
        this.transactionManager.spy(spyWriter);
    }

    void writeLinkDebug(String string, String string2, byte[] byArray, int n) {
        if (this.network.getLinkDebug()) {
            this.log.trace(StringUtil.timeStampMSec() + string + string2 + ':' + (char)byArray[0] + ' ' + SedByteArrayUtil.toString(byArray, n));
        }
    }

    public void dumpTransactions() {
        this.transactionManager.dump();
    }

    public void clearTransactions() {
        this.transactionManager.clear();
    }

    boolean xdbg() {
        boolean bl = false;
        if (this.transactionDebug || this.network.getTransactionDebug()) {
            bl = true;
        }
        return bl;
    }

    void xdbg(Object object) {
        if (this.transactionDebug || this.network.getTransactionDebug()) {
            this.log.trace("" + object);
        }
    }

    private final /* synthetic */ void this() {
        this.dsHash = new Hashtable();
        this.commStarted = false;
        this.done = true;
        this.rcvThread = null;
        this.soxThread = null;
        this.transactionDebug = false;
    }

    public SoxComm(BSedonaBaseNetwork bSedonaBaseNetwork) {
        this.this();
        this.network = bSedonaBaseNetwork;
        this.log = this.network.getLogSox();
        this.transactionManager = new SoxTransactionManager(this);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SoxReceiveDriver
    implements Runnable {
        private DaspSocket daspSocket;

        public void run() {
            SoxComm.this.done = false;
            while (!SoxComm.this.done) {
                try {
                    DaspMessage daspMessage = this.daspSocket.receive((long)-1);
                    byte[] byArray = daspMessage.payload();
                    BSedonaBaseDevice bSedonaBaseDevice = (BSedonaBaseDevice)daspMessage.session().userData;
                    SoxMsg soxMsg = SoxMsg.make(bSedonaBaseDevice, byArray, byArray.length);
                    SoxComm.this.writeLinkDebug("|rcvd:", bSedonaBaseDevice != null ? bSedonaBaseDevice.getAddress().toDebugString() : "null addr", byArray, byArray.length);
                    SoxComm.this.receiveSoxMessage(soxMsg);
                }
                catch (ThreadDeath threadDeath) {
                    SoxComm.this.done = true;
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }

        void stop() {
            SoxComm.this.done = true;
        }

        public SoxReceiveDriver(DaspSocket daspSocket) {
            this.daspSocket = daspSocket;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SoxConnect
    implements Runnable {
        SoxComm comm;
        Vector devsToAdd;
        Vector devsToRem;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            SoxComm.this.done = false;
            while (!SoxComm.this.done) {
                try {
                    SoxCommSession soxCommSession;
                    BSedonaAddress bSedonaAddress;
                    BSedonaBaseDevice bSedonaBaseDevice;
                    block14: {
                        BSedonaBaseDevice bSedonaBaseDevice2 = null;
                        bSedonaBaseDevice = null;
                        SoxConnect soxConnect = this;
                        synchronized (soxConnect) {
                            while (true) {
                                if (this.devsToAdd.size() > 0 || this.devsToRem.size() > 0) {
                                    if (this.devsToAdd.size() > 0) {
                                        bSedonaBaseDevice2 = (BSedonaBaseDevice)this.devsToAdd.remove(0);
                                    }
                                    if (this.devsToRem.size() > 0) {
                                        bSedonaBaseDevice = (BSedonaBaseDevice)this.devsToRem.remove(0);
                                    }
                                    // MONITOREXIT @DISABLED, blocks:[0, 2, 6, 7, 13] lbl19 : MonitorExitStatement: MONITOREXIT : var3_4
                                    if (bSedonaBaseDevice2 != null) {
                                        break;
                                    }
                                    break block14;
                                }
                                SoxComm.this.clearUnusedSessions();
                                this.wait(5000L);
                            }
                        }
                        bSedonaAddress = bSedonaBaseDevice2.getAddress();
                        soxCommSession = (SoxCommSession)SoxComm.this.dsHash.get((Object)bSedonaAddress);
                        if (soxCommSession != null) continue;
                        if (SoxComm.this.log.isTraceOn()) {
                            SoxComm.this.log.trace("Attempting to create a session for " + bSedonaBaseDevice2.getName());
                        }
                        BUsernameAndPassword bUsernameAndPassword = bSedonaBaseDevice2.getCredentials();
                        DaspSession daspSession = SoxComm.this.daspSocket.connect(bSedonaAddress.getInetAddress(), bSedonaAddress.getSoxPort(), bUsernameAndPassword.getUsername(), bUsernameAndPassword.getPassword().getString());
                        daspSession.userData = bSedonaBaseDevice2;
                        daspSession.traceSend = daspSession.traceReceive = bSedonaBaseDevice2.getTraceDasp();
                        daspSession.listener = new SessionClosedListener();
                        SoxComm.this.dsHash.put(bSedonaAddress, new SoxCommSession(bSedonaBaseDevice2, daspSession, this.comm));
                        bSedonaBaseDevice2.pingOk();
                        bSedonaBaseDevice2.resubscribe();
                    }
                    if (bSedonaBaseDevice == null || (soxCommSession = (SoxCommSession)SoxComm.this.dsHash.get((Object)(bSedonaAddress = bSedonaBaseDevice.getAddress()))) == null) continue;
                    if (SoxComm.this.log.isTraceOn()) {
                        SoxComm.this.log.trace("Close session for " + bSedonaBaseDevice.getName());
                    }
                    soxCommSession.session.close();
                    SoxComm.this.dsHash.remove((Object)bSedonaAddress);
                }
                catch (ThreadDeath threadDeath) {
                    SoxComm.this.done = true;
                }
                catch (Throwable throwable) {}
            }
        }

        synchronized void connectDevice(BSedonaBaseDevice bSedonaBaseDevice) {
            if (!this.devsToAdd.contains(bSedonaBaseDevice)) {
                this.devsToAdd.add(bSedonaBaseDevice);
            }
            this.notifyAll();
        }

        synchronized SoxCommSession connectDeviceSynch(BSedonaBaseDevice bSedonaBaseDevice) {
            try {
                DaspSession daspSession;
                BSedonaAddress bSedonaAddress = bSedonaBaseDevice.getAddress();
                SoxCommSession soxCommSession = (SoxCommSession)SoxComm.this.dsHash.get((Object)bSedonaAddress);
                if (soxCommSession != null) {
                    daspSession = soxCommSession.session;
                    if (daspSession == null) {
                        SoxComm.this.dsHash.remove((Object)bSedonaAddress);
                    } else {
                        if (!daspSession.isClosed()) {
                            return soxCommSession;
                        }
                        SoxComm.this.dsHash.remove((Object)bSedonaAddress);
                    }
                }
                if (SoxComm.this.log.isTraceOn()) {
                    SoxComm.this.log.trace("Attempting to SYNCHRONOUSLY create a session for " + bSedonaBaseDevice.getName());
                }
                daspSession = bSedonaBaseDevice.getCredentials();
                DaspSession daspSession2 = SoxComm.this.daspSocket.connect(bSedonaAddress.getInetAddress(), bSedonaAddress.getSoxPort(), daspSession.getUsername(), daspSession.getPassword().getString());
                daspSession2.userData = bSedonaBaseDevice;
                daspSession2.traceSend = daspSession2.traceReceive = bSedonaBaseDevice.getTraceDasp();
                daspSession2.listener = new SessionClosedListener();
                soxCommSession = new SoxCommSession(bSedonaBaseDevice, daspSession2, this.comm);
                SoxComm.this.dsHash.put(bSedonaAddress, soxCommSession);
                bSedonaBaseDevice.pingOk();
                bSedonaBaseDevice.resubscribe();
                return soxCommSession;
            }
            catch (Exception exception) {
                if (SoxComm.this.log.isTraceOn()) {
                    SoxComm.this.log.trace("Exception in synchronous connection to " + bSedonaBaseDevice + ':' + exception, (Throwable)exception);
                } else {
                    SoxComm.this.log.message("Exception in synchronous connection to " + bSedonaBaseDevice + ':' + exception);
                }
                return null;
            }
        }

        synchronized void disconnectDevice(BSedonaBaseDevice bSedonaBaseDevice) {
            if (!this.devsToRem.contains(bSedonaBaseDevice)) {
                this.devsToRem.add(bSedonaBaseDevice);
            }
            this.notifyAll();
        }

        public void spy(SpyWriter spyWriter) throws Exception {
            spyWriter.startProps("SoxComm$SoxConnect");
            spyWriter.prop((Object)"devsToAdd", this.devsToAdd.size());
            Iterator iterator = this.devsToAdd.iterator();
            while (iterator.hasNext()) {
                spyWriter.prop((Object)"  ", iterator.next());
            }
            spyWriter.prop((Object)"devsToRem", this.devsToRem.size());
            iterator = this.devsToRem.iterator();
            while (iterator.hasNext()) {
                spyWriter.prop((Object)"  ", iterator.next());
            }
            spyWriter.endProps();
        }

        void stop() {
            SoxComm.this.done = true;
        }

        private final /* synthetic */ void this() {
            this.devsToAdd = new Vector();
            this.devsToRem = new Vector();
        }

        SoxConnect(SoxComm soxComm2) {
            this.this();
            this.comm = soxComm2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SessionClosedListener
    implements DaspSession.Listener {
        public void daspSessionClosed(DaspSession daspSession) {
            BSedonaBaseDevice bSedonaBaseDevice = (BSedonaBaseDevice)daspSession.userData;
            String string = daspSession.closeCause();
            SoxComm.this.log.trace("DASP Session closed on device " + bSedonaBaseDevice + "::" + string);
            bSedonaBaseDevice.sessionClosed(daspSession);
            SoxCommSession soxCommSession = (SoxCommSession)SoxComm.this.dsHash.get((Object)bSedonaBaseDevice.getAddress());
            if (soxCommSession != null) {
                soxCommSession.closeSession();
            }
        }

        private SessionClosedListener() {
        }
    }
}

