/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet.driver;

import com.tridium.sedonanet.driver.BRefreshDeviceInfoTask;
import com.tridium.sedonanet.driver.BSedonaBaseDevice;
import com.tridium.sedonanet.driver.BSedonaBaseNetwork;
import javax.baja.driver.BDeviceExt;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Lexicon;
import sedona.Kit;
import sedona.Schema;
import sedona.Slot;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSedonaDeviceInfoExt
extends BDeviceExt {
    public static final Property platformId = BSedonaDeviceInfoExt.newProperty((int)1, (String)"", null);
    public static final Property platformVersion = BSedonaDeviceInfoExt.newProperty((int)1, (String)"", null);
    public static final Property appName = BSedonaDeviceInfoExt.newProperty((int)1, (String)"", null);
    public static final Property deviceName = BSedonaDeviceInfoExt.newProperty((int)1, (String)"", null);
    public static final Property refreshTask = BSedonaDeviceInfoExt.newProperty((int)0, (BValue)new BRefreshDeviceInfoTask(), null);
    public static final Action refresh = BSedonaDeviceInfoExt.newAction((int)16, null);
    public static final Type TYPE;
    SoxComponent platformService;
    BStatus oldStatus;
    Lexicon lex;
    static /* synthetic */ Class class$com$tridium$sedonanet$driver$BSedonaDeviceInfoExt;

    public String getPlatformId() {
        return this.getString(platformId);
    }

    public void setPlatformId(String string) {
        this.setString(platformId, string, null);
    }

    public String getPlatformVersion() {
        return this.getString(platformVersion);
    }

    public void setPlatformVersion(String string) {
        this.setString(platformVersion, string, null);
    }

    public String getAppName() {
        return this.getString(appName);
    }

    public void setAppName(String string) {
        this.setString(appName, string, null);
    }

    public String getDeviceName() {
        return this.getString(deviceName);
    }

    public void setDeviceName(String string) {
        this.setString(deviceName, string, null);
    }

    public BRefreshDeviceInfoTask getRefreshTask() {
        return (BRefreshDeviceInfoTask)this.get(refreshTask);
    }

    public void setRefreshTask(BRefreshDeviceInfoTask bRefreshDeviceInfoTask) {
        this.set(refreshTask, (BValue)bRefreshDeviceInfoTask, null);
    }

    public void refresh() {
        this.invoke(refresh, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void updateStatus() {
        BStatus bStatus = this.getDevice().getStatus();
        if (!bStatus.isDown() && this.oldStatus.isDown() || !bStatus.isDisabled() && this.oldStatus.isDisabled()) {
            this.clear();
            this.getRefreshTask().schedule();
        }
        this.oldStatus = bStatus;
    }

    public final BSedonaBaseNetwork getSedonaNetwork() {
        return (BSedonaBaseNetwork)this.getNetwork();
    }

    public final BSedonaBaseDevice getSedonaDevice() {
        return (BSedonaBaseDevice)this.getDevice();
    }

    public void clear() {
        this.platformService = null;
        this.setPlatformId("");
        this.setPlatformVersion("");
        this.setAppName("");
        this.setDeviceName("");
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action.equals((Object)refresh)) {
            return this.getSedonaNetwork().postAsync(new Runnable(){

                public final void run() {
                    block2: {
                        BSedonaBaseDevice bSedonaBaseDevice = BSedonaDeviceInfoExt.this.getSedonaDevice();
                        try {
                            BSedonaDeviceInfoExt.this.doRefresh();
                        }
                        catch (Exception exception) {
                            bSedonaBaseDevice.sedLog().message("Refresh device info failed for " + BSedonaDeviceInfoExt.this.getSedonaDevice() + ':' + exception);
                            if (!bSedonaBaseDevice.sedLog().isTraceOn()) break block2;
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }
        return super.post(action, bValue, context);
    }

    public void doRefresh() throws Exception {
        BSedonaBaseDevice bSedonaBaseDevice = this.getSedonaDevice();
        BStatus bStatus = bSedonaBaseDevice.getStatus();
        if (bStatus.isDown() || bStatus.isDisabled()) {
            throw new IllegalStateException(this.lex.getText("deviceInfoExt.deviceIs", new Object[]{bSedonaBaseDevice.getStatus()}));
        }
        if (bSedonaBaseDevice.isFatalFault()) {
            throw new IllegalStateException(this.lex.getText("deviceInfoExt.fatalFault"));
        }
        SoxClient soxClient = bSedonaBaseDevice.makeSoxClient(false);
        soxClient.connect();
        SoxComponent soxComponent = soxClient.loadApp();
        bSedonaBaseDevice.pingOk();
        if (this.getPlatformService(soxComponent) == null) {
            bSedonaBaseDevice.configFail(this.lex.getText("deviceInfoExt.noPlatSvc"));
            throw new IllegalStateException(this.lex.getText("deviceInfoExt.noPlatSvc"));
        }
        soxClient.load(this.platformService.id());
        Slot slot = this.platformService.slot("platformId");
        if (slot != null) {
            this.setPlatformId(soxClient.readProp(this.platformService, slot).toString());
        }
        if ((slot = this.platformService.slot("platformVer")) != null) {
            this.setPlatformVersion(soxClient.readProp(this.platformService, slot).toString());
        }
        if ((slot = soxComponent.slot("appName")) != null) {
            this.setAppName(soxClient.readProp(soxComponent, slot).toString());
        }
        if ((slot = soxComponent.slot("deviceName")) != null) {
            this.setDeviceName(soxClient.readProp(soxComponent, slot).toString());
        }
        bSedonaBaseDevice.configOk();
    }

    private final SoxComponent getPlatformService(SoxComponent soxComponent) throws Exception {
        if (this.platformService != null && this.platformService.client() == soxComponent.client()) {
            return this.platformService;
        }
        Schema schema = this.getSedonaDevice().makeSoxClient(false).readSchema();
        Kit kit = schema.kit("sys");
        sedona.Type type = kit.type("PlatformService");
        this.platformService = this.findPlatformService(type, soxComponent);
        return this.platformService;
    }

    private final SoxComponent findPlatformService(sedona.Type type, SoxComponent soxComponent) {
        SoxComponent[] soxComponentArray = soxComponent.children();
        int n = 0;
        while (n < soxComponentArray.length) {
            SoxComponent soxComponent2 = soxComponentArray[n];
            if (soxComponent2.type.is(type)) {
                return soxComponent2;
            }
            SoxComponent soxComponent3 = this.findPlatformService(type, soxComponent2);
            if (soxComponent3 != null) {
                return soxComponent3;
            }
            ++n;
        }
        return null;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.platformService = null;
        this.oldStatus = BStatus.ok;
        this.lex = Lexicon.make((String)"sedonanet");
    }

    public BSedonaDeviceInfoExt() {
        this.this();
    }

    public BSedonaDeviceInfoExt(BRelTime bRelTime) {
        this.this();
        this.getRefreshTask().setDelay(bRelTime);
    }

    static {
        Class clazz = class$com$tridium$sedonanet$driver$BSedonaDeviceInfoExt;
        if (clazz == null) {
            clazz = class$com$tridium$sedonanet$driver$BSedonaDeviceInfoExt = BSedonaDeviceInfoExt.class("[Lcom.tridium.sedonanet.driver.BSedonaDeviceInfoExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

