/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet.driver;

import com.tridium.sedonanet.chopan.BChopanServer;
import com.tridium.sedonanet.driver.BChangeSuperuserJob;
import com.tridium.sedonanet.driver.BSedonaAddress;
import com.tridium.sedonanet.driver.BSedonaBaseDevice;
import com.tridium.sedonanet.driver.BSedonaCommConfig;
import com.tridium.sedonanet.driver.BSedonaDeviceDiscoveryConfig;
import com.tridium.sedonanet.driver.BSedonaLearnDeviceEntry;
import com.tridium.sedonanet.driver.BSedonaLearnDevicesJob;
import com.tridium.sedonanet.driver.comm.ChopanComm;
import com.tridium.sedonanet.driver.comm.SoxComm;
import com.tridium.sedonanet.driver.point.BSedonaPollScheduler;
import com.tridium.sedonanet.driver.point.BSedonaTuningPolicy;
import com.tridium.sedonanet.driver.point.BSedonaTuningPolicyMap;
import com.tridium.util.ComponentTreeCursor;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.InetAddress;
import javax.baja.agent.AgentList;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.file.FileUtil;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BLink;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.IFuture;
import javax.baja.util.Queue;
import javax.baja.util.Worker;
import sedona.KitPart;
import sedona.manifest.ManifestDb;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BSedonaBaseNetwork
extends BDeviceNetwork
implements BIService {
    public static final Property tuningPolicies = BSedonaBaseNetwork.newProperty((int)0, (BValue)new BSedonaTuningPolicyMap(), null);
    public static final Property pollScheduler = BSedonaBaseNetwork.newProperty((int)0, (BValue)new BSedonaPollScheduler(), null);
    public static final Property commConfig = BSedonaBaseNetwork.newProperty((int)0, (BValue)new BSedonaCommConfig(), null);
    public static final Property chopanServer = BSedonaBaseNetwork.newProperty((int)4, (BValue)new BChopanServer(), null);
    public static final Property linkDebug = BSedonaBaseNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property transactionDebug = BSedonaBaseNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property timeSyncTrigger = BSedonaBaseNetwork.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BManualTriggerMode.make()), null);
    public static final Property shareSessions = BSedonaBaseNetwork.newProperty((int)4, (boolean)true, null);
    public static final Action manifestManagement = BSedonaBaseNetwork.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Action submitDeviceDiscoveryJob = BSedonaBaseNetwork.newAction((int)4, (BValue)new BSedonaDeviceDiscoveryConfig(), null);
    public static final Action dumpSoxTransactions = BSedonaBaseNetwork.newAction((int)4, null);
    public static final Action clearSoxTransactions = BSedonaBaseNetwork.newAction((int)132, null);
    public static final Action submitSuperuserJob = BSedonaBaseNetwork.newAction((int)4, (BValue)new BUsernameAndPassword(), null);
    public static final Action syncTime = BSedonaBaseNetwork.newAction((int)0, null);
    public static final Topic servicePinReceived = BSedonaBaseNetwork.newTopic((int)4, null);
    public static final Type TYPE;
    public static final Context networkTimeSync;
    private Log log;
    private Log logSox;
    private Log logCho;
    SoxComm comm;
    ChopanComm chopanComm;
    boolean networkRunning;
    Worker workQueue;
    Worker coalesceQueue;
    static /* synthetic */ Class class$com$tridium$sedonanet$driver$BSedonaBaseNetwork;
    static /* synthetic */ Class class$com$tridium$sedonanet$driver$BSedonaBaseDevice;
    static /* synthetic */ Class class$javax$baja$nav$BINavNode;

    public BSedonaTuningPolicyMap getTuningPolicies() {
        return (BSedonaTuningPolicyMap)this.get(tuningPolicies);
    }

    public void setTuningPolicies(BSedonaTuningPolicyMap bSedonaTuningPolicyMap) {
        this.set(tuningPolicies, (BValue)bSedonaTuningPolicyMap, null);
    }

    public BSedonaPollScheduler getPollScheduler() {
        return (BSedonaPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BSedonaPollScheduler bSedonaPollScheduler) {
        this.set(pollScheduler, (BValue)bSedonaPollScheduler, null);
    }

    public BSedonaCommConfig getCommConfig() {
        return (BSedonaCommConfig)this.get(commConfig);
    }

    public void setCommConfig(BSedonaCommConfig bSedonaCommConfig) {
        this.set(commConfig, (BValue)bSedonaCommConfig, null);
    }

    public BChopanServer getChopanServer() {
        return (BChopanServer)this.get(chopanServer);
    }

    public void setChopanServer(BChopanServer bChopanServer) {
        this.set(chopanServer, (BValue)bChopanServer, null);
    }

    public boolean getLinkDebug() {
        return this.getBoolean(linkDebug);
    }

    public void setLinkDebug(boolean bl) {
        this.setBoolean(linkDebug, bl, null);
    }

    public boolean getTransactionDebug() {
        return this.getBoolean(transactionDebug);
    }

    public void setTransactionDebug(boolean bl) {
        this.setBoolean(transactionDebug, bl, null);
    }

    public BTimeTrigger getTimeSyncTrigger() {
        return (BTimeTrigger)this.get(timeSyncTrigger);
    }

    public void setTimeSyncTrigger(BTimeTrigger bTimeTrigger) {
        this.set(timeSyncTrigger, (BValue)bTimeTrigger, null);
    }

    public boolean getShareSessions() {
        return this.getBoolean(shareSessions);
    }

    public void setShareSessions(boolean bl) {
        this.setBoolean(shareSessions, bl, null);
    }

    public BString manifestManagement(BString bString) {
        return (BString)this.invoke(manifestManagement, (BValue)bString, null);
    }

    public BOrd submitDeviceDiscoveryJob(BSedonaDeviceDiscoveryConfig bSedonaDeviceDiscoveryConfig) {
        return (BOrd)this.invoke(submitDeviceDiscoveryJob, (BValue)bSedonaDeviceDiscoveryConfig, null);
    }

    public void dumpSoxTransactions() {
        this.invoke(dumpSoxTransactions, null, null);
    }

    public void clearSoxTransactions() {
        this.invoke(clearSoxTransactions, null, null);
    }

    public BOrd submitSuperuserJob(BUsernameAndPassword bUsernameAndPassword) {
        return (BOrd)this.invoke(submitSuperuserJob, (BValue)bUsernameAndPassword, null);
    }

    public void syncTime() {
        this.invoke(syncTime, null, null);
    }

    public void fireServicePinReceived(BSedonaAddress bSedonaAddress) {
        this.fire(servicePinReceived, (BValue)bSedonaAddress, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public final void serviceStarted() {
        try {
            this.log = Log.getLog((String)("sedona-" + this.getName()));
            this.logSox = Log.getLog((String)(this.log.getLogName() + ".sox"));
            this.logCho = Log.getLog((String)(this.log.getLogName() + ".chopan"));
            this.checkSedonaProperties();
            if (this.workQueue == null) {
                this.workQueue = new WaitWorker((Worker.ITodo)new Queue(1000));
            }
            if (this.coalesceQueue == null) {
                this.coalesceQueue = new WaitWorker((Worker.ITodo)new CoalesceQueue(1000));
            }
            this.workQueue.start(this.getName() + ":async");
            this.coalesceQueue.start(this.getName() + ":asyncEvent");
            this.startComm();
            this.networkRunning = true;
            this.configOk();
        }
        catch (Throwable throwable) {
            this.getLog().error("Error initializing SedonaNetwork " + this.getName(), throwable);
            this.configFail(throwable.getMessage());
        }
        this.onServiceStarted();
    }

    public void onServiceStarted() {
    }

    public final void serviceStopped() {
        this.stopComm();
        if (this.workQueue != null) {
            this.workQueue.stop();
            this.workQueue = null;
        }
        if (this.coalesceQueue != null) {
            this.coalesceQueue.stop();
            this.coalesceQueue = null;
        }
        this.networkRunning = false;
        this.onServiceStopped();
    }

    public void onServiceStopped() {
    }

    /*
     * Exception decompiling
     */
    private final void checkSedonaProperties() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 217->221)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "sedonanet");
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        BSedonaBaseDevice[] bSedonaBaseDeviceArray = this.getDeviceList();
        int n = 0;
        while (n < bSedonaBaseDeviceArray.length) {
            try {
                bSedonaBaseDeviceArray[n].ping();
            }
            catch (Exception exception) {}
            ++n;
        }
        this.add(null, (BValue)new BLink(this.getTimeSyncTrigger().getOrdInSession(), "fireTrigger", "syncTime", true), 6);
    }

    public IFuture postAsync(Runnable runnable) {
        if (!this.networkRunning || !this.workQueue.isRunning()) {
            throw new NotRunningException();
        }
        ((Queue)this.workQueue.getTodo()).enqueue((Object)runnable);
        return null;
    }

    public IFuture postWrite(Runnable runnable) {
        if (!this.networkRunning || !this.coalesceQueue.isRunning()) {
            throw new NotRunningException();
        }
        ((Queue)this.coalesceQueue.getTodo()).enqueue((Object)runnable);
        return null;
    }

    public void childUnparented(Property property, BValue bValue, Context context) {
        super.childUnparented(property, bValue, context);
        if (!this.isRunning()) {
            return;
        }
        if (bValue instanceof BSedonaBaseDevice) {
            this.comm.endSession((BSedonaBaseDevice)bValue);
        }
    }

    public void tuningChanged(BSedonaTuningPolicy bSedonaTuningPolicy, Context context) {
        BSedonaBaseDevice[] bSedonaBaseDeviceArray = this.getDeviceList();
        int n = 0;
        while (n < bSedonaBaseDeviceArray.length) {
            bSedonaBaseDeviceArray[n].tuningChanged(bSedonaTuningPolicy, context);
            ++n;
        }
    }

    public boolean atNetworkSteadyState() {
        return Sys.atSteadyState();
    }

    /*
     * Unable to fully structure code
     */
    public BSedonaBaseDevice[] getDeviceList() {
        v0 = BSedonaBaseNetwork.class$com$tridium$sedonanet$driver$BSedonaBaseDevice;
        if (v0 == null) {
            v0 = BSedonaBaseNetwork.class$com$tridium$sedonanet$driver$BSedonaBaseDevice = BSedonaBaseNetwork.class("[Lcom.tridium.sedonanet.driver.BSedonaBaseDevice;", false);
        }
        var1_1 = new Array(v0);
        var2_2 = new ComponentTreeCursor((BComponent)this, null);
        if (true) ** GOTO lbl10
        do {
            var1_1.add((Object)var2_2.get());
lbl10:
            // 2 sources

            if ((v1 = BSedonaBaseNetwork.class$com$tridium$sedonanet$driver$BSedonaBaseDevice) != null) continue;
            v1 = BSedonaBaseNetwork.class("[Lcom.tridium.sedonanet.driver.BSedonaBaseDevice;", false);
        } while (var2_2.next(v1));
        return (BSedonaBaseDevice[])var1_1.trim();
    }

    public SoxComm comm() {
        return this.comm;
    }

    public ChopanComm chopanComm() {
        return this.chopanComm;
    }

    public void doDumpSoxTransactions() {
        this.comm().dumpTransactions();
    }

    public void doClearSoxTransactions() {
        this.comm().clearTransactions();
    }

    public long getSessionLingerTime() {
        return this.getCommConfig().getSessionLingerTime() * 1000L;
    }

    public void doSyncTime(Context context) {
        BSedonaBaseDevice[] bSedonaBaseDeviceArray = this.getDeviceList();
        int n = 0;
        while (n < bSedonaBaseDeviceArray.length) {
            bSedonaBaseDeviceArray[n].invoke(BSedonaBaseDevice.syncTime, null, networkTimeSync);
            ++n;
        }
    }

    public BOrd doSubmitSuperuserJob(BUsernameAndPassword bUsernameAndPassword, Context context) {
        return new BChangeSuperuserJob(this, bUsernameAndPassword).submit(context);
    }

    public boolean isDeviceDiscoverySupported() {
        return false;
    }

    public BOrd doSubmitDeviceDiscoveryJob(BSedonaDeviceDiscoveryConfig bSedonaDeviceDiscoveryConfig, Context context) {
        if (this.isFatalFault()) {
            return null;
        }
        return new BSedonaLearnDevicesJob(null, bSedonaDeviceDiscoveryConfig, this).submit(context);
    }

    public BSedonaAddress[] getDiscoveredDeviceAddresses() throws Exception {
        return null;
    }

    public BSedonaLearnDeviceEntry[] getDiscoveredDevices() throws Exception {
        return null;
    }

    public BSedonaBaseDevice getDeviceByHostAddress(String string) {
        BSedonaBaseDevice[] bSedonaBaseDeviceArray = this.getDeviceList();
        int n = 0;
        while (n < bSedonaBaseDeviceArray.length) {
            InetAddress inetAddress = bSedonaBaseDeviceArray[n].getAddress().getInetAddress();
            if (inetAddress != null && inetAddress.getHostAddress().equalsIgnoreCase(string)) {
                return bSedonaBaseDeviceArray[n];
            }
            ++n;
        }
        return null;
    }

    public BString doManifestManagement(BString bString) throws Exception {
        return BString.make((String)this.doManifestManagement(bString.getString()));
    }

    private final String doManifestManagement(String string) throws Exception {
        String string2 = string;
        String string3 = "";
        int n = string.indexOf(10);
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        String string4 = string2;
        String string5 = "";
        int n2 = string2.indexOf(32);
        if (n2 > 0) {
            string4 = string2.substring(0, n2);
            string5 = string2.substring(n2 + 1);
        }
        if (string4.equals("list")) {
            return this.manifestList();
        }
        if (string4.equals("get")) {
            return this.manifestGet(string5);
        }
        if (string4.equals("put")) {
            return this.manifestPut(string5, string3);
        }
        if (string4.equals("delete")) {
            return this.manifestDelete(string5);
        }
        return "error";
    }

    private final String manifestList() throws Exception {
        String[] stringArray = ManifestDb.listInstalledKits();
        StringBuffer stringBuffer = new StringBuffer(stringArray.length * 64);
        int n = 0;
        while (n < stringArray.length) {
            KitPart[] kitPartArray = ManifestDb.listInstalledParts((String)stringArray[n]);
            if (kitPartArray.length != 0) {
                stringBuffer.append(stringArray[n]);
                int n2 = 0;
                while (n2 < kitPartArray.length) {
                    stringBuffer.append(',').append(Integer.toHexString(kitPartArray[n2].checksum));
                    ++n2;
                }
                stringBuffer.append('\n');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private final String manifestGet(String string) throws Exception {
        KitPart kitPart = KitPart.parse((String)string);
        return FileUtil.readString((File)ManifestDb.toFile((KitPart)kitPart));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String manifestPut(String string, String string2) throws Exception {
        KitPart kitPart = KitPart.parse((String)string);
        File file = ManifestDb.toFile((KitPart)kitPart);
        file.getParentFile().mkdirs();
        FileWriter fileWriter = new FileWriter(file);
        try {
            fileWriter.write(string2);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ((Writer)fileWriter).close();
            throw throwable;
        }
        {
            Object var7_8 = null;
        }
        ((Writer)fileWriter).close();
        return "ok";
    }

    private final String manifestDelete(String string) throws Exception {
        KitPart kitPart = KitPart.parse((String)string);
        FileUtil.delete((File)ManifestDb.toFile((KitPart)kitPart));
        return "ok";
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps("SedonaBaseNetwork");
        spyWriter.prop((Object)"networkRunning", this.networkRunning);
        spyWriter.endProps();
        if (this.workQueue != null) {
            this.workQueue.spy(spyWriter);
        }
        if (this.coalesceQueue != null) {
            this.coalesceQueue.spy(spyWriter);
        }
        if (this.comm != null) {
            this.comm.spy(spyWriter);
        }
        if (this.chopanComm != null) {
            this.chopanComm.spy(spyWriter);
        }
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList.toTop("sedonanet:SedonaDeviceManager");
        return agentList;
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] bINavNodeArray = super.getNavChildren();
        Class clazz = class$javax$baja$nav$BINavNode;
        if (clazz == null) {
            clazz = class$javax$baja$nav$BINavNode = BSedonaBaseNetwork.class("[Ljavax.baja.nav.BINavNode;", false);
        }
        Array array = new Array(clazz);
        array.add((Object)this.getMonitor());
        array.add((Object)this.getPollScheduler());
        array.add((Object)this.getTuningPolicies());
        int n = 0;
        while (n < bINavNodeArray.length) {
            array.add((Object)bINavNodeArray[n]);
            ++n;
        }
        return (BINavNode[])array.trim();
    }

    private final void startComm() {
        if (this.comm == null) {
            this.comm = new SoxComm(this);
        }
        if (this.chopanComm == null) {
            this.chopanComm = new ChopanComm(this);
        }
        try {
            this.comm.start();
            this.chopanComm.start();
        }
        catch (Throwable throwable) {
            this.log.error("Error initializing SedonaNetwork " + this.getName(), throwable);
            this.configFail(throwable.getMessage());
        }
    }

    private final void stopComm() {
        try {
            this.comm.stop();
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
        }
        try {
            this.chopanComm.stop();
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
        }
    }

    public Object _fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 9900: {
                BSedonaBaseDevice bSedonaBaseDevice = (BSedonaBaseDevice)object2;
                return bSedonaBaseDevice.getAddress().getIp();
            }
            case 9901: {
                String string = (String)object;
                Class clazz = class$com$tridium$sedonanet$driver$BSedonaBaseDevice;
                if (clazz == null) {
                    clazz = class$com$tridium$sedonanet$driver$BSedonaBaseDevice = BSedonaBaseNetwork.class("[Lcom.tridium.sedonanet.driver.BSedonaBaseDevice;", false);
                }
                Array array = new Array(clazz);
                BSedonaBaseDevice[] bSedonaBaseDeviceArray = this.getDeviceList();
                int n2 = 0;
                while (n2 < bSedonaBaseDeviceArray.length) {
                    bSedonaBaseDeviceArray[n2].loadSlots();
                    if (bSedonaBaseDeviceArray[n2].getAddress().getIp().equalsIgnoreCase(string)) {
                        array.add((Object)bSedonaBaseDeviceArray[n2]);
                    }
                    ++n2;
                }
                return (BSedonaBaseDevice[])array.trim();
            }
        }
        return null;
    }

    public Log getLog() {
        return this.log;
    }

    public Log getLogSox() {
        return this.logSox;
    }

    public Log getLogCho() {
        return this.logCho;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.comm = null;
        this.chopanComm = null;
        this.networkRunning = false;
        this.workQueue = null;
        this.coalesceQueue = null;
    }

    public BSedonaBaseNetwork() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$sedonanet$driver$BSedonaBaseNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$sedonanet$driver$BSedonaBaseNetwork = BSedonaBaseNetwork.class("[Lcom.tridium.sedonanet.driver.BSedonaBaseNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        networkTimeSync = new BasicContext(){

            public final boolean equals(Object object) {
                boolean bl = false;
                if (this == object) {
                    bl = true;
                }
                return bl;
            }

            public final String toString() {
                return "SedonaNetwork:NetworkTimeSync";
            }
        };
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class WaitWorker
    extends Worker {
        protected void process(Runnable runnable) throws Exception {
            while (!BSedonaBaseNetwork.this.atNetworkSteadyState()) {
                Thread.sleep(1000L);
            }
            if (runnable != null) {
                runnable.run();
            }
        }

        public WaitWorker(Worker.ITodo iTodo) {
            super(iTodo);
        }
    }
}

