/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet.driver;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.nsedona.sox.PlatformSession;
import com.tridium.sedonanet.driver.BISedonaDevice;
import com.tridium.sedonanet.driver.FoxDevicePlatformSession;
import java.util.Properties;
import javax.baja.naming.BOrd;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IntHashMap;
import sedona.Buf;
import sedona.sox.ISoxComm;
import sedona.sox.KitVersion;
import sedona.sox.SoxFile;
import sedona.sox.VersionInfo;
import sedona.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BFoxSoxChannel
extends BFoxChannel {
    public static final Type TYPE;
    public static final String Channel = "foxsox";
    private final IntHashMap sessions;
    private int nextId;
    static /* synthetic */ Class class$com$tridium$sedonanet$driver$BFoxSoxChannel;

    public Type getType() {
        return TYPE;
    }

    public FoxResponse process(FoxRequest foxRequest) throws Throwable {
        String string = foxRequest.command;
        if (string.equals("open")) {
            return this.openSession(foxRequest);
        }
        if (string.equals("close")) {
            return this.closeSession(foxRequest);
        }
        if (string.equals("versionInfo")) {
            return this.versionInfo(foxRequest);
        }
        if (string.equals("saveApp")) {
            return this.saveApp(foxRequest);
        }
        if (string.equals("restart")) {
            return this.restart(foxRequest);
        }
        if (string.equals("renameFile")) {
            return this.renameFile(foxRequest);
        }
        throw new InvalidCommandException(string);
    }

    public void circuitOpened(FoxCircuit foxCircuit) throws Throwable {
        String string = foxCircuit.command;
        if (string.equals("getfile")) {
            this.getFile(foxCircuit);
        } else if (string.equals("putfile")) {
            this.putFile(foxCircuit);
        } else {
            throw new InvalidCommandException(string);
        }
    }

    public int openSession(BISedonaDevice bISedonaDevice, BUsernameAndPassword bUsernameAndPassword) throws Exception {
        FoxRequest foxRequest = this.makeRequest("open");
        foxRequest.add("ord", ((BComponent)bISedonaDevice).getHandleOrd().encodeToString());
        if (bUsernameAndPassword != null) {
            foxRequest.add("creds", bUsernameAndPassword.encodeCredentials());
        }
        FoxResponse foxResponse = this.sendSync(foxRequest);
        return foxResponse.getInt("id");
    }

    private final FoxResponse openSession(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        BOrd bOrd = (BOrd)BOrd.DEFAULT.decodeFromString(foxRequest.getString("ord"));
        BUsernameAndPassword bUsernameAndPassword = null;
        byte[] byArray = foxRequest.getBlob("creds", null);
        if (byArray != null) {
            bUsernameAndPassword = new BUsernameAndPassword();
            bUsernameAndPassword = (BUsernameAndPassword)bUsernameAndPassword.decodeCredentials(byArray);
        }
        BISedonaDevice bISedonaDevice = (BISedonaDevice)bOrd.get((BObject)this.getSpace());
        PlatformSession platformSession = bISedonaDevice.openPlatformSession(bUsernameAndPassword);
        this.registerSession(platformSession, foxResponse);
        return foxResponse;
    }

    public void closeSession(int n) throws Exception {
        FoxRequest foxRequest = this.makeRequest("close");
        foxRequest.add("id", n);
        this.sendSync(foxRequest);
    }

    private final FoxResponse closeSession(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        PlatformSession platformSession = this.unregisterSession(foxRequest.getInt("id"));
        if (platformSession != null) {
            platformSession.close();
        }
        return foxResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sessionClosed(Throwable var1_1) throws Exception {
        var3_2 = this.sessions;
        synchronized (var3_2) {
            var2_3 = (PlatformSession[])this.sessions.toArray((Object[])new PlatformSession[this.sessions.size()]);
            this.sessions.clear();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var3_2
            var5_4 = 0;
            if (true) ** GOTO lbl14
        }
        do {
            var2_3[var5_4].close();
            ++var5_4;
lbl14:
            // 2 sources

        } while (var5_4 < var2_3.length);
        super.sessionClosed(var1_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void registerSession(PlatformSession platformSession, FoxResponse foxResponse) {
        IntHashMap intHashMap = this.sessions;
        synchronized (intHashMap) {
            int n = this.nextId;
            while (true) {
                if (this.sessions.get(n) == null) {
                    this.nextId = n + 1;
                    this.sessions.put(n, (Object)platformSession);
                    foxResponse.add("id", n);
                    return;
                }
                n = (n + 1) % 0x7FFFFFFE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final PlatformSession unregisterSession(int n) {
        IntHashMap intHashMap = this.sessions;
        synchronized (intHashMap) {
            return (PlatformSession)this.sessions.remove(n);
        }
    }

    private final FoxRequest initRequest(String string, int n) {
        FoxRequest foxRequest = this.makeRequest(string);
        foxRequest.add("id", n);
        return foxRequest;
    }

    private final void initCircuit(FoxCircuit foxCircuit, int n) throws Exception {
        FoxRequest foxRequest = this.initRequest("initcircuit", n);
        foxCircuit.writeMessage((FoxMessage)foxRequest);
        foxCircuit.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final PlatformSession getSession(FoxMessage foxMessage) throws Exception {
        IntHashMap intHashMap = this.sessions;
        synchronized (intHashMap) {
            return (PlatformSession)this.sessions.get(foxMessage.getInt("id"));
        }
    }

    private final PlatformSession getSession(FoxCircuit foxCircuit) throws Exception {
        return this.getSession(foxCircuit.readMessage());
    }

    public VersionInfo versionInfo(FoxDevicePlatformSession foxDevicePlatformSession) throws Exception {
        FoxRequest foxRequest = this.initRequest("versionInfo", foxDevicePlatformSession.sessionId());
        FoxResponse foxResponse = this.sendSync(foxRequest);
        String string = foxResponse.getString("platformId");
        int n = foxResponse.getInt("scodeFlags");
        FoxTuple[] foxTupleArray = foxResponse.list("kitVersion");
        KitVersion[] kitVersionArray = new KitVersion[foxTupleArray.length];
        int n2 = 0;
        while (n2 < foxTupleArray.length) {
            FoxMessage foxMessage = (FoxMessage)foxTupleArray[n2];
            kitVersionArray[n2] = new KitVersion(foxMessage.getString("name"), foxMessage.getInt("checksum"), new Version(foxMessage.getString("version")));
            ++n2;
        }
        return new VersionInfo(string, n, kitVersionArray);
    }

    private final FoxResponse versionInfo(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        PlatformSession platformSession = this.getSession((FoxMessage)foxRequest);
        VersionInfo versionInfo = platformSession.getVersionInfo();
        foxResponse.add("platformId", versionInfo.platformId);
        foxResponse.add("scodeFlags", versionInfo.scodeFlags);
        int n = 0;
        while (n < versionInfo.kits.length) {
            FoxMessage foxMessage = new FoxMessage("kitVersion");
            foxMessage.add("name", versionInfo.kits[n].name);
            foxMessage.add("checksum", versionInfo.kits[n].checksum);
            foxMessage.add("version", versionInfo.kits[n].version.toString());
            foxResponse.add((FoxTuple)foxMessage);
            ++n;
        }
        return foxResponse;
    }

    public void saveApp(FoxDevicePlatformSession foxDevicePlatformSession) throws Exception {
        FoxRequest foxRequest = this.initRequest("saveApp", foxDevicePlatformSession.sessionId());
        this.sendSync(foxRequest);
    }

    private final FoxResponse saveApp(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        this.getSession((FoxMessage)foxRequest).saveApp();
        return foxResponse;
    }

    public void restart(FoxDevicePlatformSession foxDevicePlatformSession) throws Exception {
        FoxRequest foxRequest = this.initRequest("restart", foxDevicePlatformSession.sessionId());
        this.sendSync(foxRequest);
    }

    private final FoxResponse restart(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        this.getSession((FoxMessage)foxRequest).restart();
        return foxResponse;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getFile(FoxDevicePlatformSession foxDevicePlatformSession, String string, SoxFile soxFile, Properties properties, ISoxComm.TransferListener transferListener) throws Exception {
        FoxCircuit foxCircuit = this.openCircuit("getfile");
        try {
            this.initCircuit(foxCircuit, foxDevicePlatformSession.sessionId());
            FoxMessage foxMessage = new FoxMessage("req");
            foxMessage.add("uri", string);
            foxCircuit.writeMessage(foxMessage);
            foxCircuit.flush();
            FoxMessage foxMessage2 = foxCircuit.readMessage();
            while (true) {
                block4: {
                    if (!foxMessage2.getBoolean("EOF", false)) break block4;
                    this.checkStatus(foxMessage2);
                    Buf buf = new Buf(foxMessage2.getBlob("file"));
                    soxFile.open("w");
                    soxFile.write(0, buf, buf.size());
                    break;
                }
                transferListener.progress(foxMessage2.getInt("bytes"), foxMessage2.getInt("total"));
                foxMessage2 = foxCircuit.readMessage();
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            soxFile.close();
            foxCircuit.close();
            throw throwable;
        }
        {
            Object var8_12 = null;
        }
        soxFile.close();
        foxCircuit.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void getFile(FoxCircuit foxCircuit) throws Exception {
        PlatformSession platformSession = this.getSession(foxCircuit);
        FoxMessage foxMessage = foxCircuit.readMessage();
        String string = foxMessage.getString("uri");
        PlatformSession.FileTransfer fileTransfer = platformSession.makeFileTransfer(null, (ISoxComm.TransferListener)new XferListener(foxCircuit));
        Buf buf = new Buf();
        FoxMessage foxMessage2 = new FoxMessage();
        foxMessage2.add("EOF", true);
        try {
            try {
                fileTransfer.getFile(string, SoxFile.make((Buf)buf));
                foxMessage2.add("file", buf.trim());
            }
            catch (Exception exception) {
                this.handleException(foxMessage2, exception);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            foxCircuit.writeMessage(foxMessage2);
            foxCircuit.flush();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        foxCircuit.writeMessage(foxMessage2);
        foxCircuit.flush();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void putFile(FoxDevicePlatformSession foxDevicePlatformSession, SoxFile soxFile, String string, Properties properties, ISoxComm.TransferListener transferListener) throws Exception {
        FoxCircuit foxCircuit = this.openCircuit("putfile");
        try {
            this.initCircuit(foxCircuit, foxDevicePlatformSession.sessionId());
            Buf buf = new Buf();
            soxFile.open("r");
            soxFile.read(0, buf, soxFile.size());
            FoxMessage foxMessage = new FoxMessage("req");
            foxMessage.add("uri", string);
            foxMessage.add("file", buf.trim());
            foxCircuit.writeMessage(foxMessage);
            foxCircuit.flush();
            FoxMessage foxMessage2 = foxCircuit.readMessage();
            while (true) {
                block4: {
                    if (!foxMessage2.getBoolean("EOF", false)) break block4;
                    this.checkStatus(foxMessage2);
                    break;
                }
                transferListener.progress(foxMessage2.getInt("bytes"), foxMessage2.getInt("total"));
                foxMessage2 = foxCircuit.readMessage();
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            soxFile.close();
            foxCircuit.close();
            throw throwable;
        }
        {
            Object var8_12 = null;
        }
        soxFile.close();
        foxCircuit.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void putFile(FoxCircuit foxCircuit) throws Exception {
        PlatformSession platformSession = this.getSession(foxCircuit);
        FoxMessage foxMessage = foxCircuit.readMessage();
        String string = foxMessage.getString("uri");
        Buf buf = new Buf(foxMessage.getBlob("file"));
        PlatformSession.FileTransfer fileTransfer = platformSession.makeFileTransfer(null, (ISoxComm.TransferListener)new XferListener(foxCircuit));
        FoxMessage foxMessage2 = new FoxMessage();
        foxMessage2.add("EOF", true);
        try {
            try {
                fileTransfer.putFile(SoxFile.make((Buf)buf), string);
            }
            catch (Exception exception) {
                this.handleException(foxMessage2, exception);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            foxCircuit.writeMessage(foxMessage2);
            foxCircuit.flush();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        foxCircuit.writeMessage(foxMessage2);
        foxCircuit.flush();
    }

    public void renameFile(FoxDevicePlatformSession foxDevicePlatformSession, String string, String string2) throws Exception {
        FoxRequest foxRequest = this.initRequest("renameFile", foxDevicePlatformSession.sessionId());
        foxRequest.add("fromUri", string);
        foxRequest.add("toUri", string2);
        this.sendSync(foxRequest);
    }

    private final FoxResponse renameFile(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        PlatformSession platformSession = this.getSession((FoxMessage)foxRequest);
        String string = foxRequest.getString("fromUri");
        String string2 = foxRequest.getString("toUri");
        platformSession.makeFileTransfer(null, null).renameFile(string, string2);
        return foxResponse;
    }

    private final void handleException(FoxMessage foxMessage, Exception exception) {
        foxMessage.add("status", "error");
        foxMessage.add("msg", exception.getMessage());
    }

    private final void checkStatus(FoxMessage foxMessage) throws Exception {
        String string = foxMessage.getString("status", null);
        if (string != null) {
            throw new Exception(string + ": " + foxMessage.getString("msg"));
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.sessions = new IntHashMap();
        this.nextId = 0;
    }

    public BFoxSoxChannel() {
        super(Channel);
        this.this();
    }

    static {
        Class clazz = class$com$tridium$sedonanet$driver$BFoxSoxChannel;
        if (clazz == null) {
            clazz = class$com$tridium$sedonanet$driver$BFoxSoxChannel = BFoxSoxChannel.class("[Lcom.tridium.sedonanet.driver.BFoxSoxChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class XferListener
    implements ISoxComm.TransferListener {
        final FoxCircuit circuit;

        public void progress(int n, int n2) {
            FoxMessage foxMessage = new FoxMessage("progress");
            foxMessage.add("bytes", n);
            foxMessage.add("total", n2);
            try {
                this.circuit.writeMessage(foxMessage);
                this.circuit.flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public XferListener(FoxCircuit foxCircuit) {
            this.circuit = foxCircuit;
        }
    }
}

