/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet.driver;

import com.tridium.sedonanet.driver.BSedonaBaseDevice;
import com.tridium.sedonanet.driver.BSedonaBaseNetwork;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.JobCancelException;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import sedona.Buf;
import sedona.Byte;
import sedona.Int;
import sedona.Schema;
import sedona.Slot;
import sedona.Value;
import sedona.offline.OfflineComponent;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;
import sedona.util.UserUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BChangeSuperuserJob
extends BJob
implements Runnable {
    public static final Type TYPE;
    private final BSedonaBaseNetwork network;
    private final BUsernameAndPassword creds;
    private Thread jthread;
    private Context cx;
    static /* synthetic */ Class class$com$tridium$sedonanet$driver$BChangeSuperuserJob;

    public final Type getType() {
        return TYPE;
    }

    public final void doRun(Context context) throws Exception {
        this.cx = context;
        this.jthread = new Thread(this);
        this.jthread.start();
    }

    public final void doCancel(Context context) throws Exception {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
            if (this.jthread != null) {
                this.jthread.interrupt();
            }
        }
    }

    public final void run() {
        try {
            boolean bl = false;
            BSedonaBaseDevice[] bSedonaBaseDeviceArray = this.network.getDeviceList();
            int n = 0;
            while (n < bSedonaBaseDeviceArray.length) {
                BSedonaBaseDevice bSedonaBaseDevice = bSedonaBaseDeviceArray[n];
                if (Thread.interrupted()) {
                    throw new JobCancelException();
                }
                this.progress((int)((double)n / (double)bSedonaBaseDeviceArray.length * 100.0));
                try {
                    if (bSedonaBaseDevice.getCredentials().equivalent((Object)this.creds)) {
                        this.log().message(bSedonaBaseDevice.getName() + " already has this super user");
                    } else {
                        if (bSedonaBaseDevice.isDown() || bSedonaBaseDevice.isFatalFault() || bSedonaBaseDevice.isDisabled()) {
                            throw new Exception(bSedonaBaseDevice.getName() + " is down. Skipping.");
                        }
                        this.changeRemoteSuperuser(bSedonaBaseDevice);
                        this.log().success("Device " + bSedonaBaseDevice.getName());
                        bSedonaBaseDevice.pingOk();
                    }
                }
                catch (Throwable throwable) {
                    this.log().failed("Device " + bSedonaBaseDeviceArray[n].getName(), throwable);
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                throw new Exception("Some devices failed to update super user. See log for details");
            }
            this.progress(100);
            this.success();
        }
        catch (Throwable throwable) {
            this.failed(throwable);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void changeRemoteSuperuser(BSedonaBaseDevice bSedonaBaseDevice) throws Exception {
        SoxClient soxClient = bSedonaBaseDevice.makeSoxClient();
        BUsernameAndPassword bUsernameAndPassword = bSedonaBaseDevice.getCredentials();
        boolean bl = bUsernameAndPassword.getUsername().equals(this.creds.getUsername());
        try {
            SoxComponent soxComponent;
            block15: {
                Value[] valueArray;
                SoxComponent soxComponent2;
                sedona.Type type;
                block14: {
                    soxClient.connect();
                    Schema schema = soxClient.readSchema();
                    type = schema.type("sys::User");
                    soxComponent2 = soxClient.load(soxClient.queryService(schema.type("sys::UserService"))[0]);
                    soxComponent = (SoxComponent)soxComponent2.getChild(bUsernameAndPassword.getUsername());
                    if (soxComponent == null) {
                        throw new IllegalStateException("could not find current super user: " + bUsernameAndPassword.getUsername());
                    }
                    SoxComponent soxComponent3 = (SoxComponent)soxComponent2.getChild(this.creds.getUsername());
                    if (!bl && soxComponent3 != null) {
                        throw new Exception("There is already a user with name: " + this.creds.getUsername());
                    }
                    OfflineComponent offlineComponent = new OfflineComponent(type);
                    offlineComponent.set("cred", (Value)new Buf(UserUtil.credentials((String)this.creds.getUsername(), (String)this.creds.getPassword().getString())));
                    offlineComponent.set("perm", (Value)Int.make((int)-1));
                    offlineComponent.set("prov", (Value)Byte.make((int)255));
                    Slot[] slotArray = type.configProps();
                    valueArray = new Value[slotArray.length];
                    int n = 0;
                    while (true) {
                        if (n >= slotArray.length) {
                            if (bl) {
                                n = 0;
                                break;
                            }
                            break block14;
                        }
                        valueArray[n] = offlineComponent.get(slotArray[n]);
                        ++n;
                    }
                    while (n < slotArray.length) {
                        soxClient.write(soxComponent, slotArray[n], offlineComponent.get(slotArray[n]));
                        ++n;
                    }
                    break block15;
                }
                soxClient.add(soxComponent2, type, this.creds.getUsername(), valueArray);
            }
            try {
                bSedonaBaseDevice.setCredentials(new BUsernameAndPassword(this.creds.getUsername(), this.creds.getPassword()));
            }
            catch (Exception exception) {
                throw new Exception("Could not set credentials on device", exception);
            }
            if (!bl) {
                soxClient.delete(soxComponent);
            }
            try {
                SoxComponent soxComponent4 = soxClient.loadApp();
                soxClient.invoke(soxComponent4, soxComponent4.slot("save"), null);
            }
            catch (Exception exception) {
                throw new Exception("Partial sucess. Super user was changed, but app failed to save", exception);
            }
        }
        catch (Throwable throwable) {
            Object var6_18 = null;
            soxClient.close();
            throw throwable;
        }
        {
            Object var6_19 = null;
        }
        soxClient.close();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BChangeSuperuserJob() {
        this(null, null);
    }

    public BChangeSuperuserJob(BSedonaBaseNetwork bSedonaBaseNetwork, BUsernameAndPassword bUsernameAndPassword) {
        this.network = bSedonaBaseNetwork;
        this.creds = bUsernameAndPassword;
    }

    static {
        Class clazz = class$com$tridium$sedonanet$driver$BChangeSuperuserJob;
        if (clazz == null) {
            clazz = class$com$tridium$sedonanet$driver$BChangeSuperuserJob = BChangeSuperuserJob.class("[Lcom.tridium.sedonanet.driver.BChangeSuperuserJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

