/*
 * Decompiled with CFR 0.152.
 */
package sedonacert;

import java.io.File;
import java.net.InetAddress;
import sedona.Env;
import sedona.Schema;
import sedona.dasp.DaspSocket;
import sedona.platform.PlatformDb;
import sedona.platform.PlatformManifest;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;
import sedona.sox.SoxException;
import sedona.sox.VersionInfo;
import sedona.util.Abstime;
import sedona.util.FileUtil;
import sedona.util.Log;
import sedonacert.Bundle;
import sedonacert.Test;
import sedonacert.prov.Prov;
import sedonacert.sox.Sox;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Runner {
    public Log log;
    public String host;
    public int port;
    public String username;
    public String password;
    public Bundle[] bundles;
    public SoxClient sox;
    public Schema schema;
    public VersionInfo version;
    public PlatformManifest platform;
    public File testDir;

    public int run() throws Exception {
        if (!this.init()) {
            return 1;
        }
        if (!this.connect()) {
            return 1;
        }
        int n = 0;
        while (n < this.bundles.length) {
            Bundle bundle = this.bundles[n];
            this.log.info("---" + bundle.name + "---");
            int n2 = 0;
            while (n2 < bundle.tests.length) {
                Test test = bundle.tests[n2];
                try {
                    this.log.info(test.qname + " ...");
                    test.run();
                    this.log.info(test.qname + ": pass [" + test.verifies + " verifies]");
                    test.status = 1;
                }
                catch (Throwable throwable) {
                    this.log.error(test.qname + ": fail", throwable);
                    test.status = 2;
                    test.failure = throwable;
                }
                ++n2;
            }
            ++n;
        }
        this.disconnect();
        this.report();
        return 0;
    }

    public boolean init() throws Exception {
        this.testDir = new File("sedona-cert");
        FileUtil.delete((File)this.testDir, (Log)this.log);
        FileUtil.mkdir((File)this.testDir, (Log)this.log);
        this.bundles = new Bundle[]{new Sox(this), new Prov(this)};
        return true;
    }

    public boolean connect() throws Exception {
        this.log.info("Connecting to " + this.host + ':' + this.port + " as " + this.username + ':' + this.password + "...");
        try {
            DaspSocket daspSocket = DaspSocket.open((int)-1, null, (int)14);
            this.sox = new SoxClient(daspSocket, InetAddress.getByName(this.host), this.port, this.username, this.password);
            this.sox.connect();
            this.schema = this.sox.readSchema();
            this.version = this.sox.readVersion();
            this.log.info("Connected.");
        }
        catch (Exception exception) {
            this.log.error("Cannot connect via sox", (Throwable)exception);
            return false;
        }
        this.platform = PlatformDb.db().loadExact(this.version.platformId);
        if (this.platform == null) {
            this.log.error(this.version.platformId + " is not in the platform database.");
            return false;
        }
        return true;
    }

    public void disconnect() {
        this.sox.close();
        this.sox = null;
        this.log.info("Disconnected.");
    }

    public boolean restart() {
        try {
            SoxComponent soxComponent = this.sox.loadApp();
            try {
                this.log.info("restart");
                this.sox.invoke(soxComponent, soxComponent.slot("restart"), null);
            }
            catch (SoxException soxException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.disconnect();
            int n = 10;
            while (!this.connect()) {
                if (--n == 0) {
                    return false;
                }
                this.log.info("Try to connect again in 1000 ms...");
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void report() {
        this.log.out.println();
        this.log.out.println("===Setup===");
        this.log.out.println("date:           " + Abstime.now());
        this.log.out.println("platformId:     " + this.version.platformId);
        this.log.out.println("scodeFlags:     0x" + Integer.toHexString(this.version.scodeFlags));
        this.log.out.println("sedona.version: " + Env.version);
        this.log.out.println("java.version:   " + System.getProperty("java.version"));
        this.log.out.println();
        this.log.out.println("===Kits Installed===");
        int n = 0;
        while (n < this.version.kits.length) {
            this.log.out.println(this.version.kits[n]);
            ++n;
        }
        this.log.out.println();
        this.log.out.println("===Results===");
        n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.bundles.length) {
            Bundle bundle = this.bundles[n4];
            this.log.out.println("---" + bundle.name + "---");
            int n5 = 0;
            while (n5 < bundle.tests.length) {
                String string;
                Test test = bundle.tests[n5];
                switch (test.status) {
                    case 0: {
                        ++n;
                        string = "not-run";
                        break;
                    }
                    case 1: {
                        ++n2;
                        string = "pass [" + test.verifies + " verifies]";
                        break;
                    }
                    case 2: {
                        ++n3;
                        string = "fail";
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                this.log.out.println(test.qname + ": " + string);
                ++n5;
            }
            ++n4;
        }
        this.log.out.println();
        this.log.out.println("===Summary===");
        this.log.out.println("Total Not-Run: " + n);
        this.log.out.println("Total Passes:  " + n2);
        this.log.out.println("Total Fail:    " + n3);
        this.log.out.println();
        this.log.out.println("**");
        this.log.out.println("** Certification " + (n3 > 0 ? "Failed!" : "Passed!"));
        this.log.out.println("**");
    }

    private final /* synthetic */ void this() {
        this.log = new Log("cert");
        this.port = 1876;
    }

    public Runner() {
        this.this();
    }
}

