/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.util.HashSet;
import java.util.Set;
import sedona.util.TextUtil;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.ir.IrMethod;
import sedonac.ir.IrOp;
import sedonac.ir.IrType;
import sedonac.namespace.Field;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OptimizeIr
extends CompilerStep {
    private final Set noPeephole;

    public void run() {
        if (!this.compiler.optimize) {
            return;
        }
        this.log.debug("  OptimizeIr");
        IrType[] irTypeArray = this.compiler.ir.types;
        int n = 0;
        while (n < irTypeArray.length) {
            IrType irType = irTypeArray[n];
            int n2 = 0;
            while (n2 < irType.declared.length) {
                if (irType.declared[n2] instanceof IrMethod) {
                    this.optimize((IrMethod)irType.declared[n2]);
                }
                ++n2;
            }
            ++n;
        }
    }

    void optimize(IrMethod irMethod) {
        if (irMethod.code == null || irMethod.code.length < 2) {
            return;
        }
        this.noPeephole.clear();
        while (this.doOptimize(irMethod)) {
        }
    }

    boolean doOptimize(IrMethod irMethod) {
        IrOp[] irOpArray = irMethod.code;
        int n = 0;
        while (n < irOpArray.length - 1) {
            IrOp irOp = irOpArray[n];
            IrOp irOp2 = irOpArray[n + 1];
            if (irOp.index != n) {
                throw new IllegalStateException();
            }
            IrOp irOp3 = this.optimizeOp(irMethod, irOp);
            if (irOp3 != null) {
                this.replace(irMethod, n, irOp3);
                return true;
            }
            IrOp irOp4 = this.peephole(irMethod, irOp, irOp2);
            if (irOp4 != null) {
                this.join(irMethod, n, irOp4);
                return true;
            }
            ++n;
        }
        return false;
    }

    void replace(IrMethod irMethod, int n, IrOp irOp) {
        irOp.index = n;
        irMethod.code[n] = irOp;
    }

    void join(IrMethod irMethod, int n, IrOp irOp) {
        boolean bl = false;
        if (irMethod.code[n].opcode == 237) {
            bl = true;
        }
        boolean bl2 = bl;
        IrOp[] irOpArray = irMethod.code;
        IrOp[] irOpArray2 = new IrOp[irOpArray.length - 1];
        int n2 = 0;
        while (n2 < irOpArray.length) {
            if (n2 < n) {
                irOpArray2[n2] = irOpArray[n2];
            } else if (n2 == n) {
                irOpArray2[n2] = irOp;
            } else if (n2 > n + 1) {
                irOpArray2[n2 - 1] = irOpArray[n2];
            }
            ++n2;
        }
        irMethod.code = irOpArray2;
        n2 = 0;
        while (n2 < irOpArray2.length) {
            IrOp irOp2 = irOpArray2[n2];
            irOp2.index = n2;
            if (irOp2.isJump()) {
                int n3 = Integer.parseInt(irOp2.arg);
                if (n3 == n + 1) {
                    if (!bl2) {
                        int n4 = 0;
                        while (n4 < irOpArray.length) {
                            IrOp irOp3 = irOpArray[n4];
                            irOp3.index = n4;
                            if (irOp3.isJump() && (n3 = Integer.parseInt(irOp3.arg)) >= n) {
                                irOp3.arg = String.valueOf(n3 + 1);
                            }
                            ++n4;
                        }
                        irMethod.code = irOpArray;
                        this.noPeephole.add(irOpArray[n]);
                        return;
                    }
                    irOp2.arg = String.valueOf(n3 - 1);
                }
                if (n3 > n) {
                    irOp2.arg = String.valueOf(n3 - 1);
                }
            }
            if (irOp2.opcode == 235) {
                StringBuffer stringBuffer = new StringBuffer();
                String[] stringArray = TextUtil.split((String)irOp2.arg, (char)',');
                int n5 = 0;
                while (n5 < stringArray.length) {
                    int n6 = Integer.parseInt(stringArray[n5]);
                    if (n6 == n + 1) {
                        throw new IllegalStateException(irOp.toString());
                    }
                    if (n6 > n) {
                        --n6;
                    }
                    if (n5 > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(n6);
                    ++n5;
                }
                irOp2.arg = stringBuffer.toString();
            }
            ++n2;
        }
    }

    IrOp optimizeOp(IrMethod irMethod, IrOp irOp) {
        if (irOp.opcode == 221) {
            String string = irOp.argToSlot().qname();
            if (string.equals("sys::Str.get")) {
                return new IrOp(166);
            }
            if (string.equals("sys::Str.set")) {
                return new IrOp(170);
            }
        }
        return null;
    }

    IrOp peephole(IrMethod irMethod, IrOp irOp, IrOp irOp2) {
        if (this.noPeephole.contains(irOp)) {
            return null;
        }
        if (irOp.opcode == 237) {
            return irOp2;
        }
        if (irOp.opcode == 212 && this.isFieldAtZero(irOp.arg)) {
            return irOp2;
        }
        if (irOp.opcode == 162 && irOp2.opcode == 212) {
            return new IrOp(218, irOp2.arg);
        }
        if (irOp.opcode == 29) {
            if (irOp2.opcode == 212) {
                return new IrOp(215, irOp2.arg);
            }
            if (irOp2.opcode == 221) {
                return new IrOp(229, irOp2.arg);
            }
        }
        if (irOp2.opcode == 143) {
            if (irOp.opcode == 57) {
                return new IrOp(150, irOp2.arg);
            }
            if (irOp.opcode == 58) {
                return new IrOp(151, irOp2.arg);
            }
            if (irOp.opcode == 61) {
                return new IrOp(154, irOp2.arg);
            }
            if (irOp.opcode == 62) {
                return new IrOp(155, irOp2.arg);
            }
            if (irOp.opcode == 59) {
                return new IrOp(152, irOp2.arg);
            }
            if (irOp.opcode == 60) {
                return new IrOp(153, irOp2.arg);
            }
            if (irOp.opcode == 131) {
                return new IrOp(144, irOp2.arg);
            }
            if (irOp.opcode == 132) {
                return new IrOp(143, irOp2.arg);
            }
        }
        if (irOp2.opcode == 144) {
            if (irOp.opcode == 57) {
                return new IrOp(151, irOp2.arg);
            }
            if (irOp.opcode == 58) {
                return new IrOp(150, irOp2.arg);
            }
            if (irOp.opcode == 61) {
                return new IrOp(153, irOp2.arg);
            }
            if (irOp.opcode == 62) {
                return new IrOp(152, irOp2.arg);
            }
            if (irOp.opcode == 59) {
                return new IrOp(155, irOp2.arg);
            }
            if (irOp.opcode == 60) {
                return new IrOp(154, irOp2.arg);
            }
            if (irOp.opcode == 131) {
                return new IrOp(143, irOp2.arg);
            }
            if (irOp.opcode == 132) {
                return new IrOp(144, irOp2.arg);
            }
        }
        if (irOp.opcode == 2) {
            if (irOp2.opcode == 150) {
                return new IrOp(144, irOp2.arg);
            }
            if (irOp2.opcode == 151) {
                return new IrOp(143, irOp2.arg);
            }
            if (irOp2.opcode == 57) {
                return new IrOp(131);
            }
            if (irOp2.opcode == 58) {
                return new IrOp(132);
            }
        }
        if (irOp.opcode == 16) {
            if (irOp2.opcode == 129) {
                return new IrOp(131);
            }
            if (irOp2.opcode == 130) {
                return new IrOp(132);
            }
        }
        return null;
    }

    boolean isFieldAtZero(String string) {
        Field field = (Field)this.ns.resolveSlot(string);
        Type type = field.parent();
        int n = 0;
        Slot[] slotArray = type.slots();
        int n2 = 0;
        while (n2 < slotArray.length) {
            Slot slot = slotArray[n2];
            if (slot.isField() && !slot.isStatic()) {
                ++n;
            }
            ++n2;
        }
        boolean bl = false;
        if (n == 1 && type.base().isObj()) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.noPeephole = new HashSet();
    }

    public OptimizeIr(Compiler compiler) {
        super(compiler);
        this.this();
    }
}

