/*
 * Decompiled with CFR 0.152.
 */
package sedonac.namespace;

import sedona.Buf;
import sedona.Env;
import sedona.Facets;
import sedona.util.TextUtil;
import sedonac.ast.TypeDef;
import sedonac.ir.IrType;
import sedonac.namespace.ArrayType;
import sedonac.namespace.Field;
import sedonac.namespace.Method;
import sedonac.namespace.Namespace;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;

public class TypeUtil {
    public static boolean is(Type type, Type type2) {
        if (type == type2) {
            return true;
        }
        if (type.isInteger() && type2.isInteger()) {
            return true;
        }
        if (type.isArray() || type2.isArray()) {
            Type type3;
            if (!type.isArray()) {
                return false;
            }
            if (!type2.isArray()) {
                return type2.isObj();
            }
            Type type4 = type.arrayOf();
            if (!type4.is(type3 = type2.arrayOf())) {
                return false;
            }
            if (type4.isPrimitive() && type4 != type3) {
                return false;
            }
            if (type.isConst() != type2.isConst()) {
                return false;
            }
            ArrayType.Len len = type.arrayLength();
            ArrayType.Len len2 = type2.arrayLength();
            if (len2 == null) {
                return true;
            }
            if (len == null) {
                return false;
            }
            return len.equals(len2);
        }
        if (type.signature().equals(type2.signature())) {
            return true;
        }
        Type type5 = type.base();
        while (type5 != null) {
            if (TypeUtil.is(type5, type2)) {
                return true;
            }
            type5 = type5.base();
        }
        return false;
    }

    public static boolean equals(Type type, Object object) {
        if (type == object) {
            return true;
        }
        if (object instanceof Type) {
            Type type2 = (Type)object;
            return type.signature().equals(type2.signature());
        }
        return false;
    }

    public static boolean isaComponent(Type type) {
        if (type.isComponent()) {
            return true;
        }
        if (type.base() == null) {
            return false;
        }
        return TypeUtil.isaComponent(type.base());
    }

    public static boolean isaVirtual(Type type) {
        if (type.isVirtual()) {
            return true;
        }
        if (type.base() == null) {
            return false;
        }
        return TypeUtil.isaVirtual(type.base());
    }

    public static boolean isaTest(Type type) {
        if (type.qname().equals("sys::Test")) {
            return true;
        }
        if (type.base() == null) {
            return false;
        }
        return TypeUtil.isaTest(type.base());
    }

    public static int predefinedId(String string) {
        if (string.equals("sys::Buf")) {
            return 8;
        }
        return -1;
    }

    public static boolean isReflective(Type type) {
        if (type.isaComponent()) {
            return true;
        }
        if (type.isPrimitive()) {
            return true;
        }
        return TypeUtil.predefinedId(type.qname()) > 0;
    }

    public static boolean isInherited(Slot slot, Type type) {
        String string;
        Object object;
        if (slot.isPrivate()) {
            return false;
        }
        if (slot.isInternal() && !((String)(object = slot.parent().kit().name())).equals(string = type.kit().name())) {
            return false;
        }
        return !slot.isMethod() || !(object = (Method)slot).isInstanceInit() && !object.isStaticInit();
    }

    public static IrType ir(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof IrType) {
            return (IrType)type;
        }
        if (type instanceof TypeDef) {
            IrType irType = ((TypeDef)type).ir;
            if (irType == null) {
                throw new IllegalStateException("TypeDef not assembled");
            }
            return irType;
        }
        throw new IllegalStateException("Cannot map to IrType: " + type.getClass().getName());
    }

    public static Field getUnsizedArrayField(Type type) {
        Slot[] slotArray = type.slots();
        int n = 0;
        while (n < slotArray.length) {
            Field field;
            if (slotArray[n] instanceof Field && (field = (Field)slotArray[n]).ctorLengthParam() > 0) {
                return field;
            }
            ++n;
        }
        return null;
    }

    public static String toLogName(Field field) {
        String string = field.name();
        String string2 = field.qname();
        if (string.equals("log")) {
            return string2.substring(0, string2.length() - ".log".length());
        }
        if (string.length() >= 4 && string.endsWith("Log")) {
            return string2.substring(0, string2.length() - "Log".length());
        }
        return string2;
    }

    public static Method toPrintMethod(Namespace namespace, Type type) {
        if (type.isStr()) {
            return namespace.resolveMethod("sys::OutStream.print", true);
        }
        if (type.isBool()) {
            return namespace.resolveMethod("sys::OutStream.printBool", true);
        }
        if (type.isInteger()) {
            return namespace.resolveMethod("sys::OutStream.printInt", true);
        }
        if (type.isLong()) {
            return namespace.resolveMethod("sys::OutStream.printLong", true);
        }
        if (type.isFloat()) {
            return namespace.resolveMethod("sys::OutStream.printFloat", true);
        }
        if (type.isDouble()) {
            return namespace.resolveMethod("sys::OutStream.printDouble", true);
        }
        return null;
    }

    public static boolean isTestOnly(Type type) {
        return type.facets().getb("testonly", false);
    }

    public static String flagsToString(Type type) {
        StringBuffer stringBuffer = new StringBuffer();
        if (type.isAbstract()) {
            stringBuffer.append("abstract ");
        }
        if (type.isConst()) {
            stringBuffer.append("const ");
        }
        if (type.isFinal()) {
            stringBuffer.append("final ");
        }
        if (type.isInternal()) {
            stringBuffer.append("internal ");
        }
        return stringBuffer.toString();
    }

    public static String flagsToString(Slot slot) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!slot.isAction() && !slot.isProperty()) {
            if (slot.isInternal()) {
                stringBuffer.append("internal ");
            }
            if (slot.isProtected()) {
                stringBuffer.append("protected ");
            }
            if (slot.isPrivate()) {
                stringBuffer.append("private ");
            }
            if (slot.isPublic()) {
                stringBuffer.append("public ");
            }
        }
        if (slot.isAbstract()) {
            stringBuffer.append("abstract ");
        } else if (slot.isVirtual() && !slot.isAction()) {
            stringBuffer.append("virtual ");
        }
        if (slot.isDefine()) {
            stringBuffer.append("define ");
        } else if (slot.isStatic()) {
            stringBuffer.append("static ");
        }
        if (slot.isProperty()) {
            stringBuffer.append("property ");
        } else if (slot.isInline()) {
            stringBuffer.append("inline ");
        }
        if (slot.isConst()) {
            stringBuffer.append("const ");
        }
        if (slot.isAction()) {
            stringBuffer.append("action ");
        }
        if (slot.isNative()) {
            stringBuffer.append("native ");
        }
        if (slot.isOverride()) {
            stringBuffer.append("override ");
        }
        return stringBuffer.toString();
    }

    public static int rtFlags(Slot slot, Facets facets) {
        int n = 0;
        if (slot instanceof Method) {
            n |= 1;
        }
        if (facets.getb("config")) {
            n |= 2;
        }
        if (facets.getb("asStr")) {
            n |= 4;
        }
        if (facets.getb("operator")) {
            n |= 8;
        }
        return n;
    }

    public static int numParams(Method method) {
        Type[] typeArray = method.paramTypes();
        int n = 0;
        int n2 = 0;
        while (n2 < typeArray.length) {
            n += typeArray[n2].isWide() + 1;
            ++n2;
        }
        if (!method.isStatic()) {
            ++n;
        }
        return n;
    }

    public static String toCodeString(Object object) {
        if (object == null) {
            throw new IllegalStateException("Unexpected null value");
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof Integer) {
            return object.toString();
        }
        if (object instanceof Long) {
            return (Long)object == Long.MIN_VALUE ? "0x8000_0000_0000_0000L" : object.toString() + 'L';
        }
        if (object instanceof Float) {
            return Env.floatFormat((float)((Float)object).floatValue()) + 'F';
        }
        if (object instanceof Double) {
            return Env.doubleFormat((double)((Double)object)) + 'D';
        }
        if (object instanceof String) {
            return "\"" + TextUtil.toLiteral((String)object.toString()) + '\"';
        }
        if (object instanceof Buf) {
            return ((Buf)object).toString();
        }
        if (object instanceof Type) {
            return ((Type)object).qname();
        }
        if (object instanceof Slot) {
            return ((Slot)object).qname();
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            if (objectArray.length == 0) {
                return "{,}";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            int n = 0;
            while (n < objectArray.length) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(TypeUtil.toCodeString(objectArray[n]));
                ++n;
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
        throw new IllegalStateException("Unexpected literal type: " + object.getClass().getName());
    }

    public static String toCodeStringSafe(Object object) {
        try {
            return TypeUtil.toCodeString(object);
        }
        catch (Exception exception) {
            try {
                String.valueOf(object);
            }
            catch (Exception exception2) {}
            return "???";
        }
    }
}

