/*
 * Decompiled with CFR 0.152.
 */
package sedonac.ast;

import sedonac.Location;
import sedonac.ast.AstNode;
import sedonac.ast.AstVisitor;
import sedonac.ast.AstWriter;
import sedonac.ast.Block;
import sedonac.ast.Expr;
import sedonac.ast.LocalScope;
import sedonac.ast.VarDef;
import sedonac.ir.IrOp;
import sedonac.namespace.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Stmt
extends AstNode {
    public static final int EXPR_STMT = 1;
    public static final int LOCAL_DEF = 2;
    public static final int RETURN = 3;
    public static final int IF = 4;
    public static final int FOR = 5;
    public static final int FOREACH = 6;
    public static final int WHILE = 7;
    public static final int DO_WHILE = 8;
    public static final int BREAK = 9;
    public static final int CONTINUE = 10;
    public static final int ASSERT = 11;
    public static final int GOTO = 12;
    public static final int SWITCH = 13;
    public final int id;
    public String label;
    public int mark;

    public void walk(AstVisitor astVisitor) {
        astVisitor.enterStmt(this);
        this.doWalk(astVisitor);
        astVisitor.exitStmt(this);
    }

    public boolean isExit() {
        return false;
    }

    public abstract int maxStack();

    static int max(int n, int n2) {
        return Math.max(n, n2);
    }

    static int max(int n, int n2, int n3) {
        return Math.max(Math.max(n, n2), n3);
    }

    static int max(int n, int n2, int n3, int n4) {
        return Math.max(Math.max(n, n2), Math.max(n3, n4));
    }

    protected abstract void doWalk(AstVisitor var1);

    private final /* synthetic */ void this() {
        this.mark = -1;
    }

    Stmt(Location location, int n) {
        super(location);
        this.this();
        this.id = n;
    }

    public static class Case
    extends AstNode {
        public Expr label;
        public Block block;

        public void walk(AstVisitor astVisitor) {
            this.label = this.label.walk(astVisitor);
            if (this.block != null) {
                this.block.walk(astVisitor);
            }
        }

        public int maxStack() {
            int n = 0;
            if (this.block != null) {
                n = this.block.maxStack();
            }
            return n;
        }

        public void write(AstWriter astWriter) {
            astWriter.indent().w("case:").w(this.label).nl();
            if (this.block != null) {
                this.block.write(astWriter, false);
            }
        }

        public Case(Location location) {
            super(location);
        }
    }

    public static class Switch
    extends Stmt {
        public Expr cond;
        public Case[] cases;
        public Block defaultBlock;

        public boolean isExit() {
            if (this.defaultBlock == null) {
                return false;
            }
            int n = 0;
            while (n < this.cases.length) {
                if (this.cases[n].block != null && !this.cases[n].block.isExit()) {
                    return false;
                }
                ++n;
            }
            return this.defaultBlock.isExit();
        }

        protected void doWalk(AstVisitor astVisitor) {
            this.cond = this.cond.walk(astVisitor);
            int n = 0;
            while (n < this.cases.length) {
                this.cases[n].walk(astVisitor);
                ++n;
            }
            if (this.defaultBlock != null) {
                this.defaultBlock.walk(astVisitor);
            }
        }

        public int maxStack() {
            int n = this.cond.maxStack();
            int n2 = 0;
            while (n2 < this.cases.length) {
                n = Switch.max(n, this.cases[n2].maxStack());
                ++n2;
            }
            if (this.defaultBlock != null) {
                n = Switch.max(n, this.defaultBlock.maxStack());
            }
            return n;
        }

        public void write(AstWriter astWriter) {
            astWriter.indent().w("switch (").w(this.cond).w(")").nl();
            astWriter.indent().w("{").nl();
            ++astWriter.indent;
            int n = 0;
            while (n < this.cases.length) {
                this.cases[n].write(astWriter);
                ++n;
            }
            if (this.defaultBlock != null) {
                astWriter.indent().w("default:").nl();
                this.defaultBlock.write(astWriter, false);
            }
            --astWriter.indent;
            astWriter.indent().w("}").nl();
        }

        public Switch(Location location) {
            super(location, 13);
        }
    }

    public static class Goto
    extends Stmt {
        public String destLabel;
        public Stmt destStmt;
        public IrOp op;

        public boolean isExit() {
            return true;
        }

        public int maxStack() {
            return 0;
        }

        protected void doWalk(AstVisitor astVisitor) {
        }

        public void write(AstWriter astWriter) {
            astWriter.indent().w("goto ").w(this.destLabel).nl();
        }

        public Goto(Location location) {
            super(location, 12);
        }
    }

    public static class Assert
    extends Stmt {
        public Expr cond;

        protected void doWalk(AstVisitor astVisitor) {
            this.cond = this.cond.walk(astVisitor);
        }

        public int maxStack() {
            return this.cond.maxStack();
        }

        public void write(AstWriter astWriter) {
            astWriter.indent().w("assert (").w(this.cond).w(")").nl();
        }

        public Assert(Location location) {
            super(location, 11);
        }
    }

    public static class Continue
    extends Stmt {
        protected void doWalk(AstVisitor astVisitor) {
        }

        public int maxStack() {
            return 0;
        }

        public void write(AstWriter astWriter) {
            astWriter.indent().w("continue").nl();
        }

        public Continue(Location location) {
            super(location, 10);
        }
    }

    public static class Break
    extends Stmt {
        protected void doWalk(AstVisitor astVisitor) {
        }

        public int maxStack() {
            return 0;
        }

        public void write(AstWriter astWriter) {
            astWriter.indent().w("break").nl();
        }

        public Break(Location location) {
            super(location, 9);
        }
    }

    public static class DoWhile
    extends Stmt {
        public Expr cond;
        public Block block;

        protected void doWalk(AstVisitor astVisitor) {
            if (this.cond != null) {
                this.cond = this.cond.walk(astVisitor);
            }
            this.block.walk(astVisitor);
        }

        public int maxStack() {
            int n = this.cond.maxStack();
            int n2 = this.block.maxStack();
            return DoWhile.max(n, n2);
        }

        public void write(AstWriter astWriter) {
            astWriter.indent().w("do").nl();
            this.block.write(astWriter);
            astWriter.indent().w("while (").w(this.cond).w(")").nl();
        }

        public DoWhile(Location location) {
            super(location, 8);
        }
    }

    public static class While
    extends Stmt {
        public Expr cond;
        public Block block;

        protected void doWalk(AstVisitor astVisitor) {
            if (this.cond != null) {
                this.cond = this.cond.walk(astVisitor);
            }
            this.block.walk(astVisitor);
        }

        public int maxStack() {
            int n = this.cond.maxStack();
            int n2 = this.block.maxStack();
            return While.max(n, n2);
        }

        public void write(AstWriter astWriter) {
            astWriter.indent().w("while (").w(this.cond).w(")").nl();
            this.block.write(astWriter);
        }

        public While(Location location) {
            super(location, 7);
        }
    }

    public static class Foreach
    extends Stmt
    implements LocalScope {
        public LocalDef local;
        public Expr array;
        public Expr length;
        public Block block;

        public LocalDef[] getLocals() {
            return new LocalDef[]{this.local};
        }

        public LocalDef resolveLocal(String string) {
            return LocalDef.isLocal(this.local, string);
        }

        protected void doWalk(AstVisitor astVisitor) {
            this.local.walk(astVisitor);
            this.array = this.array.walk(astVisitor);
            if (this.length != null) {
                this.length = this.length.walk(astVisitor);
            }
            this.block.walk(astVisitor);
        }

        public int maxStack() {
            int n = this.array.maxStack();
            int n2 = 0;
            if (this.length != null) {
                n2 = this.length.maxStack();
            }
            int n3 = n2;
            int n4 = this.block.maxStack();
            return Foreach.max(n + n3 + 2, n4);
        }

        public void write(AstWriter astWriter) {
            astWriter.indent().w("foreach (").w(this.local).w(" : ").w(this.array);
            if (this.length != null) {
                astWriter.w(", ").w(this.length);
            }
            astWriter.w(")").nl();
            this.block.write(astWriter);
        }

        public Foreach(Location location) {
            super(location, 6);
        }
    }

    public static class For
    extends Stmt
    implements LocalScope {
        public Stmt init;
        public Expr cond;
        public Expr update;
        public Block block;

        public LocalDef[] getLocals() {
            if (this.init instanceof LocalDef) {
                return new LocalDef[]{(LocalDef)this.init};
            }
            return new LocalDef[0];
        }

        public LocalDef resolveLocal(String string) {
            return LocalDef.isLocal(this.init, string);
        }

        protected void doWalk(AstVisitor astVisitor) {
            if (this.init != null) {
                this.init.walk(astVisitor);
            }
            if (this.cond != null) {
                this.cond = this.cond.walk(astVisitor);
            }
            if (this.update != null) {
                this.update = this.update.walk(astVisitor);
            }
            this.block.walk(astVisitor);
        }

        public int maxStack() {
            int n = 0;
            if (this.init != null) {
                n = this.init.maxStack();
            }
            int n2 = n;
            int n3 = 0;
            if (this.cond != null) {
                n3 = this.cond.maxStack();
            }
            int n4 = n3;
            int n5 = 0;
            if (this.update != null) {
                n5 = this.update.maxStack();
            }
            int n6 = n5;
            int n7 = this.block.maxStack();
            return For.max(n2, n4, n6, n7);
        }

        public void write(AstWriter astWriter) {
            astWriter.indent().w("for (");
            if (this.init != null) {
                astWriter.w(this.init);
            }
            astWriter.w("; ");
            if (this.cond != null) {
                astWriter.w(this.cond);
            }
            astWriter.w("; ");
            if (this.update != null) {
                astWriter.w(this.update);
            }
            astWriter.w(")").nl();
            this.block.write(astWriter);
        }

        public For(Location location) {
            super(location, 5);
        }
    }

    public static class If
    extends Stmt {
        public Expr cond;
        public Block trueBlock;
        public Block falseBlock;

        public boolean isExit() {
            if (this.falseBlock == null) {
                return false;
            }
            boolean bl = false;
            if (this.trueBlock.isExit() && this.falseBlock.isExit()) {
                bl = true;
            }
            return bl;
        }

        protected void doWalk(AstVisitor astVisitor) {
            this.cond = this.cond.walk(astVisitor);
            this.trueBlock.walk(astVisitor);
            if (this.falseBlock != null) {
                this.falseBlock.walk(astVisitor);
            }
        }

        public int maxStack() {
            int n = this.cond.maxStack();
            int n2 = this.trueBlock.maxStack();
            int n3 = 0;
            if (this.falseBlock != null) {
                n3 = this.falseBlock.maxStack();
            }
            int n4 = n3;
            return If.max(n, n2, n4);
        }

        public void write(AstWriter astWriter) {
            astWriter.indent().w("if (").w(this.cond).w(")").nl();
            this.trueBlock.write(astWriter);
            if (this.falseBlock != null) {
                astWriter.indent().w("else").nl();
                this.falseBlock.write(astWriter);
            }
        }

        public If(Location location) {
            super(location, 4);
        }
    }

    public static class Return
    extends Stmt {
        public Expr expr;
        public int foreachDepth;

        protected void doWalk(AstVisitor astVisitor) {
            if (this.expr != null) {
                this.expr = this.expr.walk(astVisitor);
            }
        }

        public boolean isExit() {
            return true;
        }

        public int maxStack() {
            int n = 0;
            if (this.expr != null) {
                n = this.expr.maxStack();
            }
            return n;
        }

        public void write(AstWriter astWriter) {
            astWriter.indent().w("return ");
            if (this.expr != null) {
                astWriter.w(this.expr);
            }
            astWriter.nl();
        }

        public Return(Location location) {
            super(location, 3);
        }
    }

    public static class LocalDef
    extends Stmt
    implements VarDef {
        public int index;
        public Type type;
        public String name;
        public Expr init;
        public boolean declared;

        public int index() {
            return this.index;
        }

        public Type type() {
            return this.type;
        }

        public String name() {
            return this.name;
        }

        public boolean isParam() {
            return false;
        }

        public boolean isLocal() {
            return true;
        }

        public String toString() {
            return this.type + ' ' + this.name;
        }

        public int maxStack() {
            int n = 0;
            if (this.init != null) {
                n = this.init.maxStack();
            }
            return n;
        }

        protected void doWalk(AstVisitor astVisitor) {
            if (this.init != null) {
                this.init = this.init.walk(astVisitor);
            }
            this.type = astVisitor.type(this.type);
        }

        public void write(AstWriter astWriter) {
            astWriter.indent().w(this.type).w(" ").w(this.name);
            if (this.init != null) {
                astWriter.w(" = ").w(this.init);
            }
            astWriter.nl();
        }

        public static LocalDef isLocal(Stmt stmt, String string) {
            if (stmt instanceof LocalDef) {
                LocalDef localDef = (LocalDef)stmt;
                if (localDef.name.equals(string)) {
                    return localDef;
                }
            }
            return null;
        }

        public LocalDef(Location location, Type type, String string, Expr expr) {
            super(location, 2);
            this.type = type;
            this.name = string;
            this.init = expr;
        }

        public LocalDef(Location location, Type type, String string) {
            this(location, type, string, null);
        }
    }

    public static class ExprStmt
    extends Stmt {
        public Expr expr;

        protected void doWalk(AstVisitor astVisitor) {
            this.expr = this.expr.walk(astVisitor);
        }

        public int maxStack() {
            return this.expr.maxStack();
        }

        public void write(AstWriter astWriter) {
            astWriter.indent().w(this.expr).nl();
        }

        public ExprStmt(Location location, Expr expr) {
            super(location, 1);
            this.expr = expr;
        }
    }
}

