/*
 * Decompiled with CFR 0.152.
 */
package sedonac.analysis;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.analysis.BasicBlock;
import sedonac.analysis.ControlFlowGraph;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DeadCodeAnalysis
extends CompilerStep {
    protected final ControlFlowGraph cfg;
    protected final BlockComparator bc;

    public void run() {
        Object object;
        HashSet hashSet = this.cfg.asSet();
        HashSet hashSet2 = new HashSet();
        Iterator iterator = this.cfg.depthFirstIterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            hashSet.remove(object);
            hashSet2.add(object);
        }
        if (hashSet.isEmpty()) {
            return;
        }
        object = hashSet.toArray(new BasicBlock[hashSet.size()]);
        Arrays.sort(object, this.bc);
        BasicBlock[] basicBlockArray = hashSet2.toArray(new BasicBlock[hashSet2.size()]);
        Arrays.sort(basicBlockArray, this.bc);
        this.reportDeadRanges((BasicBlock[])object, basicBlockArray);
    }

    private final void reportDeadRanges(BasicBlock[] basicBlockArray, BasicBlock[] basicBlockArray2) {
        int n = 0;
        int n2 = 0;
        do {
            n2 = n + 1;
            block1: while (n2 < basicBlockArray.length) {
                int n3 = 0;
                while (n3 < basicBlockArray2.length) {
                    if (this.between(basicBlockArray[n], basicBlockArray2[n3], basicBlockArray[n2])) break block1;
                    ++n3;
                }
                ++n2;
            }
            this.reportRange(basicBlockArray[n], basicBlockArray[n2 - 1]);
        } while ((n = n2) < basicBlockArray.length);
    }

    private final void reportRange(BasicBlock basicBlock, BasicBlock basicBlock2) {
        if (basicBlock == this.cfg.exit()) {
            this.err("Method '" + this.cfg.method.qname() + "' never exits", this.cfg.method.loc);
        } else {
            Location location = basicBlock.getFirstStmt().loc;
            Location location2 = basicBlock2.getLastStmt().loc;
            StringBuffer stringBuffer = new StringBuffer().append(location);
            if (location.compareTo(location2) != 0) {
                stringBuffer.append(" - ").append(location2.line).append(':').append(location2.col);
            }
            stringBuffer.append(": Dead Code");
            this.warn(stringBuffer.toString());
        }
    }

    private final boolean between(BasicBlock basicBlock, BasicBlock basicBlock2, BasicBlock basicBlock3) {
        if (basicBlock3 == this.cfg.exit()) {
            return true;
        }
        return this.bc.compare(basicBlock, basicBlock2) < 0 && this.bc.compare(basicBlock2, basicBlock3) < 0;
    }

    private final /* synthetic */ void this() {
        this.bc = new BlockComparator();
    }

    public DeadCodeAnalysis(Compiler compiler, ControlFlowGraph controlFlowGraph) {
        super(compiler);
        this.this();
        this.cfg = controlFlowGraph;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class BlockComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            BasicBlock basicBlock = (BasicBlock)object;
            BasicBlock basicBlock2 = (BasicBlock)object2;
            if (basicBlock == DeadCodeAnalysis.this.cfg.exit()) {
                return 1;
            }
            if (basicBlock2 == DeadCodeAnalysis.this.cfg.exit()) {
                return -1;
            }
            return basicBlock.getFirstStmt().loc.compareTo(basicBlock2.getFirstStmt().loc);
        }

        private BlockComparator() {
        }
    }
}

