/*
 * Decompiled with CFR 0.152.
 */
package sedona.util;

import java.text.DecimalFormat;
import java.util.Comparator;

public class TextUtil {
    private static String[] SPACES = new String[50];
    public static Comparator caseInsensitiveComparator;

    public static String byteToString(int n) {
        return Integer.toString(n);
    }

    public static String byteToHexString(int n) {
        String string = Integer.toHexString(n & 0xFF);
        if (string.length() == 1) {
            return "0" + string;
        }
        return string;
    }

    public static char byteToChar(int n, char c) {
        if (n < 32 || n > 126) {
            return c;
        }
        return (char)n;
    }

    public static String intToHexString(int n) {
        return TextUtil.intToHexString(n, 8);
    }

    public static String intToHexString(int n, int n2) {
        if (n2 < 1 || n2 > 8) {
            n2 = 8;
        }
        String string = Integer.toHexString(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    public static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(TextUtil.byteToHexString(byArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static int charToInt(char c) {
        int n = c - 48;
        if (n < 0 || n > 9) {
            throw new IllegalArgumentException("'" + c + '\'');
        }
        return n;
    }

    public static int hexCharToInt(char c) {
        int n = c - 48;
        if (n >= 0 && n <= 9) {
            return n;
        }
        n = c - 65 + 10;
        if (n >= 10 && n <= 15) {
            return n;
        }
        n = c - 97 + 10;
        if (n >= 10 && n <= 15) {
            return n;
        }
        throw new IllegalArgumentException("'" + c + '\'');
    }

    public static boolean isHex(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static long parseHexLong(String string) {
        long l = 0L;
        int n = 0;
        while (n < string.length()) {
            l = (l << 4) + (long)TextUtil.hexCharToInt(string.charAt(n));
            ++n;
        }
        return l;
    }

    public static String toLiteral(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\u0000': {
                    stringBuffer.append("\\0");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '$': {
                    stringBuffer.append("\\$");
                    break;
                }
                default: {
                    if (c < ' ') {
                        throw new IllegalStateException("Escape sequences not implemented");
                    }
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String fromLiteral(String string) {
        int n = string.indexOf(92);
        if (n < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c != '\\') {
                stringBuffer.append(c);
            } else {
                c = string.charAt(++n2);
                switch (c) {
                    case '0': {
                        stringBuffer.append('\u0000');
                        break;
                    }
                    case 'n': {
                        stringBuffer.append('\n');
                        break;
                    }
                    case 'r': {
                        stringBuffer.append('\r');
                        break;
                    }
                    case 't': {
                        stringBuffer.append('\t');
                        break;
                    }
                    case '\\': {
                        stringBuffer.append('\\');
                        break;
                    }
                    case '\"': {
                        stringBuffer.append('\"');
                        break;
                    }
                    case '$': {
                        stringBuffer.append('$');
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown escape sequence: " + string);
                    }
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String getSpaces(int n) {
        try {
            return SPACES[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (n < 0) {
                return "";
            }
            int n2 = SPACES.length;
            StringBuffer stringBuffer = new StringBuffer(n);
            int n3 = n;
            while (true) {
                if (n3 < n2) break;
                stringBuffer.append(SPACES[n2 - 1]);
                n3 -= n2 - 1;
            }
            stringBuffer.append(SPACES[n3]);
            return stringBuffer.toString();
        }
    }

    public static String pad(String string, int n) {
        return TextUtil.padRight(string, n);
    }

    public static String padRight(String string, int n) {
        if (string.length() >= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string).append(TextUtil.getSpaces(n - string.length()));
        return stringBuffer.toString();
    }

    public static String padLeft(String string, int n) {
        if (string.length() >= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(TextUtil.getSpaces(n - string.length())).append(string);
        return stringBuffer.toString();
    }

    public static String truncate(String string, int n) {
        return string.length() > n ? string.substring(0, n) : string;
    }

    public static char toUpperCase(char c) {
        if ('a' <= c && c <= 'z') {
            return (char)(c & 0xFFFFFFDF);
        }
        return c;
    }

    public static char toLowerCase(char c) {
        if ('A' <= c && c <= 'Z') {
            return (char)(c | 0x20);
        }
        return c;
    }

    public static String toUpperCase(String string) {
        int n;
        int n2;
        int c2 = string.length();
        int c3 = -1;
        int cArray = 0;
        while (cArray < c2) {
            char c;
            n2 = string.charAt(cArray);
            if (n2 != (c = TextUtil.toUpperCase((char)n2))) {
                n = cArray;
                break;
            }
            ++cArray;
        }
        if (n == -1) {
            return string;
        }
        char[] cArray2 = new char[c2];
        string.getChars(0, n, cArray2, 0);
        n2 = n;
        while (n2 < c2) {
            cArray2[n2] = TextUtil.toUpperCase(string.charAt(n2));
            ++n2;
        }
        return new String(cArray2);
    }

    public static String toLowerCase(String string) {
        int n;
        int n2;
        int c2 = string.length();
        int c3 = -1;
        int cArray = 0;
        while (cArray < c2) {
            char c;
            n2 = string.charAt(cArray);
            if (n2 != (c = TextUtil.toLowerCase((char)n2))) {
                n = cArray;
                break;
            }
            ++cArray;
        }
        if (n == -1) {
            return string;
        }
        char[] cArray2 = new char[c2];
        string.getChars(0, n, cArray2, 0);
        n2 = n;
        while (n2 < c2) {
            cArray2[n2] = TextUtil.toLowerCase(string.charAt(n2));
            ++n2;
        }
        return new String(cArray2);
    }

    public static String capitalize(String string) {
        char[] cArray = string.toCharArray();
        cArray[0] = TextUtil.toUpperCase(cArray[0]);
        return new String(cArray);
    }

    public static String decapitalize(String string) {
        char[] cArray = string.toCharArray();
        cArray[0] = TextUtil.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    public static String getClassName(Class clazz) {
        return TextUtil.getClassName(clazz.getName());
    }

    public static String getClassName(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if (string.charAt(string.length() - 1) == ';') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String getPackageName(Class clazz) {
        return TextUtil.getPackageName(clazz.getName());
    }

    public static String getPackageName(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        return string.substring(0, n);
    }

    public static String kb(int n) {
        double d = (double)n / 1024.0;
        return TextUtil.padLeft(new DecimalFormat("#.#kb").format(d), 8) + " (" + n + " bytes)";
    }

    public static String[] split(String string, char c) {
        if (string.indexOf(c) == -1) {
            if (string.length() == 0) {
                return new String[0];
            }
            return new String[]{string};
        }
        String[] stringArray = new String[8];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == c) {
                stringArray = TextUtil.ensureCapacity(stringArray, n3);
                stringArray[n3++] = string.substring(n, n2);
                n = ++n2;
                continue;
            }
            ++n2;
        }
        stringArray = TextUtil.ensureCapacity(stringArray, n3);
        stringArray[n3++] = string.substring(n, string.length());
        if (n3 == stringArray.length) {
            return stringArray;
        }
        String[] stringArray2 = new String[n3];
        System.arraycopy(stringArray, 0, stringArray2, 0, n3);
        return stringArray2;
    }

    public static String[] splitAndTrim(String string, char c) {
        return TextUtil.trim(TextUtil.split(string, c));
    }

    public static String join(Object[] objectArray, String string) {
        return TextUtil.join(objectArray, 0, objectArray.length, string);
    }

    public static String join(Object[] objectArray, int n, int n2, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (n3 < n2) {
            if (n3 > n) {
                stringBuffer.append(string);
            }
            stringBuffer.append(objectArray[n3]);
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String[] ensureCapacity(String[] stringArray, int n) {
        if (n < stringArray.length) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length * 2];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    public static String[] trim(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                stringArray[n] = stringArray[n].trim();
            }
            ++n;
        }
        return stringArray;
    }

    public static String join(String[] stringArray, char c) {
        if (stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length - 1;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(stringArray[n2]).append(c);
            ++n2;
        }
        stringBuffer.append(stringArray[n]);
        return stringBuffer.toString();
    }

    public static String trimLeft(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() > 0 && Character.isWhitespace(stringBuffer.charAt(0))) {
            stringBuffer.deleteCharAt(0);
        }
        return stringBuffer.toString();
    }

    public static String trimRight(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        while (n > 0 && Character.isWhitespace(stringBuffer.charAt(n - 1))) {
            stringBuffer.deleteCharAt(n - 1);
            --n;
        }
        return stringBuffer.toString();
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string2 == null) {
            throw new NullPointerException();
        }
        if (string3 == null) {
            throw new NullPointerException();
        }
        int n = string.indexOf(string2, 0);
        if (n == -1) {
            return string;
        }
        return TextUtil.doReplace(new StringBuffer(string), string2, string3, n).toString();
    }

    public static StringBuffer replace(StringBuffer stringBuffer, String string, String string2) {
        if (stringBuffer == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (string2 == null) {
            throw new NullPointerException();
        }
        int n = TextUtil.indexOf(stringBuffer, string, 0);
        if (n == -1) {
            return stringBuffer;
        }
        return TextUtil.doReplace(stringBuffer, string, string2, n);
    }

    private static final StringBuffer doReplace(StringBuffer stringBuffer, String string, String string2, int n) {
        int n2 = string.length();
        int n3 = string2.length();
        while (n != -1) {
            stringBuffer.replace(n, n + n2, string2);
            n = TextUtil.indexOf(stringBuffer, string, n + n3);
        }
        return stringBuffer;
    }

    public static int indexOf(StringBuffer stringBuffer, String string) {
        return TextUtil.indexOf(stringBuffer, string, 0);
    }

    public static int indexOf(StringBuffer stringBuffer, String string, int n) {
        int n2;
        if (stringBuffer == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        int[] nArray = TextUtil.computeOverlap(string);
        int n3 = 0;
        int n4 = stringBuffer.length();
        int n5 = string.length();
        int n6 = 0;
        if (n >= 0) {
            n6 = n;
        }
        int n7 = n2 = n6;
        while (n7 < n4) {
            while (true) {
                if (stringBuffer.charAt(n7) == string.charAt(n3)) {
                    if (++n3 != n5) break;
                    return n7 - n5 + 1;
                }
                if (n3 == 0) break;
                n3 = nArray[n3];
            }
            ++n7;
        }
        return -1;
    }

    private static final int[] computeOverlap(String string) {
        int n = string.length();
        int[] nArray = new int[n + 1];
        nArray[0] = -1;
        int n2 = 0;
        while (n2 < n) {
            nArray[n2 + 1] = nArray[n2] + 1;
            while (nArray[n2 + 1] > 0 && string.charAt(n2) != string.charAt(nArray[n2 + 1] - 1)) {
                nArray[n2 + 1] = nArray[nArray[n2 + 1] - 1] + 1;
            }
            ++n2;
        }
        return nArray;
    }

    static {
        TextUtil.SPACES[0] = "";
        int n = 1;
        while (n < 50) {
            TextUtil.SPACES[n] = SPACES[n - 1] + ' ';
            ++n;
        }
        caseInsensitiveComparator = new Comparator(){

            public final int compare(Object object, Object object2) {
                return TextUtil.toLowerCase(object.toString()).compareTo(TextUtil.toLowerCase(object2.toString()));
            }
        };
    }
}

