/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.io.IOException;
import sedona.Buf;
import sedona.Value;

public final class Byte
extends Value {
    static final Byte[] predefined = new Byte[256];
    static final Byte ZERO;
    static final Byte MAX;
    public final int val;

    public static final Byte make(int n) {
        if (n < 0 || n > Byte.MAX.val) {
            throw new IllegalArgumentException("Valid Byte range [0-" + Byte.MAX.val + "]: val = " + n);
        }
        return predefined[n];
    }

    public final int typeId() {
        return 2;
    }

    public final boolean equals(Object object) {
        if (object instanceof Byte) {
            boolean bl = false;
            if (this.val == ((Byte)object).val) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final int hashCode() {
        return this.val;
    }

    public final String encodeString() {
        return String.valueOf(this.val);
    }

    public final Value decodeString(String string) {
        return Byte.make(Integer.decode(string));
    }

    public final void encodeBinary(Buf buf) {
        buf.u1(this.val);
    }

    public final Value decodeBinary(Buf buf) throws IOException {
        return Byte.make(buf.u1());
    }

    private Byte(int n) {
        this.val = n;
    }

    static {
        int n = 0;
        while (n < predefined.length) {
            Byte.predefined[n] = new Byte(n);
            ++n;
        }
        ZERO = predefined[0];
        MAX = predefined[255];
    }
}

