/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.ui.pstore;

import com.tridium.nsedona.sys.BISedonaSpace;
import com.tridium.nsedona.sys.BSedonaComponent;
import com.tridium.nsedona.ui.SedonaConst;
import com.tridium.nsedona.ui.pstore.BPstoreGraph;
import com.tridium.nsedona.ui.pstore.FileItem;
import com.tridium.nsedona.ui.pstore.FileItemModel;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.transfer.TransferUtil;
import java.util.ArrayList;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.space.Mark;
import javax.baja.sys.Action;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.commands.ReflectCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.util.TextUtil;
import javax.baja.workbench.view.BWbComponentView;
import sedona.Component;
import sedona.Schema;
import sedona.Str;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPstoreManager
extends BWbComponentView
implements SedonaConst {
    public static final Type TYPE;
    static BFont bold;
    BSedonaComponent service;
    BISedonaSpace space;
    Schema schema;
    FileItemModel model;
    BTable table;
    BPstoreGraph graph;
    Command layout;
    Command add;
    Command clear;
    Command delete;
    boolean editConfirmed;
    ArrayList autoSelect;
    static /* synthetic */ Class class$com$tridium$nsedona$ui$pstore$BPstoreManager;

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        this.service = (BSedonaComponent)bObject;
        this.space = (BISedonaSpace)this.service.getSpace();
        this.schema = this.service.s().type.schema;
        this.model = new FileItemModel().load(this.service);
        this.graph = new BPstoreGraph(this, this.model);
        BScrollPane bScrollPane = new BScrollPane((BWidget)this.graph);
        bScrollPane.setHpolicy(BScrollBarPolicy.never);
        this.table = new BTable((TableModel)this.model);
        this.model.selection = new TableSelection(){

            public final void updateTable() {
                super.updateTable();
                BPstoreManager.this.tableSelectionModified();
            }
        };
        this.table.setSelection(this.model.selection);
        this.table.setController(new TableController(){

            protected final void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
                BPstoreManager.this.tableDoubleClicked(bMouseEvent, n, n2);
            }
        });
        this.registerForComponentEvents(this.service, 1);
        BGridPane bGridPane = new BGridPane();
        bGridPane.setColumnCount(4);
        bGridPane.setUniformColumnWidth(true);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.add(null, (BValue)new BButton(this.layout));
        bGridPane.add(null, (BValue)new BButton(this.add));
        bGridPane.add(null, (BValue)new BButton(this.clear));
        bGridPane.add(null, (BValue)new BButton(this.delete));
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)this.table);
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)bGridPane, BInsets.make((double)5, (double)0.0, (double)0.0, (double)0.0)));
        BSplitPane bSplitPane = new BSplitPane((BWidget)bEdgePane, (BWidget)bScrollPane);
        bSplitPane.setDividerPosition(60.0);
        this.setContent((BWidget)bSplitPane);
        this.graph.relayout();
        this.model.updateTable(true);
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        super.handleComponentEvent(bComponentEvent);
        if (bComponentEvent.getId() == 1) {
            this.registerForComponentEvents(this.service, 1);
        }
        this.model.reload();
        this.graph.relayout();
        this.model.updateTable(false);
        if (bComponentEvent.getId() == 1) {
            try {
                int n = 0;
                while (n < this.model.size()) {
                    if (this.autoSelect.contains(this.model.get((int)n).name)) {
                        this.table.getSelection().select(n);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {}
        }
    }

    public void tableDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
        FileItem fileItem = this.model.get(n);
        if (fileItem != null) {
            this.getWbShell().hyperlink(new HyperlinkInfo(fileItem.c.getNavOrd(), (BInputEvent)bMouseEvent));
        }
    }

    public void select(FileItem fileItem) {
        this.table.getSelection().deselectAll();
        this.table.getSelection().select(this.model.toRow(fileItem));
    }

    public void tableSelectionModified() {
        this.graph.repaint();
    }

    public void cmdLayout() {
        if (!this.confirmEdit()) {
            return;
        }
        FileItem[] fileItemArray = this.model.selected();
        if (fileItemArray.length == 0) {
            BDialog.message((BWidget)this, (Object)SedonaConst.lex.getText("pstore.layoutSelectFirst"));
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.model.size()) {
            n = Math.max(n, this.model.get(n2).end());
            ++n2;
        }
        BGridPane bGridPane = new BGridPane();
        bGridPane.setValign(BValign.top);
        bGridPane.setColumnCount(2);
        bGridPane.add(null, (BValue)new BLabel(SedonaConst.lex.getText("pstore.layoutOffset")));
        BTextField bTextField = new BTextField("" + n, 16);
        bGridPane.add(null, (BValue)bTextField);
        bGridPane.add(null, (BValue)new BLabel(SedonaConst.lex.getText("pstore.layoutSize")));
        BTextField bTextField2 = new BTextField("1KB", 16);
        bGridPane.add(null, (BValue)bTextField2);
        BList bList = new BList();
        int n3 = 0;
        while (n3 < fileItemArray.length) {
            bList.addItem(fileItemArray[n3].icon, (Object)fileItemArray[n3].name);
            ++n3;
        }
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bList);
        bConstrainedPane.setMinWidth(100.0);
        bConstrainedPane.setMaxHeight(400.0);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setLeft((BWidget)new BBorderPane((BWidget)bGridPane));
        bEdgePane.setCenter((BWidget)bConstrainedPane);
        int n4 = BDialog.open((BWidget)this, (String)this.layout.getLabel(), (Object)bEdgePane, (int)3);
        if (n4 != 1) {
            return;
        }
        int n5 = BPstoreManager.parseBytes(bTextField.getText());
        int n6 = BPstoreManager.parseBytes(bTextField2.getText());
        int n7 = 0;
        while (n7 < fileItemArray.length) {
            BSedonaComponent bSedonaComponent = fileItemArray[n7].c;
            bSedonaComponent.setInt(bSedonaComponent.getProperty("resvOffset"), n5);
            bSedonaComponent.setInt(bSedonaComponent.getProperty("resvSize"), n6);
            n5 += n6;
            ++n7;
        }
        this.service.invoke(this.service.getAction("validateAll"), null);
    }

    public void cmdAdd() throws Exception {
        Str str;
        sedona.Type type;
        if (!this.confirmEdit()) {
            return;
        }
        sedona.Type[] typeArray = this.schema.allConcreteTypes(this.schema.type("pstore::PstoreFile"));
        BListDropDown bListDropDown = new BListDropDown();
        int n = 0;
        while (n < typeArray.length) {
            type = typeArray[n];
            str = (Str)type.facet("niagaraIcon", true);
            BImage bImage = str != null ? BImage.make((String)str.toString()) : null;
            bListDropDown.getList().addItem(bImage, (Object)type);
            ++n;
        }
        bListDropDown.setSelectedIndex(0);
        BTextField bTextField = new BTextField("file", 8);
        type = new BTextField("1", 4);
        str = new BGridPane();
        str.setColumnCount(2);
        str.add(null, (BValue)new BLabel(SedonaConst.lex.getText("pstore.fileType")));
        str.add(null, (BValue)bListDropDown);
        str.add(null, (BValue)new BLabel(SedonaConst.lex.getText("pstore.fileName")));
        str.add(null, (BValue)bTextField);
        str.add(null, (BValue)new BLabel(SedonaConst.lex.getText("pstore.numToAdd")));
        str.add(null, (BValue)type);
        int n2 = BDialog.open((BWidget)this, (String)this.add.getLabel(), (Object)str, (int)3);
        if (n2 != 1) {
            return;
        }
        this.table.getSelection().deselectAll();
        sedona.Type type2 = (sedona.Type)bListDropDown.getSelectedItem();
        String string = bTextField.getText();
        int n3 = Integer.parseInt(type.getText());
        this.autoSelect = new ArrayList();
        int n4 = 0;
        while (n4 < n3) {
            String string2 = string;
            int n5 = 1;
            while (this.autoSelect.contains(string2) || this.service.get(string2) != null) {
                string2 = string + n5;
                ++n5;
            }
            this.autoSelect.add(string2);
            Component component = this.space.newInstance(type2.qname);
            this.service.add(string2, (BValue)new BSedonaComponent(component));
            ++n4;
        }
    }

    public void cmdClear() {
        FileItem[] fileItemArray = this.model.selected();
        if (fileItemArray.length == 0) {
            BDialog.message((BWidget)this, (Object)SedonaConst.lex.getText("pstore.clearSelectFirst"));
            return;
        }
        int n = BDialog.confirm((BWidget)this, (Object)SedonaConst.lex.getText("pstore.clearConfirm"));
        if (n != 4) {
            return;
        }
        int n2 = 0;
        while (n2 < fileItemArray.length) {
            BSedonaComponent bSedonaComponent = fileItemArray[n2].c;
            Action action = bSedonaComponent.getAction("clear");
            if (action != null) {
                bSedonaComponent.invoke(action, null);
            }
            ++n2;
        }
    }

    public CommandArtifact cmdDelete() throws Exception {
        if (!this.confirmEdit()) {
            return null;
        }
        BSedonaComponent[] bSedonaComponentArray = this.model.selectedComponents();
        if (bSedonaComponentArray.length == 0) {
            return null;
        }
        return TransferUtil.delete((BWidget)this, (Mark)new Mark((BObject[])bSedonaComponentArray));
    }

    boolean confirmEdit() {
        if (this.editConfirmed) {
            return true;
        }
        String string = SedonaConst.lex.getText("pstore.editConfirm");
        int n = BDialog.confirm((BWidget)this, (String)BDialog.TITLE_CONFIRM, (Object)string, (int)3);
        boolean bl = false;
        if (n == 1) {
            bl = true;
        }
        this.editConfirmed = bl;
        return bl;
    }

    static int parseBytes(String string) {
        string = TextUtil.toLowerCase((String)string.trim());
        int n = 1;
        if (string.endsWith("kb")) {
            string = string.substring(0, string.length() - 2).trim();
            n = 1024;
        }
        if (string.endsWith("mb")) {
            string = string.substring(0, string.length() - 2).trim();
            n = 0x100000;
        }
        if (string.endsWith("gb")) {
            string = string.substring(0, string.length() - 2).trim();
            n = 0x40000000;
        }
        return Integer.parseInt(string) * n;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.layout = new ReflectCommand((BWidget)this, SedonaConst.lex, "pstore.cmd.layout", "cmdLayout");
        this.add = new ReflectCommand((BWidget)this, SedonaConst.lex, "pstore.cmd.add", "cmdAdd");
        this.clear = new ReflectCommand((BWidget)this, SedonaConst.lex, "pstore.cmd.clear", "cmdClear");
        this.delete = new ReflectCommand((BWidget)this, SedonaConst.lex, "pstore.cmd.delete", "cmdDelete");
        this.editConfirmed = false;
        this.autoSelect = new ArrayList();
    }

    public BPstoreManager() {
        this.this();
        this.autoRegisterForComponentEvents = false;
    }

    static {
        Class clazz = class$com$tridium$nsedona$ui$pstore$BPstoreManager;
        if (clazz == null) {
            clazz = class$com$tridium$nsedona$ui$pstore$BPstoreManager = BPstoreManager.class("[Lcom.tridium.nsedona.ui.pstore.BPstoreManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        bold = Theme.widget().getBoldText();
    }
}

