/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.ui.daemon;

import com.tridium.nsedona.ui.daemon.BEnvTable;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.PlatformFileManager;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.platform.FileTransferOperation;
import javax.baja.platform.ICancelHint;
import javax.baja.util.Lexicon;
import javax.baja.util.Queue;
import sedona.Env;

public abstract class UnifiedFileSpace {
    protected final BDaemonSession daemonSession;
    private final BFileSpace delegate;

    public static UnifiedFileSpace makeLocal(BDaemonSession bDaemonSession) {
        return new LocalUnified(bDaemonSession);
    }

    public static UnifiedFileSpace makeDaemon(BDaemonSession bDaemonSession) {
        return new DaemonUnified(bDaemonSession);
    }

    public final BFileSpace getFileSpace() {
        return this.delegate;
    }

    public final boolean isLocalFileSpace() {
        boolean bl = false;
        if (this.delegate == BFileSystem.INSTANCE) {
            bl = true;
        }
        return bl;
    }

    public abstract FilePath getSedonaHome();

    public abstract BIFile[] getChildren(BIFile var1);

    public abstract BIFile findFile(FilePath var1);

    public abstract BIFile mkdir(FilePath var1);

    public abstract void transfer(BEnvTable.TransferItem[] var1, ICancelHint var2, DaemonSessionTaskListener var3) throws Exception;

    public abstract void delete(BEnvTable.TransferItem[] var1, ICancelHint var2, DaemonSessionTaskListener var3) throws Exception;

    protected UnifiedFileSpace(BDaemonSession bDaemonSession, BFileSpace bFileSpace) {
        this.daemonSession = bDaemonSession;
        this.delegate = bFileSpace;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class LocalUnified
    extends UnifiedFileSpace {
        private Lexicon lex;
        private BFileSystem lfs;
        static /* synthetic */ Class class$com$tridium$nsedona$ui$daemon$UnifiedFileSpace;

        public FilePath getSedonaHome() {
            return this.lfs.localFileToPath(Env.home);
        }

        public BIFile[] getChildren(BIFile bIFile) {
            return this.lfs.getChildren(bIFile);
        }

        public BIFile findFile(FilePath filePath) {
            return this.lfs.findFile(filePath);
        }

        public BIFile mkdir(FilePath filePath) {
            try {
                return this.lfs.makeDir(filePath);
            }
            catch (Exception exception) {
                return null;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void transfer(BEnvTable.TransferItem[] transferItemArray, ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
            this.checkCanceled(iCancelHint);
            CancelableDaemonSessionTask cancelableDaemonSessionTask = new CancelableDaemonSessionTask(this.lex, "ufs.transferTitle", "ufs.transferMessage", transferItemArray.length, iCancelHint);
            if (daemonSessionTaskListener == null) {
                daemonSessionTaskListener = DaemonSessionTaskListener.NULL_TASK_LISTENER;
            }
            cancelableDaemonSessionTask.setProgress(0);
            daemonSessionTaskListener.taskStarted((DaemonSessionTask)cancelableDaemonSessionTask);
            try {
                FilePath filePath = this.getSedonaHome();
                int n = 0;
                while (n < transferItemArray.length) {
                    this.checkCanceled(iCancelHint);
                    cancelableDaemonSessionTask.setProgress(n);
                    cancelableDaemonSessionTask.setMessage("Transferring " + transferItemArray[n].sedonaHomeRelPath);
                    daemonSessionTaskListener.taskUpdated((DaemonSessionTask)cancelableDaemonSessionTask);
                    FilePath filePath2 = filePath.merge(transferItemArray[n].sedonaHomeRelPath.getParent());
                    FileTransferOperation fileTransferOperation = FileTransferOperation.makeGet((FilePath)transferItemArray[n].file.getFilePath(), (FilePath)filePath2);
                    PlatformFileManager.make((BDaemonSession)this.daemonSession).transfer(fileTransferOperation, null);
                    ++n;
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                daemonSessionTaskListener.taskFinished((DaemonSessionTask)cancelableDaemonSessionTask);
                throw throwable;
            }
            {
                Object var6_11 = null;
            }
            daemonSessionTaskListener.taskFinished((DaemonSessionTask)cancelableDaemonSessionTask);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void delete(BEnvTable.TransferItem[] transferItemArray, ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
            this.checkCanceled(iCancelHint);
            CancelableDaemonSessionTask cancelableDaemonSessionTask = new CancelableDaemonSessionTask(this.lex, "ufs.deleteTitle", "ufs.deleteMessage", transferItemArray.length, iCancelHint);
            if (daemonSessionTaskListener == null) {
                daemonSessionTaskListener = DaemonSessionTaskListener.NULL_TASK_LISTENER;
            }
            cancelableDaemonSessionTask.setProgress(0);
            daemonSessionTaskListener.taskStarted((DaemonSessionTask)cancelableDaemonSessionTask);
            try {
                FilePath filePath = this.getSedonaHome();
                int n = 0;
                while (n < transferItemArray.length) {
                    this.checkCanceled(iCancelHint);
                    cancelableDaemonSessionTask.setProgress(n);
                    cancelableDaemonSessionTask.setMessage("Deleting " + transferItemArray[n].sedonaHomeRelPath);
                    daemonSessionTaskListener.taskUpdated((DaemonSessionTask)cancelableDaemonSessionTask);
                    this.lfs.delete(transferItemArray[n].file.getFilePath());
                    ++n;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                daemonSessionTaskListener.taskFinished((DaemonSessionTask)cancelableDaemonSessionTask);
                throw throwable;
            }
            {
                Object var6_9 = null;
            }
            daemonSessionTaskListener.taskFinished((DaemonSessionTask)cancelableDaemonSessionTask);
        }

        private final void checkCanceled(ICancelHint iCancelHint) throws ICancelHint.CanceledException {
            if (iCancelHint != null && iCancelHint.isCanceled()) {
                throw new ICancelHint.CanceledException();
            }
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private final /* synthetic */ void this() {
            Class clazz = class$com$tridium$nsedona$ui$daemon$UnifiedFileSpace;
            if (clazz == null) {
                clazz = class$com$tridium$nsedona$ui$daemon$UnifiedFileSpace = LocalUnified.class("[Lcom.tridium.nsedona.ui.daemon.UnifiedFileSpace;", false);
            }
            this.lex = Lexicon.make((Class)clazz);
            this.lfs = BFileSystem.INSTANCE;
        }

        public LocalUnified(BDaemonSession bDaemonSession) {
            super(bDaemonSession, (BFileSpace)BFileSystem.INSTANCE);
            this.this();
        }
    }

    private static class DaemonUnified
    extends UnifiedFileSpace {
        BDaemonFileSpace fs;

        public FilePath getSedonaHome() {
            return new FilePath("!sedona");
        }

        public BIFile[] getChildren(BIFile bIFile) {
            return DaemonFileUtil.listFiles((BDirectory)((BDirectory)bIFile), null);
        }

        public BIFile findFile(FilePath filePath) {
            return DaemonFileUtil.findFile((BFileSpace)this.fs, (FilePath)filePath, null);
        }

        public BIFile mkdir(FilePath filePath) {
            Queue queue = new Queue();
            try {
                FilePath filePath2 = filePath;
                while (filePath2 != null && this.findFile(filePath2) == null) {
                    queue.push((Object)filePath2);
                    filePath2 = filePath2.getParent();
                }
                while (!queue.isEmpty()) {
                    filePath2 = (FilePath)queue.dequeue();
                    FileTransferMessage fileTransferMessage = FileTransferMessage.makeMkDir((FilePath)filePath2, (BDaemonFileSpace)this.fs);
                    DaemonFileUtil.transfer((BDaemonSession)this.daemonSession, (FileTransferMessage)fileTransferMessage, null);
                }
                return this.findFile(filePath);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void delete(BEnvTable.TransferItem[] transferItemArray, ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
            FileTransferMessage fileTransferMessage = new FileTransferMessage(this.fs);
            int n = 0;
            while (n < transferItemArray.length) {
                fileTransferMessage.addDelete(transferItemArray[n].file.getFilePath());
                ++n;
            }
            DaemonFileUtil.transfer((BDaemonSession)this.daemonSession, (FileTransferMessage)fileTransferMessage, (ICancelHint)iCancelHint, (DaemonSessionTaskListener)daemonSessionTaskListener);
        }

        public void transfer(BEnvTable.TransferItem[] transferItemArray, ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
            FilePath filePath = this.getSedonaHome();
            FileTransferMessage fileTransferMessage = new FileTransferMessage(this.fs);
            int n = 0;
            while (n < transferItemArray.length) {
                if (!transferItemArray[n].file.isDirectory()) {
                    fileTransferMessage.addFile(transferItemArray[n].file, filePath.merge(transferItemArray[n].sedonaHomeRelPath));
                }
                ++n;
            }
            DaemonFileUtil.transfer((BDaemonSession)this.daemonSession, (FileTransferMessage)fileTransferMessage, (ICancelHint)iCancelHint, (DaemonSessionTaskListener)daemonSessionTaskListener);
        }

        public DaemonUnified(BDaemonSession bDaemonSession) {
            super(bDaemonSession, (BFileSpace)bDaemonSession.getFileSpace());
            this.fs = bDaemonSession.getFileSpace();
        }
    }
}

