/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.sox;

import com.tridium.nsedona.sox.BISoxPlatform;
import com.tridium.nsedona.sox.PlatformSession;
import java.util.Properties;
import sedona.Schema;
import sedona.sox.ISoxComm;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;
import sedona.sox.SoxFile;
import sedona.sox.VersionInfo;

public class SoxPlatformSession
extends PlatformSession {
    public final SoxClient client;

    public VersionInfo getVersionInfo() throws Exception {
        return this.client.readVersion();
    }

    public Schema getSchema() throws Exception {
        return this.client.readSchema();
    }

    public void saveApp() throws Exception {
        SoxComponent soxComponent = this.client.loadApp();
        this.client.invoke(soxComponent, soxComponent.slot("save"), null);
    }

    public void restart() throws Exception {
        RestartThread restartThread = new RestartThread();
        restartThread.start();
        try {
            restartThread.join(5000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void close() {
        this.client.close();
    }

    public PlatformSession.FileTransfer makeFileTransfer(Properties properties, ISoxComm.TransferListener transferListener) {
        return new SoxClientTransfer(this.client, properties, transferListener);
    }

    public SoxPlatformSession(BISoxPlatform bISoxPlatform, SoxClient soxClient) {
        super(bISoxPlatform);
        this.client = soxClient;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class RestartThread
    extends Thread {
        public void run() {
            block4: {
                try {
                    SoxComponent soxComponent = SoxPlatformSession.this.client.loadApp();
                    SoxPlatformSession.this.client.invoke(soxComponent, soxComponent.slot("restart"), null);
                    SoxPlatformSession.this.client.close();
                }
                catch (Exception exception) {
                    if (SoxPlatformSession.this.client.isClosed()) break block4;
                    try {
                        SoxPlatformSession.this.client.close();
                    }
                    catch (Exception exception2) {}
                }
            }
        }
    }

    public static class SoxClientTransfer
    implements PlatformSession.FileTransfer {
        final SoxClient client;
        final Properties headers;
        final ISoxComm.TransferListener listener;

        public void getFile(String string, SoxFile soxFile) throws Exception {
            this.client.getFile(string, soxFile, this.headers, this.listener);
        }

        public void putFile(SoxFile soxFile, String string) throws Exception {
            this.client.putFile(string, soxFile, this.headers, this.listener);
        }

        public void renameFile(String string, String string2) throws Exception {
            this.client.renameFile(string, string2);
        }

        public SoxClientTransfer(SoxClient soxClient, Properties properties, ISoxComm.TransferListener transferListener) {
            this.client = soxClient;
            this.headers = properties;
            this.listener = transferListener;
        }
    }
}

