/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.sox;

import com.tridium.nsedona.IntraMoveSedona;
import com.tridium.nsedona.SedonaDeleteOp;
import com.tridium.nsedona.sox.SoxLoadCallbacks;
import com.tridium.nsedona.sox.SoxSubscribeCallbacks;
import com.tridium.nsedona.sox.SoxTrapCallbacks;
import com.tridium.nsedona.sys.BISedonaSpace;
import com.tridium.nsedona.sys.BSedonaComponent;
import com.tridium.nsedona.sys.SedonaSyncBuffer;
import com.tridium.nsedona.util.StringUtil;
import com.tridium.util.ObjectUtil;
import com.tridium.util.backport.concurrent.BlockingQueue;
import com.tridium.util.backport.concurrent.ConcurrentHashMap;
import com.tridium.util.backport.concurrent.ConcurrentMap;
import com.tridium.util.backport.concurrent.LinkedBlockingQueue;
import com.tridium.util.backport.concurrent.TimeUnit;
import com.tridium.util.backport.concurrent.locks.ReentrantLock;
import java.util.Collection;
import java.util.LinkedList;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nav.NavEvent;
import javax.baja.space.Mark;
import javax.baja.space.TrapCallbacks;
import javax.baja.sync.BProxyComponentSpace;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;
import sedona.Component;
import sedona.Link;
import sedona.Schema;
import sedona.Slot;
import sedona.Value;
import sedona.offline.OfflineComponent;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;
import sedona.sox.SoxComponentListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BSoxSpace
extends BProxyComponentSpace
implements SoxComponentListener,
BISedonaSpace {
    public static final Type TYPE;
    private static final Log log;
    private static final BIcon changedUR;
    protected SoxComponent app;
    protected final ConcurrentMap soxToAx;
    final ReentrantLock eventingLock;
    private SoxEventHandler eventHandler;
    private final BlockingQueue eventQueue;
    private final BlockingQueue eventDelayQueue;
    private ReentrantLock waitLock;
    private WaitThread waitThread;
    private final BlockingQueue waitQueue;
    private boolean saveNeeded;
    static /* synthetic */ Class class$com$tridium$nsedona$sox$BSoxSpace;

    public Type getType() {
        return TYPE;
    }

    protected final synchronized void openSpace() {
        try {
            this.getSoxClient().subscribeToAllTreeEvents();
            this.loadApp();
            this.eventHandler = new SoxEventHandler();
            this.eventHandler.start();
        }
        catch (RuntimeException runtimeException) {
            this.closeSpace();
            throw runtimeException;
        }
        catch (Exception exception) {
            this.closeSpace();
            throw new BajaRuntimeException("Could not open sox space", (Throwable)exception);
        }
    }

    protected synchronized void closeSpace() {
        try {
            this.getSoxClient().unsubscribeToAllTreeEvents();
        }
        catch (Exception exception) {
            this.trace("Exception closing SoxSpace:" + exception);
        }
        if (this.eventHandler != null) {
            this.eventHandler.isAlive = false;
        }
        this.waitThread.interrupt();
        this.waitQueue.clear();
    }

    public abstract SoxClient getSoxClient();

    private final SoxComponent loadApp() {
        try {
            this.app = this.getSoxClient().loadApp();
            return this.app;
        }
        catch (Schema.MissingKitManifestException missingKitManifestException) {
            String string = StringUtil.formatMissingManifestException(missingKitManifestException);
            throw new LocalizableRuntimeException("nsedona", "soxGateway.missingManifest", new Object[]{string});
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    protected final SoxComponent app() {
        return this.app;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void enqueueWait(IWait iWait) {
        try {
            this.waitLock.lock();
            this.waitQueue.add((Object)iWait);
            if (!this.waitThread.isAlive()) {
                this.waitThread = new WaitThread("WaitThread_" + this.getNavName());
                this.waitThread.start();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.waitLock.unlock();
            throw throwable;
        }
        {
            Object var3_4 = null;
        }
        this.waitLock.unlock();
    }

    public Component loadSedonaComponent(int n) {
        try {
            return this.getSoxClient().load(n);
        }
        catch (Exception exception) {
            this.trace("failed to load sedona component " + n, exception);
            return null;
        }
    }

    public Schema getSchema() throws Exception {
        return this.getSoxClient().readSchema();
    }

    public Component newInstance(String string) throws Exception {
        sedona.Type type = this.getSchema().type(string);
        if (type == null) {
            throw new IllegalArgumentException("Schema does not define type: " + string);
        }
        return new OfflineComponent(type);
    }

    public void set(BSedonaComponent bSedonaComponent, Slot slot, Value value) throws Exception {
        this.trace("set: " + bSedonaComponent + '.' + slot.name + " = " + value);
        this.getSoxClient().write((SoxComponent)bSedonaComponent.s(), slot, value);
        this.setSaveNeeded(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BSedonaComponent addComponent(Component component, sedona.Type type, String string, Value[] valueArray) throws Exception {
        SoxComponent soxComponent = this.getSoxClient().add((SoxComponent)component, type, string, valueArray);
        this.setSaveNeeded(true);
        WaitAdd waitAdd = new WaitAdd(soxComponent);
        WaitAdd waitAdd2 = waitAdd;
        synchronized (waitAdd2) {
            this.enqueueWait(waitAdd);
            waitAdd.wait();
        }
        if (log.isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            this.trace(stringBuffer.append("add: ").append(string).append(" [").append(type).append("] id = ").append(soxComponent.id()).append(" on ").append(component.name()).toString());
        }
        if (waitAdd.added == null) {
            log.error("add " + string + " timed out");
            return new BSedonaComponent((Component)soxComponent);
        }
        return waitAdd.added;
    }

    public void addLink(Component component, Slot slot, Component component2, Slot slot2) throws Exception {
        Link link = new Link(component.id(), slot.id, component2.id(), slot2.id);
        this.trace("link: " + link);
        this.getSoxClient().link(link);
        this.setSaveNeeded(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeComponent(Component component) throws Exception {
        BSedonaComponent bSedonaComponent = (BSedonaComponent)this.loadByHandle(new Integer(component.id()));
        if (!bSedonaComponent.isMounted()) {
            log.error(component.name() + " is not mounted!!!");
        }
        this.getSoxClient().unsubscribe((SoxComponent)component, (int)((char)-1));
        this.getSoxClient().delete((SoxComponent)component);
        this.setSaveNeeded(true);
        this.trace("removed: " + component.name() + " id = " + component.id() + " from " + component.getParent().name());
        WaitRemove waitRemove = new WaitRemove(bSedonaComponent);
        WaitRemove waitRemove2 = waitRemove;
        synchronized (waitRemove2) {
            this.enqueueWait(waitRemove);
            waitRemove.wait();
            return;
        }
    }

    public void removeLink(Component component, Slot slot, Component component2, Slot slot2) throws Exception {
        Link link = new Link(component.id(), slot.id, component2.id(), slot2.id);
        this.trace("unlink: " + link);
        this.getSoxClient().unlink(link);
        this.setSaveNeeded(true);
    }

    public void rename(Component component, String string) throws Exception {
        this.trace("rename: " + component.name() + " to " + string);
        this.getSoxClient().rename((SoxComponent)component, string);
        this.setSaveNeeded(true);
    }

    public void reorder(Component component, int[] nArray) throws Exception {
        this.getSoxClient().reorder((SoxComponent)component, nArray);
        this.setSaveNeeded(true);
        if (log.isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("reorder: ").append(component.name()).append(" [");
            int n = 0;
            while (n < nArray.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(nArray[n]);
                ++n;
            }
            stringBuffer.append(']');
            this.trace(stringBuffer.toString());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changed(SoxComponent soxComponent, int n) {
        SoxEvent soxEvent = new SoxEvent(soxComponent, n);
        try {
            this.eventingLock.lock();
            if (((SoxSubscribeCallbacks)this.getSubscribeCallbacks()).isSubscribing(soxComponent)) {
                this.eventDelayQueue.add((Object)soxEvent);
            } else {
                this.eventQueue.add((Object)soxEvent);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.eventingLock.unlock();
            throw throwable;
        }
        {
            Object var5_6 = null;
        }
        this.eventingLock.unlock();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void flushDelayQueue() {
        try {
            this.eventingLock.lock();
            this.eventDelayQueue.drainTo((Collection)this.eventQueue);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.eventingLock.unlock();
            throw throwable;
        }
        {
            Object var2_3 = null;
        }
        this.eventingLock.unlock();
    }

    protected BComponent loadByHandle(Object object) {
        SlotPath slotPath = this.handleToSlotPath(object);
        if (slotPath == null) {
            throw new UnresolvedException(String.valueOf(object));
        }
        return (BComponent)BOrd.make((OrdQuery)slotPath).get((BObject)this);
    }

    public SlotPath handleToSlotPath(Object object) {
        SlotPath slotPath;
        block3: {
            slotPath = null;
            try {
                LinkedList<String> linkedList = new LinkedList<String>();
                SoxComponent soxComponent = this.getSoxClient().load(Integer.parseInt(object.toString()));
                while (soxComponent != null && soxComponent.id() != 0) {
                    linkedList.addFirst(soxComponent.name());
                    soxComponent = this.getSoxClient().load(soxComponent.parentId());
                }
                slotPath = new SlotPath("slot", linkedList.toArray(new String[linkedList.size()]));
            }
            catch (Exception exception) {
                if (!log.isTraceOn()) break block3;
                log.trace("Failed to resolve by handle: " + object, (Throwable)exception);
            }
        }
        return slotPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sync() throws Exception {
        SoxEvent soxEvent = SoxEvent.makeSyncEvent();
        SoxEvent soxEvent2 = soxEvent;
        synchronized (soxEvent2) {
            this.eventQueue.add((Object)soxEvent);
            soxEvent.wait();
            return;
        }
    }

    public long getDefaultLeaseTime() {
        return 10000L;
    }

    public Transaction newTransaction(Context context) {
        return new SedonaSyncBuffer(this, context);
    }

    protected void setSaveNeeded(boolean bl) {
        this.saveNeeded = bl;
        this.fireNavEvent(NavEvent.makeRenamed((BINavNode)this.getNavParent(), (String)this.getNavName(), (String)this.getNavName(), null));
    }

    protected boolean getSaveNeeded() {
        return this.saveNeeded;
    }

    public BIcon getNavIcon() {
        BIcon bIcon = super.getNavIcon();
        if (this.saveNeeded) {
            bIcon = BIcon.make((BIcon)bIcon, (BIcon)changedUR);
        }
        return bIcon;
    }

    public Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 103: {
                return this.fwGenerateHandles((Integer)object);
            }
            case 111: {
                return this.fwGenerateUniqueName((String)object, (ObjectUtil.NameContainer)object2);
            }
            case 112: {
                return new SedonaDeleteOp((Mark)object, (Context)object2);
            }
            case 113: {
                return new IntraMoveSedona(this);
            }
            case 114: {
                return new IntraMoveSedona(this);
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    protected Object[] fwGenerateHandles(int n) {
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = "auto" + n2;
            ++n2;
        }
        return objectArray;
    }

    protected String fwGenerateUniqueName(String string, ObjectUtil.NameContainer nameContainer) {
        return SedonaSyncBuffer.generateUniqueName(string, nameContainer);
    }

    public abstract String getUniqueId();

    public void trace(String string) {
        this.trace(string, null);
    }

    public void trace(String string, Throwable throwable) {
        if (log.isTraceOn()) {
            log.trace(this.getUniqueId() + ": " + string, throwable);
        }
    }

    public void error(String string) {
        this.error(string, null);
    }

    public void error(String string, Exception exception) {
        log.error(this.getUniqueId() + ": " + string, (Throwable)exception);
    }

    public void msg(String string) {
        log.message(this.getUniqueId() + ": " + string);
    }

    static /* synthetic */ ReentrantLock access$0(BSoxSpace bSoxSpace) {
        return bSoxSpace.waitLock;
    }

    static /* synthetic */ BlockingQueue access$1(BSoxSpace bSoxSpace) {
        return bSoxSpace.waitQueue;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.soxToAx = new ConcurrentHashMap();
        this.eventingLock = new ReentrantLock();
        this.eventQueue = new LinkedBlockingQueue();
        this.eventDelayQueue = new LinkedBlockingQueue();
        this.waitLock = new ReentrantLock();
        this.waitThread = new WaitThread("default_wait_thread");
        this.waitQueue = new LinkedBlockingQueue();
        this.saveNeeded = false;
    }

    public BSoxSpace(String string, LexiconText lexiconText, BOrd bOrd) {
        super(string, lexiconText, bOrd);
        this.this();
        this.setTrapCallbacks((TrapCallbacks)new SoxTrapCallbacks(this));
        this.setLoadCallbacks(new SoxLoadCallbacks(this));
        this.setSubscribeCallbacks(new SoxSubscribeCallbacks(this));
    }

    static {
        Class clazz = class$com$tridium$nsedona$sox$BSoxSpace;
        if (clazz == null) {
            clazz = class$com$tridium$nsedona$sox$BSoxSpace = BSoxSpace.class("[Lcom.tridium.nsedona.sox.BSoxSpace;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"sedona.soxspace");
        changedUR = BIcon.make((String)"module://nsedona/rc/changedUR.png");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SoxEventHandler
    extends Thread {
        public volatile boolean isAlive = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            SoxEvent soxEvent = null;
            SoxClient soxClient = BSoxSpace.this.getSoxClient();
            while (this.isAlive && !soxClient.isClosed()) {
                try {
                    soxEvent = (SoxEvent)BSoxSpace.this.eventQueue.poll(10L, TimeUnit.SECONDS);
                    if (soxEvent == null) continue;
                    if (soxEvent.isSync()) {
                        SoxEvent soxEvent2 = soxEvent;
                        synchronized (soxEvent2) {
                            soxEvent.notify();
                            continue;
                        }
                    }
                    BSedonaComponent bSedonaComponent = (BSedonaComponent)BSoxSpace.this.soxToAx.get((Object)soxEvent.s);
                    if (bSedonaComponent == null) continue;
                    if (soxEvent.isTree()) {
                        bSedonaComponent.syncChildren();
                    }
                    if (soxEvent.isRuntime()) {
                        bSedonaComponent.syncRuntime();
                    }
                    if (soxEvent.isConfig()) {
                        bSedonaComponent.syncConfig();
                    }
                    if (!soxEvent.isLinks()) continue;
                    bSedonaComponent.syncLinks();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }

        public SoxEventHandler() {
            super(BSoxSpace.this.getUniqueId());
            BSoxSpace.this.eventQueue.clear();
            BSoxSpace.this.eventDelayQueue.clear();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class WaitThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block9: while (true) {
                if (Thread.interrupted()) {
                    return;
                }
                try {
                    BSoxSpace.access$0(BSoxSpace.this).lock();
                    var1_1 = (IWait)BSoxSpace.access$1(BSoxSpace.this).poll();
                    if (var1_1 == null) {
                        var3_2 = null;
                        BSoxSpace.access$0(BSoxSpace.this).unlock();
                        return;
                    }
                    ** try [egrp 1[TRYBLOCK] [0 : 41->44)] { 
                }
lbl13:
                // 3 sources

                catch (Throwable var2_6) {
                    var3_2 = null;
                    BSoxSpace.access$0(BSoxSpace.this).unlock();
                    throw var2_6;
                }
lbl19:
                // 2 sources

                var3_2 = null;
                BSoxSpace.access$0(BSoxSpace.this).unlock();
                var4_3 = Clock.ticks();
                while (true) {
                    v0 = false;
                    if (Clock.ticks() - var4_3 > 7000L) {
                        v0 = true;
                    }
                    if (var6_4 = v0) {
                        var1_1.timedOut();
                    }
                    if (var6_4 | var1_1.isDone()) {
                        var7_5 = var1_1;
                        synchronized (var7_5) {
                            var1_1.notify();
                            continue block9;
                        }
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception v2) {
                    }
                }
                break;
            }
        }

        public WaitThread(String string) {
            super(string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class WaitAdd
    implements IWait {
        final SoxComponent s;
        BSedonaComponent added;

        public boolean isDone() {
            try {
                boolean bl = false;
                this.added = (BSedonaComponent)BSoxSpace.this.loadByHandle(new Integer(this.s.id()));
                if (this.added != null) {
                    bl = true;
                }
                return bl;
            }
            catch (Exception exception) {
                return false;
            }
        }

        public void timedOut() {
            this.added = null;
        }

        public WaitAdd(SoxComponent soxComponent) {
            this.s = soxComponent;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class WaitRemove
    implements IWait {
        final BSedonaComponent removed;

        public boolean isDone() {
            return this.removed.isMounted() ^ true;
        }

        public void timedOut() {
        }

        public WaitRemove(BSedonaComponent bSedonaComponent) {
            this.removed = bSedonaComponent;
        }
    }

    static class SoxEvent {
        final SoxComponent s;
        final int mask;

        public static SoxEvent makeSyncEvent() {
            return new SoxEvent(null, -1);
        }

        public boolean isTree() {
            boolean bl = false;
            if ((this.mask & 1) > 0) {
                bl = true;
            }
            return bl;
        }

        public boolean isRuntime() {
            boolean bl = false;
            if ((this.mask & 4) > 0) {
                bl = true;
            }
            return bl;
        }

        public boolean isConfig() {
            boolean bl = false;
            if ((this.mask & 2) > 0) {
                bl = true;
            }
            return bl;
        }

        public boolean isLinks() {
            boolean bl = false;
            if ((this.mask & 8) > 0) {
                bl = true;
            }
            return bl;
        }

        public boolean isSync() {
            boolean bl = false;
            if (this.s == null && this.mask == -1) {
                bl = true;
            }
            return bl;
        }

        public String toString() {
            if (this.isSync()) {
                return "sync event";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.s.name()).append(' ');
            if (this.isTree()) {
                stringBuffer.append('T');
            }
            if (this.isRuntime()) {
                stringBuffer.append('R');
            }
            if (this.isConfig()) {
                stringBuffer.append('C');
            }
            if (this.isLinks()) {
                stringBuffer.append('L');
            }
            return stringBuffer.toString();
        }

        public SoxEvent(SoxComponent soxComponent, int n) {
            this.s = soxComponent;
            this.mask = n;
        }
    }

    static interface IWait {
        public boolean isDone();

        public void timedOut();
    }
}

