/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.sox;

import com.tridium.nsedona.env.LocalSedonaEnv;
import com.tridium.nsedona.env.SedonaEnv;
import com.tridium.nsedona.sox.BISoxPlatform;
import com.tridium.nsedona.sox.BSoxScheme;
import com.tridium.nsedona.sox.BSoxSessionSpace;
import com.tridium.nsedona.sox.NSoxSocket;
import com.tridium.nsedona.sox.PlatformSession;
import com.tridium.nsedona.sox.SoxPlatformSession;
import com.tridium.nsedona.sys.BSedonaComponent;
import com.tridium.platform.BSessionNavNodeFactory;
import com.tridium.util.IFoxSession;
import java.net.ConnectException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BSession;
import javax.baja.naming.OrdQuery;
import javax.baja.nav.BINavNode;
import javax.baja.security.AuthenticationException;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.LexiconText;
import sedona.Env;
import sedona.Schema;
import sedona.dasp.DaspException;
import sedona.dasp.DaspSession;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;
import sedona.sox.SoxException;
import sedona.sox.VersionInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSoxSession
extends BSession
implements AuthenticationRealm,
SoxClient.Listener,
BISoxPlatform,
IFoxSession {
    public static final Type TYPE;
    private static final BIcon iconConnected;
    private static final BIcon iconDisconnected;
    private static final BIcon iconTunnelConnected;
    private static final BIcon iconTunnelDisconnected;
    static Log log;
    BHost host;
    int port;
    BSoxScheme.RouteSpec[] routes;
    BOrd absOrd;
    BOrd ordInHost;
    String appName;
    BUsernameAndPassword credentials;
    SoxClient client;
    Context sessionContext;
    BSoxSessionSpace space;
    BSessionNavNodeFactory[] navFactories;
    Set secretAgents;
    boolean spaceNeededSaving;
    static /* synthetic */ Class class$com$tridium$nsedona$sox$BSoxSession;
    static /* synthetic */ Class class$javax$baja$nav$BINavNode;

    public Type getType() {
        return TYPE;
    }

    public static BSoxSession[] list() {
        ArrayList<BINavNode> arrayList = new ArrayList<BINavNode>();
        BHost[] bHostArray = BHost.getAllHosts();
        int n = 0;
        while (n < bHostArray.length) {
            BHost bHost = bHostArray[n];
            BINavNode[] bINavNodeArray = bHost.getNavChildren();
            int n2 = 0;
            while (n2 < bINavNodeArray.length) {
                if (bINavNodeArray[n2] instanceof BSoxSession) {
                    arrayList.add(bINavNodeArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new BSoxSession[arrayList.size()]);
    }

    public static BSoxSession make(BHost bHost) {
        return BSoxSession.make(null, bHost, 1876);
    }

    public static BSoxSession make(BHost bHost, int n) {
        return BSoxSession.make(null, bHost, n);
    }

    public static BSoxSession make(String string, BHost bHost, int n) {
        return BSoxSession.make(string, bHost, n, null);
    }

    public static BSoxSession make(String string, BHost bHost, int n, BSoxScheme.RouteSpec[] routeSpecArray) {
        BSoxSession bSoxSession;
        String string2 = "sox";
        if (n != 1876) {
            string2 = string2 + ':' + n;
        }
        if (routeSpecArray != null) {
            string2 = string2 + BSoxScheme.RouteSpec.joinRoutes(routeSpecArray);
        }
        if ((bSoxSession = (BSoxSession)bHost.getNavChild(string2)) == null) {
            bSoxSession = new BSoxSession(string2, string, bHost, n, routeSpecArray);
            bHost.addNavChild((BINavNode)bSoxSession);
        }
        return bSoxSession;
    }

    public BHost getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public BSoxScheme.RouteSpec[] getRoutes() {
        return this.routes;
    }

    public String getAppName() {
        return this.appName;
    }

    public Schema getSchema() throws Exception {
        return this.client.readSchema();
    }

    public VersionInfo getVersion() throws Exception {
        return this.client.readVersion();
    }

    public SoxClient getClient() {
        return this.client;
    }

    public boolean isConnected() {
        boolean bl = false;
        if (this.client != null && !this.client.isClosed()) {
            bl = true;
        }
        return bl;
    }

    public synchronized void connect() throws Exception {
        if (this.isConnected()) {
            return;
        }
        String string = "";
        String string2 = "";
        if (this.credentials != null) {
            string = this.credentials.getUsername();
            string2 = this.credentials.getPassword().getString();
        }
        if (string.equals("")) {
            throw new AuthenticationException((AuthenticationRealm)this, null);
        }
        InetAddress inetAddress = ((BIpHost)this.host).getInetAddress();
        this.client = NSoxSocket.make(this).makeSoxClient(inetAddress, this.port, string, string2);
        this.client.addListener((SoxClient.Listener)this);
        try {
            this.client.connect();
            log.trace("Connected to " + this.clientStr());
        }
        catch (DaspException daspException) {
            if (daspException.errorCode == 228) {
                throw new AuthenticationException((AuthenticationRealm)this, (Throwable)daspException);
            }
            throw new ConnectException(daspException.getMessage());
        }
        catch (SoxException soxException) {
            throw new ConnectException(soxException.getMessage());
        }
        try {
            this.loadSubSpaces();
        }
        catch (Exception exception) {
            this.disconnect();
            throw exception;
        }
        try {
            SoxComponent soxComponent = this.client.loadApp();
            this.appName = this.client.readProp(soxComponent, soxComponent.slot("appName")).toString();
        }
        catch (Exception exception) {
            this.appName = null;
        }
        this.sessionContext = new BasicContext();
    }

    public void disconnect() {
        new Thread(new Runnable(){

            public final void run() {
                if (BSoxSession.this.client != null) {
                    String string = BSoxSession.this.clientStr();
                    log.trace("disconnect() -> : " + string);
                    BSoxSession.this.client.close();
                    log.trace("disconnect() <- : " + string);
                }
                BSoxSession.this.credentials = null;
            }
        }, this.clientStr()).start();
    }

    public void close() {
        String string = this.clientStr();
        log.trace("close() -> : " + string);
        this.disconnect();
        this.host.removeNavChild((BINavNode)this);
        log.trace("close() <- : " + string);
    }

    public Context getSessionContext() {
        return this.sessionContext;
    }

    public void soxClientClosed(SoxClient soxClient) {
        String string = this.clientStr();
        log.trace("soxClientClosed() -> : " + string);
        this.client.removeListener((SoxClient.Listener)this);
        this.client = null;
        this.unloadSubSpaces();
        log.trace("soxClientClosed() <- : " + string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadSubSpaces() throws Exception {
        String string = this.clientStr();
        try {
            try {
                log.trace("loadSubSpaces() -> : " + string);
                this.navFactories = BSessionNavNodeFactory.makeFor((BISession)this);
                Class clazz = class$javax$baja$nav$BINavNode;
                if (clazz == null) {
                    clazz = class$javax$baja$nav$BINavNode = BSoxSession.class("[Ljavax.baja.nav.BINavNode;", false);
                }
                Array array = new Array(clazz);
                int n = 0;
                while (true) {
                    if (n >= this.navFactories.length) break;
                    array.addAll(this.navFactories[n].getNavNodes().trim());
                    ++n;
                }
                n = 0;
                while (true) {
                    block8: {
                        if (n < array.size()) break block8;
                        this.space = new BSoxSessionSpace(this);
                        this.addNavChild((BINavNode)this.space);
                        this.space.setSaveNeeded(this.spaceNeededSaving);
                        break;
                    }
                    this.addNavChild((BINavNode)array.get(n));
                    ++n;
                }
            }
            catch (Exception exception) {
                log.trace("exception in loadSubSpaces()", (Throwable)exception);
                this.unloadSubSpaces();
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            log.trace("loadSubSpaces() <- : " + string);
            throw throwable;
        }
        {
            Object var3_7 = null;
        }
        log.trace("loadSubSpaces() <- : " + string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unloadSubSpaces() {
        var1_1 = this.clientStr();
        try {
            try {
                BSoxSession.log.trace("unloadSubSpaces() -> : " + var1_1);
                if (this.space != null) {
                    this.removeNavChild((BINavNode)this.space);
                    this.spaceNeededSaving = this.space.getSaveNeeded();
                    this.space = null;
                }
                ** GOTO lbl-1000
            }
            catch (Exception var6_2) {
                var6_2.printStackTrace();
            }
            ** GOTO lbl-1000
        }
        catch (Throwable var2_3) {
            var3_4 = null;
            var4_6 = this.getNavChildren();
            var5_8 = 0;
        }
        while (true) {
            if (var5_8 >= var4_6.length) {
                this.navFactories = null;
                BSoxSession.log.trace("unloadSubSpaces() <- : " + var1_1);
                throw var2_3;
            }
            this.removeNavChild(var4_6[var5_8]);
            ++var5_8;
        }
lbl-1000:
        // 3 sources

        {
            var3_5 = null;
        }
        var4_7 = this.getNavChildren();
        var5_9 = 0;
        while (true) {
            if (var5_9 >= var4_7.length) {
                this.navFactories = null;
                BSoxSession.log.trace("unloadSubSpaces() <- : " + var1_1);
                return;
            }
            this.removeNavChild(var4_7[var5_9]);
            ++var5_9;
        }
    }

    public String getAuthenticationRealmName() {
        return this.absOrd.toString();
    }

    public String getAuthenticationScheme() {
        return "DASP SHA-1";
    }

    public BICredentials makeCredentials() {
        return new BUsernameAndPassword();
    }

    public BICredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(BICredentials bICredentials) {
        this.credentials = (BUsernameAndPassword)bICredentials;
    }

    public BOrd getAbsoluteOrd() {
        return this.absOrd;
    }

    public BOrd getOrdInHost() {
        return this.ordInHost;
    }

    public String getNavDisplayName(Context context) {
        String string = super.getNavDisplayName(context);
        if (this.appName != null && this.appName.length() > 0) {
            string = string + " (" + this.appName + ')';
        }
        string = string + ':';
        if (this.port != 1876) {
            string = string + this.port;
        }
        if (this.routes != null) {
            string = string + BSoxScheme.RouteSpec.joinRoutes(this.routes);
        }
        return string;
    }

    public boolean hasNavChildren() {
        return this.isConnected();
    }

    public BOrd getNavOrd() {
        return this.absOrd;
    }

    public String getStationName() {
        return this.routes == null ? this.appName : null;
    }

    public SedonaEnv getSedonaEnv() {
        return new LocalSedonaEnv();
    }

    public PlatformSession openPlatformSession(BUsernameAndPassword bUsernameAndPassword) throws Exception {
        if (!this.isConnected()) {
            throw new IllegalStateException();
        }
        return new SoxPlatformSession(this, this.client){

            public final void saveApp() throws Exception {
                BSedonaComponent bSedonaComponent = (BSedonaComponent)BOrd.make((String)"soxapp:|slot:/").get((BObject)BSoxSession.this);
                bSedonaComponent.invoke(bSedonaComponent.action("save"), null);
            }

            public final void close() {
            }
        };
    }

    public void appUpdated(BOrd bOrd) {
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        if (this.client != null) {
            BSoxSession.spy(spyWriter, this.client.session());
        }
        super.spy(spyWriter);
    }

    public static void spy(SpyWriter spyWriter, DaspSession daspSession) {
        spyWriter.startProps();
        spyWriter.trTitle((Object)"SoxSession", 2);
        spyWriter.prop((Object)"address", (Object)("" + daspSession.host + ':' + daspSession.port));
        spyWriter.prop((Object)"localId", (Object)("0x" + Integer.toHexString(daspSession.id)));
        spyWriter.prop((Object)"remoteId", (Object)("0x" + Integer.toHexString(daspSession.remoteId())));
        spyWriter.prop((Object)"interface", (Object)daspSession.iface.getClass().getName());
        spyWriter.prop((Object)"idealMax", (Object)(daspSession.idealMax() + " bytes"));
        spyWriter.prop((Object)"absMax", (Object)(daspSession.absMax() + " bytes"));
        spyWriter.prop((Object)"receiveTimeout", (Object)(daspSession.receiveTimeout() / 1000L + " sec"));
        spyWriter.prop((Object)"localReceiveMax", (Object)(daspSession.localReceiveMax() + " msgs"));
        spyWriter.prop((Object)"remoteReceiveMax", (Object)(daspSession.remoteReceiveMax() + " msgs"));
        spyWriter.prop((Object)"numReceived", (Object)(daspSession.numReceived() + " msgs"));
        spyWriter.prop((Object)"numSent", (Object)(daspSession.numSent() + " msgs"));
        spyWriter.prop((Object)"numRetries", (Object)(daspSession.numRetries() + " msgs"));
        spyWriter.prop((Object)"uptime", (Object)BRelTime.toString((long)daspSession.uptime()));
        spyWriter.prop((Object)"lastSend", (Object)(Env.ticks() - daspSession.lastSend() + "ms ago"));
        spyWriter.prop((Object)"lastReceive", (Object)(Env.ticks() - daspSession.lastReceive() + "ms ago"));
        spyWriter.prop((Object)"sendWindowSize", (Object)(daspSession.sendWindowSize() + " msgs"));
        spyWriter.prop((Object)"sendWindowRetry", (Object)(daspSession.sendWindowRetry() + "ms"));
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = daspSession.ackTimes();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = nArray[n3];
            if (n4 >= 0) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(n4);
                n += n4;
                ++n2;
            }
            ++n3;
        }
        spyWriter.prop((Object)"ackTimes", (Object)stringBuffer.toString());
        spyWriter.prop((Object)"ackTimeAverage", (Object)(n2 == 0 ? "-" : n / n2 + "ms"));
        spyWriter.endProps();
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList.toBottom("nsedona:SoxSessionAgent");
        agentList.toBottom("nsedona:SoxTunnelSessionAgent");
        AgentList agentList2 = agentList.filter(AgentFilter.is((String)"sedonaProvisioning:ISoxPlatformTool"));
        AgentInfo[] agentInfoArray = agentList2.list();
        int n = 0;
        while (n < agentInfoArray.length) {
            if (!this.secretAgents.contains(agentInfoArray[n].getAgentType().getTypeSpec().toString())) {
                agentList.remove(agentInfoArray[n]);
            }
            ++n;
        }
        agentList.toTop("workbench:NavContainerView");
        return agentList;
    }

    public BIcon getIcon() {
        if (this.isConnected()) {
            return this.routes == null ? iconConnected : iconTunnelConnected;
        }
        return this.routes == null ? iconDisconnected : iconTunnelDisconnected;
    }

    private final String clientStr() {
        return this.absOrd != null ? this.absOrd.toString() : this.client.addr.toString();
    }

    public Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        if (n == 9900) {
            this.secretAgents.add(object);
        }
        return super.fw(n, object, object2, object3, object4);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.navFactories = null;
        this.secretAgents = new HashSet();
        this.spaceNeededSaving = false;
    }

    private BSoxSession(String string, String string2, BHost bHost, int n, BSoxScheme.RouteSpec[] routeSpecArray) {
        super(string, LexiconText.make((String)"nsedona", (String)"nav.soxSession"));
        this.this();
        this.appName = string2;
        this.host = bHost;
        this.port = n;
        this.routes = routeSpecArray;
        this.setLexiconText(LexiconText.make((Type)TYPE, (String)"nav.soxSession"));
        this.ordInHost = BOrd.make((OrdQuery)new BSoxScheme.SoxQuery(n, routeSpecArray));
        this.absOrd = BOrd.make((BOrd)bHost.getAbsoluteOrd(), (BOrd)this.ordInHost);
        Sys.getLicenseManager().checkFeature("tridium", "sox");
    }

    static {
        Class clazz = class$com$tridium$nsedona$sox$BSoxSession;
        if (clazz == null) {
            clazz = class$com$tridium$nsedona$sox$BSoxSession = BSoxSession.class("[Lcom.tridium.nsedona.sox.BSoxSession;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        iconConnected = BIcon.std((String)"sox.png");
        iconDisconnected = BIcon.std((String)"soxDisconnected.png");
        iconTunnelConnected = BIcon.make((String)"module://nsedona/rc/soxTunnel.png");
        iconTunnelDisconnected = BIcon.make((String)"module://nsedona/rc/soxTunnelDisconnected.png");
        log = Log.getLog((String)"sedona.sox.session");
    }
}

