/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.sax;

import com.tridium.nsedona.CopyUtil;
import com.tridium.nsedona.IntraMoveSedona;
import com.tridium.nsedona.SedonaDeleteOp;
import com.tridium.nsedona.sax.BSaxFile;
import com.tridium.nsedona.sys.BISedonaSpace;
import com.tridium.nsedona.sys.BSedonaComponent;
import com.tridium.nsedona.sys.SedonaSyncBuffer;
import com.tridium.util.FileLock;
import com.tridium.util.ObjectUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.baja.file.BIFileStore;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.space.BComponentSpace;
import javax.baja.space.LoadCallbacks;
import javax.baja.space.Mark;
import javax.baja.space.TrapCallbacks;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.Transaction;
import javax.baja.sync.TrapToSyncBuffer;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.CopyHints;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import sedona.Buf;
import sedona.Component;
import sedona.Link;
import sedona.Schema;
import sedona.Slot;
import sedona.Value;
import sedona.offline.OfflineApp;
import sedona.offline.OfflineComponent;
import sedona.offline.OfflineLink;
import sedona.util.FileUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSaxSpace
extends BComponentSpace
implements BISedonaSpace {
    public static final Type TYPE;
    public static final Log log;
    public static final Lexicon lex;
    OfflineApp app;
    BSaxFile saxFile;
    boolean modified;
    long openTimestamp;
    FileLock lock;
    HashMap map;
    boolean enableParentChildChecks;
    static /* synthetic */ Class class$com$tridium$nsedona$sax$BSaxSpace;
    static /* synthetic */ Class class$com$tridium$nsedona$sys$BSedonaComponent;

    public Type getType() {
        return TYPE;
    }

    private final void loadAppTree(BSaxFile bSaxFile) {
        BComponent[] bComponentArray;
        this.saxFile = bSaxFile;
        this.app = this.loadApp(this.saxFile);
        BSedonaComponent bSedonaComponent = new BSedonaComponent((Component)this.app);
        Class clazz = class$com$tridium$nsedona$sys$BSedonaComponent;
        if (clazz == null) {
            clazz = class$com$tridium$nsedona$sys$BSedonaComponent = BSaxSpace.class("[Lcom.tridium.nsedona.sys.BSedonaComponent;", false);
        }
        Array array = new Array(clazz);
        array.push((Object)bSedonaComponent);
        while (!array.isEmpty()) {
            bComponentArray = (BComponent[])array.pop();
            Component[] componentArray = bComponentArray.s().getChildren();
            int n = 0;
            while (n < componentArray.length) {
                BSedonaComponent bSedonaComponent2 = new BSedonaComponent(componentArray[n]);
                bComponentArray.add(componentArray[n].name(), (BValue)bSedonaComponent2);
                array.add((Object)bSedonaComponent2);
                ++n;
            }
        }
        this.setRootComponent(bSedonaComponent);
        bComponentArray = this.getAllComponents();
        int n = 0;
        while (n < bComponentArray.length) {
            ((BSedonaComponent)bComponentArray[n]).syncConfig();
            ((BSedonaComponent)bComponentArray[n]).syncLinks();
            ++n;
        }
    }

    private final OfflineApp loadApp(BSaxFile bSaxFile) {
        try {
            OfflineApp offlineApp = bSaxFile.getFileName().endsWith(".sax") ? OfflineApp.decodeAppXml((String)bSaxFile.getFileName(), (InputStream)bSaxFile.getInputStream()) : OfflineApp.decodeAppBinary((InputStream)bSaxFile.getInputStream());
            return offlineApp;
        }
        catch (Schema.MissingKitManifestException missingKitManifestException) {
            throw new BajaRuntimeException((Throwable)missingKitManifestException);
        }
        catch (Exception exception) {
            throw new BajaRuntimeException("Cannot load sax file: " + bSaxFile.getAbsoluteOrd(), (Throwable)exception);
        }
    }

    public void setParentChildChecksEnabled(boolean bl) {
        this.enableParentChildChecks = bl;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void modified(BComponent bComponent, Context context) {
        this.modified = true;
    }

    public Transaction newTransaction(Context context) {
        SedonaSyncBuffer sedonaSyncBuffer = new SedonaSyncBuffer(this, context);
        sedonaSyncBuffer.setParentChildChecksEnabled(this.enableParentChildChecks);
        return sedonaSyncBuffer;
    }

    public Schema getSchema() throws Exception {
        return this.app.schema;
    }

    public Component newInstance(String string) throws Exception {
        sedona.Type type = this.getSchema().type(string);
        if (type == null) {
            throw new IllegalArgumentException("Unknown type: " + string);
        }
        return new OfflineComponent(type);
    }

    public Component loadSedonaComponent(int n) {
        return this.app.lookup(n);
    }

    public void set(BSedonaComponent bSedonaComponent, Slot slot, Value value) throws Exception {
        log.trace("set: " + bSedonaComponent + '.' + slot.name + " -> " + value);
        bSedonaComponent.s().set(slot, value);
        if (slot.isConfig()) {
            bSedonaComponent.syncConfig();
        } else {
            bSedonaComponent.syncRuntime();
        }
    }

    public BSedonaComponent addComponent(Component component, sedona.Type type, String string, Value[] valueArray) throws Exception {
        Object object;
        OfflineComponent offlineComponent = new OfflineComponent(type, string);
        Slot[] slotArray = type.configProps();
        if (slotArray.length != valueArray.length) {
            throw new IllegalArgumentException("Config props don't match type's definition: " + type + " (" + slotArray.length + " != " + valueArray.length + ')');
        }
        int n = 0;
        while (n < valueArray.length) {
            object = slotArray[n];
            int n2 = valueArray[n].typeId();
            if (object.isAsStr() ? n2 != 101 : object.type.id != n2) {
                throw new IllegalArgumentException("Config props don't match type's definition: " + type + " (" + slotArray[n].name + ' ' + slotArray[n].type + " != " + valueArray[n].getClass().getName() + ')');
            }
            offlineComponent.set(slotArray[n], valueArray[n]);
            ++n;
        }
        this.app.add((OfflineComponent)component, offlineComponent);
        this.app.assignIds();
        BSedonaComponent bSedonaComponent = (BSedonaComponent)this.map.get(component);
        bSedonaComponent.syncChildren();
        log.trace("addComponent: " + string + " [" + type + "] id=" + offlineComponent.id() + " on " + component.name());
        object = (BSedonaComponent)bSedonaComponent.get(offlineComponent.name());
        this.map.put(offlineComponent, object);
        return object;
    }

    public void addLink(Component component, Slot slot, Component component2, Slot slot2) throws Exception {
        OfflineLink offlineLink = new OfflineLink((OfflineComponent)component, slot, (OfflineComponent)component2, slot2);
        log.trace("addLink: " + offlineLink);
        this.app.addLink(offlineLink);
        BSedonaComponent bSedonaComponent = (BSedonaComponent)this.map.get(component);
        bSedonaComponent.syncLinks();
        bSedonaComponent = (BSedonaComponent)this.map.get(component2);
        bSedonaComponent.syncLinks();
    }

    public void removeComponent(Component component) throws Exception {
        Component component2 = component.getParent();
        Link[] linkArray = component.links();
        OfflineComponent[] offlineComponentArray = ((OfflineComponent)component).children();
        int n = 0;
        while (n < offlineComponentArray.length) {
            this.removeComponent((Component)offlineComponentArray[n]);
            ++n;
        }
        log.trace("removeComponent: " + component.name() + " [id=" + component.id() + "] from " + component2.name());
        this.app.remove((OfflineComponent)component);
        n = 0;
        while (n < linkArray.length) {
            OfflineComponent offlineComponent = null;
            offlineComponent = linkArray[n].fromCompId == component.id() ? this.app.lookup(linkArray[n].toCompId) : this.app.lookup(linkArray[n].fromCompId);
            if (offlineComponent != null) {
                ((BSedonaComponent)this.map.get(offlineComponent)).syncLinks();
            }
            ++n;
        }
        BSedonaComponent bSedonaComponent = (BSedonaComponent)this.map.get(component2);
        bSedonaComponent.syncChildren();
    }

    public void removeLink(Component component, Slot slot, Component component2, Slot slot2) throws Exception {
        OfflineLink offlineLink = new OfflineLink((OfflineComponent)component, slot, (OfflineComponent)component2, slot2);
        log.trace("removeLink: " + offlineLink);
        this.app.removeLink(offlineLink);
        BSedonaComponent bSedonaComponent = (BSedonaComponent)this.map.get(component);
        bSedonaComponent.syncLinks();
        bSedonaComponent = (BSedonaComponent)this.map.get(component2);
        bSedonaComponent.syncLinks();
    }

    public void rename(Component component, String string) throws Exception {
        log.trace("rename: " + component.name() + " -> " + string);
        ((OfflineComponent)component).rename(string);
        BSedonaComponent bSedonaComponent = (BSedonaComponent)this.map.get(component);
        bSedonaComponent.syncChildren();
    }

    public void reorder(Component component, int[] nArray) throws Exception {
        Object object;
        if (log.isTraceOn()) {
            object = new StringBuffer("reorder: " + component.name() + " [");
            int n = 0;
            while (n < nArray.length) {
                if (n > 0) {
                    ((StringBuffer)object).append(",");
                }
                ((StringBuffer)object).append(nArray[n]);
                ++n;
            }
            ((StringBuffer)object).append("]");
            log.trace(((StringBuffer)object).toString());
        }
        this.app.reorder((OfflineComponent)component, nArray);
        object = (BSedonaComponent)this.map.get(component);
        ((BSedonaComponent)object).syncChildren();
    }

    public boolean isSpaceReadonly() {
        if (this.saxFile != null) {
            return this.saxFile.isReadonly();
        }
        return false;
    }

    public boolean isMounted() {
        boolean bl = false;
        if (this.saxFile != null) {
            bl = true;
        }
        return bl;
    }

    public BHost getHost() {
        if (this.saxFile == null) {
            return null;
        }
        return this.saxFile.getHost();
    }

    public BISession getSession() {
        if (this.saxFile == null) {
            return null;
        }
        return this.saxFile.getSession();
    }

    public BOrd getAbsoluteOrd() {
        if (this.saxFile == null) {
            return null;
        }
        return BOrd.make((BOrd)this.saxFile.getAbsoluteOrd(), (String)"sax:");
    }

    public BOrd getOrdInHost() {
        if (this.saxFile == null) {
            return null;
        }
        return BOrd.make((BOrd)this.saxFile.getOrdInHost(), (String)"sax:");
    }

    public BOrd getOrdInSession() {
        if (this.saxFile == null) {
            return null;
        }
        return BOrd.make((BOrd)this.saxFile.getOrdInSession(), (String)"sax:");
    }

    public BINavNode getNavParent() {
        return this.getSaxFile();
    }

    public BSaxFile getSaxFile() {
        return this.saxFile;
    }

    void save() throws Exception {
        this.saxFile.checkLock();
        if (this.saxFile.isReadonly()) {
            throw new CannotSaveException(lex.getText("saxFile.saveErr.readonly"));
        }
        BIFileStore bIFileStore = this.saxFile.getStore();
        OutputStream outputStream = bIFileStore.getOutputStream();
        if ("sax".equals(this.saxFile.getExtension())) {
            this.app.encodeAppXml(outputStream);
        } else {
            Buf buf = this.app.encodeAppBinary();
            buf.seek(0);
            FileUtil.pipe((InputStream)buf.getInputStream(), (OutputStream)outputStream);
        }
        outputStream.close();
        this.saxFile.setLastModified(BAbsTime.now());
        this.modified = false;
    }

    void save(Schema schema) throws Exception {
        this.save(schema, true);
    }

    void save(Schema schema, boolean bl) throws Exception {
        OfflineApp offlineApp = new OfflineApp(schema);
        this.copySlots((OfflineComponent)this.app, (OfflineComponent)offlineApp, bl);
        int n = 0;
        while (n < this.app.children().length) {
            this.copyChildren(offlineApp, (OfflineComponent)offlineApp, this.app.children()[n], bl);
            ++n;
        }
        OfflineLink[] offlineLinkArray = this.app.getLinks();
        int n2 = 0;
        while (n2 < offlineLinkArray.length) {
            offlineApp.addLink(offlineLinkArray[n2]);
            ++n2;
        }
        this.app = offlineApp;
        this.save();
    }

    private final void copySlots(OfflineComponent offlineComponent, OfflineComponent offlineComponent2, boolean bl) {
        sedona.Type type = offlineComponent.type;
        sedona.Type type2 = offlineComponent2.type;
        Slot[] slotArray = offlineComponent.type.slots;
        int n = 0;
        while (n < slotArray.length) {
            Slot slot = slotArray[n];
            if (slot.isConfig()) {
                Value value = offlineComponent.get(slot);
                Slot slot2 = type2.slot(slot.name);
                if (slot2 != null && slot2.type.equals((Object)slot.type)) {
                    offlineComponent2.set(slot.name, value);
                } else if (bl) {
                    throw new IllegalStateException("schema mismatch: from type " + type + '[' + Integer.toHexString(type.kit.checksum) + "] != to type " + type2 + '[' + Integer.toHexString(type2.kit.checksum) + ']');
                }
            }
            ++n;
        }
    }

    private final void copyChildren(OfflineApp offlineApp, OfflineComponent offlineComponent, OfflineComponent offlineComponent2, boolean bl) {
        OfflineComponent offlineComponent3 = new OfflineComponent(offlineComponent2.type, offlineComponent2.name(), offlineComponent2.id());
        this.copySlots(offlineComponent2, offlineComponent3, bl);
        offlineApp.add(offlineComponent, offlineComponent3);
        OfflineComponent[] offlineComponentArray = offlineComponent2.children();
        int n = 0;
        while (n < offlineComponentArray.length) {
            this.copyChildren(offlineApp, offlineComponent3, offlineComponentArray[n], bl);
            ++n;
        }
    }

    void close() {
        this.saxFile = null;
        this.setRootComponent(null);
    }

    public Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 103: {
                return this.generateHandles((Integer)object);
            }
            case 111: {
                return this.generateUniqueName((String)object, (ObjectUtil.NameContainer)object2);
            }
            case 112: {
                return new SedonaDeleteOp((Mark)object, (Context)object2);
            }
            case 113: {
                return new IntraMoveSedona(this);
            }
            case 114: {
                return new IntraMoveSedona(this);
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    synchronized Object[] generateHandles(int n) {
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = "auto" + n2;
            ++n2;
        }
        return objectArray;
    }

    String generateUniqueName(String string, ObjectUtil.NameContainer nameContainer) {
        return SedonaSyncBuffer.generateUniqueName(string, nameContainer);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.map = new HashMap();
        this.enableParentChildChecks = true;
    }

    public BSaxSpace(BSaxFile bSaxFile) {
        super(bSaxFile.getFileName(), null, BOrd.make((BOrd)bSaxFile.getOrdInSession(), (String)"sax:"));
        this.this();
        this.enableParentChildChecks = true;
        this.setLoadCallbacks(new SaxLoadCallbacks());
        this.setTrapCallbacks((TrapCallbacks)new SaxTrapCallbacks());
        this.loadAppTree(bSaxFile);
        this.modified = false;
    }

    public BSaxSpace(Schema schema) {
        super("unmounted", null, BOrd.make((String)"unmounted:"));
        this.this();
        this.enableParentChildChecks = true;
        this.setLoadCallbacks(new SaxLoadCallbacks());
        this.setTrapCallbacks((TrapCallbacks)new SaxTrapCallbacks());
        this.app = new OfflineApp(schema);
        BSedonaComponent bSedonaComponent = new BSedonaComponent((Component)this.app);
        this.map.put(this.app, bSedonaComponent);
        bSedonaComponent.syncConfig();
        this.setRootComponent(new BSedonaComponent((Component)this.app));
    }

    static {
        Class clazz = class$com$tridium$nsedona$sax$BSaxSpace;
        if (clazz == null) {
            clazz = class$com$tridium$nsedona$sax$BSaxSpace = BSaxSpace.class("[Lcom.tridium.nsedona.sax.BSaxSpace;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"sedona.sax.space");
        Class clazz2 = class$com$tridium$nsedona$sax$BSaxSpace;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$nsedona$sax$BSaxSpace = BSaxSpace.class("[Lcom.tridium.nsedona.sax.BSaxSpace;", false);
        }
        lex = Lexicon.make((Class)clazz2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SaxLoadCallbacks
    extends LoadCallbacks {
        public BValue[] newCopy(BValue[] bValueArray, CopyHints copyHints) {
            try {
                return CopyUtil.copyFrom((BISedonaSpace)BSaxSpace.this, bValueArray);
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public void loadSlots(BComponent bComponent) {
            Component component = ((BSedonaComponent)bComponent).s();
            BSaxSpace.this.map.put(component, bComponent);
            Component[] componentArray = component.getChildren();
            int n = 0;
            while (n < componentArray.length) {
                try {
                    BSedonaComponent bSedonaComponent = new BSedonaComponent(componentArray[n]);
                    if (bComponent.get(bSedonaComponent.s().name()) == null) {
                        bComponent.add(bSedonaComponent.s().name(), (BValue)bSedonaComponent, Context.commit);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
        }

        SaxLoadCallbacks() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SaxTrapCallbacks
    extends TrapToSyncBuffer {
        public SyncBuffer getBuffer() {
            SedonaSyncBuffer.AutoCommitBuffer autoCommitBuffer = new SedonaSyncBuffer.AutoCommitBuffer(BSaxSpace.this, null);
            autoCommitBuffer.setParentChildChecksEnabled(BSaxSpace.this.enableParentChildChecks);
            return autoCommitBuffer;
        }

        public BValue invoke(BComponent bComponent, Action action, BValue bValue, Context context) {
            return null;
        }

        SaxTrapCallbacks() {
        }
    }
}

