/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.kitmgr;

import com.tridium.nsedona.env.KitDb;
import com.tridium.nsedona.kitmgr.KitManagerModel;
import java.util.HashSet;
import java.util.Stack;
import javax.baja.util.Array;
import sedona.Component;
import sedona.Depend;
import sedona.Kit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ManagerVerifier {
    private KitManagerModel model;
    private Array items;
    static /* synthetic */ Class class$com$tridium$nsedona$kitmgr$ManagerVerifier$VerifyItem;

    public static final VerifyItem[] verify(KitManagerModel kitManagerModel) {
        return new ManagerVerifier(kitManagerModel).verify();
    }

    private final VerifyItem[] verify() {
        this.verifyCoreKits();
        this.verifyDepends();
        this.verifyApp();
        return (VerifyItem[])this.items.sort().trim();
    }

    private final void verifyCoreKits() {
        if (this.model.getDesiredVersion("sys") == null) {
            this.items.add((Object)new VerifyItem("sys", "Missing required kit: sys"));
        }
        if (this.model.getDesiredVersion("inet") == null) {
            this.items.add((Object)new VerifyItem("inet", "Missing required kit: inet"));
        }
        if (this.model.getDesiredVersion("sox") == null) {
            this.items.add((Object)new VerifyItem("sox", "Missing required kit: sox"));
        }
    }

    private final void verifyDepends() {
        KitDb.KitSummary[] kitSummaryArray = this.model.commit();
        int n = 0;
        while (n < kitSummaryArray.length) {
            KitDb.KitSummary kitSummary = kitSummaryArray[n];
            Depend[] dependArray = this.model.getUnmetDependencies(kitSummary.name());
            int n2 = 0;
            while (n2 < dependArray.length) {
                this.items.add((Object)new VerifyItem(dependArray[n2].name(), "Missing dependency: " + dependArray[n2] + " (required by " + kitSummary.fileName() + ')'));
                ++n2;
            }
            ++n;
        }
    }

    private final void verifyApp() {
        Kit kit;
        Component component;
        HashSet<Kit> hashSet = new HashSet<Kit>();
        Stack<Object> stack = new Stack<Object>();
        stack.push(this.model.app);
        while (!stack.isEmpty()) {
            component = (Component)stack.pop();
            kit = component.type.kit;
            if (this.model.getDesiredVersion(kit.name) == null) {
                hashSet.add(component.type.kit);
            }
            Component[] componentArray = component.getChildren();
            int n = 0;
            while (n < componentArray.length) {
                stack.push(componentArray[n]);
                ++n;
            }
        }
        component = hashSet.iterator();
        while (component.hasNext()) {
            kit = (Kit)component.next();
            this.items.add((Object)new VerifyItem(kit.name, "Missing dependency: " + kit + " (required for app)"));
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Class clazz = class$com$tridium$nsedona$kitmgr$ManagerVerifier$VerifyItem;
        if (clazz == null) {
            clazz = class$com$tridium$nsedona$kitmgr$ManagerVerifier$VerifyItem = ManagerVerifier.class("[Lcom.tridium.nsedona.kitmgr.ManagerVerifier$VerifyItem;", false);
        }
        this.items = new Array(clazz);
    }

    private ManagerVerifier(KitManagerModel kitManagerModel) {
        this.this();
        this.model = kitManagerModel;
    }

    public static class VerifyItem
    implements Comparable {
        public final String kit;
        public final String msg;

        public int compareTo(Object object) {
            VerifyItem verifyItem = (VerifyItem)object;
            if (this.kit.equals("sys")) {
                return -1;
            }
            if (verifyItem.kit.equals("sys")) {
                return 1;
            }
            return this.kit.compareTo(verifyItem.kit);
        }

        public String toString() {
            return this.msg;
        }

        public VerifyItem(String string, String string2) {
            this.kit = string;
            this.msg = string2;
        }
    }
}

