/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.dasp;

import com.tridium.nsedona.dasp.HostDaspSocketInterface;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.baja.log.Log;
import javax.baja.sys.BVector;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import sedona.dasp.DaspSocket;
import sedona.dasp.DaspSocketInterface;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HostInterfaceManager {
    private static final Log log = Log.getLog((String)"nsedona.dasp");
    ArrayList hostInterfaces;
    int port;
    static /* synthetic */ Class class$com$tridium$platform$tcpip$BTcpIpAdapterSettings;

    public int getPort() {
        return this.port;
    }

    public void startAll(DaspSocket daspSocket) {
        int n = 0;
        while (n < this.hostInterfaces.size()) {
            HostDaspSocketInterface hostDaspSocketInterface = (HostDaspSocketInterface)((Object)this.hostInterfaces.get(n));
            hostDaspSocketInterface.start(daspSocket);
            ++n;
        }
    }

    public void stopAll() {
        int n = 0;
        while (n < this.hostInterfaces.size()) {
            HostDaspSocketInterface hostDaspSocketInterface = (HostDaspSocketInterface)((Object)this.hostInterfaces.get(n));
            hostDaspSocketInterface.stop();
            ++n;
        }
    }

    public void populate(int n) throws IOException {
        this.populate(n, false);
    }

    public void populate(int n, boolean bl) throws IOException {
        this.hostInterfaces.clear();
        this.port = n;
        BTcpIpAdapterSettings[] bTcpIpAdapterSettingsArray = this.getAllAdapterSettings();
        if (bTcpIpAdapterSettingsArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < bTcpIpAdapterSettingsArray.length) {
            String string = bTcpIpAdapterSettingsArray[n2].getAdapterId();
            if (bTcpIpAdapterSettingsArray[n2].getIsAdapterEnabled()) {
                HostDaspSocketInterface hostDaspSocketInterface = new HostDaspSocketInterface(n, string, bTcpIpAdapterSettingsArray[n2].getIpAddress());
                hostDaspSocketInterface.determineIPv4BCastAddr(bTcpIpAdapterSettingsArray[n2].getSubnetMask());
                if (hostDaspSocketInterface.isOpen()) {
                    log.trace("   Adding interface for " + string + " addr " + hostDaspSocketInterface.getIp() + ", port " + this.port);
                    this.hostInterfaces.add(hostDaspSocketInterface);
                }
                if (bTcpIpAdapterSettingsArray[n2].getIsIpv6Enabled() && (hostDaspSocketInterface = new HostDaspSocketInterface(n, string, bTcpIpAdapterSettingsArray[n2].getIpv6Address())).isOpen()) {
                    log.trace("   Adding interface for " + string + " addr " + hostDaspSocketInterface.getIp() + ", port " + this.port);
                    this.hostInterfaces.add(hostDaspSocketInterface);
                }
            }
            ++n2;
        }
        log.trace("  Created new list of " + this.hostInterfaces.size() + " host interfaces");
    }

    DaspSocketInterface getIface(InetAddress inetAddress) {
        int n = 0;
        while (n < this.hostInterfaces.size()) {
            HostDaspSocketInterface hostDaspSocketInterface = (HostDaspSocketInterface)((Object)this.hostInterfaces.get(n));
            if (hostDaspSocketInterface.localAddr.toString().equals(inetAddress.toString())) {
                return hostDaspSocketInterface;
            }
            ++n;
        }
        return null;
    }

    DaspSocketInterface getIface(String string) {
        int n = 0;
        while (n < this.hostInterfaces.size()) {
            HostDaspSocketInterface hostDaspSocketInterface = (HostDaspSocketInterface)((Object)this.hostInterfaces.get(n));
            if (hostDaspSocketInterface.getIp().equals(string)) {
                return hostDaspSocketInterface;
            }
            ++n;
        }
        return null;
    }

    DaspSocketInterface[] getAll() {
        return this.hostInterfaces.toArray(new DaspSocketInterface[0]);
    }

    BTcpIpAdapterSettings[] getAllAdapterSettings() throws UnknownHostException {
        BTcpIpPlatformService bTcpIpPlatformService = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
        if (bTcpIpPlatformService == null) {
            return null;
        }
        bTcpIpPlatformService.poll();
        BVector bVector = bTcpIpPlatformService.getSettings().getAdapters();
        Class clazz = class$com$tridium$platform$tcpip$BTcpIpAdapterSettings;
        if (clazz == null) {
            clazz = class$com$tridium$platform$tcpip$BTcpIpAdapterSettings = HostInterfaceManager.class("[Lcom.tridium.platform.tcpip.BTcpIpAdapterSettings;", false);
        }
        return (BTcpIpAdapterSettings[])bVector.getChildren(clazz);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.port = -1;
    }

    public HostInterfaceManager() {
        this.this();
        this.hostInterfaces = new ArrayList();
    }
}

