/*
 * Decompiled with CFR 0.152.
 */
package sedonac.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import sedona.Env;

public class CStrGen {
    public static void main(String[] stringArray) throws Exception {
        String string;
        if (stringArray.length < 1) {
            System.out.println("usage: CStrGen <infile> ");
            return;
        }
        File file = new File(stringArray[0]);
        int n = file.getName().indexOf(46);
        boolean bl = false;
        if (file.getName().endsWith(".scode")) {
            string = "_scode";
            bl = true;
        } else if (file.getName().endsWith(".sab")) {
            string = "_sab";
        } else {
            System.out.println("infile must by .scode or .sab");
            return;
        }
        File file2 = new File(file.getParentFile(), file.getName().substring(0, n) + string + ".c");
        System.out.println("in:  " + file);
        System.out.println("out: " + file2);
        CStrGen.toCFile(file, file2, bl ? "scode" : "sab");
    }

    public static void toCFile(File file, File file2, String string) throws Exception {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
        printWriter.print("// auto generated sedonac " + Env.timestamp() + '\n');
        printWriter.print("\n");
        printWriter.print("#include \"sedona.h\"\n");
        printWriter.print("\n");
        printWriter.print("const unsigned int " + string + "Size = " + file.length() + ";\n");
        printWriter.print("const uint8_t " + string + "Image[] = \n{\n");
        String string2 = "";
        while ((n = ((InputStream)bufferedInputStream).read()) >= 0) {
            if (string2.length() > 75) {
                string2 = string2 + '\n';
                printWriter.print(string2);
                string2 = "";
            }
            string2 = string2 + "0x" + CStrGen.hex(n) + ',';
        }
        string2 = string2.substring(0, string2.length() - 1);
        string2 = string2 + "\n};\n";
        printWriter.print(string2);
        ((InputStream)bufferedInputStream).close();
        printWriter.close();
    }

    private static final String hex(int n) {
        if (n < 16) {
            return "0" + Integer.toHexString(n);
        }
        return Integer.toHexString(n);
    }
}

