/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.IOException;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ast.KitDef;
import sedonac.ast.TypeDef;
import sedonac.translate.CTranslator;
import sedonac.translate.HTranslator;
import sedonac.translate.Translation;

public class Translate
extends CompilerStep {
    public void run() {
        Translation translation = this.compiler.translation;
        this.log.info("  Translate [" + translation.outDir + ']');
        try {
            translation.outDir.mkdirs();
            int n = 0;
            while (n < translation.kits.length) {
                KitDef kitDef = translation.kits[n];
                int n2 = 0;
                while (n2 < kitDef.types.length) {
                    TypeDef typeDef = kitDef.types[n2];
                    this.translate(typeDef);
                    ++n2;
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw this.err("Cannot translate", new Location(translation.outDir));
        }
    }

    public void translate(TypeDef typeDef) throws IOException {
        Translation translation = this.compiler.translation;
        if (!translation.target.equals("c")) {
            throw this.err("Unknown translation target language '" + translation.target + '\'');
        }
        new HTranslator(this.compiler, typeDef).translate();
        new CTranslator(this.compiler, typeDef).translate();
    }

    public Translate(Compiler compiler) {
        super(compiler);
    }
}

