/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import sedona.Depend;
import sedona.Env;
import sedona.util.VendorUtil;
import sedona.util.Version;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.SourceFile;
import sedonac.ast.DependDef;
import sedonac.ast.IncludeDef;
import sedonac.ast.KitDef;
import sedonac.ast.NativeDef;
import sedonac.namespace.NativeId;
import sedonac.util.VarResolver;

public class InitKitCompile
extends CompilerStep {
    File kitFile;
    File kitDir;
    XElem xml;

    public void run() {
        try {
            this.log.debug("  InitKitCompile");
            this.parseKitDef();
            this.findSourceFiles();
            this.validateNames();
        }
        catch (XException xException) {
            throw this.err(xException);
        }
    }

    private final void validateNames() {
        KitDef kitDef = this.compiler.ast;
        Location location = new Location(this.kitFile);
        String string = kitDef.name;
        String string2 = kitDef.vendor;
        if (!string2.equals("Tridium")) {
            try {
                VendorUtil.checkVendorName((String)string2);
            }
            catch (Exception exception) {
                throw this.err(exception.getMessage(), location);
            }
            if (!string.toLowerCase().startsWith(string2.toLowerCase())) {
                throw this.err("Kit name '" + string + "' must be prefixed with vendor name '" + string2 + '\'', location);
            }
        }
        string = string.toLowerCase();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!(c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_')) {
                throw this.err("Invalid kit name '" + kitDef.name + "'. Valid characters: [a-zA-Z0-9_]");
            }
            ++n;
        }
    }

    private final void parseKitDef() {
        KitDef kitDef = new KitDef(new Location(this.kitFile));
        kitDef.name = this.xml.get("name");
        kitDef.vendor = this.xml.get("vendor");
        kitDef.description = this.xml.get("description");
        kitDef.includeSource = this.xml.getb("includeSource", false);
        kitDef.doc = this.xml.getb("doc", false);
        Version version = this.compiler.kitVersion;
        if (version == null && this.xml.get("version", null) != null) {
            String string = this.xml.get("version");
            try {
                version = new Version(new VarResolver().resolve(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XException("Invalid attr version = '" + string + '\'', this.xml);
            }
            catch (Exception exception) {
                throw new XException("Could not resolve variable version = '" + string + '\'', this.xml);
            }
        }
        if (version == null) {
            version = Version.parse((String)Env.getProperty((String)"buildVersion", null));
        }
        if (version == null) {
            throw this.err("Kit version isn't defined", kitDef.loc);
        }
        kitDef.version = version;
        this.parseDepends(kitDef, this.xml.elems("depend"));
        this.parseIncludes(kitDef, this.xml.elems("include"));
        this.parseNatives(kitDef, this.xml.elems("native"));
        this.compiler.ast = kitDef;
    }

    private final void parseDepends(KitDef kitDef, XElem[] xElemArray) {
        kitDef.depends = new DependDef[xElemArray.length];
        int n = 0;
        while (n < xElemArray.length) {
            XElem xElem = xElemArray[n];
            kitDef.depends[n] = new DependDef(new Location(xElem), xElem.getDepend("on"));
            ++n;
        }
        n = kitDef.name.equals("sys") ? 1 : 0;
        int n2 = 0;
        while (n2 < kitDef.depends.length) {
            if (kitDef.depends[n2].depend.name().equals("sys")) {
                n = 1;
                break;
            }
            ++n2;
        }
        if (n == 0) {
            this.err("Must declare dependency on 'sys'", new Location(this.xml));
        }
    }

    private final void parseIncludes(KitDef kitDef, XElem[] xElemArray) {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < kitDef.depends.length) {
            hashSet.add(kitDef.depends[n].depend.name());
            ++n;
        }
        HashSet<Depend> hashSet2 = new HashSet<Depend>();
        kitDef.includes = new IncludeDef[xElemArray.length];
        int n2 = 0;
        while (n2 < xElemArray.length) {
            XElem xElem = xElemArray[n2];
            Location location = new Location(this.xml.location().file, xElem.line());
            IncludeDef includeDef = kitDef.includes[n2] = new IncludeDef(new Location(xElem), xElem.getDepend("from"));
            if (hashSet.contains(includeDef.depend.name())) {
                this.err("Cannot include and depend on the same kit: '" + includeDef.depend.name() + '\'', location);
            }
            if (!hashSet2.add(includeDef.depend)) {
                this.err("Duplicate <include> directive for kit: '" + includeDef.depend + '\'', location);
            }
            XElem[] xElemArray2 = xElem.elems("type");
            int n3 = 0;
            while (n3 < xElemArray2.length) {
                includeDef.typeToSource.put(xElemArray2[n3].get("name"), null);
                ++n3;
            }
            ++n2;
        }
    }

    private final void parseNatives(KitDef kitDef, XElem[] xElemArray) {
        ArrayList<NativeDef> arrayList = new ArrayList<NativeDef>();
        int n = 0;
        while (n < xElemArray.length) {
            XElem xElem = xElemArray[n];
            String string = xElem.get("qname");
            NativeId nativeId = NativeId.parse(new Location(xElem), xElem.get("id"));
            if (nativeId == null) {
                throw new XException("Invalid id format", xElem);
            }
            arrayList.add(new NativeDef(new Location(xElem), string, nativeId));
            ++n;
        }
        kitDef.natives = arrayList.toArray(new NativeDef[arrayList.size()]);
    }

    void findSourceFiles() {
        XElem[] xElemArray = this.xml.elems("source");
        if (xElemArray.length == 0) {
            throw this.err("Must specify at least one <source> element", new Location(this.xml));
        }
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < xElemArray.length) {
            this.findSourceFiles(arrayList, xElemArray[n]);
            ++n;
        }
        this.compiler.sourceFiles = arrayList.toArray(new SourceFile[arrayList.size()]);
        if (this.compiler.log.isDebug()) {
            n = 0;
            while (n < this.compiler.sourceFiles.length) {
                this.log.debug("    " + this.compiler.sourceFiles[n]);
                ++n;
            }
        }
    }

    void findSourceFiles(ArrayList arrayList, XElem xElem) {
        String string = xElem.get("dir");
        File file = new File(this.kitFile.getParentFile(), string);
        if (!file.exists() || !file.isDirectory()) {
            throw this.err("Unknown source directory '" + string + '\'', new Location(xElem));
        }
        try {
            if (!file.getCanonicalPath().startsWith(this.kitFile.getParentFile().getCanonicalPath())) {
                throw this.err("Source directory must be a sub-directory of " + this.kitFile.getParentFile(), new Location(xElem));
            }
        }
        catch (IOException iOException) {}
        boolean bl = this.isTestonly(xElem);
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            if (file2.getName().endsWith(".sedona")) {
                try {
                    SourceFile sourceFile = new SourceFile();
                    sourceFile.file = file2.getCanonicalFile();
                    sourceFile.testOnly = bl;
                    arrayList.add(sourceFile);
                }
                catch (IOException iOException) {
                    throw this.err("Cannot map to canonical filename: " + file2, new Location(xElem), (Throwable)iOException);
                }
            }
            ++n;
        }
    }

    private final boolean isTestonly(XElem xElem) {
        Location location = new Location(xElem);
        boolean bl = false;
        try {
            bl = xElem.getb("testonly");
            try {
                boolean bl2 = xElem.getb("test");
                this.err("Attributes 'test' and 'testonly' cannot both be present. Use 'testonly'.", location);
            }
            catch (XException xException) {}
        }
        catch (XException xException) {
            try {
                bl = xElem.getb("test");
                this.warn("The 'test' attribute is deprecated. Use 'testonly' instead. ", location);
            }
            catch (XException xException2) {}
        }
        return bl;
    }

    public InitKitCompile(Compiler compiler) {
        super(compiler);
        this.kitFile = compiler.input;
        this.kitDir = this.kitFile.getParentFile();
        this.xml = compiler.xml;
    }
}

