/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.ast.SlotDef;
import sedonac.ast.TypeDef;
import sedonac.ir.IrType;
import sedonac.namespace.Method;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;

public class Inherit
extends CompilerStep {
    public void run() {
        this.log.debug("  Inherit");
        int n = 0;
        while (n < this.compiler.kits.length) {
            IrType[] irTypeArray = this.compiler.kits[n].types;
            int n2 = 0;
            while (n2 < irTypeArray.length) {
                this.inherit(irTypeArray[n2]);
                ++n2;
            }
            ++n;
        }
        if (this.compiler.ast != null) {
            this.walkAst(1);
        }
        this.quitIfErrors();
    }

    public void enterType(TypeDef typeDef) {
        super.enterType(typeDef);
        this.inherit(typeDef);
    }

    private final void inherit(Type type) {
        if (type.base() == null) {
            return;
        }
        Slot[] slotArray = type.base().slots();
        int n = 0;
        while (n < slotArray.length) {
            this.inheritSlot(type, slotArray[n]);
            ++n;
        }
        if (type instanceof TypeDef) {
            TypeDef typeDef = (TypeDef)type;
            SlotDef[] slotDefArray = typeDef.slotDefs();
            int n2 = 0;
            while (n2 < slotDefArray.length) {
                if (slotDefArray[n2].isOverride() && slotDefArray[n2].overrides == null) {
                    this.err("Override of unknown method '" + slotDefArray[n2].name + '\'', slotDefArray[n2].loc);
                }
                ++n2;
            }
        }
    }

    private final void inheritSlot(Type type, Slot slot) {
        if (!slot.isInherited(type)) {
            return;
        }
        String string = slot.name();
        String string2 = slot.qname();
        Slot slot2 = type.slot(string);
        if (slot2 == null) {
            type.addSlot(slot);
            return;
        }
        if (!(slot2 instanceof SlotDef)) {
            return;
        }
        SlotDef slotDef = (SlotDef)slot2;
        if (!this.doSignaturesMatch(slot, slot2)) {
            if (slot2.isOverride()) {
                this.err("Overridden method '" + string + "' has different signature than '" + string2 + '\'', slotDef.loc);
                slotDef.overrides = slotDef;
                return;
            }
            this.err("Slot name '" + string + "' conflicts with inherited slot '" + string2 + '\'', slotDef.loc);
            slotDef.overrides = slotDef;
            return;
        }
        if (!slotDef.isOverride()) {
            this.err("Must use 'override' keyword to override '" + string2 + '\'', slotDef.loc);
            slotDef.overrides = slotDef;
            return;
        }
        if (slotDef.isAction() && !slot.isAction()) {
            this.err("'" + slotDef.qname + "' cannot be declared an action because it overrides non-action '" + string2 + '\'', slotDef.loc);
            return;
        }
        if (slot.isAction() && !slotDef.isAction()) {
            this.err("'" + slotDef.qname + "' must be decalred as an action because it overrides action '" + string2 + '\'', slotDef.loc);
            return;
        }
        if (!slot.isVirtual()) {
            this.err("Cannot override non-virtual method '" + string2 + '\'', slotDef.loc);
            slotDef.overrides = slotDef;
            return;
        }
        slotDef.overrides = slot;
    }

    private final boolean doSignaturesMatch(Slot slot, Slot slot2) {
        Type[] typeArray;
        if (slot.isField()) {
            return false;
        }
        if (slot2.isField()) {
            return false;
        }
        Method method = (Method)slot;
        Method method2 = (Method)slot2;
        if (!method.returnType().equals(method2.returnType())) {
            return false;
        }
        Type[] typeArray2 = method.paramTypes();
        if (typeArray2.length != (typeArray = method2.paramTypes()).length) {
            return false;
        }
        int n = 0;
        while (n < typeArray2.length) {
            if (!typeArray2[n].equals(typeArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Inherit(Compiler compiler) {
        super(compiler);
    }
}

