/*
 * Decompiled with CFR 0.152.
 */
package sedonac.ast;

import java.util.ArrayList;
import sedona.Bool;
import sedona.Buf;
import sedona.Double;
import sedona.Float;
import sedona.Int;
import sedona.Long;
import sedona.Str;
import sedona.Value;
import sedonac.Location;
import sedonac.ast.AstNode;
import sedonac.ast.AstVisitor;
import sedonac.ast.AstWriter;
import sedonac.ast.ParamDef;
import sedonac.ast.Stmt;
import sedonac.ast.VarDef;
import sedonac.namespace.Method;
import sedonac.namespace.Namespace;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;
import sedonac.namespace.TypeUtil;
import sedonac.parser.Token;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Expr
extends AstNode {
    public static final int TRUE_LITERAL = 1;
    public static final int FALSE_LITERAL = 2;
    public static final int INT_LITERAL = 3;
    public static final int LONG_LITERAL = 4;
    public static final int FLOAT_LITERAL = 5;
    public static final int DOUBLE_LITERAL = 6;
    public static final int TIME_LITERAL = 7;
    public static final int NULL_LITERAL = 8;
    public static final int STR_LITERAL = 9;
    public static final int BUF_LITERAL = 10;
    public static final int TYPE_LITERAL = 11;
    public static final int SLOT_LITERAL = 12;
    public static final int ARRAY_LITERAL = 13;
    public static final int SIZE_OF = 14;
    public static final int SLOT_ID_LITERAL = 15;
    public static final int NEGATE = 20;
    public static final int COND_NOT = 21;
    public static final int BIT_NOT = 22;
    public static final int PRE_INCR = 23;
    public static final int PRE_DECR = 24;
    public static final int POST_INCR = 25;
    public static final int POST_DECR = 26;
    public static final int COND_OR = 27;
    public static final int COND_AND = 28;
    public static final int EQ = 29;
    public static final int NOT_EQ = 30;
    public static final int GT = 31;
    public static final int GT_EQ = 32;
    public static final int LT = 33;
    public static final int LT_EQ = 34;
    public static final int BIT_OR = 35;
    public static final int BIT_XOR = 36;
    public static final int BIT_AND = 37;
    public static final int LSHIFT = 38;
    public static final int RSHIFT = 39;
    public static final int MUL = 40;
    public static final int DIV = 41;
    public static final int MOD = 42;
    public static final int ADD = 43;
    public static final int SUB = 44;
    public static final int ASSIGN = 45;
    public static final int ASSIGN_ADD = 46;
    public static final int ASSIGN_SUB = 47;
    public static final int ASSIGN_MUL = 48;
    public static final int ASSIGN_DIV = 49;
    public static final int ASSIGN_MOD = 50;
    public static final int ASSIGN_BIT_OR = 51;
    public static final int ASSIGN_BIT_XOR = 52;
    public static final int ASSIGN_BIT_AND = 53;
    public static final int ASSIGN_LSHIFT = 54;
    public static final int ASSIGN_RSHIFT = 55;
    public static final int ELVIS = 56;
    public static final int TERNARY = 57;
    public static final int NAME = 58;
    public static final int PARAM = 59;
    public static final int LOCAL = 60;
    public static final int THIS = 61;
    public static final int SUPER = 62;
    public static final int FIELD = 63;
    public static final int INDEX = 64;
    public static final int CALL = 65;
    public static final int CAST = 66;
    public static final int INIT_ARRAY = 67;
    public static final int INIT_VIRT = 68;
    public static final int INIT_COMP = 69;
    public static final int STATIC_TYPE = 70;
    public static final int PROP_SET = 71;
    public static final int INTERPOLATION = 72;
    public static final int NEW = 73;
    public static final int DELETE = 74;
    public static final int PROP_ASSIGN = 75;
    public int id;
    public Type type;
    public boolean leave;

    public final Expr walk(AstVisitor astVisitor) {
        if (this.type != null) {
            this.type = astVisitor.type(this.type);
        }
        this.doWalk(astVisitor);
        return astVisitor.expr(this);
    }

    public Stmt toStmt() {
        return new Stmt.ExprStmt(this.loc, this);
    }

    public boolean isAssign() {
        return false;
    }

    public boolean isIncrDecr() {
        return false;
    }

    public boolean isStmt() {
        switch (this.id) {
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 74: 
            case 75: {
                return true;
            }
        }
        return false;
    }

    public boolean isLiteral() {
        return false;
    }

    public Literal toLiteral() {
        return null;
    }

    public boolean isDefine() {
        return false;
    }

    public String toCodeString() {
        throw new IllegalStateException("not literal: " + this.getClass().getName());
    }

    public boolean isAssignable() {
        return false;
    }

    public Integer toIntLiteral() {
        return null;
    }

    protected abstract void doWalk(AstVisitor var1);

    public void write(AstWriter astWriter) {
        astWriter.w(this);
    }

    public abstract String toString();

    public boolean isNullLiteral(Type type) {
        if (this.id == 8 && type.isNullable()) {
            this.type = type;
            return true;
        }
        return false;
    }

    public abstract int maxStack();

    private final /* synthetic */ void this() {
        this.leave = true;
    }

    Expr(Location location, int n) {
        super(location);
        this.this();
        this.id = n;
    }

    public static interface NameDef {
        public VarDef def();
    }

    public static class Delete
    extends Expr {
        public Expr target;

        protected void doWalk(AstVisitor astVisitor) {
            this.target = this.target.walk(astVisitor);
        }

        public int maxStack() {
            return this.target.maxStack();
        }

        public String toString() {
            return "delete " + this.target;
        }

        public Delete(Location location) {
            super(location, 74);
        }
    }

    public static class New
    extends Expr {
        public Type of;
        public Expr arrayLength;

        protected void doWalk(AstVisitor astVisitor) {
            this.of = astVisitor.type(this.of);
            if (this.arrayLength != null) {
                this.arrayLength = this.arrayLength.walk(astVisitor);
            }
        }

        public String toString() {
            String string = "new " + this.of;
            string = this.arrayLength != null ? string + '[' + this.arrayLength + ']' : string + "()";
            return string;
        }

        public int maxStack() {
            return 2;
        }

        public New(Location location) {
            super(location, 73);
        }
    }

    public static class Interpolation
    extends Expr {
        public ArrayList parts = new ArrayList();
        public Method[] printMethods;
        public boolean callOk;

        public Literal first() {
            Expr expr = (Expr)this.parts.get(0);
            if (expr.id != 9) {
                throw new IllegalStateException("first not string literal: " + expr.id + ' ' + expr);
            }
            return (Literal)expr;
        }

        protected void doWalk(AstVisitor astVisitor) {
            ArrayList<Expr> arrayList = new ArrayList<Expr>();
            int n = 0;
            while (n < this.parts.size()) {
                Expr expr = (Expr)this.parts.get(n);
                arrayList.add(expr.walk(astVisitor));
                ++n;
            }
            this.parts = arrayList;
        }

        public int maxStack() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.parts.size()) {
                n += ((Expr)this.parts.get(n2)).maxStack();
                ++n2;
            }
            return n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('\"');
            int n = 0;
            while (n < this.parts.size()) {
                Expr expr = (Expr)this.parts.get(n);
                if (expr.id == 9) {
                    stringBuffer.append(expr.toString());
                } else {
                    stringBuffer.append("${").append(expr).append('}');
                }
                ++n;
            }
            stringBuffer.append('\"');
            return stringBuffer.toString();
        }

        public Interpolation(Location location) {
            super(location, 72);
        }
    }

    public static class StaticType
    extends Expr {
        protected void doWalk(AstVisitor astVisitor) {
            this.type = astVisitor.type(this.type);
        }

        public int maxStack() {
            return 0;
        }

        public String toString() {
            return this.type.toString();
        }

        public StaticType(Location location, Type type) {
            super(location, 70);
            this.type = type;
        }
    }

    public static class InitComp
    extends Expr {
        protected void doWalk(AstVisitor astVisitor) {
        }

        public int maxStack() {
            return 2;
        }

        public String toString() {
            return "InitComp " + this.type;
        }

        public InitComp(Location location, Type type) {
            super(location, 69);
            this.type = type;
        }
    }

    public static class InitVirt
    extends Expr {
        protected void doWalk(AstVisitor astVisitor) {
        }

        public int maxStack() {
            return 2;
        }

        public String toString() {
            return "InitVirt " + this.type;
        }

        public InitVirt(Location location, Type type) {
            super(location, 68);
            this.type = type;
        }
    }

    public static class InitArray
    extends Expr {
        public Expr field;
        public Expr length;

        protected void doWalk(AstVisitor astVisitor) {
        }

        public String toString() {
            return "{...}";
        }

        public int maxStack() {
            return 4;
        }

        public InitArray(Location location) {
            super(location, 67);
        }
    }

    public static class Cast
    extends Expr {
        public Expr target;

        protected void doWalk(AstVisitor astVisitor) {
            this.type = astVisitor.type(this.type);
            this.target = this.target.walk(astVisitor);
        }

        public int maxStack() {
            int n = this.target.maxStack();
            if (this.type.isWide()) {
                n = Math.max(n, 2);
            }
            return n;
        }

        public String toString() {
            return "(" + this.type + ')' + this.target;
        }

        public Cast(Location location, Type type, Expr expr) {
            super(location, 66);
            this.type = type;
            this.target = expr;
        }
    }

    public static class Call
    extends Name {
        public Expr[] args;
        public Method method;

        protected void doWalk(AstVisitor astVisitor) {
            super.doWalk(astVisitor);
            int n = 0;
            while (n < this.args.length) {
                this.args[n] = this.args[n].walk(astVisitor);
                ++n;
            }
        }

        public int maxStack() {
            Type type;
            int n = super.maxStack();
            int n2 = 0;
            while (n2 < this.args.length) {
                n += this.args[n2].maxStack();
                ++n2;
            }
            if (this.id == 71) {
                n += this.type.isWide() + 1;
            }
            if (!(type = this.method.returnType()).isVoid()) {
                n = Math.max(n, type.isWide() + 1);
            }
            return n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append("(");
            int n = 0;
            while (n < this.args.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.args[n]);
                ++n;
            }
            return stringBuffer.append(")").toString();
        }

        public Call(Location location, Expr expr, String string, Expr[] exprArray) {
            super(location, 65, expr, string);
            this.args = exprArray;
        }

        public Call(Location location, Expr expr, Method method, Expr[] exprArray) {
            this(location, 65, expr, method, exprArray);
        }

        public Call(Location location, int n, Expr expr, Method method, Expr[] exprArray) {
            super(location, n, expr, method.name());
            this.method = method;
            this.args = exprArray;
            if (method != null) {
                this.type = method.returnType();
            }
        }
    }

    public static class Index
    extends Expr {
        public Expr target;
        public Expr index;

        public boolean isAssignable() {
            return this.target.id != 63 || !((Field)this.target).field.isConst();
        }

        protected void doWalk(AstVisitor astVisitor) {
            this.target = this.target.walk(astVisitor);
            this.index = this.index.walk(astVisitor);
        }

        public int maxStack() {
            return this.target.maxStack() + this.index.maxStack();
        }

        public String toString() {
            return this.target.toString() + '[' + this.index + ']';
        }

        public Index(Location location, Expr expr, Expr expr2) {
            super(location, 64);
            this.target = expr;
            this.index = expr2;
        }
    }

    public static class Field
    extends Name {
        public sedonac.namespace.Field field;

        public boolean isAssignable() {
            boolean bl = false;
            if (!this.field.isInline() && !this.field.isConst()) {
                bl = true;
            }
            return bl;
        }

        public Literal toLiteral() {
            if (this.isDefine()) {
                return this.field.define();
            }
            return null;
        }

        public boolean isDefine() {
            return this.field.isDefine();
        }

        public Integer toIntLiteral() {
            if (this.isDefine() && this.type.isInt()) {
                return this.field.define().toIntLiteral();
            }
            return null;
        }

        public int maxStack() {
            int n = super.maxStack();
            int n2 = this.type.isWide() + 1;
            if (this.type.isByte() || this.type.isShort()) {
                ++n2;
            }
            return Math.max(n, n2);
        }

        public String toString() {
            return super.toString();
        }

        public Field(Location location, Expr expr, sedonac.namespace.Field field, boolean bl) {
            super(location, 63, expr, field.name());
            this.field = field;
            this.type = field.type();
            this.safeNav = bl;
        }

        public Field(Location location, Expr expr, sedonac.namespace.Field field) {
            this(location, expr, field, false);
        }
    }

    public static class Super
    extends Expr {
        public void doWalk(AstVisitor astVisitor) {
        }

        public int maxStack() {
            return 1;
        }

        public String toString() {
            return "super";
        }

        public Super(Location location) {
            super(location, 62);
        }
    }

    public static class This
    extends Expr {
        public void doWalk(AstVisitor astVisitor) {
        }

        public int maxStack() {
            return 1;
        }

        public String toString() {
            return "this";
        }

        public This(Location location) {
            super(location, 61);
        }
    }

    public static class Local
    extends Name
    implements NameDef {
        public Stmt.LocalDef def;

        public boolean isAssignable() {
            return true;
        }

        public int maxStack() {
            return this.type.isWide() + 1;
        }

        public VarDef def() {
            return this.def;
        }

        public Local(Location location, Stmt.LocalDef localDef) {
            super(location, 60, null, localDef.name);
            this.type = localDef.type;
            this.def = localDef;
        }
    }

    public static class Param
    extends Name
    implements NameDef {
        public ParamDef def;

        public boolean isAssignable() {
            return true;
        }

        public int maxStack() {
            return this.type.isWide() + 1;
        }

        public VarDef def() {
            return this.def;
        }

        public Param(Location location, String string, ParamDef paramDef) {
            super(location, 59, null, string);
            this.type = paramDef.type;
            this.def = paramDef;
        }
    }

    public static class Name
    extends Expr {
        public Expr target;
        public String name;
        public boolean safeNav;

        protected void doWalk(AstVisitor astVisitor) {
            if (this.target != null) {
                this.target = this.target.walk(astVisitor);
            }
        }

        public String toString() {
            if (this.target == null) {
                return this.name;
            }
            if (this.safeNav) {
                return this.target.toString() + "?." + this.name;
            }
            return this.target.toString() + '.' + this.name;
        }

        public int maxStack() {
            int n;
            int n2 = 0;
            if (this.target != null) {
                n2 = n = this.target.maxStack();
            }
            if (this.safeNav) {
                ++n;
            }
            return n;
        }

        public Name(Location location, Expr expr, String string) {
            this(location, 58, expr, string);
        }

        public Name(Location location, int n, Expr expr, String string) {
            super(location, n);
            this.target = expr;
            this.name = string;
        }
    }

    public static class Ternary
    extends Expr {
        public Expr cond;
        public Expr trueExpr;
        public Expr falseExpr;

        protected void doWalk(AstVisitor astVisitor) {
            this.cond = this.cond.walk(astVisitor);
            this.trueExpr = this.trueExpr.walk(astVisitor);
            this.falseExpr = this.falseExpr.walk(astVisitor);
        }

        public String toString() {
            return "(" + this.cond + " ? " + this.trueExpr + " : " + this.falseExpr + ')';
        }

        public int maxStack() {
            return Math.max(this.cond.maxStack(), Math.max(this.trueExpr.maxStack(), this.falseExpr.maxStack()));
        }

        public Ternary(Location location) {
            super(location, 57);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Cond
    extends Expr {
        public Token op;
        public ArrayList operands;

        protected void doWalk(AstVisitor astVisitor) {
            ArrayList<Expr> arrayList = new ArrayList<Expr>();
            int n = 0;
            while (n < this.operands.size()) {
                Expr expr = (Expr)this.operands.get(n);
                arrayList.add(expr.walk(astVisitor));
                ++n;
            }
            this.operands = arrayList;
        }

        public int maxStack() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.operands.size()) {
                n += ((Expr)this.operands.get(n2)).maxStack();
                ++n2;
            }
            return n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(");
            int n = 0;
            while (n < this.operands.size()) {
                if (n > 0) {
                    stringBuffer.append(" " + this.op + ' ');
                }
                stringBuffer.append(this.operands.get(n));
                ++n;
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        private final /* synthetic */ void this() {
            this.operands = new ArrayList();
        }

        public Cond(Location location, int n, Token token, Expr expr) {
            super(location, n);
            this.this();
            this.op = token;
            this.operands.add(expr);
        }
    }

    public static class Binary
    extends Expr {
        public Token op;
        public Expr lhs;
        public Expr rhs;

        public boolean isAssign() {
            return this.op.isAssign();
        }

        protected void doWalk(AstVisitor astVisitor) {
            this.lhs = this.lhs.walk(astVisitor);
            this.rhs = this.rhs.walk(astVisitor);
        }

        public int maxStack() {
            int n = this.lhs.maxStack() + this.rhs.maxStack();
            if (this.isAssign()) {
                n += this.type.isWide() + 1;
            }
            return n;
        }

        public String toString() {
            return "(" + this.lhs + ' ' + this.op + ' ' + this.rhs + ')';
        }

        public Binary(Location location, Token token, Expr expr, Expr expr2) {
            super(location, token.toBinaryExprId());
            this.op = token;
            this.lhs = expr;
            this.rhs = expr2;
            this.type = expr.type;
        }
    }

    public static class Unary
    extends Expr {
        public Token op;
        public Expr operand;

        public boolean isIncrDecr() {
            boolean bl = false;
            if (this.isIncr() || this.isDecr()) {
                bl = true;
            }
            return bl;
        }

        public boolean isIncr() {
            boolean bl = false;
            if (this.id == 23 || this.id == 25) {
                bl = true;
            }
            return bl;
        }

        public boolean isDecr() {
            boolean bl = false;
            if (this.id == 24 || this.id == 26) {
                bl = true;
            }
            return bl;
        }

        public boolean isPrefix() {
            boolean bl = false;
            if (this.id == 23 || this.id == 24) {
                bl = true;
            }
            return bl;
        }

        public boolean isPostfix() {
            boolean bl = false;
            if (this.id == 25 || this.id == 26) {
                bl = true;
            }
            return bl;
        }

        protected void doWalk(AstVisitor astVisitor) {
            this.operand = this.operand.walk(astVisitor);
        }

        public int maxStack() {
            int n = this.operand.maxStack();
            if (this.id == 21) {
                ++n;
            }
            if (this.isIncrDecr()) {
                n += this.type.isWide() ? 4 : 2;
            }
            return n;
        }

        public String toString() {
            if (this.isPostfix()) {
                return this.operand.toString() + this.op.toString();
            }
            return this.op.toString() + this.operand.toString();
        }

        public Unary(Location location, Token token, Expr expr) {
            this(location, token, expr, false);
        }

        public Unary(Location location, Token token, Expr expr, boolean bl) {
            super(location, token.toUnaryExprId(bl));
            this.op = token;
            this.operand = expr;
        }
    }

    public static class Literal
    extends Expr {
        public Object value;

        public boolean isLiteral() {
            return true;
        }

        public Literal toLiteral() {
            return this;
        }

        public boolean isZero() {
            switch (this.id) {
                case 3: {
                    boolean bl = false;
                    if (this.asInt() == 0) {
                        bl = true;
                    }
                    return bl;
                }
                case 4: {
                    boolean bl = false;
                    if (this.asLong() == 0L) {
                        bl = true;
                    }
                    return bl;
                }
                case 5: {
                    boolean bl = false;
                    if (this.asFloat() == 0.0f) {
                        bl = true;
                    }
                    return bl;
                }
                case 6: {
                    boolean bl = false;
                    if (this.asDouble() == 0.0) {
                        bl = true;
                    }
                    return bl;
                }
                case 7: {
                    boolean bl = false;
                    if (this.asLong() == 0L) {
                        bl = true;
                    }
                    return bl;
                }
            }
            return false;
        }

        public Integer toIntLiteral() {
            if (this.id == 3) {
                return (Integer)this.value;
            }
            return null;
        }

        public int asInt() {
            return (Integer)this.value;
        }

        public long asLong() {
            return (java.lang.Long)this.value;
        }

        public float asFloat() {
            return ((java.lang.Float)this.value).floatValue();
        }

        public double asDouble() {
            return (java.lang.Double)this.value;
        }

        public String asString() {
            return (String)this.value;
        }

        public Buf asBuf() {
            return (Buf)this.value;
        }

        public Type asType() {
            return (Type)this.value;
        }

        public Slot asSlot() {
            return (Slot)this.value;
        }

        public Object[] asArray() {
            return (Object[])this.value;
        }

        protected void doWalk(AstVisitor astVisitor) {
        }

        public Value toValue() {
            switch (this.id) {
                case 1: {
                    return Bool.TRUE;
                }
                case 2: {
                    return Bool.FALSE;
                }
                case 3: {
                    return Int.make((int)this.asInt());
                }
                case 4: {
                    return Long.make((long)this.asLong());
                }
                case 5: {
                    return Float.make((float)this.asFloat());
                }
                case 6: {
                    return Double.make((double)this.asDouble());
                }
                case 7: {
                    return Long.make((long)this.asLong());
                }
                case 9: {
                    return Str.make((String)this.value.toString());
                }
                case 10: {
                    return Buf.fromString((String)this.asBuf().toString());
                }
                case 8: {
                    if (this.type.isBool()) {
                        return Bool.NULL;
                    }
                    if (this.type.isFloat()) {
                        return Float.NULL;
                    }
                    if (this.type.isDouble()) {
                        return Double.NULL;
                    }
                    throw new IllegalStateException("Cannot map null literal: " + this.type);
                }
            }
            throw new IllegalStateException("Cannot map to value: " + this);
        }

        public String toCodeString() {
            switch (this.id) {
                case 8: {
                    return "null";
                }
                case 7: {
                    return this.value.toString() + "ns";
                }
                case 14: {
                    return this.asType().qname();
                }
                case 15: {
                    return this.value.toString();
                }
            }
            return TypeUtil.toCodeString(this.value);
        }

        public Literal negate() {
            Number number;
            switch (this.id) {
                case 3: {
                    number = new Integer(-this.asInt());
                    break;
                }
                case 4: {
                    number = new java.lang.Long(-this.asLong());
                    break;
                }
                case 5: {
                    number = new java.lang.Float(-this.asFloat());
                    break;
                }
                case 6: {
                    number = new java.lang.Double(-this.asDouble());
                    break;
                }
                case 7: {
                    number = new java.lang.Long(-this.asLong());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return new Literal(this.loc, this.id, this.type, (Object)number);
        }

        public int maxStack() {
            return this.type.isWide() + 1;
        }

        public String toString() {
            return this.toCodeString();
        }

        public Literal(Location location, Namespace namespace, int n, Object object) {
            super(location, n);
            this.value = object;
            switch (n) {
                case 1: {
                    this.type = namespace.boolType;
                    break;
                }
                case 2: {
                    this.type = namespace.boolType;
                    break;
                }
                case 3: {
                    this.type = namespace.intType;
                    break;
                }
                case 4: {
                    this.type = namespace.longType;
                    break;
                }
                case 5: {
                    this.type = namespace.floatType;
                    break;
                }
                case 6: {
                    this.type = namespace.doubleType;
                    break;
                }
                case 7: {
                    this.type = namespace.longType;
                    break;
                }
                case 9: {
                    this.type = namespace.strType;
                    break;
                }
                case 10: {
                    this.type = namespace.bufType;
                    break;
                }
                case 11: {
                    this.type = namespace.typeType;
                    break;
                }
                case 12: {
                    this.type = namespace.slotType;
                    break;
                }
                case 8: {
                    this.type = namespace.objType;
                    break;
                }
                case 14: {
                    this.type = namespace.intType;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        public Literal(Location location, int n, Type type, Object object) {
            super(location, n);
            this.type = type;
            this.id = n;
            this.value = object;
        }
    }
}

