/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonaProvisioning.tooltasks;

import com.tridium.nsedona.env.KitDb;
import com.tridium.sedonaProvisioning.ProvCx;
import com.tridium.sedonaProvisioning.ProvTask;
import com.tridium.sedonaProvisioning.tooltasks.TransferFiles;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.baja.file.BIFile;
import javax.baja.file.FileUtil;
import javax.baja.util.Lexicon;
import javax.baja.util.TextUtil;
import sedona.Buf;
import sedona.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Restore
implements ProvTask {
    protected final TransferFiles transfer;
    protected final BIFile backup;
    protected final boolean restoreKits;
    private ProvCx cx;
    static /* synthetic */ Class class$com$tridium$sedonaProvisioning$tooltasks$Restore;

    public String getSummary() {
        Class clazz = class$com$tridium$sedonaProvisioning$tooltasks$Restore;
        if (clazz == null) {
            clazz = class$com$tridium$sedonaProvisioning$tooltasks$Restore = Restore.class("[Lcom.tridium.sedonaProvisioning.tooltasks.Restore;", false);
        }
        Lexicon lexicon = Lexicon.make((Class)clazz);
        return lexicon.getText("restore.summary");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(ProvCx provCx) throws Exception {
        this.cx = provCx;
        provCx.log(this.getSummary(), -1.0);
        Buf buf = new Buf(this.backup.read());
        ZipInputStream zipInputStream = new ZipInputStream(buf.getInputStream());
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                Object var8_5;
                block12: {
                    block14: {
                        block13: {
                            try {
                                if (zipEntry.getName().startsWith("kits/")) {
                                    this.restoreKit(zipEntry, zipInputStream);
                                    break block12;
                                }
                                if (zipEntry.getName().startsWith("manifests/")) {
                                    this.restoreManifest(zipEntry, zipInputStream);
                                    break block12;
                                }
                                if (zipEntry.getName().startsWith("par/")) {
                                    this.restorePar(zipEntry, zipInputStream);
                                    break block12;
                                }
                                if (zipEntry.getName().startsWith("meta-inf/")) {
                                    var8_5 = null;
                                    break block13;
                                }
                                if (zipEntry.getName().indexOf("/") != -1) {
                                    provCx.log("  Skipping unexpected entry: " + zipEntry.getName());
                                    break block14;
                                }
                                File file = File.createTempFile(zipEntry.getName(), null);
                                FileOutputStream fileOutputStream = new FileOutputStream(file);
                                FileUtil.pipe((InputStream)zipInputStream, (OutputStream)fileOutputStream);
                                fileOutputStream.flush();
                                fileOutputStream.close();
                                provCx.log("  Registering " + zipEntry.getName() + " for transfer");
                                this.transfer.register(file, zipEntry.getName());
                                break block12;
                            }
                            catch (Throwable throwable) {
                                var8_5 = null;
                                zipInputStream.closeEntry();
                                throw throwable;
                            }
                        }
                        zipInputStream.closeEntry();
                        continue;
                    }
                    var8_5 = null;
                    zipInputStream.closeEntry();
                    continue;
                }
                var8_5 = null;
                zipInputStream.closeEntry();
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            provCx.log("", 100.0);
            zipInputStream.close();
            throw throwable;
        }
        {
            Object var5_11 = null;
            provCx.log("", 100.0);
        }
        zipInputStream.close();
    }

    private final void restoreKit(ZipEntry zipEntry, ZipInputStream zipInputStream) throws Exception {
        if (!this.restoreKits) {
            return;
        }
        int n = "kits/".length();
        String string = zipEntry.getName();
        String[] stringArray = TextUtil.split((String)string.substring(n, string.lastIndexOf(46)), (char)'-');
        this.cx.log("  Restoring " + string + " to kit database");
        KitDb kitDb = this.cx.env().kitDb();
        kitDb.installKit(stringArray[0], (int)Long.parseLong(stringArray[1], 16), new Version(stringArray[2]), (InputStream)zipInputStream);
    }

    private final void restoreManifest(ZipEntry zipEntry, ZipInputStream zipInputStream) throws Exception {
        if (!this.restoreKits) {
            return;
        }
        int n = "manifests/".length();
        String string = zipEntry.getName().substring(n);
        this.cx.log("  Restoring " + string + " to manifest database");
        this.cx.env().manifestDb().installManifest((InputStream)zipInputStream, false);
    }

    private final void restorePar(ZipEntry zipEntry, ZipInputStream zipInputStream) throws Exception {
        if (!this.restoreKits) {
            return;
        }
        int n = "par/".length();
        String string = zipEntry.getName().substring(n);
        Buf buf = new Buf();
        FileUtil.pipe((InputStream)zipInputStream, (OutputStream)buf.getOutputStream());
        buf.seek(0);
        this.cx.log("  Restoring " + string + " to platform database");
        this.cx.env().platformDb().installPar(new ZipInputStream(buf.getInputStream()));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Restore(TransferFiles transferFiles, BIFile bIFile, boolean bl) {
        this.transfer = transferFiles;
        this.backup = bIFile;
        this.restoreKits = bl;
    }
}

