//
// Copyright (c) 2004 Contemporary Control Sytems, Inc.  May not be
// reproduced without permission.
//
#ifndef		ARCX_H
#define		ARCX_H
//
// Hardware type values.
//
#define	USB22				0
#define	PCI20				1
#define	AI_SRVR				2
#define	ISA20				3
//
// Speed values for 'byCom20020ClockPrescaler' in CONFIG structure.
//
#define	SPEED_156KHZ		4
#define	SPEED_312KHZ		3
#define	SPEED_625KHZ		2
#define	SPEED_1250KHZ		1
#define SPEED_2500KHZ		0
#define	SPEED_5MHZ			5
#define	SPEED_7MHZ			7
#define	SPEED_10MHZ			10
//
// Timeout values for 'byCom2020Timeout' in CONFIG structure.
//
#define STANDARD_TIMEOUT	0x18
#define QUAD_TIMEOUT 		0x10
#define EIGHT_TIMEOUT	    0x08
#define SIXTEEN_TIMEOUT		0x00
//
// Return values of Com20020Init() for USB22 devices. 
//
#define USB22_OK					0
#define USB22_FAILED				-1
#define USB22_INVALID_COMMAND		-2
#define USB22_INVALID_DATA			-3
#define	USB22_DUPID					-4
#define	USB22_BAUD					-5
//
// Transmit return values.
//
#define TRANSMITTER_OK				0
#define TRANSMITTER_NOT_AVAILABLE	1
#define ILLEGAL_PACKET_SIZE			2
#define	EXCESSIVE_NAKS				3
//
// Using 1 byte alignment for our structures.
//
#pragma		pack(1)
//
// Structure definitions.
//
typedef struct tagCOM20020_CONFIG
{
    USHORT	uiCom20020BaseIOAddress;
    UCHAR	byCom20020InterruptLevel;
    UCHAR	byCom20020Timeout;
    UCHAR	byCom20020NodeID;
    UCHAR	bCom20020_128NAKs;  //128 NAKs (TRUE), 4NAKs(false)
    UCHAR	bCom20020ReceiveAll;
    UCHAR	byCom20020ClockPrescaler;
    UCHAR	bCom20020SlowArbitration;
    UCHAR	bCom20020ReceiveBroadcasts;
}
COM20020_CONFIG;

typedef struct tagCOM20020_TRANSMIT_BUFFER
{
    UCHAR	byDestinationNodeID;
    USHORT	uiNumberOfBytes;
    UCHAR	byDataBuffer[508];
}
COM20020_TRANSMIT_BUFFER;

typedef struct tagCOM20020_RECEIVE_BUFFER
{
    UCHAR	bySourceNodeID;
    UCHAR	byDestinationNodeID;
    USHORT	uiNumberOfBytes;
    UCHAR	byDataBuffer[508];
    ULONG	dwNumberOfFilledBuffers;
}
COM20020_RECEIVE_BUFFER;

typedef struct tagCOM20020_STATUS
{
    UCHAR	bReceiveActivity;
    UCHAR	bPowerOnReset;
    UCHAR	bRecon;
    UCHAR	bToken;
    ULONG	dwReceivedMessages;
    UCHAR	bTransmissionComplete;
    UCHAR	bTransmissionAcknowledged;
    UCHAR	bExcessiveNAKs;
    ULONG	dwReserved;
}
COM20020_STATUS;

typedef struct tagCOM20020_REGISTER
{
    UCHAR	bWrite;
    UCHAR	byRegister;
    UCHAR	byValue;
}
COM20020_REGISTER;
//
// This has been added to support configuration of the AI-SRVR.
//
// When initializing a AI-SRVR, you must pass a (cast) pointer to a SRVR_CONFIG
// structure as the first argument to Com20020Init(), instead of a pointer to
// a COM20020_CONFIG structure.
//
// The hardware type will alert Com20020Init() what to look for.
//
// If hostname is '0', auto-detect will be used.
//
// If port is '0', the default port will be used.
//
// Upon successfully connecting with the host, the configuration information
// is filled in before the init function returns.
//
typedef struct tagSRVR_CONFIG
{
	char			*hostname;
	unsigned short	port;
	//
	// These fields are filled out by init function if connection
	// made to host.
	//
    unsigned char	cf_node;		// Node number bridge (0: not initialized)
    unsigned char	cf_intf;		// Interface:  0,1
    unsigned char	cf_speed;		// ARCNET baudrate 0..9
    unsigned char	cf_timeout;		// ARCNET Timeout (ET1, ET2: 0..3)
    unsigned char	cf_rcntm;		// RECON Timeout (0..3)
    unsigned char	cf_rcvall;		// Receive all. 0: off, else: active
    unsigned short	cf_nltim;		// Timeout Node-List  [ 1/10 s]. If a node does not send

    unsigned short	cr_fifo;		// FIFO depth
    unsigned short	cr_hwver;		// Hardware-Version Hi/Lo-byte
    unsigned short	cr_swver;		// Software-Version Hi/Lo-byte
    char			cr_vendor[128];	// Vendor-Name, null-terminated
}
SRVR_CONFIG;
//
// Back to default structure alignment.
//
#pragma		pack()
//
// Function prototypes.
//
#ifdef __cplusplus
extern "C"
{
#endif
//
int Com20020Init(COM20020_CONFIG *cfg , UCHAR deviceNumber , UCHAR hardwareType);
int Com20020Register(COM20020_REGISTER *reg);
int Com20020Status(COM20020_STATUS *status);
int Com20020CancelTX(void);
int Com20020FlushRX(void);
int Com20020Transmit(COM20020_TRANSMIT_BUFFER *txbuf);
int Com20020Receive(COM20020_RECEIVE_BUFFER *rxbuf);
int Com20020WakeOnReceive(HANDLE receiveEvent);
int Com20020ResetWakeOnReceive(void);
int Com20020WakeOnTXComplete(HANDLE transmitEvent);
int Com20020ResetWakeOnTXComplete(void);
int Com20020WakeOnRecon(HANDLE reconEvent);
int Com20020ResetWakeOnRecon(void);
int Com20020GetOverflowTotal( long *packets , long *data );
int Com20020GetFirmwareRevision( short *rev );
int Com20020UsbVersion( short *version );
int Com20020Exit(void);
//
#ifdef __cplusplus
}
#endif
//
#endif