/**
 * Created by rcw on 3/9/14.
 */

/** @type {string} */
var unit_number = '1';
/** @type {string} */
var chn_number = '1';
/** @type {string} */
var timestamp = 'null';
/** @type {string} */
var app_name = 'null';
/** @type {string} */
var app_width = '800';
/** @type {string} */
var app_height = '600';

/**
 * This sets the index.html window variable to null so that
 * it won't try to close an already closed window when a new
 * applet is desired.
 */
window.onbeforeunload = function()
{
	window.opener['cur_applet_window'] = null;
};

$(document).ready(function()
{
	var applet = $('#DivApplet');
	/** @type {string} */
	var app_str;
	/** @type {string} */
	var size;
	/** @type {string} */
	var title;
	/** @type {string} */
	var help;
	/** @type {FormObject} */
	var lblHelp;

	unit_number = window.opener['unit_number'];
	chn_number = window.opener['chn_number'];
	timestamp = window.opener['timestamp'];
	//
	app_name = window.opener['app_name'];
	app_width = window.opener['app_width'];
	app_height = window.opener['app_height'];

	size = 'width="' + app_width + '" height="' + app_height + '"';

	lblHelp = new FormObject(fmoType.Label , 'LblHelp');

	switch (app_name)
	{
	case 'config-channel-applet':
		app_str = '<APPLET code="ConfigChannel/ConfigChannelJApplet" archive="config-channel-applet-' + timestamp + '.jar" ' + size + '>';
		app_str += '<PARAM NAME="UnitNo" VALUE="' + unit_number + '" />';
		app_str += '<PARAM NAME="ChannelNo" VALUE="' + chn_number + '" />';
		title = 'Configure Channel ' + chn_number;
		help = 'help.htm#config';
		break;
	case 'monitor-channel-applet':
		app_str = '<APPLET code="MonitorChannel/MonitorChannelJApplet" archive="monitor-channel-applet-' + timestamp + '.jar" ' + size + '>';
		app_str += '<PARAM NAME="UnitNo" VALUE="' + unit_number + '" />';
		app_str += '<PARAM NAME="ChannelNo" VALUE="' + chn_number + '" />';
		title = 'Force Channel ' + chn_number;
		help = 'help.htm#force';
		break;
	case 'config-unit-applet':
		app_str = '<APPLET code="ConfigUnit/ConfigUnitJApplet" archive="config-unit-applet-' + timestamp + '.jar" ' + size + '>';
		app_str += '<PARAM NAME="UnitNo" VALUE="' + unit_number + '" />';
		title = 'Configure Master Unit';
		help = 'help.htm#configUnit';
		break;
	case 'config-exp-unit-applet':
		app_str = '<APPLET code="ConfigExpUnit/ConfigExpUnitJApplet" archive="config-exp-unit-applet-' + timestamp + '.jar" ' + size + '>';
		app_str += '<PARAM NAME="UnitNo" VALUE="' + unit_number + '" />';
		title = 'Configure Expansion Unit';
		help = 'help.htm#configUnit';
		break;
	case 'modbus-mapping-applet':
		app_str = '<APPLET code="ModbusMapping/ModbusMappingApplet" archive="modbus-mapping-applet-' + timestamp + '.jar" ' + size + '>';
		title = 'Modbus Mapping';
		help = 'help.htm#MapApplet';
		break;
	case 'modreg-applet':
		app_str = '<APPLET code="modreg/modreg" archive="modreg-applet-' + timestamp + '.jar" ' + size + '>';
		title = 'Modbus Utility';
		help = 'help.htm#ModbusUtility';
		break;
	case 'time-set-applet':
		app_str = '<APPLET code="timeset/TimeSet" archive="time-set-applet-' + timestamp + '.jar" ' + size + '>';
		title = 'Set Time';
		help = 'help.htm#datetime';
		break;
	case 'email-applet':
		app_str = '<APPLET code="ui/PanelApplet" archive="email-applet-' + timestamp + '.jar" ' + size + '>';
		title = 'Configure Email';
		help = 'help.htm#configEmail';
		break;
	}
	app_str += '<param name="permissions" value="all-permissions" />'
	app_str += '</APPLET>';

	document.title = title;
	lblHelp.SetLink(help);
	$(applet).html(app_str);
});
